//
//  ViewController.m
//
//
//  Created by Claus Richter on 2/5/13.
//  Copyright (c) 2014 gyronimo. All rights reserved.
//



#import "ViewController.h"
#import "crewPerson.h"
#import "helicopter.h"
#import "location.h"

#import "StartPage.h"

#import "VDLabelWithDropDown.h"


#import "JBSignatureController.h"
#import "JBSignatureView.h"

#import "dispatcherFlight.h"


#import <QuartzCore/CoreAnimation.h>

#import <SystemConfiguration/SCNetworkReachability.h>
#include <netinet/in.h>
#import "Reachability.h"


#import "DocumentViewer.h"

#import "EquipmentViewController.h"
#import "EquipmentPackages.h"
#import "EquipPackagesManager.h"
#import "PackagesTotalsTVController.h"

#import <CommonCrypto/CommonHMAC.h>

#import "UtilityCategories.h"           // VD


#import "RiskAssessment.h"


#import "dList.h"

#import "importPerfData.h"


#import "calcPerfClass.h"



@interface ViewController (){
    

    
    __weak IBOutlet UIView *packagesTotalsView_;
    PackagesTotalsTVController* packagesTotalsController_;
    
    
    
       dList* dListClass_;
    
     __weak IBOutlet UIView *dListClassView_;
    
    
    calcPerfClass *calculatePerformanceClass_;
    
    __weak IBOutlet UIView *calculatePerformanceClassView_;
    
    
}
@end

@implementation ViewController

#define blueButtonColor [UIColor colorWithRed: 79.0/255.0 green: 105.0/255.0 blue: 144.0/255.0 alpha: 1.0] // this is red
#define GreenColor [UIColor colorWithRed: 33.0/255.0 green: 176.0/255.0 blue: 21.0/255.0 alpha: 1.0] // this is green
#define yellowSpecialColor [UIColor colorWithRed: 265.0/255.0 green: 216.0/255.0 blue: 0.0/255.0 alpha: 1.0] // this is yellow
#define orangeSpecialColor [UIColor colorWithRed: 265.0/255.0 green: 150.0/255.0 blue: 0.0/255.0 alpha: 1.0] // this is yellow
#define mediumGrayColor [UIColor colorWithRed: 90.0/255.0 green: 90.0/255.0 blue: 90.0/255.0 alpha: 1.0] // this is medium gray
#define verydarkGrayColor [UIColor colorWithRed: 60.0/255.0 green: 60.0/255.0 blue: 60.0/255.0 alpha: 1.0] // this is dark gray
#define lightBlueColor [UIColor colorWithRed: 83.0/255.0 green: 148.0/255.0 blue: 255.0/255.0 alpha: 1.0] // this is dark gray
#define verylightBlueColor [UIColor colorWithRed: 179.0/255.0 green: 202/255.0 blue: 238/255.0 alpha: 1.0] // this is dark gray

@synthesize crossLDW;
@synthesize buttonDisplayEnvironment;

@synthesize buttonSetup;
@synthesize buttonDisplayFlight;
@synthesize inputWarningFuelReserveTime;
@synthesize inputFuelFlowOverride;
@synthesize crew_locations_sview;
@synthesize helicopter_sview;
@synthesize buttonLoadManifest;
@synthesize viewSetup;
@synthesize inputWarningPercentMargin;
@synthesize switchWarnings;


@synthesize displayHeliRegistration;

@synthesize vFlightDeparture;
@synthesize vFlightDestination;
@synthesize vFlightRegistration;
@synthesize viewTopDisplayButtons;
@synthesize viewTopTop;
@synthesize enterPad,      labelActualOAT, labelDisplayOAT, labelDisplayPA,  inputPressureAlt, labelISAdiff, sliderISADiff, labelISAAnsage, labelDensityAlt, viewOne, viewMain, ScrollViewManifest, viewLoadManifest, viewEnvironment, viewSliderISA,   sliderOATforOGE, labelOATforOGE;


@synthesize warningAS355Pax5, warningCGoutsideEnvelope, warningWeightLimitExceeded, warningLatCGExceeded, crossTOW, crossZFW, crossLatTOW, labelWeightTakeoff, labelCGTakeoff, labelCGLat, labelWeightLanding, labelWeightZeroFuel, labelCGLanding, labelCGZeroFuel   ;


@synthesize Flight,Callsign, buttonOAT;


@synthesize unitsWeight,sliderHp,vBEW,vBEWMom,vBEWMomLat,lBEWArm,lBEWArmLat;

@synthesize calculatorscreen;

@synthesize buttonISA, buttonPressureAlt;

@synthesize datepick;

@synthesize  sliderQNH, labelQNH, labelQNHEuro, MSLfeet;

int configuration = 2;

int previousConfiguration = 0;

float activeConfigButton = 1;

float flagIsLandscape = 1;

float XstartPix = 0;    //left corner of graphic
float XendPix = 0;      // right corner

float XstartVal = 0;    // left start value
float XendVal = 0;      // right end value

float Xinput = 0;    // OAT
int counterAutoCheckFlagStatus = 0;


float RESERVEfuelRequired = 0;

float YbottomPix = 0;
float YtopPix = 0;

float YbottomVal = 0;
float YtopVal = 0;

float Yinput = 0;   // OGEinterpolResultIGE

float fullScreenPerfCharts = 0;

float memX1 = 0, memX2 = 0, memX3 = 0, memY1 = 0, memY2 = 0, memY3 = 0, bNr = 0;

float chartWidthInApp = 0;

float chartHeightInApp = 0;

float obstHeightExtern = 0;

float transferLineInput = 0, transferAxisInput = 0, catAVtolCeiling = 0, PC2ceiling = 0, triangleTrigger = 0;

float wantedX = 0, resultY = 0, resultY1 = 0,  resultY2 = 0, x1 = 0, x2 = 0, curveCut = 0;

float flagButtonListoPressed = 0;


float hoistLoadBefore = 0;


float sliderColor = 2; float lockISA = 0; float ISAdif = 0; float densityalt = 0;

float OATinput = 0; float OATinISA = 15;

float warningMaxTOW = 0; float FuelReserveTimeMinutes = 0; 

float OGEinterpolResultIGE = 0;

float CGLongTOW = 0; float CGLongZFW = 0; float CGLongLDW = 0;

float weightZFW = 0; float weightTOW = 0; float weightLDW = 0;

float CGLATTOW = 0; float CGLATZFW = 0; float CGLATLDW = 0;

float weightLATZFW = 0; float weightLATTOW = 0; float weightLATLDW = 0;

float calcisa = 0, flagSignature = 0;

float HeliDataLoaded = 0;

float activeseat = 0;

int flagDoCreateNewFlight = 1;

int configMode = 0;

int flagCGEnvelopeLarge = 0;

int flagResetAllLegs = 0;

float flagChartsFitToScreenHeight = 0;

//altimetry

float OGEIGEmax = 0; float MSLtoHpDifference = 0; float OGEinterpolMaxHp = 0;

int flagShowPerformance = 1;

float listStatusIsOnline = 0;

float previousdButton = 1;

int toggleItemsInOut = 0;

float CrewDataLoaded = 0;

float OAT = 15; 

// alert

float alertFlag = 0;

float headWind = 0;

int flagRefreshSpecialEquipmentList = 1;

float  moveupDown = 0, moveLeftRight = 0, pinchScale = 1, pinchScaleEnded = 1;

float KIAS = 0;

float Hp =0;

// tank capcacity in lbs **************************************************************************************************************

float tankCapacityVolume = 0;

// tank capcacity in lbs **************************************************************************************************************



float amountOfButtons  = 0; // amountOfPerfButtons




//  interpolation Moment Fuel

float InLow1 = 0,  InHigh1 = 0, OutLow1 = 0,  OutHigh1 = 0,  OutInterpol1 = 0; 
float InLow2 = 0, InHigh2 = 0, OutLow2 = 0,  OutHigh2 = 0,  OutInterpol2 = 0;

float momTankFront = 0;  float momTankRear = 0; 

float GroupAKg = 0; float GroupBKg = 0;

float fuelMaxA = 0 ;  float fuelMaxB = 0; float fuelA = 0 ;  float fuelB = 0;

// conversions

float factorKgtoLBS =  2.20462;

float factorArmMeterToInches =  39.3701;

float factorMomentMeterToInches = 86.79517958;

float signAs = 1;

float lineHoistLoad = 0, lineHoistSystem = 0, lineCargoLoad = 0, lineFriesArmKit = 0;

int flagDoNOTheckFWDAFTCG = 0;

// floats to be saved 

float MBpagevisit = 0;

float warningFuelReserveTime = 20;

float warningPercentMargin = 3;

float warningsOnOff = 1; float warningsOnOffIGEOGE = 0, nvgMode = 0; float previousButton = 0;

float flagFuelVisisble = 1;

float flagShowSliders = 0;

float flagShowCargoPod = 0;

int flagOrientationHasChanged = 0;
// floats to be saved and converted

float hoistLoadAttached = 0, friesLoadAttached = 0;

float sliderSeatIncrement = 5; 

float sliderFuelIncrement = 50;

float fuelPositionScroll = 0;

float dListInputFieldTag = 0;

float displayWindow = 0;

float flagSetPickerTimeForFields = 0;

// enterpad
float currentNumber = 0; float commapressedTwo = 0;  float minuspressedTwo  = 0; float EnterValueTwo = 0;  

NSString *EnterPadString = @"0"; 

float selectedItem = 0; float enterpadAutoHide = 0; float flagButtonPressed = 0;

// interpol DTC

float interpolResultDTC1 = 0; float interpolResultDTC2 = 0; float interpolResultDTC3 = 0; float HpReduced = 0;


// interpol manually
float curveID = 2400; float yInput = 8; float xposDTCpart1 = 0; float headWindKts = 0;

float xVal1 = 0, xVal2 = 0, xVal3 = 0, xVal4 = 0, xVal5 = 0, xVal6 = 0, xVal7 = 0, xVal8 = 0, xVal9 = 0, xVal10 = 0, xVal11 = 0, xVal12 = 0, xVal13 = 0, xVal14 = 0, xVal15 = 0, xVal16 = 0;

float xVal1b = 0, xVal2b = 0, xVal3b = 0, xVal4b = 0, xVal5b = 0, xVal6b = 0, xVal7b = 0, xVal8b = 0, xVal9b = 0;

float intpol1 = 0; float intpol2 = 0; float intpol1b = 0; float intpol2b = 0; float xOutput = 0; float intpolMinus = 0;

// interpol Helipad

float interpolResultMTOWHelipad = 0; float interpolResultMTOWClearArea = 0; float flightTimeMinutesALL = 0;

// interpol FuelFlow

float interpolResultFuelFlow = 0; float intpolDif = 0;

int flagRecallSeat =0;

// flights

float currentFlightNumber = 0;  float highestFlightNumber = 0;

// individual Environments

float iEnviSliderOATforOGE = 15; float iEnviSliderOATforALL = 15; float iEnviMode = 0;
float iEnviSliderHpforOGE = 0; float iEnviSliderHpforALL = 0;

// warnings

float flagWarningCG = 0; float flagWarningWeight = 0, warningOnOff_MTOW = 0;;

float warningROC2Engines = 0; float warningROC1Engine = 0, statusSignature =0;

float RAW_BEW = 0; float RAW_BEW_Moment = 0; float RAW_BEW_MomentLAT = 0;



float datepickInterval = 1;

float colorModeForCGenvelope = 0;

 float totalFuelRequiredIncludingRESERVE_lbs = 0;


// ****** El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo  El Listo   *********************

float listStart = 1, listEnd = 0;

float width1 = 0, width2 = 0, width3 = 0, width4 = 0, width5= 0, width6 = 0, width7 = 0, width8= 0;

float xButton = 1000;

float xPos1 = 0, xPos2 = 0, xPos3 = 0, xPos4 = 0, xPos5 = 0, xPos6 = 0, xPos7 = 0, xPos8 = 0 ;

float gap = 0;


int foundLines = 0;

int flagUIdesign = 0;

float yPosTable = 0;

double totalWeightListo = 0, totallongMomentListo = 0, totalLatMomentListo = 0, totalArmListo = 0, totalArmLatListo = 0,    listoCGLong  = 0, listoCGLat  = 0;

double totalFuelListo = 0, totalFuelMomentListo = 0;

float listoPackStart = 0, listoPackEnd = 0;

float resultX= 0;

float yIn = 0;

float rideAlongSeat = 0;

float wgtTOWkg = 0, transferValue = 0;

float movementTranslationX = 0, movementTranslationY = 0;

float connectedToFleetControl = 0;

float sliderWindowXpos = 0;

float sliderWindowYpos = 115;

float sliderWindowWidth = 275;

float sliderWindowHeight = 583;

float stationYincrement = 70;  // pixel vertical gap



float LongArmFrontSeat = 0;

float LongArmRearSeat = 0;

float LatArmLeftSeat = 0;

float LatArmRightSeat = 0;

NSString *pilotNameGlobal = @"";

float maxConfigs = 5;

float roc150OEIceiling2600 = 0;
float roc150OEIceiling2900 = 0;
float roc150OEIceiling3175 = 0;
float roc150OEIceiling = 0;

int initialAC = 2;

int linePilot = 0;

int lineMCM = 0;

// *************************************************************************************************************************************************


-(UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView {
    
    return self.viewHeliCenterLabels;
    
}



// pax input ************************

BOOL changeRow;



JBSignatureController *signatureController ;
UIImageView *scrollSig;

NSMutableData *pdfData, *pdfData2, *pdfData3, *screenshotData1, *screenshotData2;




// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/


-(UIStatusBarStyle)preferredStatusBarStyle{
    return UIStatusBarStyleLightContent;
}



- (BOOL)prefersStatusBarHidden {
    
    if (nvgMode == 1) {
        
       
        
        
        return YES;
    }else{
        
       
        
        return NO;
        
    }
    
}


-(void)appWillResignActive:(NSNotification*)note
{
    
    [self SaveValues];
}


- (void)viewDidLoad {
    
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
   
    
    [self didLoadInitialStartUp];
    
}


- (void) didLoadInitialStartUp {
    
    
    
    _vFlightTypeField.items   =  @[ @"VFR Day", @"VFR Night", @"IFR"];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(actionDataReceived)
                                                 name:@"NotificationataReceived"
                                               object:nil];

    
    
    UIButton *largerButton = [UIButton buttonWithType:UIButtonTypeCustom];        
    largerButton.frame     = CGRectMake( _buttonEnterQNH.frame.origin.x , _buttonEnterQNH.frame.origin.y-15, _buttonEnterQNH.frame.size.width, _buttonEnterQNH.frame.size.height + 20 );   
    [largerButton addTarget:self action:@selector(buttonActionEnterQNH:) forControlEvents:UIControlEventTouchUpInside]; 
    largerButton.backgroundColor = [UIColor clearColor];  
    [_viewSliderPA addSubview:largerButton];
    
    largerButton = [UIButton buttonWithType:UIButtonTypeCustom];        
    largerButton.frame     = CGRectMake( _buttonEnterMSLfeet.frame.origin.x , _buttonEnterMSLfeet.frame.origin.y-15, _buttonEnterMSLfeet.frame.size.width, _buttonEnterMSLfeet.frame.size.height + 20 );   
    [largerButton addTarget:self action:@selector(buttonActionEnterMSLfeet:) forControlEvents:UIControlEventTouchUpInside]; 
    largerButton.backgroundColor = [UIColor clearColor];  
    [_viewSliderPA addSubview:largerButton];
    
    largerButton = [UIButton buttonWithType:UIButtonTypeCustom];        
    largerButton.frame     = CGRectMake( buttonISA.frame.origin.x , buttonISA.frame.origin.y-15, buttonISA.frame.size.width, buttonISA.frame.size.height + 20 );   
    [largerButton addTarget:self action:@selector(buttonActionEnterISA:) forControlEvents:UIControlEventTouchUpInside]; 
    largerButton.backgroundColor = [UIColor clearColor];  
    [viewSliderISA addSubview:largerButton];
    
    largerButton = [UIButton buttonWithType:UIButtonTypeCustom];        
    largerButton.frame     = CGRectMake( buttonOAT.frame.origin.x , buttonOAT.frame.origin.y-15, buttonOAT.frame.size.width, buttonOAT.frame.size.height + 20 );   
    [largerButton addTarget:self action:@selector(buttonActionEnterOAT:) forControlEvents:UIControlEventTouchUpInside]; 
    largerButton.backgroundColor = [UIColor clearColor];  
    [_viewSliderOAT addSubview:largerButton];
    
    
    
    
    
    decimalFormatter = [[NSNumberFormatter alloc] init];
    
        
    self.scrollView.delegate = self;
    
    self.scrollView.maximumZoomScale = 3.0;
    self.scrollView.minimumZoomScale = 0.1;
    
    
    _scrollViewHeliCenter.zoomScale = 0.5;
    //_scrollView.contentOffset = CGPointMake(0, 0);

    calculatePerformanceClassView_.frame  = CGRectMake( 0, 114, 646, 634 );
    
    
    //NSLog(@"didLoadInitialStartUp");
    
    // load settings from start page
    serverUrl  = [[NSUserDefaults standardUserDefaults]  stringForKey:@"serverUrl"];
    _inputCommunicationKey.text   = [[NSUserDefaults standardUserDefaults]  stringForKey:@"_inputCommunicationKey"];
    ACCategory  = [[NSUserDefaults standardUserDefaults]  stringForKey:@"ACCategory"];
    ACmanufacturer = [[NSUserDefaults standardUserDefaults]  stringForKey:@"ACmanufacturer"];
    AC_Type = [[NSUserDefaults standardUserDefaults]  stringForKey:@"AC_Type"];
    ACVariant = [[NSUserDefaults standardUserDefaults]  stringForKey:@"ACVariant"];
    equipListID = [[NSUserDefaults standardUserDefaults]  stringForKey:@"equipListID"];
    
    
    
    _segmentSwapMode.selectedSegmentIndex = 1;
    
    _segmentSeatLoadOptions.selectedSegmentIndex = 1;
    
    _segmentNamesOnSeats.selectedSegmentIndex = 0;
    
    _segmentFlightLegMode.selectedSegmentIndex = 0;
    
    selectedChartButton = 1;
    
    
    legSettingsDictionary = [[NSMutableDictionary alloc] init];
    allFlightsMasterArray = [[NSMutableArray alloc] init];
    allLegsPerFlightArray = [[NSMutableArray alloc] init];
  
    guidanceDictionary = [[NSMutableDictionary alloc] init];
    
    
    _arrayExternalLoadRestrictions = [[NSMutableArray alloc] init];
    arrayHoistRestrictions = [[NSMutableArray alloc] init];
    
    arrayAvailableListIDs = [[NSMutableArray alloc] init];
    arrayBaseName = [[NSMutableArray alloc] init];
    arrayConfigurationName = [[NSMutableArray alloc] init];
    arrayPackageName = [[NSMutableArray alloc] init];
    arrayConfigItemName = [[NSMutableArray alloc] init];
    arrayConfigItemWeight = [[NSMutableArray alloc] init];
    arrayConfigItemArmLong = [[NSMutableArray alloc] init];
    arrayConfigItemMomLong = [[NSMutableArray alloc] init];
    arrayConfigItemArmLat = [[NSMutableArray alloc] init];
    arrayConfigItemMomLat = [[NSMutableArray alloc] init];
    arrayConfigIteminOut = [[NSMutableArray alloc] init];
    arrayConfigItemLocked = [[NSMutableArray alloc] init];
    
    availableACTypes = [[NSMutableArray alloc] init];
    
    [_scrollViewSpecialEquipList setScrollEnabled:YES];
    
    [_scrollViewLegData setScrollEnabled:NO];
   

    
    
    [_scrollViewSetupItems setScrollEnabled:YES];
    [_scrollViewSetupItems setContentSize:CGSizeMake(_viewSetupItems.frame.size.width, _viewSetupItems.frame.size.height)];
    
    
    
    [_scrollViewConfiguratorItems setScrollEnabled:YES];
    

    
    
    
    arrayConfigButtons = [[NSMutableArray alloc] init];
    arrayConfigurations = [[NSMutableArray alloc] init];
    _arrayName1 = [[NSMutableArray alloc] init];
    _arrayName2 = [[NSMutableArray alloc] init];
    _arrayName3 = [[NSMutableArray alloc] init];
    _arrayName4 = [[NSMutableArray alloc] init];
    _arrayName5 = [[NSMutableArray alloc] init];
    _arrayName6 = [[NSMutableArray alloc] init];
    _arrayName7 = [[NSMutableArray alloc] init];
    _arrayName8 = [[NSMutableArray alloc] init];
    _arrayName9 = [[NSMutableArray alloc] init];
    _arrayName10 = [[NSMutableArray alloc] init];
    _arrayName11 = [[NSMutableArray alloc] init];
    _arrayName12 = [[NSMutableArray alloc] init];
    _arrayName13 = [[NSMutableArray alloc] init];
    _arrayName14 = [[NSMutableArray alloc] init];
    _arrayName15 = [[NSMutableArray alloc] init];
    _arrayName16 = [[NSMutableArray alloc] init];
    _arrayName17 = [[NSMutableArray alloc] init];
    _arrayName18 = [[NSMutableArray alloc] init];
    _arrayName19 = [[NSMutableArray alloc] init];
    _arrayName20 = [[NSMutableArray alloc] init];
    _arrayName21 = [[NSMutableArray alloc] init];
    _arrayName22 = [[NSMutableArray alloc] init];
    _arrayName23 = [[NSMutableArray alloc] init];
    _arrayName24 = [[NSMutableArray alloc] init];
    _arrayName25 = [[NSMutableArray alloc] init];
    
    
    
    _bundleVersion.text =[@"Version: " stringByAppendingFormat:@"%@ ",[[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleVersion"]];
    
    
    
    
    [self prefersStatusBarHidden];
    
    [self performSelector:@selector(setNeedsStatusBarAppearanceUpdate)];
    
    [[UITextField appearance] setKeyboardAppearance:UIKeyboardAppearanceDark];
    
    
    _inputCommunicationKey.secureTextEntry = YES;
    
    _inputCommunicationKey.keyboardType = UIKeyboardTypeDefault;
    
    _inputCommunicationKey.autocorrectionType = UITextAutocorrectionTypeNo;
    
    
     sliderHp.minimumValue = -1000; _sliderMSL.minimumValue = -1000;
    
    
    
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appWillResignActive:) name:UIApplicationWillResignActiveNotification object:nil];
    
    
    
    // dList
    
    dListClass_ = [[dList alloc] init];
    [self addChildViewController:dListClass_];
    
    [dListClassView_ addSubview:dListClass_.view];
    
    
    dListClass_.view.frame = dListClassView_.bounds;
    [dListClass_ didMoveToParentViewController:self];
    
    
    
    
    importPerfData *_importPerfData = [[importPerfData alloc]init];
    
    //[_importPerfData loadDataFromDisk];
    //[_importPerfData checkIfPerfDataIsLoaded];
    
    
    // calc perf class
    
    calculatePerformanceClass_ = [[calcPerfClass alloc] init];
    [self addChildViewController:calculatePerformanceClass_];
    
    [calculatePerformanceClassView_ addSubview:calculatePerformanceClass_.view];
    
    
    calculatePerformanceClass_.view.frame = calculatePerformanceClassView_.bounds;
    [calculatePerformanceClass_ didMoveToParentViewController:self];
    
    
    
    
    
    // shadow
    //dListClassView_.layer.masksToBounds = NO;
    //dListClassView_.layer.shadowOffset = CGSizeMake(0, 0);
    //dListClassView_.layer.shadowRadius = 10;
    //dListClassView_.layer.shadowOpacity = 0.5;
    
    
    
    [EquipPackagesManager initializeWithMaxConfigs:maxConfigs];
    
    packagesTotalsController_ = [[UIStoryboard storyboardWithName:@"MedicalList" bundle:nil] instantiateViewControllerWithIdentifier:@"packagesTotals"];
    [packagesTotalsController_ willMoveToParentViewController:self];
    [self addChildViewController:packagesTotalsController_];
    [packagesTotalsView_ addSubview:packagesTotalsController_.view];
    packagesTotalsController_.view.frame = packagesTotalsView_.bounds;
    
    
    
    EquipmentViewController* controller = [[UIStoryboard storyboardWithName:@"MedicalList" bundle:nil] instantiateViewControllerWithIdentifier:@"medicalListController"];   // VD
    controller.equipmentPackages = [self currentFlightEquipmentPackage];
    
    [controller.equipmentPackages setWeightUnits:YES]; // VD set to LBS (LBS=NO, KG=YES)
    
    
    
    serverpath_alternate        = @"http://testserver.gyronimosystems.com/manager/webservice_";
    serverpath_new_alternate    = @"http://testserver.gyronimosystems.com/api/default/";
    serverhost_alternate        = @"gyronimo.kulanaserver.com";
    
    serverpath_standard         = @"http://gyronimo.kulanaserver.com/manager/webservice_";
    serverpath_new_standard     = @"http://gyronimo.kulanaserver.com/api/default/";
    serverhost_standard         = @"gyronimo.kulanaserver.com";
    
    
    
    _switchAdjustACTopView.on = NO;
    
    
    
    buttonRed = [UIImage imageNamed:@"button_red.png"];
    
    buttonGrey = [UIImage imageNamed:@"button grey top184x52.png"];
    
    buttonBlue = [UIImage imageNamed:@"button blue top184x52.png"];
    
    
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    
    
    [_scrollViewUniversalButtons setScrollEnabled:YES];
    [_scrollViewUniversalButtons setContentSize:CGSizeMake(_viewUniversalButtons.frame.size.width, _viewUniversalButtons.frame.size.height)];
    
    
    
    
    
    
    
    perfButtonChartNames = [[NSMutableArray alloc] init];
    perfButtonUserNames = [[NSMutableArray alloc] init];
    
    
    
    buttonChartNamesToProcess = [[NSMutableArray alloc] init];
    
    
    
    
    
    
    
    
    UITapGestureRecognizer *singleTapRecognizer = [[UITapGestureRecognizer alloc]
                                                   initWithTarget: self
                                                   action:@selector(handleSingleTapOnCGEnvelope:)];
    
    [singleTapRecognizer setNumberOfTouchesRequired:1];
    [_viewCGLong addGestureRecognizer: singleTapRecognizer];
    
    
    
    
    
    panRecognizerForGhost = [[UIPanGestureRecognizer alloc]
                             initWithTarget:self
                             action:@selector(panRecognizerAction:)]
    ;
    
    [[self viewInterior] addGestureRecognizer:panRecognizerForGhost];
    
    
    
    
    
    
    
   
    
    
    
    
    
    [self loadPerfChartData];
    
    
    
    
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    // performance ******** performance******** performance******** performance******** performance******** performance******** performance
    
    
    
    

    
    
    [viewLoadManifest bringSubviewToFront: ScrollViewManifest]; [viewLoadManifest bringSubviewToFront: _buttonmanifest]; [viewLoadManifest bringSubviewToFront: _viewManifestLowerButtons];
    
    
    ScrollViewManifest.frame = CGRectMake(0, -2, 1024, 694);
    
    
    _viewStationsWindow.hidden = NO; [viewOne bringSubviewToFront: _viewStationsWindow];
    
    
    
    //NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    
    
    
    
    
    //INIT arrays for helicopter and crew objects
    crew_sectioned = [[NSMutableArray alloc] init];
    crew_types = [[NSMutableArray alloc] init];
    locations = [[NSMutableArray alloc] init];
    helicopters = [[NSMutableArray alloc] init];
    
    dispatcherFlights = [[NSMutableArray alloc] init];
    
    
    dispatcherPaxNames = [[NSMutableArray alloc] init];
    dispatcherPaxWeight = [[NSMutableArray alloc] init];
    
    dispatcherCrewNames= [[NSMutableArray alloc] init];
    dispatcherCrewWeight = [[NSMutableArray alloc] init];
    
    
    
    // scroll view
    
    
    [_scrollViewConfigurations setScrollEnabled:YES];
    [_scrollViewConfigurations setContentSize:CGSizeMake(377, 1400)];
    
    [_scrollViewHeliCenter setScrollEnabled:YES];
    
    
    
    [_scrollViewHeliCenter scrollRectToVisible:CGRectMake(376, 1186, 376, 600) animated:YES];
    
    
    // MTOW warning off
    
    _switchWarningMTOW.on = NO; warningOnOff_MTOW = 0;
    switchWarnings.on = YES; _switchWarningsIGEOGE.on = NO;
    warningsOnOff = 1;
    
    
    // Initiallize the signature controller
    signatureController = [[ JBSignatureController  alloc] init];
    
    
    
    [ _viewSignature addSubview:signatureController.view];
    
    
    //signatureController.delegate = self;
    
    
    // pax input
    
    _viewChangeSelectedEntry.hidden = YES;  _viewEditPilotList.hidden = YES; _viewPilotList.hidden = YES;
    
    self.tableViewDataName = [NSMutableArray arrayWithCapacity:10];
    self.tableViewDataWeight = [NSMutableArray arrayWithCapacity:10];
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    
    
    changeRow = NO;
    
    
    
    // disable kg button
    
    
    [viewMain bringSubviewToFront:_viewStationsWindow];
    
    [viewMain bringSubviewToFront:_viewHelicopterInCenter];
    
    [viewMain bringSubviewToFront:_viewButtonsFuelAndConfig];
    
    
    
    [viewOne bringSubviewToFront:_viewConfigurations];
    
    
    
   
    
    
    
    // hide views
    
    _viewManifest2.hidden = YES;
    _viewManifest1.hidden = NO;
    
    _viewPenaltyOverride.hidden = YES;
    
    _viewStationOptions.hidden = YES;
    
    _viewStationOptionsList.hidden = YES;
    
    _viewConfigurator.hidden = YES;
    
    _viewInputOptions.hidden = YES;
    
    _viewACViewSettings.hidden = YES;
    
    _viewSummaryManifest.hidden = YES;
    
    _viewLegData.hidden = YES;
    
    _viewFlightManager.hidden = YES;
    
    _viewDispatch.hidden = YES;
    
    _labelAvailableExternalLoad.hidden = YES;
    
    _viewSpecialEquiplist.hidden = YES;
    
    _viewAltimetry.hidden = YES;
    
    _viewDatePicker.hidden = YES;
    
    _viewDlist.hidden = YES;
    
    _viewSelectServer.hidden = YES;
    
    viewLoadManifest.hidden = YES;  viewSliderISA.hidden = YES;
    
    _viewConfigurations.hidden = YES;
    
    viewEnvironment.hidden = YES;
    
    enterPad.hidden = YES;
    
    viewSetup.hidden = YES;
    
    _viewSignature.hidden = YES;
    
    _viewSelectHelicopter.hidden = YES;
    
    
    
    
    
    // scroll view
    
    [ScrollViewManifest setScrollEnabled:YES];
    
    [ScrollViewManifest setContentSize:CGSizeMake(644, 1600)];
    
    [ScrollViewManifest scrollRectToVisible:CGRectMake(0, 0, 644, 635) animated:YES];
    
    
    
    
    
    [_scrollViewSummaryManifest setScrollEnabled:YES];
    
    
    
    
    UIImage *sliderImage = [UIImage imageNamed:@"sliderEmpty.png"];
    
    UIImage *sliderThumb = [UIImage imageNamed:@"triangle3.png"];
    
    
    [sliderOATforOGE setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderOATforOGE setMinimumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderOATforOGE setThumbImage:sliderThumb forState:UIControlStateNormal];
    
    [sliderHp setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderHp setMinimumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderHp setThumbImage:sliderThumb forState:UIControlStateNormal];
    
    [sliderISADiff setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderISADiff setMinimumTrackImage:sliderImage forState:UIControlStateNormal];
    [sliderISADiff setThumbImage:sliderThumb forState:UIControlStateNormal];
    
    
    UIImage * sliderImageYel = [UIImage imageNamed:@"sliderYellowLine.png"];
    
    [_sliderFuelMain1 setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
    [_sliderFuelMain1 setMinimumTrackImage:sliderImageYel forState:UIControlStateNormal];
    [_sliderFuelMain1 setThumbImage:sliderThumb forState:UIControlStateNormal];
    
    [_sliderFuelLanding setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
    [_sliderFuelLanding setMinimumTrackImage:sliderImageYel forState:UIControlStateNormal];
    [_sliderFuelLanding setThumbImage:sliderThumb forState:UIControlStateNormal];
    
    
    
    
    
    
    
    // hide warnings
    
    
    warningAS355Pax5.hidden = YES; warningWeightLimitExceeded.hidden = YES; warningCGoutsideEnvelope.hidden = YES; warningLatCGExceeded.hidden = YES;
    
    
    
    
    
    
    // check if here for the first time:
    
    // load aircraft number
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    
    
    
    MBpagevisit = [defaults  floatForKey: @"MBpagevisit"];
    
    //NSLog (@"*********** komme auf WB page an MBpagevisit %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", MBpagevisit]);
    
    
    
    if (MBpagevisit < 10 ) { // wirklich zum ersten mal hier (auch ohne speicherung)
        
        //NSLog (@"start 1");
        
        
        [[NSUserDefaults standardUserDefaults]  setFloat:  100   forKey:@"MBpagevisit"];
        
        
        [allFlightsMasterArray addObject:@"-"];
        [[NSUserDefaults standardUserDefaults]  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];

        [allLegsPerFlightArray addObject:@"-"];
        [[NSUserDefaults standardUserDefaults]  setObject: allLegsPerFlightArray  forKey:@"allLegsPerFlightArray"];
        
        
        
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        
        
 
        
        [self importConfigurationsAndSaveDefaults: 1];  // 1 = load from disk
       
        
        //importPerfData *_importPerfData = [[importPerfData alloc]init];
        
        //[_importPerfData importData];
        
        [_importPerfData loadDataFromDisk];
        
        
        
        [self loadPerfChartData];
        
        
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        // ******** import config ******* import config ******* import config ******* import config ******* import config ******* import config ****
        
        
        
        
        
        
        
        // flserver settings   ************************************************************************************
        
        
        serverpath= serverpath_standard;
        serverpath_new= serverpath_new_standard;
        serverhost= serverhost_standard;
        
        _labelServer.text = @"Standard Server";
        
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        
        [defaults  setObject: _labelServer.text                     forKey:@"_labelServer"];
        
        
        
        
        //  ************************************************************************************
        
        
       
        
        [self loadHelicoptersFromServerVoid];
        
        [self import_equip_download: 0];
        
        configuration = 1;
        
        [self loadArrayListo];
        
        [self createListoItemsSlidersAndInterior];
        
        [self makeConfigButtons];
        
        
        //******************************************************************************************************************************
        
        
        //NSLog (@"bin zum ersen mal hier");
        
        vLegID = @"0";
        vFlightID = @"0";
        
        
        // preload crewlist!
        
        [self loadLocationsFromServer];
        
        UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        [aButton setTag:0];
        
        [self loadCrewFromServer:aButton];
        
        
        // open up flight manager
        
        displayWindow = 12;
        
        [self checkButtonFlight];
        
        [buttonDisplayFlight setImage:buttonBlue forState:UIControlStateNormal];
        
        _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
        
        
        
        
        
    }
    
    
    
    
    
    
    
    
    if (MBpagevisit > 10 ) {
        
        //NSLog (@"start 2");
        
        
        //NSLog (@"hello again! started second time");
        
        
        
        
        //  ************************************************************************************
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        
        _labelServer.text = [defaults  stringForKey:@"_labelServer"];
        
        _inputCommunicationKey.text = [defaults  stringForKey:@"_inputCommunicationKey"];
        
        customer = [defaults  stringForKey:@"customer"];
        
        
        
        if ([_labelServer.text isEqualToString:@"Alternate Server"] ) {
            
            
            // Alternate Server
            
            serverpath      = serverpath_alternate;
            serverpath_new  = serverpath_alternate;
            serverhost      = serverhost_alternate;
            
            
        }else{
            
            // Standard Server
            
            
            serverpath      = serverpath_standard;
            serverpath_new  = serverpath_new_standard;
            serverhost      = serverhost_standard;
            
            
            
        }
        
        //  ************************************************************************************'
        
        
        vLegID = @"1";
        
        vFlightID =@"1";
        
        [self LoadValues]; // get bew
        
        [self makeConfigButtons];
        
        
        // setup last configuration
        
        
        [self createListoItemsSlidersAndInterior];
        
        
        
        
        
        
        
        displayWindow = 0;
        
        [self displayWindows];
        
        
        
        
    }
    
    
    
    
    
    
    
    // NVG safety
    
    if ([defaults  floatForKey:@"_sliderNVG"] > 85) {
        
        _sliderNVG.value = 80;
        
        [defaults  setFloat: _sliderNVG.value    forKey:@"_sliderNVG"];
        
    }
    
    
    
    
    
    [self MainRoutine];
    
    
    
    
    
    
    
    
    
    
    
    

    
}



// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/
// =/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/=/




- (void) setACimages {
   
    
    
    
}



//Dennis START
//Dennis START



//---------------- Packages.txt Import/Export START-----------






- (IBAction)buttonActionImportEquip:(id)sender {
    
    
    
    [self import_equip_download:1];
    
    
    
    
    
    
}


- (IBAction)buttonActionViewEquipmentList:(id)sender {
    
    // VD
    EquipmentViewController* controller = [[UIStoryboard storyboardWithName:@"MedicalList" bundle:nil] instantiateViewControllerWithIdentifier:@"medicalListController"];   // VD
    controller.equipmentPackages = [self currentFlightEquipmentPackage];
    // VD
    [controller.equipmentPackages setWeightUnits:YES];
    [self presentViewController:controller animated:YES completion:nil]; // VD
    __block id observer = [[NSNotificationCenter defaultCenter] addObserverForName:@"EquipmentControllerDismissed" object:nil queue:nil usingBlock:^(NSNotification *note) {
        [[NSNotificationCenter defaultCenter] removeObserver:observer];
        [self MainRoutine];
    }];
    
    
    
}






- (void)import_equip_download: (int)mode  {
    
    
    
    equipListID = [[NSUserDefaults standardUserDefaults] objectForKey:@"equipListID"];
    
    //equipListID = [_arrayName23 objectAtIndex:32];
    
    NSString *callsign  = @"HB-ZQG";
    
    
    
    
     NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
     [defaults  setObject:vFlightRegistration.text       forKey:@"currentFlightRegistration"];
    
    //NSLog(@"import_equip_download: customer -%@-", customer);
    //NSLog(@"import_equip_download: callsign -%@- ", callsign);
    
    UIActivityIndicatorView* spinner = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
    //UIButton* button = sender;
    
    NSString* urlstring;
    if ([_labelServer.text isEqualToString:@"Alternate Server"] ) {
        // Alternate Server
        urlstring = @"http://testserver.gyronimosystems.com/manager/webservice_get_equipment.php?";
    }else{
        // Standard Server
        urlstring = @"http://gyronimo.kulanaserver.com/manager/webservice_get_equipment.php?";
    }
    
    urlstring=[urlstring stringByAppendingFormat:@"customer=%@&callsign=%@",customer,callsign];
    
    //NSLog(@"import_equip_download urlstring %@", urlstring);
    
    [[EquipPackagesManager sharedInstance] downloadDefaultConfigsFromURL:urlstring completionBlock:^(NSString *error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [spinner removeFromSuperview];
            if (error){
                alertFlag = 333;
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"ERROR -EQUIP 1"
                                      message:error
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:@"TRY AGAIN", nil];
                [alert show];
            } else {
                NSString *msg=[[NSString alloc]initWithFormat:@"Equipment data successfully updated." ];
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"EQUIPMENT"
                                      message:msg
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil];
                [alert show];
                /*
                if (mode == 1) {
                    NSString *msg=[[NSString alloc]initWithFormat:@"Equipment data successfully updated." ];
                    
                    UIAlertView *alert = [[UIAlertView alloc]
                                          initWithTitle:@"EQUIPMENT"
                                          message:msg
                                          delegate:self
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
                    [alert show];
                }
                */
                
                //[self createEquipmentArrays];
                
                configuration = 1;
                [self setConfiguration];
                
            }
        });
    }];
}





- (IBAction)buttonActionExportEquip:(id)sender {
    
   
    
    
} // = export_equip







//---------------- Packages.txt Import/Export END-----------




- (void)loadCrewFromServer:(UIButton*)sender {
    
    //Check if server reachable
    
    //NSLog(@"1 loadCrewFromServer customer %@",customer);
    
    
    
    
    
    if (!([self is_online])) {
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Error"
                              message:@"Cannot reach server. Please check if this device is online."
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        [alert show];
        
    } else {
        
        // get location from button clicked
        
        NSString *locationName=@"";
        NSString *locationCode=@"";
        
        locationCode=[[locations objectAtIndex:sender.tag]locationCode];
        locationName=[[locations objectAtIndex:sender.tag]locationName];
        
        //        locationCode = @"base1";
        //
        //        locationName = @"base1";
        
        
        
        
        crew_lastLocation=locationCode;
        
        // send request to server
        
        //NSLog(@"loadCrewFromServer customer %@",customer);
        
        NSString *url=serverpath;
        url = [url stringByAppendingString:@"get_crew.php?customer="];
        url = [url stringByAppendingString:customer];
        url = [url stringByAppendingString:@"&location="];
        url = [url stringByAppendingString:locationCode];
        
        
        //NSLog(@"url: %@",url);
        
        NSData* data = [NSData dataWithContentsOfURL:
                        [NSURL URLWithString: url]];
        __autoreleasing NSError* error = nil;
        
        id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
        
        //check if JSON data valid
        
        if (error != nil) {
            UIAlertView *alert = [[UIAlertView alloc]
                                  initWithTitle:@"Error [02]"
                                  message:@"Received data that is not valid. Please contact administrator."
                                  delegate:self
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil];
            [alert show];
            //NSLog(@"%@",error);
        } else {
            
            
            
            
            //create crew objects
            
            [crew_sectioned removeAllObjects];
            [crew_types removeAllObjects];
            
            
            NSArray *allItems = [result objectForKey:@"crewData"];
            NSArray *allTypes = [result objectForKey:@"crewTypes"];
            
            
            for (int i=0; i<allTypes.count; ++i) {
                NSDictionary *item = [allTypes objectAtIndex:i];
                NSString *crewType =[item objectForKey:@"crewType"];
                
                [crew_types addObject:crewType];
            }
            
            NSString *currentType=@"";
            int currentTypeID=-1;
            
            for (int i=0; i<allItems.count; ++i) {
                NSDictionary *item = [allItems objectAtIndex:i];
                NSString *TheName=[item objectForKey:@"name"];
                NSString *TheInitial=[item objectForKey:@"initial"];
                NSString *TheCrewtype=[item objectForKey:@"crewType"];
                NSString *TheStatus=[item objectForKey:@"status"];
                
                
                
                
                //double WeightValue = ([[item objectForKey:@"weight"]doubleValue] / 2.20462); // dj!
                
                double WeightValue = ([[item objectForKey:@"weight"]doubleValue] );
                
                
                NSString *TheWeight = [NSString stringWithFormat:@"%f",WeightValue];
                
                // crew is sorted by crewType
                // so we put all crew objects into array crew_sectioned
                // crew_sectioned[0] could be for objects with crewtype PIC
                // and crew_sectioned[1] could be for objects with crewtype PAR
                //if we find a new crewtype we create a new element in crew_sectioned array
                
                if ([currentType isEqualToString:TheCrewtype]) {
                    [[crew_sectioned objectAtIndex:currentTypeID] addObject:[[crewPerson alloc] initWithName:TheName AndInitial:TheInitial AndCrewtype:TheCrewtype AndStatus:TheStatus AndWeight:TheWeight]];
                    
                } else {
                    currentTypeID+=1;
                    currentType=TheCrewtype;
                    NSMutableArray *temp = [[NSMutableArray alloc] init];
                    [crew_sectioned insertObject:temp atIndex:currentTypeID];
                    [[crew_sectioned objectAtIndex:currentTypeID] addObject:[[crewPerson alloc] initWithName:TheName AndInitial:TheInitial AndCrewtype:TheCrewtype AndStatus:TheStatus AndWeight:TheWeight]];
                }
                
                
            }
            
            allItems = [result objectForKey:@"updateData"];
            NSDictionary *item = [allItems objectAtIndex:0];
            lastupdate_crew=[item objectForKey:@"lastUpdate"];
            
            
            
         
            
            
            
            CrewDataLoaded = 1;
            
            NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
            
            [defaults  setFloat: CrewDataLoaded                     forKey:@"CrewDataLoaded"];
            
            [self.tableView reloadData];
            
            _viewEditPilotList.hidden = YES;
            
            [self SaveValues];
            
        }
    }
}

- (void) addLocationButtons {
    
    //we create one button per location dynamically in our scrollview
    
    int xCoord=0;
    int yCoord=0;
    int buttonWidth=200;
    int buttonHeight=50;
    int buffer = 10;
    
    
    //we take the locations that are already in our locations array
    
    for(UIView *subview in [crew_locations_sview subviews]) {
        [subview removeFromSuperview];
    }
    
    
    for(int i=0; i<locations.count; i++) {
        UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.frame     = CGRectMake(xCoord, yCoord,buttonWidth,buttonHeight );
        [aButton setTitle:[[locations objectAtIndex:i]locationName] forState:(UIControlStateNormal)];
        [aButton setTag:i];
        [aButton addTarget:self action:@selector(loadCrewFromServer:) forControlEvents:UIControlEventTouchUpInside];
        [crew_locations_sview addSubview:aButton];
        
        aButton.tintColor = [UIColor whiteColor];
        
        aButton.titleLabel.font = [UIFont systemFontOfSize:18];
        
        
        
        yCoord += buttonHeight + buffer;
        
    }
    
    
    [crew_locations_sview setContentSize:CGSizeMake(200, yCoord)];
    [crew_locations_sview setScrollEnabled:YES];
    [crew_locations_sview setNeedsDisplay];
    
    
}

- (void) addHelicopterButtons {
    
    [self updateAvailableACTypes:1];
    
    
    for (UIView *subview in helicopter_sview.subviews) {
        [subview removeFromSuperview];
    }
    
    //we create buttons for each helicopter callsign
    
    int xCoord=38;
    int yCoord=14;
    int buttonWidth=190;
    int buttonHeight=45;
    int buffer = 66;
    int i=0;
    
    //the helicopters array contains all helicopter objects that came from the server
    
    //NSLog (@"availableACTypes %@", availableACTypes);
    
    int acPositionInList = 0;
    
    for(helicopter *current in helicopters)
    {
        
        /*
        UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.frame     = CGRectMake(xCoord, yCoord,buttonWidth,buttonHeight );
        
        //NSString *callsignAndType = [NSString stringWithFormat:@"%@: %@", current.typeM, current.callsign];
        
        NSString *callsignAndType = [NSString stringWithFormat:@" %@",  current.callsign];
        
        [aButton setTitle:callsignAndType  forState:(UIControlStateNormal)];
        [aButton setTag:i];
        [aButton addTarget:self action:@selector(butSelHeli:) forControlEvents:UIControlEventTouchUpInside];
        
        aButton.tintColor = [UIColor whiteColor];
        
        
        aButton.showsTouchWhenHighlighted = YES;
        
        aButton.titleLabel.font = [UIFont systemFontOfSize:18];
        
        UIImage *buttonBack = [UIImage imageNamed:@"button generic blue.png"];
        [aButton setBackgroundImage:buttonBack forState:UIControlStateNormal];
        
        
        [helicopter_sview addSubview:aButton];
        
        
        UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord, yCoord+28, buttonWidth, buttonHeight)];
        label.font = [UIFont systemFontOfSize:15];
        label.textAlignment = NSTextAlignmentCenter;
        label.textColor = [UIColor whiteColor];
        
        [label  setText: [NSString stringWithFormat:@"%@",  current.typeM]  ];
        
        
        
        [helicopter_sview addSubview: label];
        
        
        if ((acPositionInList%2)!=0) {
            xCoord=38;
            yCoord += buffer;
            
        } else {
            xCoord=238;
        }
        
        i+=1;
        acPositionInList +=1;
         */

        
        
        
        //NSLog (@"this a %@", current.callsign);
        
        if (![availableACTypes containsObject: current.typeM ]) {
            //NSLog (@"this aircraft is in Fleet Control but not authorized for this app -%@-", current.typeM );
            
            i+=1;
            
        }else{
            
            UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
            aButton.frame     = CGRectMake(xCoord, yCoord,buttonWidth,buttonHeight );
            
            //NSString *callsignAndType = [NSString stringWithFormat:@"%@: %@", current.typeM, current.callsign];
            
            NSString *callsignAndType = [NSString stringWithFormat:@" %@",  current.callsign];
            
            [aButton setTitle:callsignAndType  forState:(UIControlStateNormal)];
            [aButton setTag:i];
            [aButton addTarget:self action:@selector(butSelHeli:) forControlEvents:UIControlEventTouchUpInside];
            
            aButton.tintColor = [UIColor whiteColor];
            
            
            aButton.showsTouchWhenHighlighted = YES;
            
            aButton.titleLabel.font = [UIFont systemFontOfSize:18];
            
            UIImage *buttonBack = [UIImage imageNamed:@"button generic blue.png"];
            [aButton setBackgroundImage:buttonBack forState:UIControlStateNormal];
            
            
            [helicopter_sview addSubview:aButton];
            
            
            UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord, yCoord+28, buttonWidth, buttonHeight)];
            label.font = [UIFont systemFontOfSize:15];
            label.textAlignment = NSTextAlignmentCenter;
            label.textColor = [UIColor whiteColor];
            
            [label  setText: [NSString stringWithFormat:@"%@",  current.typeM]  ];
            
            
            
            [helicopter_sview addSubview: label];
            
            
            if ((acPositionInList%2)!=0) {
                xCoord=38;
                yCoord += buffer;
                
            } else {
                xCoord=238;
            }
            
            i+=1;
            acPositionInList +=1;
            
            
        }
        
        
       
    }
    [helicopter_sview setContentSize:CGSizeMake(432, yCoord)];
    [helicopter_sview setScrollEnabled:YES];
    
    
}

- (bool)is_online {
    
    //check if server is reachable / device is online
    
    Reachability *r = [Reachability reachabilityWithHostName:serverhost];
    NetworkStatus internetStatus = [r currentReachabilityStatus];
    
    if ((internetStatus != ReachableViaWiFi) && (internetStatus != ReachableViaWWAN))
    {
        
        
        
        return false;
        
        
        
        
        
    } else {
        
        
        return true;
    }
    
}

- (void)loadLocationsFromServer {
    
    //NSLog(@"1 loadLocationsFromServer customer %@",customer);
    
    
    
    //send a request to server to get all locations of this customer
    
    NSString *url=serverpath;
    url = [url stringByAppendingString:@"get_locations.php?customer="];
    url = [url stringByAppendingString:customer];
    NSData* data = [NSData dataWithContentsOfURL:
                    [NSURL URLWithString: url]];
    __autoreleasing NSError* error = nil;
    
    
    //NSLog(@"2 loadLocationsFromServer customer %@",customer);
    
    id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
    
    //check if JSON data is valid
    
    if (error != nil) {
        
        //NSLog(@"%@",error);
        
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Error [01]"
                              message:@"Received data that is not valid. Please contact administrator."
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        [alert show];
    } else {
        
        _viewEditPilotList.hidden = NO; // mklist
        
        
        
        [locations removeAllObjects];
        
        NSArray *allItems = [result objectForKey:@"locationData"];
        
        
        
        //put locations into global locations object array
        
        for (int i=0; i<allItems.count; ++i) {
            
            
            NSDictionary *item = [allItems objectAtIndex:i];
            NSString *TheLocationCode=[item objectForKey:@"location"];
            NSString *TheLocationName=[item objectForKey:@"locationName"];
            
            [locations addObject:[[location alloc] initWithLocationCode:TheLocationCode AndLocationName:TheLocationName]];
            
            
        }
        
        //create button for each location
        
        [self addLocationButtons];
        
        
    }
    
    
}

- (void) loadHelicoptersNow {
    //check if online
    
    arrayKey = @"availableACTypesArray" ;
    availableACTypes = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    
    //NSLog(@" loadHelicoptersNow customer = %@", customer);
    
    
    if (!([self is_online])) {
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Error"
                              message:@"Cannot reach server. Please check if this device is online."
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        [alert show];
        
        
        
        
    } else {
        
        //send request to server to get helicopter data as json data
        
        
        NSString *helicopterTypeOfThisApp = AC_Type;
        
        //NSLog(@"loadHelicoptersNow  helicopterTypeOfThisApp = %@", helicopterTypeOfThisApp);

        
        NSString *url=serverpath_new;
        
        // load only typr
        //url = [url stringByAppendingFormat:@"get_helicopters/1.1/?customer=%@&type=%@",customer,helicopterTypeOfThisApp];
        
        // trick 1 load all helicopters
        url = [url stringByAppendingFormat:@"get_helicopters/1.1/?customer=%@",customer];
        
        url = [url stringByAddingPercentEscapesUsingEncoding:NSASCIIStringEncoding];
        
        
        
        
       
        
        
        //NSLog(@"url: %@",url);
        
        //NSLog(@"customer: %@",customer);
        
        
        NSData* data = [NSData dataWithContentsOfURL:
                        [NSURL URLWithString: url]];
        
        NSString *dataString=[[NSString alloc]initWithData:data encoding:NSASCIIStringEncoding];
        //NSLog(@"loadHelicoptersNow datastring: ---%@--- ",dataString);
        
        if ([dataString isEqualToString:@"NOK"]) {
            
            NSString *msg=[[NSString alloc]initWithFormat:@"No %@ helicopter found in your FleetControl fleet.",helicopterTypeOfThisApp];
            UIAlertView *alert = [[UIAlertView alloc]
                                  initWithTitle:@"Error"
                                  message:msg
                                  delegate:self
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil];
            [alert show];
            
        } else {
            
            
            
            
            __autoreleasing NSError* error = nil;
            
            id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
            
            //check if json data is valid
            
            if (error != nil) {
                
                //NSLog(@"%@",error);
                
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"Error"
                                      message:@"Received data that is not valid. Please contact administrator."
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil];
                [alert show];
                
                
                
            } else {
                
                //create helicopter objects and store them in helicopters array
                
                [helicopters removeAllObjects];
                
                NSArray *allItems = [result objectForKey:@"helicopterData"];
                
                //NSLog(@"%i",allItems.count);
                
                for (int i=0; i<allItems.count; ++i) {
                    
                    
                    NSDictionary *item = [allItems objectAtIndex:i];
                    NSString *TheCallsign=[item objectForKey:@"callsign"];
                    
                    //NSString *TheType=[item objectForKey:@"type"];
                    
                    
                   
                    // trick 2
                    //NSLog(@"trick !!!!! type -%@-",  [item objectForKey:@"type"]);
                    NSString *TheType;
                    if (![[item objectForKey:@"type"] isEqualToString:@"0"]) {
                       TheType=[item objectForKey:@"type"]; // ac tyoe
                    }else{
                        continue;
                    }
                
                    
                    
                    
                    //NSString *units=[item objectForKey:@"customer_units"];
                    
                    //NSLog (@"loadHelicoptersNow customer_units %@ " , units);
                    
                    //units enthält "kg" oder "lbs", könnte man verwenden, um in der App ne Ausgabe zu machen,
                    //dass die in der App eingestellten Units nicht zu FC passen, damit der Kunde auch check, wenn er zu blöd ist ;)
                    
                    double TheBew=([[item objectForKey:@"bew"] doubleValue] );
                    double TheArmlong=([[item objectForKey:@"armlong"] doubleValue]);
                    double TheArmlat=([[item objectForKey:@"armlat"] doubleValue] );
                    
                    
                    NSString *specialdata1 =[item objectForKey:@"specialdata1"];
                    NSString *specialdata2 =[item objectForKey:@"specialdata2"];
                    NSString *specialdata3 =[item objectForKey:@"specialdata3"];
                    
                    //NSLog (@"specialdata1 %@ " , specialdata1); // ac tyoe
                    //NSLog (@"specialdata2 %@ " , specialdata2); // tank bladder?
                    //NSLog (@"specialdata3 %@ " , specialdata3);
                    
                    
                    
                    
                    
                    [helicopters addObject:[[helicopter alloc] initWithCallsign:TheCallsign AndType:TheType AndBew:TheBew AndArmlong:TheArmlong AndArmlat:TheArmlat AndSpecialData1:specialdata1 AndSpecialData2:specialdata2 AndSpecialData3:specialdata3]];
                    
                    
                }
                
                allItems = [result objectForKey:@"updateData"];
                NSDictionary *item = [allItems objectAtIndex:0];
                lastupdate_helicopters=[item objectForKey:@"lastUpdate"];
                
                
               
                
                
                //create button for each helicopter
                
                [self addHelicopterButtons];
                
              
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"INFO"
                                      message:@"Helicopters successfully loaded."
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil];
                
                 [alert show];
                
                
                HeliDataLoaded = 1; connectedToFleetControl = 1;
                
                
               
                
            }
        }
    }
    
    
}

- (IBAction)actionConnectButton:(id)sender {
    
    // this is the "Connect" button
    
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    
    [defaults  setObject: _inputCommunicationKey.text                     forKey:@"_inputCommunicationKey"];
    
    
    [self.view endEditing:TRUE];
    
    
    
    
    [self loadHelicoptersFromServerVoid];
    
}

- (IBAction)actionUpdateAircraftList:(id)sender {
    
    
    [self loadHelicoptersFromServerVoid];
    
    
}




- (void)loadHelicoptersFromServerVoid {
    
    
   
    
    //check if online
    
    //NSLog(@"loadHelicoptersFromServerVoid   ");
    
    if ([self is_online]) {
        
        //NSLog(@"Device online.");
        
        //send request to server to get lastupdate data as json data
        
        NSString *url=serverpath;
        
        //NSLog(@"serverpath %@ ", serverpath);
        
        url = [url stringByAppendingString:@"get_codecheck.php?code="];
        url = [url stringByAppendingString:_inputCommunicationKey.text];
        
        //NSLog(@"checkCode echo %@",url);
        
        //NSLog(@"1 customer  %@",customer);
        
        
        NSData* data = [NSData dataWithContentsOfURL:
                        [NSURL URLWithString: url]];
        __autoreleasing NSError* error = nil;
        
        
        id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
        
        //check if json data is valid
        
        if (error != nil) {
            
            //NSLog(@"JSON error.");
            
        } else {
            
            //compare
            
            
            NSArray *allItems = [result objectForKey:@"check"];
            
            NSDictionary *item = [allItems objectAtIndex:0];
            
            
            if (!([[item objectForKey:@"result"] isEqualToString:@"OK"])) {
                
                
                //NOT SUCCESSFULL - AlertView
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"FleetControl™"
                                      message:@"The code you entered is not valid."
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil, nil];
                
                NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
                
                customer = @"";
                
                [defaults  setObject:customer                    forKey:@"customer"];  // here we set the customer no zero *********************
                
                
                
                
                [alert show];
                
                
                
            } else {
                
                
                customer=[item objectForKey:@"customer"];
                
               //NSLog(@"loadHelicoptersFromServerVoid  customer object =  %@",customer);
                
                
                NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
                
                
                [defaults  setObject:customer                    forKey:@"customer"];  // here we set the customer *********************
                
                
                
                
                [self loadHelicoptersNow];
                
            }
            
        }
    } else {
        
        
        //NSLog(@"Device offline.");
        
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Can not update Helicopter Data!"
                              message:@"Device Offline"
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        
        
        
    }
    
    
    
}

- (void) checkForUpdates_Helicopter {
    
    //check if online
    
    if ([self is_online]) {
        
        
        //send request to server to get lastupdate data as json data
        
        NSString *url=serverpath;
        url = [url stringByAppendingString:@"get_lastupdate_heli.php?customer="];
        url = [url stringByAppendingString:customer];
        NSData* data = [NSData dataWithContentsOfURL:
                        [NSURL URLWithString: url]];
        __autoreleasing NSError* error = nil;
        
        id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
        
        //check if json data is valid
        
        if (error != nil) {
            
            
        } else {
            
            //compare timestamps
            
            
            NSArray *allItems = [result objectForKey:@"updateData"];
            
            //NSLog(@"%i",allItems.count);
            
            
            NSDictionary *item = [allItems objectAtIndex:0];
            
            
            if (!([[item objectForKey:@"lastUpdate"] isEqualToString:lastupdate_helicopters])) {
                
                
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"INFO"
                                      message:@"There is an update available. Please tap on button 'Update Aircraft Data'."
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil];
                [alert show];
                
                
                
            } else {
                //NSLog(@"No Update available.");
            }
            
        }
    }
    
}

- (void) checkForUpdates_Crew {
    
    //check if online
    
    if ([self is_online]) {
        
        
        //send request to server to get lastupdate data as json data
        
        
       
        
        if (crew_lastLocation!=nil) {
            
            NSString *url=serverpath;
            url = [url stringByAppendingString:@"get_lastupdate_crew.php?customer="];
            url = [url stringByAppendingString:customer];
            url = [url stringByAppendingString:@"&location="];
            url = [url stringByAppendingString:crew_lastLocation];
            
            //NSLog(@"url: %@",url);
            
            NSData* data = [NSData dataWithContentsOfURL:
                            [NSURL URLWithString: url]];
            __autoreleasing NSError* error = nil;
            
            
            
            id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
            
            //check if json data is valid
            
            if (error != nil) {
                
                
            } else {
                
                //compare timestamps
                
                
                NSArray *allItems = [result objectForKey:@"updateData"];
                
                //NSLog(@"%i",allItems.count);
                
                
                NSDictionary *item = [allItems objectAtIndex:0];
                
                
                if (!([[item objectForKey:@"lastUpdate"] isEqualToString:lastupdate_crew])) {
                    
                    
                    UIAlertView *alert = [[UIAlertView alloc]
                                          initWithTitle:@"CREW LIST UPDATE!"
                                          message:@"Crew list update available. Please open the Crew List window and tap Load Crew List. Then select a base."
                                          delegate:self
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
                    [alert show];
                    
                    
                    
                } else {
                    //NSLog(@"No Update available.");
                }
            }
        }
    }
    
}


- (void)checkDocuments_lastUpdate {
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    connectedToFleetControl = [defaults floatForKey:@"connectedToFleetControl"];
    
    //Check if FC is connected
    
    if (connectedToFleetControl==1) {
        
        
        //NSLog(@"checkDocuments_lastUpdate:  customer %@", customer );
        
     
        
        if (!([self is_online])) {
            
            
        } else {
            
            // send request to server
            
            NSString *url=serverpath_new;
            url = [url stringByAppendingString:@"get_lastupdate_documents/1.1/?customer="];
            url = [url stringByAppendingString:customer];
            //NSLog(@"url: %@",url);
            
            NSData* data = [NSData dataWithContentsOfURL:
                            [NSURL URLWithString: url]];
            __autoreleasing NSError* error = nil;
            
            id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
            
            //check if JSON data valid
            
            if (error != nil) {
                
                // RECEIVED DATA NOT VALID
                
                
            } else {
                
                
                NSString *current_lastUpdate= [defaults stringForKey:@"documents_lastUpdate"];
                
                //PARSE json object
                NSArray *lastUpdate = [result objectForKey:@"updateData"];
                NSString *value=@"";
                for (int i=0; i<lastUpdate.count; i++) {
                    NSDictionary *item = [lastUpdate objectAtIndex:i];
                    value= [item objectForKey:@"lastUpdate"];
                }
                
                if ([current_lastUpdate isEqual:value]) {
                    
                    //local lastUpdate value is equal to Server value
                    
                    //DO NOTHING
                    
                    UIAlertView *alert = [[UIAlertView alloc]
                                          initWithTitle:@"no Change detected"
                                          message:@"LastUpdate on server equal to local var"
                                          delegate:self
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
                    [alert show];
                    
                } else {
                    
                    //Local lastUpdate value is NOT equal to Server Value
                    //Something changed on the server
                    
                    //NOTIFY USER
                    
                    UIAlertView *alert = [[UIAlertView alloc]
                                          initWithTitle:@"Updates available"
                                          message:@"Please open the document viewer to download new files."
                                          delegate:self
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
                    [alert show];
                }
            }
            
        }
    }
    
}

- (IBAction)buttonSwitchToDocumentViewer:(id)sender {
    
    [self SaveValues];
    
    DocumentViewer *second = [[DocumentViewer alloc] initWithNibName:nil bundle:nil];
    second.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
    second.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentModalViewController:second animated: YES];
    
    
}



// DENNIS stuff - END



- (IBAction)buttonSwitchToRiskPage:(id)sender {
    
    
    if (CrewDataLoaded != 1) {
        
        
        UIAlertView *alert = [[UIAlertView alloc]
                              
                              initWithTitle:@"No Crew List Loaded"
                              
                              message:@"Please load crew list before opening the Risk Assessment."
                              
                              delegate:self
                              
                              cancelButtonTitle:@"CANCEL"
                              
                              
                              
                              otherButtonTitles: nil];
        
        [alert show];
    }else{
        
      
        pilotNameGlobal = [_arrayName7 objectAtIndex:linePilot];
        
        [self SaveValues];
        
        displayWindow = 0;
        
        [self displayWindows];
        
        RiskAssessment *second = [[RiskAssessment alloc] initWithNibName:nil bundle:nil];
        second.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
        second.modalPresentationStyle = UIModalPresentationFullScreen;
        [self presentModalViewController:second animated: YES];

        
        
    }
    
    
    
}

- (IBAction)buttonActionLoadCrewList:(id)sender {
    
    
    if (listStatusIsOnline == 1 ) {
        
        if (!([self is_online])) {
            UIAlertView *alert = [[UIAlertView alloc]
                                  initWithTitle:@"Error"
                                  message:@"Cannot reach server. Please check if this device is online."
                                  delegate:self
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil];
            [alert show];
        } else {
            [self loadLocationsFromServer];
            
        }
    }
   
}



- (IBAction)actionCancelEditPilotList:(id)sender {
    
      _viewEditPilotList.hidden = YES;
    
    
}

- (IBAction)actionClosePilotList:(id)sender {
    
    _viewPilotList.hidden = YES;
    
    [self.tableView deselectRowAtIndexPath:selectedPathTransfer animated:YES];
  
    
}

- (IBAction)actionShowPilotList:(id)sender {
    
    
    //NSLog(@"actionShowPilotList CrewDataLoaded  %.0f ", CrewDataLoaded);
    
    guidanceDictionary[@"guidanceBtnCrew"] =  @"ok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"ok";

    
    if (_viewPilotList.hidden == NO) { // viewPilotList visible
        
        _viewPilotList.hidden = YES;
        [self.tableView deselectRowAtIndexPath:selectedPathTransfer animated:YES];
        
        _viewEditPilotList.hidden=YES;
        
        
    } else { // viewPilotList hidden
        
        if (CrewDataLoaded==1) {
            
            _viewPilotList.hidden = NO;
            _viewEditPilotList.hidden=YES;
            _viewSeatOptions.hidden=YES;
          
            //_loadButton_label.text=@"Load Crew List";
            [viewOne bringSubviewToFront:_viewPilotList];   [viewOne bringSubviewToFront:viewTopTop];
            
            if (flagIsLandscape == 0) {
                
             _viewHelicopterInCenter.center = CGPointMake( _viewHelicopterInCenter.center.x + 45, _viewHelicopterInCenter.center.y);
                
            }
            
            
        } else {
            
             _viewPilotList.hidden = NO;
            _viewEditPilotList.hidden=NO;
           
            //_loadButton_label.text=@"Load Crew List";
            
            [viewOne bringSubviewToFront:_viewPilotList];   [viewOne bringSubviewToFront:viewTopTop];
            
        }
    }
    
    
    [self MainRoutine];

    
}

- (IBAction)actionShowFlightSettings:(id)sender {
    
    if (_viewLegData.hidden == YES) {
        _viewLegData.hidden = NO;
        
        [viewOne bringSubviewToFront:_viewLegData];
        
    }else{
         _viewLegData.hidden = YES;
    }
    
    
}




// seat options

- (void) seatOptions {
    
   
  
    _viewPilotList.hidden = NO; [viewOne bringSubviewToFront:_viewPilotList]; [viewOne bringSubviewToFront:viewTopTop];
    
    _inputSeatName.text =@"";
    
    [_viewPilotList bringSubviewToFront:_viewSeatOptions];
    
    
    
 
    
    
    
    return;
    
}



- (IBAction)buttonActionCancelSeatOptions:(id)sender {
    
    _viewPilotList.hidden = YES; [_viewPilotList sendSubviewToBack:_viewSeatOptions];
    
    _inputSeatName.text =@"";
    
    _viewFreeLoad.hidden = YES;
    
    
    
}





//functions for getting name and weight of crew table view

- (NSString *)nameForRow:(float)rowNo AndSection:(float)section {
    
    
    
    
    if (listStatusIsOnline == 1) {
        
        
        return [NSString stringWithFormat:@"%@, %@",[[[crew_sectioned objectAtIndex:section] objectAtIndex:rowNo]name],[[[crew_sectioned objectAtIndex:section] objectAtIndex:rowNo]initial]];
        
        
        
    }
    
    
    
    
    if ( rowNo>=0 && rowNo<self.tableViewDataName.count){
        return [self.tableViewDataName objectAtIndex:rowNo];
    } else {
        return nil;
    }
    
    
    
    
}

- (NSString *)weightForRow:(float)rowNo AndSection:(float)section {
    
    if (listStatusIsOnline == 1) {
        
        return [[[crew_sectioned objectAtIndex:section] objectAtIndex:rowNo]weight];
        
    }
    
    
    
    
    
    if ( rowNo>=0 && rowNo<self.tableViewDataName.count){
        return [self.tableViewDataWeight objectAtIndex:rowNo];
    } else {
        return nil;
    }
    
    
    
    
    
}

- (void)changeCurrentRowWithName:(NSString *)name andWeight:(NSString *)weight{
    
    //NSLog(@"changeCurrentRowWithName");
    
    
    
    
    NSIndexPath *selectedPath = [self.tableView indexPathForSelectedRow];
    if ( selectedPath != nil){
        [ self.tableViewDataName setObject:name atIndexedSubscript:selectedPath.row];
        [ self.tableViewDataWeight setObject:weight atIndexedSubscript:selectedPath.row];
        [ self sortData];
        [ self.tableView reloadData];
        
        
        
    }
    
    
    
    
    
};


- (void) sortData {
    
    
    BOOL didSwap = YES;
    while (didSwap) {
        didSwap = NO;
        for (int i=0; i< self.tableViewDataName.count-1; i++){
            NSString *nameI = [self.tableViewDataName objectAtIndex:i];
            for (int j=i+1; j< self.tableViewDataName.count; j++){
                NSString *nameJ = [self.tableViewDataName objectAtIndex:j];
                if ( [nameJ compare:nameI] == NSOrderedAscending){
                    [self.tableViewDataName exchangeObjectAtIndex:i withObjectAtIndex:j];
                    [self.tableViewDataWeight exchangeObjectAtIndex:i withObjectAtIndex:j];
                    didSwap = YES;
                }
            }
        }
    }
}



#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    
    
    if (listStatusIsOnline == 1) {
        
        return crew_sectioned.count;
        
        
    }
    
    
    
    
    return 1;
    
    
    
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    
    
    
    if (listStatusIsOnline == 0) {
        
        
        return self.tableViewDataName.count;
        
    }
    
    
    
    
    if (crew_sectioned.count==0) {
        return 0;
    } else {
        return [[crew_sectioned objectAtIndex:section] count];
    }
    
    
    
    
    
    
    
    
}


- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    
    
    if (crew_types.count==0) {
        return @"test";
    } else {
        return [crew_types objectAtIndex:section];
    }
}



static NSString *CellIdentifier = @"CELL";



- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    if (cell.selectionStyle != UITableViewCellSelectionStyleNone) {
        // Handle tap code here 
        cell.contentView.backgroundColor = [UIColor darkGrayColor];       
        previousCell.contentView.backgroundColor = [UIColor blackColor];        
    }
    previousCell = cell;
    
    if (flagEnterCrewListMode == 2) {
        [self loadSeatFromCrewList];
        [tableView deselectRowAtIndexPath:indexPath animated:YES];
    }
}




// color table cells

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    //NSLog(@"listStatusIsOnline %.0f ", listStatusIsOnline);
    
    
    if (listStatusIsOnline == 1) {
        
        
        UITableViewCell * normalCell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        
        
        if (normalCell == nil){
            
            normalCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        }
        
        
        //normalCell.textLabel.textAlignment = UITextAlignmentCenter;
        
        
        // color the cells
        // every other cell or red if NOK
        
        if (indexPath.section %2==0) {
            normalCell.textLabel.textColor=[UIColor colorWithRed:255.0f/255.0f green:148.0f/255.0f blue:0.0f/255.0f alpha:1.0f]; // yellow
            
        } else {
            normalCell.textLabel.textColor=[UIColor colorWithRed:140.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
        }
        if ([[[[crew_sectioned objectAtIndex:indexPath.section] objectAtIndex:indexPath.row]status] isEqualToString:@"NOK"]) {
            normalCell.textLabel.textColor=[UIColor redColor];
        }
        
        normalCell.contentView.backgroundColor = [UIColor blackColor];
        
        
        
        
        normalCell.selectionStyle = UITableViewCellSelectionStyleBlue;
        
        
        NSString *name_combined = [NSString stringWithFormat:@"%@, %@",[[[crew_sectioned objectAtIndex:indexPath.section] objectAtIndex:indexPath.row]name],[[[crew_sectioned objectAtIndex:indexPath.section] objectAtIndex:indexPath.row]initial]];
        
        
        [normalCell.textLabel setText:name_combined]; // hier Name drucken
        
        
        return normalCell;
        
        
        
    }else{
        
        
        UITableViewCell * normalCell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        
        if (normalCell == nil){
            
            normalCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        }
        
        NSString *cellLabel =  [ NSString stringWithFormat:@"%@, %@ lbs", [ self.tableViewDataName objectAtIndex:indexPath.row],
                                [ self.tableViewDataWeight objectAtIndex:indexPath.row]];
        
        _labelPilotCheck.text = cellLabel;
        
        normalCell.textLabel.textColor=[UIColor whiteColor];
        
        normalCell.textLabel.textColor=[UIColor colorWithRed:255.0f/255.0f green:222.0f/255.0f blue:0.0f/255.0f alpha:1.0f]; // yellow
        
        normalCell.textLabel.textColor=[UIColor whiteColor];
        
        normalCell.contentView.backgroundColor = [UIColor blackColor];
        
        [normalCell.textLabel setText:cellLabel];
        
        return normalCell;
        
        
    }
    
    
    
    
    
    
}





- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    // First, create the text that will end up in the input field if you'll return YES:
    NSString *resultString = [textField.text stringByReplacingCharactersInRange:range withString:string];
    
    // Now, validate the text and return NO if you don't like what it'll contain.
    // You accomplish this by trying to convert it to a number and see if that worked.
    NSNumberFormatter *numberFormatter = [[NSNumberFormatter alloc] init];
    [numberFormatter setNumberStyle:NSNumberFormatterDecimalStyle];
    NSNumber* resultingNumber = [numberFormatter numberFromString:resultString];
    return resultingNumber != nil;
}


// ********************************************************************************************************************************************
// ********************************************************************************************************************************************
// ********************************************************************************************************************************************






/// ================================================================  DETECT PORTRAIT LANDSCAPE ==================================================================




-(void)viewDidAppear:(BOOL)animated
{
    [self setUpViewForInterfaceOrientation:self.interfaceOrientation];
    
    //[[UIApplication sharedApplication] statusBarOrientation];
    
    
}

- (void) setUpViewForInterfaceOrientation:(UIInterfaceOrientation) interfaceOrientation
{
    if (UIInterfaceOrientationIsLandscape(interfaceOrientation)) {
        
        //NSLog(@"Start in Landscape ");
        
        [self sortForLandscape];
    }
    
    else {
        //NSLog(@"Start in Portrait ");
        
        //[self sortForPortrait];
    }
    
    
}



- (void)willAnimateRotationToInterfaceOrientation:
(UIInterfaceOrientation)toInterfaceOrientation
                                         duration:(NSTimeInterval)duration
{
    if (toInterfaceOrientation == UIInterfaceOrientationLandscapeLeft ||
        toInterfaceOrientation == UIInterfaceOrientationLandscapeRight)
    {
        
        [self sortForLandscape];
    }
    else
    {
        
        //[self sortForPortrait];
        
        
        
        
    }
}


-(void) sortForLandscape { // normal!
    
    //NSLog(@"sortForLandscape");
    
    flagIsLandscape = 1;
    
    
    configMode = 0;
    
    _viewHelicopterInCenter.clipsToBounds = YES;
    
    _scrollViewSpecialEquipList.frame = CGRectMake(0, 126, 1024, 570);
    
    _viewSpecialEquipLowerTotals.frame = CGRectMake(0, 687, 1024, 60);
    
    _viewDlist.frame = CGRectMake(0, 0, 1024, 748);
    
    dListClassView_.frame = CGRectMake(436, 105, 475, 546);
    
    calculatePerformanceClassView_.frame  = CGRectMake( 0, 114, 646, 634 );
    _viewCGLong.frame  = CGRectMake( 646, 140, 374, 282 );
    _viewMeasureCGenvelope.frame  = CGRectMake( 50, 14, 309, 255 );
    _viewCGenvelopeFrame.frame  = CGRectMake( 0, 0, _viewCGLong.frame.size.width, _viewCGLong.frame.size.height );
    _viewFuelPathCG.frame  = CGRectMake( 0, 0, _viewCGLong.frame.size.width, _viewCGLong.frame.size.height );
    _viewFuelPathCGLat.frame  = CGRectMake( 0, 0, _viewCGlat.frame.size.width, _viewCGlat.frame.size.height );
    _labelAvailableExternalLoad.frame = CGRectMake(80, 258, 242, 21);
    
    
    _viewTrennerTop.hidden = NO;
    _buttonmanifest.frame = CGRectMake( 967, 4, 50, 50 ) ;
    _buttonSummary.frame = CGRectMake( 967, 4, 50, 50 ) ;
    _buttonSpecialEquipList.frame = CGRectMake( 955, 5, 50, 50 ) ;
    viewTopDisplayButtons.frame = CGRectMake( -2, 54, 1031, 73 ) ;
    
    
    viewMain.frame = CGRectMake( 0, -10, 1024, 768 );
    viewOne.frame = CGRectMake( 0, 20, 1024, 748 );
    
    viewLoadManifest.frame = CGRectMake( 0, 57, 1024, 694 );
    
    _viewSignature.frame = CGRectMake( 0, 54, 1024, 704 );
  
    _viewFlightManager.frame = CGRectMake(0, 0, 1024, 748);
    
    //_viewMCDUdata.frame = CGRectMake(117, 24, 765, 533);
    
    viewSetup.frame = CGRectMake(0, 0, 1024, 748);
    
    _viewSetupButtons.frame = CGRectMake(-2, 580, 1026, 54);
    
    
    enterPad.frame = CGRectMake(  648, 410, 377, 346 ) ;
    
    
    _logoOnly.frame = CGRectMake( 583, 0 ,445, 51 ) ;
    
    
    UIImage *background = [UIImage imageNamed:@"Flight_Page.png"];
    [_backgroundMain setImage:background];
    
    

    
    UIImage *backgroundFlight = [UIImage imageNamed:@"Flight_Page.png"];
    [_backgroundFlightPage setImage:backgroundFlight];
    [_backgroundFlightManager setImage:backgroundFlight];
    [_backgroundSetupPage setImage:backgroundFlight];
    
    
    
    UIImage *triangle = [UIImage imageNamed:@"triangle white.png"];
    [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];
    
    
    _backgroundMain.frame = CGRectMake( 0, 10, 1024, 748 ) ;
    
    _viewStationsWindow.frame = CGRectMake( 0, 127, 643, 603 ) ;
    
    
    
    _triangleWhite.frame = CGRectMake( 188, 13, 19, 38 );
    
    _viewButtonOATPA.frame = CGRectMake( -1, 6, 186, 52 );  buttonDisplayEnvironment.frame = CGRectMake( 1, 0, 182, 52 );
    _viewButtonOATlabelOAT.frame = CGRectMake( 2, 1, 90, 23 ); labelDisplayOAT.frame = CGRectMake( 2, 22, 92, 23 );
    _viewButtonOATLabelPA.frame = CGRectMake( 82, 1, 90, 23 ); labelDisplayPA.frame = CGRectMake( 75, 22, 92, 23 );
    
    
    
    _trennerBottom.hidden = YES;
    
    _viewCGValues.frame  = CGRectMake( 650, 420, 377, 74 );
    
   
    
    _viewCGlat.frame  = CGRectMake( 646, 505, 374, 282 );
    

    
    
    _viewMeasureCGenvelope_LAT.frame  = CGRectMake( 50, 14, 309, 165 ); [self setCGenvelope];
    
    _trennerVerticalBottom.hidden  = YES;
    
    viewEnvironment.frame  = CGRectMake( 645, 117, 382, 304 );
    
    _viewPilotList.frame = CGRectMake( 647, 115, 383, 633 ); // landscape
    _tableView.frame = CGRectMake( 0, 0, _viewPilotList.frame.size.width, _viewPilotList.frame.size.height );
   
    
    _buttonONLINEloadCrewList.frame = CGRectMake( 0, 584, 388, 50 );
    
    [viewMain bringSubviewToFront:_viewPilotList];
    
    _labelLoadCrewList.frame = CGRectMake( 96, 598, 197, 23 );
    
    
    ScrollViewManifest.frame = CGRectMake(0, -2, 1024, 694);
    [ScrollViewManifest setContentSize:CGSizeMake(644, 1600)];
    [ScrollViewManifest scrollRectToVisible:CGRectMake(0, 0, 644, 635) animated:YES];
    
    _scrollViewSummaryManifest.frame = CGRectMake(0, 0, 1024, 694);
    [_scrollViewSummaryManifest setContentSize:CGSizeMake(644, 1600)];
    
    
    
    _viewConfigurations.frame = CGRectMake(647, 114, 377, 635); [viewOne bringSubviewToFront:_viewConfigurations];
    
    
    _viewSelectHelicopter.frame = CGRectMake( 0, 0, 1040, 750 );
    
 
    
    _viewManifestLowerButtons.frame = CGRectMake( 0, 644, 1024, 50 );
    _viewSummaryLowerButtons.frame  = CGRectMake( 0, 644, 1024, 50 ); // landscape
    
    [self addPerformanceButtons];
    
    
    
    flagOrientationHasChanged = 1;

    _scrollViewSetupItems.frame = CGRectMake(17, 119, 725, 576);
    
    //NSLog(@"sortForLandscape");
    //[self setBasicsForConfiguration];
    
    [self displayWindows];
    
    
    
    
}




-(void) sortForPortrait {
    
    //NSLog(@"sortForPortrait");
    
    flagIsLandscape = 0;
 
    configMode = 0;
    
    _viewHelicopterInCenter.clipsToBounds = YES;
    
    
    _scrollViewSpecialEquipList.frame = CGRectMake(0, 126, 1024, 1024);
    
    _viewSpecialEquipLowerTotals.frame = CGRectMake(0, 944, 1024, 60);
    
   
    
    _viewDlist.frame = CGRectMake(0, 0, 768, 1024);
    
    dListClassView_.frame = CGRectMake(160, 305, 475, 546);
    
    
    
    calculatePerformanceClassView_.frame  = CGRectMake( 0, 114 - 58, 643, 630 );
    
     _viewCGLong.frame  = CGRectMake( 1, 712, 374, 289 );
    
    _viewMeasureCGenvelope.frame  = CGRectMake( 50, 17, 309, 255 );
    
    _viewCGenvelopeFrame.frame  = CGRectMake( 0, 0, _viewCGLong.frame.size.width, _viewCGLong.frame.size.height );
    
    _viewFuelPathCG.frame  = CGRectMake( 0, 0, _viewCGLong.frame.size.width, _viewCGLong.frame.size.height );
    
    _labelAvailableExternalLoad.frame = CGRectMake(80, 258, 242, 21);
    
    
    
    viewTopDisplayButtons.frame = CGRectMake( 645, 54, 150, 650 ) ;
    
    [self addPerformanceButtons];
    
    _buttonmanifest.frame = CGRectMake( 710, 4, 50, 50 ) ;
    _buttonSummary.frame = CGRectMake( 710, 4, 50, 50 ) ;
    _buttonSpecialEquipList.frame = CGRectMake( 725, 5, 50, 50 ) ;
    
    viewMain.frame = CGRectMake( 0, -10, 1024, 1900 );
    
    viewOne.frame = CGRectMake( 0, 20, 1024, 1900 );
    
    viewLoadManifest.frame = CGRectMake( 0, 57, 1024, 1900 );
    
    _viewSignature.frame = CGRectMake( -128, -1, 1024, 1010 );
    
 
    
       _viewFlightManager.frame = CGRectMake(0, 0, 768, 1004);
    
    //_viewMCDUdata.frame = CGRectMake(10, 24, 765, 533);
    
    
    viewSetup.frame = CGRectMake(0, 0, 768, 1004);
    
    _viewSetupButtons.frame = CGRectMake(-2, 840, 1026, 54);
    
    enterPad.frame = CGRectMake(  389, 690, 380, 346 ) ;
    
    
    
    _logoOnly.frame = CGRectMake( 446, 5, 325, 42 ) ;
    
    
    
    UIImage *background = [UIImage imageNamed:@"WB_background_portrait.png"];
    [_backgroundMain setImage:background];
 
    
    
    UIImage *triangle = [UIImage imageNamed:@"triangle white down.png"];
    [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];
    
    UIImage *backgroundFlight = [UIImage imageNamed:@"WB_background_generic_empty.png"];
    [_backgroundFlightPage setImage:backgroundFlight];
     [_backgroundFlightManager setImage:backgroundFlight];
    [_backgroundSetupPage setImage:backgroundFlight];
    
    
    
    
    _backgroundMain.frame = CGRectMake( 0, 10, 768, 1004 ) ;
    
   
    
    
    _viewStationsWindow.frame = CGRectMake( 0, 70, 643, 603 ) ;
    
    
    
    _triangleWhite.frame = CGRectMake( 45, 105, 38, 19 );
    
    float yGapEnvi = 5;
    
    _viewButtonOATPA.frame = CGRectMake( -1, 3, 128, 95 );  buttonDisplayEnvironment.frame = CGRectMake( 0, 0, 128, 95 ) ;
    _viewButtonOATlabelOAT.frame = CGRectMake( 0, yGapEnvi, 128, 23 ) ; labelDisplayOAT.frame = CGRectMake( 0, yGapEnvi+20, 128, 23 ) ;
    _viewButtonOATLabelPA.frame = CGRectMake( 0, yGapEnvi+20+20, 128, 23 ) ; labelDisplayPA.frame = CGRectMake( 0, yGapEnvi+20+20+20, 128, 23 ) ;
    
    
    _trennerBottom.hidden = NO; [viewOne bringSubviewToFront:_trennerBottom];
    _viewCGValues.frame  = CGRectMake( 400, 710, 377, 74   );
    _viewCGlat.frame  = CGRectMake( 390, 790, 374, 289 );
    
    _viewMeasureCGenvelope_LAT.frame  = CGRectMake( 50, 14, 309, 135 ); [self setCGenvelope];
    _trennerVerticalBottom.hidden  = NO; [viewOne bringSubviewToFront:_trennerVerticalBottom];
    viewEnvironment.frame  = CGRectMake( 0, 712, 400, 600 );
   
    _viewPilotList.frame = CGRectMake( 0, 49, 383, 633 ); // portrait
    _tableView.frame = CGRectMake( 0, 0, _viewPilotList.frame.size.width, _viewPilotList.frame.size.height );
   
    
    _buttonONLINEloadCrewList.frame = CGRectMake( -10, 430, 388, 50 );
    [viewMain bringSubviewToFront:_viewPilotList];
    _labelLoadCrewList.frame = CGRectMake( 96, 442, 197, 23 );
    ScrollViewManifest.frame = CGRectMake(0, -2, 768, 980);
    [ScrollViewManifest setContentSize:CGSizeMake(1024, 1600)];
    [ScrollViewManifest scrollRectToVisible:CGRectMake(0, 0, 644, 635) animated:YES];
    _scrollViewSummaryManifest.frame = CGRectMake(0, 0, 768, 980);
    [_scrollViewSummaryManifest setContentSize:CGSizeMake(1024, 1600)];
    
    
    _viewConfigurations.frame = CGRectMake(0, 530, 386, 630); [viewOne bringSubviewToFront:_viewConfigurations];
   
    _viewSelectHelicopter.frame = CGRectMake( -150, 0, 1040, 750 );
    
    _viewManifestLowerButtons.frame = CGRectMake( 0, 900, 1024, 50 );
    _viewSummaryLowerButtons.frame  = CGRectMake( 380, 957, 390, 50 ); // portrait
    _scrollViewSetupItems.frame = CGRectMake(17, 119, 725, 760);

    
    [self addPerformanceButtons];
    
    flagOrientationHasChanged = 1;
    
    //NSLog(@"sortForPortrait");
    [self setBasicsForConfiguration];
    
    [self displayWindows];
    
  
    
}









- (void)viewDidUnload
{
    [super viewDidUnload];
}





- (EquipmentPackages*)currentFlightEquipmentPackage {
    return [[EquipPackagesManager sharedInstance] packageForKey:Flight.text];
}



#pragma mark MainRoutine


- (IBAction)actionLOGACViewSettings:(id)sender {
    
    [self.view endEditing:TRUE];
    
    //NSLog(@"_viewMeasureFrontSeats.center.y %.0f ", _viewMeasureFrontSeats.center.y);
    //NSLog(@"_viewMeasureFrontSeats.frame.origin.y %.0f ", _viewMeasureFrontSeats.frame.origin.y);
    
    _viewMeasureFrontSeats.frame = CGRectMake(_viewMeasureFrontSeats.frame.origin.x, [_iacMeasureFrontSeatsY.text floatValue], _viewMeasureFrontSeats.frame.size.width, _viewMeasureFrontSeats.frame.size.height);
    _viewMeasureRearSeats.frame = CGRectMake(_viewMeasureRearSeats.frame.origin.x, [_iacMeasureRearSeatsY.text floatValue], _viewMeasureRearSeats.frame.size.width, _viewMeasureRearSeats.frame.size.height);
    _viewSeatSize.frame = CGRectMake(_viewSeatSize.frame.origin.x, _viewSeatSize.frame.origin.y, [_iacSeatWidth.text floatValue] , [_iacSeatHeight.text floatValue]);
    _viewMeasureCenter.frame = CGRectMake([_iacLatCenter.text floatValue], _viewMeasureCenter.frame.origin.y, _viewMeasureCenter.frame.size.width , _viewMeasureCenter.frame.size.height);
    _viewMeasureLatRight.frame = CGRectMake([_iacLatCenter.text floatValue] + [_iacLatRight.text floatValue], _viewMeasureLatRight.frame.origin.y, _viewMeasureLatRight.frame.size.width , _viewMeasureLatRight.frame.size.height);
     _ACtopView.frame = CGRectMake([_iacACX.text floatValue], [_iacACY.text floatValue], [_iacACwidth.text floatValue], [_iacACheight.text floatValue]);
    
    [_arrayName11 replaceObjectAtIndex:[_iacStationID.text integerValue] withObject:_iacOffsetY.text];
    [_arrayName13 replaceObjectAtIndex:[_iacStationID.text integerValue] withObject:_iacOffsetX.text];
    
    [_arrayName19 replaceObjectAtIndex:[_iacStationID.text integerValue] withObject:_iacSizeX.text];
    [_arrayName20 replaceObjectAtIndex:[_iacStationID.text integerValue] withObject:_iacSizeY.text];
    
    previousConfiguration = 999;
    [self createListoItemsSlidersAndInterior];
    
    [self MainRoutine];
    
}




- (void) MainRoutine {
    
    //NSLog(@"MainRoutine ");
    
    // compute total seats removed
    
    
     loopStart = [NSDate date];
    
    
    // hoist set max load
    
    
    if (OAT > 0) {
        
        maxHoistLoad = 249;
        [_arrayName9 replaceObjectAtIndex:lineHoistLoad withObject:@"249"];
        
    }else{
        
        maxHoistLoad = 227;
        [_arrayName9 replaceObjectAtIndex:lineHoistLoad withObject:@"227"];
        
        if ([[_arrayName2 objectAtIndex:lineHoistLoad] floatValue] > 227) {
            _labelAvailableExternalLoad.text = @"HOIST MAX 227kg (OAT <=0ºC)";
            _labelAvailableExternalLoad.backgroundColor =  [UIColor redColor];
            _labelAvailableExternalLoad.textColor = [UIColor whiteColor];
        }
    }
    
    
    
  
    _labelRegaRemark.hidden = NO;
    _labelRegaRemark.text = [_arrayName23 objectAtIndex:44];
    
    if (_labelRegaRemark.text.length < 1) {
        _labelRegaRemark.hidden = YES;
    }
    
    float totalWgtRemoved = 0;
    float totalMomtRemoved = 0;
    float totalArmRemoved = 0;
    
    float totalMomtRemovedLat = 0;
    float totalArmRemovedLat = 0;
    
    float wgtRemoved =0;
    float momRemoved =0;
    float momRemovedLat =0;
    
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = [[_arrayName23 objectAtIndex:13] intValue];

    
    for(int i =configStationsStart; i<configStationsEnd+1; i++) {
        
        
        if ( [[_arrayName8 objectAtIndex:i] floatValue] == 1) {
            
            wgtRemoved = [[_arrayName17 objectAtIndex:i] floatValue] ;
            
            float itemArm = 0;
            if ([[_arrayName18 objectAtIndex:i] length] > 1) {
             
                itemArm = [[_arrayName18 objectAtIndex:i]floatValue];
            }else{
                itemArm = [[_arrayName3 objectAtIndex:i]floatValue];
            }
            
            momRemoved = wgtRemoved * itemArm;
            momRemovedLat = wgtRemoved * [[_arrayName5 objectAtIndex:i] floatValue];
            
        }else{
            
            wgtRemoved = 0;
            momRemoved = 0;
            momRemovedLat = 0;
        }
        
        totalWgtRemoved = totalWgtRemoved + wgtRemoved;
        totalMomtRemoved = totalMomtRemoved + momRemoved;
        totalArmRemoved = totalMomtRemoved / totalWgtRemoved;
        
        
        totalMomtRemovedLat = totalMomtRemovedLat + momRemovedLat;
        totalArmRemovedLat = totalMomtRemovedLat / totalWgtRemoved;
        
        if (totalMomtRemoved == 0) {
            totalArmRemoved = 0;
        }
        
        if (totalMomtRemovedLat == 0) {
            totalArmRemovedLat = 0;
        }
        
    }
    
    
    
    _labelRemovedWgt.text = [[NSString alloc] initWithFormat:@"%.2f", totalWgtRemoved ];
    _labelRemovedArm.text = [[NSString alloc] initWithFormat:@"%.0f", totalArmRemoved ];
    _labelRemovedMoment.text = [[NSString alloc] initWithFormat:@"%.0f", totalMomtRemoved ];
    
    _labelRemovedArmLat.text = [[NSString alloc] initWithFormat:@"%.0f", totalArmRemovedLat ];
    _labelRemovedMomentLat.text = [[NSString alloc] initWithFormat:@"%.0f", totalMomtRemovedLat ];
    
    [_arrayName2 replaceObjectAtIndex:4 withObject:_labelRemovedWgt.text];
    [_arrayName3 replaceObjectAtIndex:4 withObject:_labelRemovedArm.text];
    [_arrayName4 replaceObjectAtIndex:4 withObject:_labelRemovedMoment.text];
    [_arrayName5 replaceObjectAtIndex:4 withObject:_labelRemovedArmLat.text];
    [_arrayName6 replaceObjectAtIndex:4 withObject:_labelRemovedMomentLat.text];
    
    _labelConfigurationName.text = arrayConfigurations[configuration];
    
    _labelBaseName.text = _dropDownBaseID.text;
    
    
    
    
    [self calcLegTime];

   
    
    if (flagShowPerformance == 1) {
        _viewLegButtons.hidden = YES;
        
         viewTopDisplayButtons.hidden = NO;
        
    }else{
        _viewLegButtons.hidden = NO;
        
         viewTopDisplayButtons.hidden = YES;
        
    }
 
    
    if (_segmentSwapMode.selectedSegmentIndex == 1) {
        panRecognizerForGhost.enabled = YES;
    }else{
         panRecognizerForGhost.enabled = NO; ;
    }
    

    
    
    
    if (_switchAdjustACTopView.on == YES) {
        _viewACViewSettings.hidden = NO;
        
        [viewOne bringSubviewToFront:_viewACViewSettings];
        
        _iacMeasureFrontSeatsY.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewMeasureFrontSeats.frame.origin.y ];
        _iacMeasureRearSeatsY.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewMeasureRearSeats.frame.origin.y ];
        
        _iacSeatWidth.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewSeatSize.frame.size.width];
        _iacSeatHeight.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewSeatSize.frame.size.height];
        
        _iacLatCenter.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewMeasureCenter.frame.origin.x];
        _iacLatRight.text =  [ [NSString alloc] initWithFormat:@"%.0f", _viewMeasureLatRight.frame.origin.x - _viewMeasureCenter.frame.origin.x];
        
        _iacACX.text =  [ [NSString alloc] initWithFormat:@"%.0f", _ACtopView.frame.origin.x];
        _iacACY.text =  [ [NSString alloc] initWithFormat:@"%.0f", _ACtopView.frame.origin.y];
        _iacACwidth.text =  [ [NSString alloc] initWithFormat:@"%.0f", _ACtopView.frame.size.width];
        _iacACheight.text =  [ [NSString alloc] initWithFormat:@"%.0f", _ACtopView.frame.size.height];
        
        
        
    }else{
        
         _viewACViewSettings.hidden = YES;
        
    }
    
    
     //NSLog(@"MainRoutine previousdButton %.0f ", previousdButton);
    
    
    
    
    
    
    
    //NSLog(@"allLegsPerFlightArray  %d ", allLegsPerFlightArray.count);
    
    
    
    //NSLog(@"MainRoutine ");
    
    
    if (flagIsLandscape == 1) {
        
        viewEnvironment.frame  = CGRectMake( 645, 126, 382, 304 ); // landscape
        
        _viewEnvironmerntButtons.frame  = CGRectMake( 0, 256, 391, 48 );
        
       
        
    }else{
        
        viewEnvironment.frame  = CGRectMake( 0, 695, 400, 600 ); // portrait
        
        _viewEnvironmerntButtons.frame  = CGRectMake( 0, 272, 391, 48 );
        
        
    }
    
   
    
    
    
   
    
    
    if (displayWindow > 100) {
        
        _viewUniversalExtras.hidden = NO;
       
        if (flagIsLandscape == 1) {
            
            _trennerBottom.hidden = YES; _trennerVerticalBottom.hidden = YES;
            
            viewEnvironment.frame  = CGRectMake( 645, 126, 382, 304 ); // landscape
            
             _viewUniversalExtras.frame  = CGRectMake( 645, 419, 382, 283 );
            
            
        }else{
            
            _trennerBottom.hidden = NO; _trennerVerticalBottom.hidden = NO;
            
            viewEnvironment.frame  = CGRectMake( 0, 695, 390, 600 ); // portrait
            
            _viewUniversalExtras.frame  = CGRectMake( 390, 695, 390, 300 );
        }
        
        
        
    }else{
        
        _viewUniversalExtras.hidden = YES;
        
        
        if (flagIsLandscape == 1) {
             _trennerBottom.hidden = YES; _trennerVerticalBottom.hidden = YES;
        }
        
        if (flagIsLandscape == 0 & configMode == 0) {
            _trennerBottom.hidden = NO; _trennerVerticalBottom.hidden = NO;
        }
        
        
    }
    
    
    //NSLog(@"arrayConfigurations    %@  - %@", arrayConfigurations, arrayConfigButtons);
    
    
    
    
    // fuel arie ************************************************************************************
    // fuel arie ************************************************************************************
    // fuel arie ************************************************************************************
    
    if (_segmentFuelVolumeOrMass.selectedSegmentIndex == 0) {
        fuelEnterMode = @"volume";
    }else{
        fuelEnterMode = @"mass";
    }
    
    
   
    
    if ([fuelUnits isEqualToString:@"lbs"]) {
        
        _unitFuelFlow.text = @"lbs/h";
        
        _unitFuelDensity.text = @"lbs/Gal";
        
        
        
        
        
        if ([fuelEnterMode isEqualToString:@"mass"]) {
            
            _labelFuelUnitMainTank.text = @"lbs";
            _labelFuelUnitLandingFuel.text = @"lbs";
            
            _labelMainFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value   ]; // lbs in gallons  or kg in liter
            _labelFuelUnitOnBar.text = @"Gal";
            
            _labelLandingFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value   ]; // lbs in gallons  or kg in liter
            
            
            
        }else{
            
            _labelFuelUnitMainTank.text = @"Gal";
            _labelFuelUnitLandingFuel.text = @"Gal";
            
            _labelMainFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue]  ]; // lbs in gallons  or kg in liter
            _labelFuelUnitOnBar.text = @"lbs";
            
            _labelLandingFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value * [_inputSpecificFuelMassPerVolume.text floatValue]  ]; // lbs in gallons  or kg in liter
            
        }
        
        
        
    }else{
        
        _unitFuelFlow.text = @"kg/h";
        
        _unitFuelDensity.text = @"kg/ltr";
        
        
      
        
        
        if ([fuelEnterMode isEqualToString:@"mass"]) {
            
            _labelFuelUnitMainTank.text = @"kg";
            _labelFuelUnitLandingFuel.text = @"kg";
            
            
            _labelMainFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value   ]; // lbs in gallons  or kg in liter
            _labelFuelUnitOnBar.text = @"ltr";

            _labelLandingFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value   ]; // lbs in gallons  or kg in liter
            
            
        }else{
            
            _labelFuelUnitMainTank.text = @"Ltr";
            _labelFuelUnitLandingFuel.text = @"Ltr";
            
            
            _labelMainFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value  * [_inputSpecificFuelMassPerVolume.text floatValue] ]; // lbs in gallons  or kg in liter
            _labelFuelUnitOnBar.text = @"kg";
            
            _labelLandingFuelOnBar.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value * [_inputSpecificFuelMassPerVolume.text floatValue]  ]; // lbs in gallons  or kg in liter
        }
        
        
    }
    
    
    
    
    
    
    if ([fuelEnterMode isEqualToString:@"mass"]) {
        
        _labelSliderFuelMain.text =  [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue]];
        
        _labelSliderFuelLanding.text =  [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value  * [_inputSpecificFuelMassPerVolume.text floatValue]];
        
    }else{
        
        _labelSliderFuelMain.text =  [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value ];
        
        _labelSliderFuelLanding.text =  [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelLanding.value ];
        
    }
    
    _labelFuelOnBoard.text = _labelSliderFuelMain.text;
    
    // fuel arie ************************************************************************************
    // fuel arie ************************************************************************************
    // fuel arie ************************************************************************************
    

    
    
   
  
    
    [self calculateListo];  // from mainRoutine
    
    [self updateSeatButtonLabels];
    
   
    
    
    //NSLog(@"linePatient %d ", linePatient);
    
   _labelPatientWeight.text =  [ [NSString alloc] initWithFormat:@"%.0f kg", [[_arrayName2 objectAtIndex:linePatient]floatValue] * [[_arrayName8 objectAtIndex:linePatient]floatValue] ];
   
    
    _mani_ACtype.text = AC_Type;
    
    _mani_Configuration.text = arrayConfigurations[configuration];
    
    
    
    
    
    
    connectedToFleetControl = 1;
    
    if (connectedToFleetControl == 1) {
        
        listStatusIsOnline = 1;
        
        
    }else{
        
        listStatusIsOnline = 0;
        
        HeliDataLoaded = 0;
        
    }
    
    
    
    
    
    
    
   
    
    _labelFuelMainPercent.text =  [ [NSString alloc] initWithFormat:@"%.0f", (100.0/tankCapacityVolume) * _sliderFuelMain1.value ];
    
    _labelFuelLandingPercent.text =  [ [NSString alloc] initWithFormat:@"%.0f", (100.0/tankCapacityVolume) * _sliderFuelLanding.value ];
    
    _labelHeadwind2.text = [ [NSString alloc] initWithFormat:@"%.0f kts", _sliderHeadwind2.value];
    
    _labelKIAS.text = [ [NSString alloc] initWithFormat:@"%.0f kt", _sliderKIAS.value];
    
 
   
    
   
    float OATCelsius = OAT;
    
    float fahrenheit = (OATCelsius * 1.8) + 32;
    
    
    
    
    
    // Environment ALTIMETRY
    
    float QNHEuro = 0;
    
    QNHEuro = sliderQNH.value * 33.86530749;
    
    labelQNHEuro.text = [ [NSString alloc] initWithFormat:@"%.1f", QNHEuro];
    
    labelQNH.text = [ [NSString alloc] initWithFormat:@"%.2f", sliderQNH.value];
    
    
    
    // MSL slider ****   ****   ****   ****   ****   ****   ****   ****   ****
    
    
    
    //float MSL = sliderHp.value - ((29.92- sliderQNH.value) * 1000);
    
    
    float MSL = _sliderMSL.value;
    
    float paCalc = ((29.92 - sliderQNH.value) *1000);
    if (paCalc < 0.001 & paCalc > -0.001) {
        paCalc = 0;
    }
    
     
    
    sliderHp.value = MSL + paCalc;
     
   
    
    _labelMSL.text      = [ [NSString alloc] initWithFormat:@"%.0f", MSL];
    _labelMslMeter.text = [ [NSString alloc] initWithFormat:@"%.0f", MSL * 0.3048];
    
    MSLfeet.text = [ [NSString alloc] initWithFormat:@"%.0f", MSL];
    
   
    MSLtoHpDifference = MSL - sliderHp.value;
    
    // animate Hp Lines
    
    
    _graphicHpLines.center = CGPointMake( 322, 318 - (MSLtoHpDifference * 0.023)  );
    
    
 
    
    
    displayHeliRegistration.text = vFlightRegistration.text ;
    
    
    
    
    if (displayWindow ==1  ) {
        
        
        [buttonDisplayEnvironment setBackgroundImage:buttonBlue forState:UIControlStateNormal];
        
        
        
    } else {
        
        [buttonDisplayEnvironment setBackgroundImage:buttonGrey forState:UIControlStateNormal];
        
    }         
    
    
       
    
    // check for options
    
    if ( [[self.arrayName2 objectAtIndex: lineOptions + 1 ] isEqualToString:@"0"]  ) {
        
        flagSlump = 0;
        
    }else{
        
        flagSlump = 1;
        
    }
    
    if ( [[self.arrayName2 objectAtIndex: lineOptions + 2 ] isEqualToString:@"0"]  ) {
        
        flagSkies = 0;
        
    }else{
        
        flagSkies = 1;
        
    }
    
    
   
    
    
    
       
    
    
 

  
    
    
    
    
    
    // ************************************   Fuel Flow  **********************************************************************
    
    
    // get fuel on board:
    
    //_labelFuelLiter.text = [ [NSString alloc] initWithFormat:@"%.0f", _sliderFuelMain1.value / [inputSpecificFuelMassPerVolume.text floatValue]  ];
    
    
    
    float fuelConsumtionKgh = [inputFuelFlowOverride.text floatValue];
    
    //float flightTimeHours = [vFlightTimeHours.text floatValue] +  ([vFlightTimeMinutes.text floatValue] /60);
    
    float endurance = (fuelTO / fuelConsumtionKgh) * 60;
    
    float reserveTimeMinutes = (fuelLD / fuelConsumtionKgh) * 60;
    
    _lFuelEndurance.text = [ [NSString alloc] initWithFormat:@"%.0f min", endurance  ];
    
    _lReserveTime.text = [ [NSString alloc] initWithFormat:@"%.0f min", reserveTimeMinutes  ];

    _warningLabelFuelEndurance.hidden = YES;
    
    
    
   
    
    
    
    
    
    // labels  lat and long ***************************************************************************************
    
    
    labelWeightTakeoff.text     = [ [NSString alloc] initWithFormat:@"%.0f", vTOW   ];
    
    
    labelCGTakeoff.text         = [ [NSString alloc] initWithFormat:@"%.2f", vTOWArm/1000  ];
    
  
    

    
    
    
    labelWeightLanding.text     = [ [NSString alloc] initWithFormat:@"%.0f", vLDW  ];
    
    
    
    _labelWeightLanding2.text     = labelWeightLanding.text;
    
    _labelWeightTakeoff2.text     = labelWeightTakeoff.text;
    
    
    
    
    
    
    
    labelCGLanding.text         = [ [NSString alloc] initWithFormat:@"%.2f", vLDWArm /1000 ];
    
    
    labelWeightZeroFuel.text    = [ [NSString alloc] initWithFormat:@"%.0f", lZFW ];
    
    labelCGZeroFuel.text        = [ [NSString alloc] initWithFormat:@"%.2f", lZFWArm /1000 ];
    

    //NSLog(@"vTOWArmLat.text %@", vTOWArmLat.text);

    
    
    if ([unitsWeight.text isEqualToString:@"kg"]) {
        
        if (CGLATTOW > 0) {
            
            labelCGLat.text = [ [NSString alloc] initWithFormat:@"%.1f", vTOWArmLat * 100 ];
            
        } else {
            labelCGLat.text = [ [NSString alloc] initWithFormat:@"%.1f", vTOWArmLat * 100 ];
        }
        
            
            } else {
                
                if (CGLATTOW > 0) {
                    
                    labelCGLat.text = [ [NSString alloc] initWithFormat:@"%.1f", vTOWArmLat ];
                    
                } else {
                    labelCGLat.text = [ [NSString alloc] initWithFormat:@"%.1f", vTOWArmLat ];
                }
                
                    
                    }
    

    
    
    
    
   
    
    
    // crosses ***************************************************************************************
    
    
    // fuel bar
    
    
    _fuelBarMain.layer.anchorPoint = CGPointMake(0.5, 1);
    
    float totalFuelPercent = (100.0/tankCapacityVolume) * _sliderFuelMain1.value;
    
    float TotalFuelBarHeight = (10.1 / 100) * totalFuelPercent;
    
    _fuelBarMain.layer.transform = CATransform3DMakeScale(1, TotalFuelBarHeight, 0);
    
    
    _fuelBarLanding.layer.anchorPoint = CGPointMake(0.5, 1);
    
    totalFuelPercent = (100.0/tankCapacityVolume) * _sliderFuelLanding.value;
    
    TotalFuelBarHeight = (10.1 / 100) * totalFuelPercent;
    
    _fuelBarLanding.layer.transform = CATransform3DMakeScale(1, TotalFuelBarHeight, 0);


    
    
    
    
    
    // CG WARNINGS ********************************************************************************************
    

    if (configMode == 0) {
        
        [self calculateCGLimits];
    }
   
    
    
    
    
    // *********************************************************************************************************
    // ******************************** calc performance ********************************************************
    // *********************************************************************************************************
    
    
    
    
    [self  iEnviCalcALL];
    
    [self checkButtonFlight];
    
    [self checkButtonMainPage];
  
    
    [self checkButtonSetup];
    
    [self checkButtonManifeest];
    
    [self checkButtonSummaryManifest];
    
    
    triangleTrigger = 0;
    
    loopStartSpecific2 = [NSDate date];
    
    [self calcPerformance];
    
    loopFinishSpecific2 = [NSDate date];
    
    loopTimeSpecific2 = [loopFinishSpecific2 timeIntervalSinceDate:loopStartSpecific2];
    
  
          
    
    //[self animateEnvironment];

    if (displayWindow > 100){
        
        [viewMain bringSubviewToFront:_viewUniversalExtras];
        
    }
    
    
    
    
    // *********************************************************************************************************
    // ******************************** check if red warnings on ***********************************************
    // *********************************************************************************************************
    
    
    float warningTrigger = 0;
    
    /*
    for (int i = 1; i < amountOfButtons+1; i++) {
        
        UIButton* button = (UIButton *)[self.viewTopDisplayButtons viewWithTag: i];
        
        UIImage *img = button.currentBackgroundImage ;
    
        if(img == [UIImage imageNamed:@"button_red.png" ]){
            
            //NSLog (@"warning on !!!! ");
            
            warningTrigger = 1;
        }
        
       
    }
     */
    
    if (triangleTrigger > 0) {
        warningTrigger = 1;
    }
    
    
    if (warningTrigger == 1) {
        
        if (flagIsLandscape == 1) {
            UIImage *triangle = [UIImage imageNamed:@"triangle red.png"];
            
            [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];

        }else{
            UIImage *triangle = [UIImage imageNamed:@"triangle red down.png"];
            
            [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];
            
        }
        
        
        /*
        self.triangleWhite.alpha = 0.2;
        
        [UIView animateWithDuration:0.5 delay:0.2 options:UIViewAnimationOptionRepeat | UIViewAnimationOptionAutoreverse animations:^{
            self.triangleWhite.alpha = 1.0;
            
        } completion:nil];
         
         */

    }else{
        
        
        
        if (flagIsLandscape == 1) {
            
            UIImage *triangle = [UIImage imageNamed:@"triangle white.png"];
            
            [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];

            
        }else{
            UIImage *triangle = [UIImage imageNamed:@"triangle white down.png"];
            
            [_triangleWhite setBackgroundImage:triangle forState:UIControlStateNormal];
            
        }

        
        
        
        /*
        [self.triangleWhite.layer removeAllAnimations];
        
        self.triangleWhite.alpha = 1;
         
         */
        
    }
    
    
    
    
    // *********************************************************************************************************
    // ******************************** NVG / NIGHT MODE   *****************************************************
    // *********************************************************************************************************
    
    
    _labelNVGpercent.text = [ [NSString alloc] initWithFormat:@"%.0f %%", _sliderNVG.value  ];
    
    
    if (nvgMode == 1) {
        
        //NSLog(@"nightMode ON");
        
        _switchNVG.on = YES;
        
        _viewFilterNVG.hidden = NO; [viewOne bringSubviewToFront:_viewFilterNVG];
        
        [self prefersStatusBarHidden];
        
        [self performSelector:@selector(setNeedsStatusBarAppearanceUpdate)];
        
        _viewFilterNVG.alpha = _sliderNVG.value/100;
        
        
    }else{
        
        
        //NSLog(@"nightMode OFF");
        
        
        _viewFilterNVG.hidden = YES;
    
        _switchNVG.on = NO;
        
    }

    
  
    
    if (_segmentCGAutoCheck.selectedSegmentIndex == 1) {
        [self autoCheckFWDAFTCG];
    }else{
        _labelCGWarning.hidden = YES;
        
      

    }
    
  
    loopFinish = [NSDate date];
    NSTimeInterval loopTime = [loopFinish timeIntervalSinceDate:loopStart];

   
    //NSLog(@"the specific process takes  %.1f %% of total time = %.4f", (100 / loopTime) * loopTimeSpecific,  loopTime  );
    //NSLog(@"calcPerformance takes %.1f %% ", (100 / loopTime) * loopTimeSpecific2  );
    
    // best E145 Rega on computer = 0.006  on iPad = 0.05
    
}


- (void) makeFreakViewShape1 {
    
   //NSLog(@"makeFreakViewShape" );
    
    MTOWfromEnvelope = 0;
    
    float numberOfPoints = 0;
    pathCGenvelope = [UIBezierPath bezierPath];
    for (int i = 7; i < _arrayCG1.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [self.arrayCG1 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound) {
            // error condition — the text searchKeyword wasn't in 'string'
        }else{
            if (numberOfPoints == 0) { // first point only
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            
            if (yCGpos > MTOWfromEnvelope) {
                MTOWfromEnvelope = yCGpos;
            }
            
            
            numberOfPoints = numberOfPoints + 1;            
        }// end add to path
    }// end for next make path
    
    shapeLayerFreakViewCG1 = [CAShapeLayer layer];
    shapeLayerFreakViewCG1.path = [pathCGenvelope CGPath];
    return;
}


- (void) makeFreakViewShape2 {
    
    //NSLog(@"makeFreakViewShape" );
    
    float numberOfPoints = 0;
    pathCGenvelope = [UIBezierPath bezierPath];
    for (int i = 7; i < _arrayCG2.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [_arrayCG2 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound) {
            // error condition — the text searchKeyword wasn't in 'string'
        }else{
            if (numberOfPoints == 0) { // first point only
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    shapeLayerFreakViewCG2 = [CAShapeLayer layer];
    shapeLayerFreakViewCG2.path = [pathCGenvelope CGPath];
    return;
}


- (void) makeFreakViewShapeMargin {
    
    
    float marginCGx = [_inputSafetyMargin.text floatValue];
    
    //NSLog(@"makeFreakViewShapeMargin" );
    
    
    float numberOfPoints = 0;
    int flagfirstMoveToRight = 0;
    
    //NSLog(@"******************************************************************************" );
    
    pathCGenvelope = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG1MarginLine.count ; i++) { /// make path for freak
     
        
        NSString *Xstring     = [_arrayCG1MarginLine objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        NSString *XstringNext     = [_arrayCG1MarginLine objectAtIndex: i+1];
        if ([XstringNext isEqualToString: @""]) {
            XstringNext = Xstring;
        }
        
        searchKeyword = @"/";
        NSRange rangeOfYourStringNext = [XstringNext rangeOfString:searchKeyword];
        
        
        float xCGpos = 0;
        float yCGpos = 0;
        
        float xCGposNext = 0;
        float yCGposNext = 0;
        
        float xCGposMargined = 0;
        float yCGposMargined = 0;
        
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
            yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
            
            xCGposNext = [ [XstringNext substringToIndex:rangeOfYourStringNext.location] floatValue];
            yCGposNext = [ [XstringNext substringFromIndex:rangeOfYourStringNext.location+1] floatValue];

            
            int caseIsFound = 0;
            
            if (xCGpos < xCGposNext & yCGpos < yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the right and up" );
                xCGposMargined = xCGpos + marginCGx ;
                yCGposMargined = yCGpos;
            }
            
            if (xCGpos == xCGposNext & yCGpos < yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"not moving and up" );
                xCGposMargined = xCGpos + marginCGx ;
                yCGposMargined = yCGpos;
            }
            
            if (xCGpos == xCGposNext & yCGpos > yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"not moving and down" );
                xCGposMargined = xCGpos - marginCGx;
                yCGposMargined = yCGpos;
            }
            
            
            if (xCGpos < xCGposNext & yCGpos == yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the right and steady" );
                xCGposMargined = xCGpos + marginCGx;
                yCGposMargined = yCGpos;
                if (flagfirstMoveToRight == 0) {
                    //NSLog(@"moving to the right and steady first time" );
                    xCGposMargined = xCGpos + marginCGx;
                    yCGposMargined = yCGpos;
                    flagfirstMoveToRight = 1;
                }else{
                    //NSLog(@"moving to the right and steady second time " );
                    xCGposMargined = xCGpos - marginCGx;
                    yCGposMargined = yCGpos;
                }
            }
            
            
            if (xCGpos < xCGposNext & yCGpos > yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the right and down" );
                xCGposMargined = xCGpos - marginCGx;
                yCGposMargined = yCGpos;
            }
            
            if (xCGpos > xCGposNext & yCGpos == yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the left  and steady" );
                xCGposMargined = xCGpos - marginCGx;
                yCGposMargined = yCGpos;
            }
            
            if (xCGpos > xCGposNext & yCGpos < yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the left and up" );
                xCGposMargined = xCGpos + marginCGx;
                yCGposMargined = yCGpos;
            }
            
            if (xCGpos > xCGposNext & yCGpos > yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving to the left and down" );
                xCGposMargined = xCGpos - marginCGx;
                yCGposMargined = yCGpos;
            }
            
            
            if (xCGpos == xCGposNext & yCGpos == yCGposNext) {
                caseIsFound = 1;
                //NSLog(@"moving back to start" );
                xCGposMargined = xCGpos + marginCGx;
                yCGposMargined = yCGpos;
            }
            

            if (caseIsFound == 0) {
               //NSLog(@"---------------------------------------------- FREAK caseIsFound 0");
            }
            
            if (numberOfPoints == 0) { // first point only
                [pathCGenvelope moveToPoint:CGPointMake( xCGposMargined, yCGposMargined )];
                
                 //NSLog(@"xCGposMargined %f " ,xCGposMargined );
            }else{
                 [pathCGenvelope addLineToPoint:CGPointMake( xCGposMargined, yCGposMargined )];
            }
            
            
            numberOfPoints = numberOfPoints + 1;
            
            
        }// end add to path
        
        
        
    }// end for next make path
    
    
    
    shapeLayerFreakViewCG1Margin = [CAShapeLayer layer];
    shapeLayerFreakViewCG1Margin.path = [pathCGenvelope CGPath];
    shapeLayerFreakViewCG1Margin.strokeColor = [[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];
    if (colorModeForCGenvelope == 0) {  shapeLayerFreakViewCG1Margin.strokeColor =[[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];  }else{ shapeLayerFreakViewCG1Margin.strokeColor = [[UIColor redColor] CGColor];    }
    shapeLayerFreakViewCG1Margin.lineWidth = 5.5;
    shapeLayerFreakViewCG1Margin.fillColor = [[UIColor clearColor] CGColor];
    //[self.cgFreakView.layer addSublayer:shapeLayerFreakViewCG1];
    
    return;
    
    
    
}




- (void) calculateCGLimits {
    
    
    
    //forward
    
    float cgFWDlimit = 0;
    
    if (weightTOW >= 8800) { cgFWDlimit = ( weightTOW - -70219.6078431373 ) / 607.843137254903  ;  ;}
    
    if (weightTOW < 8800) { cgFWDlimit = 130.0 ;}
    
    
    _cgFWDlimit.text =  [ [NSString alloc] initWithFormat:@"%.1f", cgFWDlimit  ];
    
    
    float cgAftlimit = 0;
    
    if (weightTOW >= 8800) { cgAftlimit = ( weightTOW - 180492.307692308 ) / -1192.30769230769  ; ;}
    
    
    if (weightTOW < 8800) {cgAftlimit = 144.0 ;}
    
    _cgAFTlimit.text =  [ [NSString alloc] initWithFormat:@"%.1f", cgAftlimit  ];

    
    
    //NSLog(@"_cgFWDlimit  %@f", _cgFWDlimit.text);
    
    //NSLog(@"_cgAFTlimit  %@f", _cgAFTlimit.text);
    
}

- (void) calcMaxEnternalLoad {
    
    
    float merkerWeightTOW = weightTOW;
    float merkerCGLongTOW = CGLongTOW;
   
 
    
    // get current externalLoad
    float currentExternalLoadWeight = [[_arrayName2 objectAtIndex:lineHoistLoad] floatValue]; // weight
    float currentExternalLoadArm = [[_arrayName3 objectAtIndex:lineHoistLoad] floatValue]; // arm
    float currentExternalLoadMoment = currentExternalLoadWeight * currentExternalLoadArm;
    
    //NSLog(@"currentExternalLoadWeight %.1f", currentExternalLoadWeight);
    //NSLog(@"currentExternalLoadArm %.1f", currentExternalLoadArm);
    //NSLog (@"mostFWDCGpoint %.0f", mostFWDCGpoint);
    // take external load out of equation
    //float startTOW = merkerWeightTOW - currentExternalLoadWeight;
    //float startTOMoment = merkerMomTOW - currentExternalLoadMoment;
    
    
    
     //NSLog(@"changing mostFWDCGpoint %.0f ", mostFWDCGpoint );
    
    float startTOW = mostFWDweight - currentExternalLoadWeight;
    float startTOMoment = (mostFWDweight * mostFWDCGpoint) - currentExternalLoadMoment;
    
    int totalStepsHoistCheck = 0;
    float searchWeightFactor = 1;
    flagReportEnvelopeExceeded = 0;
    
    maxMTOWforHoist = MTOWfromEnvelope - (merkerWeightTOW - currentExternalLoadWeight);
   
    float availableHoistLoadCGCheck = 0;
    
    for (float searchWeight = 0; searchWeight < 10000; searchWeight++) {
        
        totalStepsHoistCheck = totalStepsHoistCheck + 1;
        //NSLog(@"searchWeight %.1f", searchWeight * searchWeightFactor);
        float searchMoment = (searchWeight * searchWeightFactor) * currentExternalLoadArm;
        float checkWeightTOW = startTOW + (searchWeight * searchWeightFactor) ;
        float checkMoment = startTOMoment + searchMoment;
        float checkCG = checkMoment / checkWeightTOW;
        weightTOW = checkWeightTOW;
        CGLongTOW = checkCG;
        //NSLog(@"TOW  %.1f", weightTOW);
        //NSLog(@"CGLongTOW  %.1f", CGLongTOW);
        
        // go check ******************************************************************************
        [self checkCGwarningLongitudinalForHOIST: CGLongTOW transferWeightTOW:weightTOW ];
        // ***************************************************************************************
        
        if (flagReportEnvelopeExceeded == 1 ) {
            availableHoistLoadCGCheck = (searchWeight * searchWeightFactor) -  searchWeightFactor;
            //NSLog(@"availableExternalLoad %.1f", availableExternalLoad);
            break;
        }
        
    }// end loop
    
    
    //NSLog(@"****************");
    
    //NSLog(@"availableHoistLoadCGCheck %.0f", availableHoistLoadCGCheck);
    
    //NSLog(@"maxMTOWforHoist %.0f", maxMTOWforHoist);
    
    //NSLog(@"maxHoistLoad %.0f", maxHoistLoad);
    
    // take lowest
    
    if (maxMTOWforHoist < availableHoistLoadCGCheck) {
        availableExternalLoad = maxMTOWforHoist;
        _labelAvailableExternalLoad.text = [ [NSString alloc] initWithFormat:@"Max. Hoist: %.0fkg (MTOW)", availableExternalLoad ];
    }else{
        availableExternalLoad = availableHoistLoadCGCheck;
        _labelAvailableExternalLoad.text = [ [NSString alloc] initWithFormat:@"Max. Hoist: %.0fkg (FWD CG)", availableExternalLoad ];
    }
    
    if (maxHoistLoad < maxMTOWforHoist & maxHoistLoad < availableHoistLoadCGCheck) {
        availableExternalLoad = maxHoistLoad;
         _labelAvailableExternalLoad.text = [ [NSString alloc] initWithFormat:@"Max. Hoist: %.0fkg (HOIST)", availableExternalLoad ];
    }
    
    if (maxHoistLoad < maxMTOWforHoist & maxHoistLoad < availableHoistLoadCGCheck & OAT < 0) {
        availableExternalLoad = maxHoistLoad;
        _labelAvailableExternalLoad.text = [ [NSString alloc] initWithFormat:@"Max. Hoist: %.0fkg (OAT)", availableExternalLoad ];
    }
    
    
    if (flagReportEnvelopeExceeded == 2) {
        availableExternalLoad = availableHoistLoadCGCheck;
        _labelAvailableExternalLoad.text = [ [NSString alloc] initWithFormat:@"Max. Hoist: %.0fkg (LATERAL)", availableExternalLoad ];
    }
    
  
    
    //NSLog(@"availableExternalLoad %.0f", availableExternalLoad);

   
          
    
    
    if (currentExternalLoadWeight > availableExternalLoad ) {
        _labelAvailableExternalLoad.backgroundColor = [UIColor redColor];
        _labelAvailableExternalLoad.text = @"Max. Hoist: Exceeded!";
        _labelAvailableExternalLoad.textColor = [UIColor whiteColor];
        if (currentExternalLoadWeight < 1) {
            _labelAvailableExternalLoad.text = @"Max. Hoist: 0kg";
            _labelAvailableExternalLoad.backgroundColor = [UIColor greenColor];
            _labelAvailableExternalLoad.textColor = [UIColor blackColor];
        }
    }else{
        _labelAvailableExternalLoad.backgroundColor = [UIColor greenColor];
        _labelAvailableExternalLoad.textColor = [UIColor blackColor];
    }
    
    
    
    // restore
    CGLongTOW = merkerCGLongTOW;
    weightTOW = merkerWeightTOW;
    [self checkCGwarningLongitudinal: CGLongTOW transferWeightTOW:weightTOW ];
    
    
}



- (void) checkCGwarningLongitudinal: (float)receivedCGlong  transferWeightTOW:(float)receivedWeightTOW  {
    
    
    // check CG
    flagWarningWeight = 0; flagWarningCG = 0;
    _labelCGinExtendedEnvelope.hidden = YES;
    _labelCGoutsideSafetyMargin.hidden = YES;
    CGwithinEnvelope1 = 0;
    CGwithinEnvelope2 = 0;
    CGwithinMargin = 0;
    
    CGPoint pointCG = {receivedCGlong, receivedWeightTOW};
    //NSLog(@"checking receivedCGlong %f", receivedCGlong);
    
    // check margin takeoff weight
    if ([[_arrayName23 objectAtIndex:21] isEqualToString:@"yes"]) {
        if (CGPathContainsPoint(shapeLayerFreakViewCG1Margin.path, NULL, pointCG, FALSE)) {
            CGwithinMargin = 1;
        }
    }
    
    if (CGPathContainsPoint(shapeLayerFreakViewCG1.path, NULL, pointCG, FALSE)) {
        CGwithinEnvelope1 = 1;
    }else{
        
    }
    
    if ([AC_Type isEqualToString:@"H175"] || [AC_Type isEqualToString:@"H145"]) {
        if (CGPathContainsPoint(shapeLayerFreakViewCG2.path, NULL, pointCG, FALSE)) {
            CGwithinEnvelope2 = 1;
        }
    }
    
    return;
   
}


- (void) checkCGwarningLongitudinalForHOIST: (float)receivedCGlong  transferWeightTOW:(float)receivedWeightTOW  {
    
    
    if (densityalt < 12000 || Hp < 12000) {
        CGPoint pointCG = {receivedCGlong, receivedWeightTOW};
        if (CGPathContainsPoint(shapeLayerFreakViewCG1Margin.path, NULL, pointCG, FALSE)) {
            
        }else{
            flagReportEnvelopeExceeded = 1;
        }
        
    }else{
        
        CGPoint pointCG = {receivedCGlong, receivedWeightTOW};
        if (CGPathContainsPoint(shapeLayerFreakViewCG1.path, NULL, pointCG, FALSE)) {
            
        }else{
            flagReportEnvelopeExceeded = 1;
        }
        
        
    }
   
    
    
    
    
    return;
    
}








- (void) makeFreakViewLateral {
    
    //make cg envelope just for checking
    
    
    float numberOfPoints = 0;
    
    pathCGenvelope = [UIBezierPath bezierPath];
    for (int i = 7; i < _arrayCG1_LAT.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [self.arrayCG1_LAT objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound){
            // error condition — the text searchKeyword wasn't in 'string'
        }else{
            if (numberOfPoints == 0) { // first point only
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = [ [Xstring substringToIndex:rangeOfYourString.location] floatValue];
                yCGpos = [ [Xstring substringFromIndex:rangeOfYourString.location+1] floatValue];
                [pathCGenvelope addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
            
        }// end add to path
        
    }// end for next make path
    
    shapeLayerFreakViewCG1Lat = [CAShapeLayer layer];
    shapeLayerFreakViewCG1Lat.path = [pathCGenvelope CGPath];
    shapeLayerFreakViewCG1Lat.strokeColor = [[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];
    if (colorModeForCGenvelope == 0) {  shapeLayerFreakViewCG1Lat.strokeColor =[[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];  }else{ shapeLayerFreakViewCG1Lat.strokeColor = [[UIColor redColor] CGColor];    }
    shapeLayerFreakViewCG1Lat.lineWidth = 3.5;
    shapeLayerFreakViewCG1Lat.fillColor = [[UIColor clearColor] CGColor];
    //[self.cgFreakView.layer addSublayer:shapeLayerFreakViewCG1Lat];
    
    return;
    
    
}



- (void) checkButtonTimer {
    
    if (displayWindow == 15  ) {
        
        [_displayButtonTimers setImage:buttonBlue forState:UIControlStateNormal];
        
        return;
        
    } else {
        
        [_displayButtonTimers setImage:buttonGrey forState:UIControlStateNormal];
        
        return;
        
    }
    
    
    
    return;
    
    
}


- (void) checkButtonFlight {
    
    //NSLog(@"checkButtonFlight displayWindow %.0f", displayWindow );
    
    
        
    if (displayWindow == 12  ) {
        
        [buttonDisplayFlight setImage:buttonBlue forState:UIControlStateNormal];
        
        return;
        
    } else {
        
        [buttonDisplayFlight setImage:buttonGrey forState:UIControlStateNormal];
        
        return;
        
    }  
    
    
        
    return;
    
    
}


- (void) checkButtonMainPage {
    
    if (displayWindow == 0  ) {
        [_buttonDisplayMainPage setImage:buttonBlue forState:UIControlStateNormal];
        return;
    } else {
        [_buttonDisplayMainPage setImage:buttonGrey forState:UIControlStateNormal];
        return;
    }
    
}




- (void) checkButtonSetup {
    
    if (displayWindow == 10  ) {
        [buttonSetup setImage:buttonBlue forState:UIControlStateNormal];
        return;
    } else {
        [buttonSetup setImage:buttonGrey forState:UIControlStateNormal];
        return;
    }
    
}

- (void) checkButtonManifeest {    
    
    if (displayWindow == 11  ) {
        
        [buttonLoadManifest setImage:buttonBlue forState:UIControlStateNormal];
        
        return;
        
    } else {
        
        [buttonLoadManifest setImage:buttonGrey forState:UIControlStateNormal];
        
        return;
        
    }   
    
    
    return;
    
    
}

- (void) checkButtonSummaryManifest {
    
    
    if (displayWindow == 14  ) {
        
        [_buttonSummaryManifest setImage:buttonBlue forState:UIControlStateNormal];
        
        return;
        
    } else {
        
        [_buttonSummaryManifest setImage:buttonGrey forState:UIControlStateNormal];
        
        return;
        
    }
    
    
    return;
    
    
}






// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------









// calc all performance values check button warnings

- (IBAction)sliderActionHp:(id)sender {
    
    int dummy = sliderHp.value/100;
    sliderHp.value = dummy * 100;
    
    
    
    
    [self MainRoutine];
    
    
    
    
}




- (IBAction)sliderActionMSL:(id)sender {
    
    int dummy = _sliderMSL.value/100;
    _sliderMSL.value = dummy * 100;
    
    
    
    [self MainRoutine];
    
    
}


- (IBAction)sliderActionHeadwind2:(id)sender {
    
    int dummy = _sliderHeadwind2.value/1;
    _sliderHeadwind2.value = dummy * 1;
    
    
    
    [self MainRoutine];
    
    
}






- (void) iEnviCalcALL {
    
    

    
    
    
    calcisa = 15 - (1.98 * (sliderHp.value/1000));
    
    
    float actualOAT = sliderOATforOGE.value;
    
    ISAdif = actualOAT - calcisa;
    
    if (ISAdif > 0.5) {
        
        labelISAAnsage.textColor =  [UIColor orangeColor];
        
        labelISAAnsage.text = [ [NSString alloc] initWithFormat:@"%.0fºC warmer than ISA", ISAdif];
        
    }
    
    
    if (ISAdif < -0.5) {
        
        labelISAAnsage.textColor = [UIColor colorWithRed:196.0f/255.0f green:221.0f/255.0f blue:250.0f/255.0f alpha:1.0f];
        
        
        labelISAAnsage.text = [ [NSString alloc] initWithFormat:@"%.0fºC cooler than ISA", ISAdif];
        
    }
    
    if (ISAdif >= -0.5 & ISAdif <= 0.5) {
        
        labelISAAnsage.textColor = [UIColor whiteColor];
        
        
        labelISAAnsage.text = [ [NSString alloc] initWithFormat:@"ISA temperature"];
        
    }
    
    
    
    // OAT in ISA
    
    
    
    OATinISA = calcisa + sliderISADiff.value;
    
    
    
    labelActualOAT.text = [ [NSString alloc] initWithFormat:@"%.0fºC", OATinISA];
    labelISAdiff.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderISADiff.value];
    
    
    if (OATinput == 0) {
        
        OAT = sliderOATforOGE.value;
        
        sliderISADiff.value = ISAdif;
        
    } else {
        
        OAT = OATinISA;
        
        sliderOATforOGE.value = OATinISA;
    }
    
    
    
    
    // density alt
    
    int   PressAltforDensity = sliderHp.value;
    
    float TKelvin = 273.15 + OAT;
    
    float TSuper = 273.15 + ( 15 - ( 0.0019812 * PressAltforDensity) );
    
    densityalt = PressAltforDensity + (TSuper / 0.0019812) * ( 1- ( powf (TSuper / TKelvin, .2349690) ) ) ;
    
    labelDensityAlt.text = [ [NSString alloc] initWithFormat:@"%.0f ft", densityalt];
    
    
    
    labelDisplayPA.text = [ [NSString alloc] initWithFormat:@"%.0f'", sliderHp.value];
    
    labelDisplayOAT.text = [ [NSString alloc] initWithFormat:@"%.0fºC", OAT];
    
    
    
    // ************************************************************************************************
    
    
    //NSLog (@"Hp %@ ", [ [NSString alloc] initWithFormat:@"%.1f lbs", Hp]);
    
    //NSLog (@"OAT %@ ", [ [NSString alloc] initWithFormat:@"%.1f lbs", OAT]);
    
    Hp = sliderHp.value;
    
    inputPressureAlt.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderHp.value];
    
    labelOATforOGE.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderOATforOGE.value];
    
    
    
    return;
    
    
} // calc Environment


// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------








// /*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*
//                                                                                      LOAD SAVE
// /*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*/*/*//*/*/*/*/*/*/*/*/*





- (void) LoadValues {
    
    //NSLog (@"LoadValues");
    
    [tempArraySeatWgt removeAllObjects];
    [tempArraySeatName removeAllObjects];

    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    vFlightID   = [defaults  stringForKey:@"vFlightID"];
    
    
    //************************************************************************************************************************
    //************************************************************************************************************************
    
    
    //NSLog(@"loading flight %@, leg %@ ", vFlightID, vLegID );
    
    allFlightsMasterArray = [[NSMutableArray alloc] init];
    
    allFlightsMasterArray = [[[NSUserDefaults standardUserDefaults] objectForKey:@"allFlightsMasterArray"] mutableCopy];
    
    
    
    //NSLog(@"allFlightsMasterArray.count %d", allFlightsMasterArray.count);
    
    allLegsPerFlightArray = [[NSMutableArray alloc] init];
    allLegsPerFlightArray = [[allFlightsMasterArray objectAtIndex: [vFlightID integerValue] ] mutableCopy];
    

    
    legSettingsDictionary = [[NSMutableDictionary alloc] init];
    
    
    legSettingsDictionary = [allLegsPerFlightArray objectAtIndex: [vLegID integerValue] ];
    
   
    
    //************************************************************************************************************************
    //************************************************************************************************************************
    
    

    
    //************************************************************************************************************************
    // flight settings
    
    flightSettingsDictionary = [[NSMutableDictionary alloc] init];
    
    flightSettingsDictionary = [[allLegsPerFlightArray objectAtIndex: 0 ] mutableCopy];
    
    //NSLog(@"loading flightSettingsDictionary %@", flightSettingsDictionary);
    
    
    
    //************************************************************************************************************************
    // basics
    
    _inputSliderIncrement.text                      = [defaults  stringForKey:@"_inputSliderIncrement"];
    _inputQuickLoadPreset.text                      = [defaults  stringForKey:@"_inputQuickLoadPreset"];
    _defaultEmailAddress.text                       = [defaults  stringForKey:@"_defaultEmailAddress"];
    _defaultEmailAddressCC.text                     = [defaults  stringForKey:@"_defaultEmailAddressCC"];
    _inputSpecificFuelMassPerVolume.text            = [defaults  stringForKey:@"_inputSpecificFuelMassPerVolume"];
    inputWarningFuelReserveTime.text                = [defaults  stringForKey:@"inputWarningFuelReserveTime"];
    connectedToFleetControl                         = [defaults  floatForKey:@"connectedToFleetControl"];
    warningPercentMargin                            = [defaults  floatForKey:@"warningPercentMargin"];
    warningsOnOff                                   = [defaults  floatForKey:@"warningsOnOff"];
    warningsOnOffIGEOGE                             = [defaults  floatForKey:@"warningsOnOffIGEOGE"];
    warningOnOff_MTOW                               = [defaults  floatForKey:@"warningOnOff_MTOW"];
    nvgMode                                         = [defaults  floatForKey:@"nvgMode"];
    _sliderNVG.value                                = [defaults  floatForKey:@"_sliderNVG"];
    datepickInterval                                = [defaults  floatForKey:@"datepickInterval"];
    _segmentFuelVolumeOrMass.selectedSegmentIndex   = [defaults  integerForKey:@"_segmentFuelVolumeOrMass"];
    _segmentCGAutoCheck.selectedSegmentIndex        = [defaults  integerForKey:@"_segmentCGAutoCheck"];
    _segmentFlightLegMode.selectedSegmentIndex      = [defaults  integerForKey:@"_segmentFlightLegMode"];
    _segmentPlanMode.selectedSegmentIndex           = [defaults  integerForKey:@"_segmentPlanMode"];
    _segmentSeatLoadOptions.selectedSegmentIndex    = [defaults  integerForKey:@"_segmentSeatLoadOptions"];
    _segmentNamesOnSeats.selectedSegmentIndex       = [defaults  integerForKey:@"_segmentNamesOnSeats"];
    _segmentSwapMode.selectedSegmentIndex           = [defaults  integerForKey:@"_segmentSwapMode"];
    _inputSafetyMargin.text                         = [defaults  stringForKey:@"_inputSafetyMargin"];
    _inputFuelIncrement.text                        = [defaults  stringForKey:@"_inputFuelIncrement"];
    
    _inputOverrideBEW.text                         = [defaults  stringForKey:@"_inputOverrideBEW"];
    _inputOverrideMoment.text                      = [defaults  stringForKey:@"_inputOverrideMoment"];
    _inputOverrideMomentLat.text                   = [defaults  stringForKey:@"_inputOverrideMomentLat"];
    _inputOverrideRegistration.text                = [defaults  stringForKey:@"_inputOverrideRegistration"];
    inputFuelFlowOverride.text                = [defaults  stringForKey:@"inputFuelFlowOverride"];

    
    arrayAvailableListIDs = [[NSMutableArray alloc] initWithArray:[[[NSUserDefaults standardUserDefaults] objectForKey:@"arrayAvailableListIDs"] mutableCopy]];
    
    _switchGuidance.on = [[NSUserDefaults standardUserDefaults] boolForKey:@"_switchGuidance"];
    
    _switchAutoLandingFuel.on = [[NSUserDefaults standardUserDefaults] boolForKey:@"_switchAutoLandingFuel"];
    
    
    // enter Arrays  ************************************************************************************************************************
    
    
    NSMutableArray *LOADtableViewDataName = [[[NSUserDefaults standardUserDefaults] objectForKey:@"tableViewDataName"] mutableCopy];
    
    [self.tableViewDataName setArray:LOADtableViewDataName];
    
    NSMutableArray *LOADtableViewDataWeight = [[[NSUserDefaults standardUserDefaults] objectForKey:@"tableViewDataWeight"] mutableCopy];
    
    [self.tableViewDataWeight setArray:LOADtableViewDataWeight];
    
    
    
    
    
    
    //LOAD helicopter objects into array
    
    NSData *dataRepresentingSavedArray = [defaults objectForKey:@"helicopters"];
    if (dataRepresentingSavedArray != nil)
    {
        NSArray *oldSavedArray = [NSKeyedUnarchiver unarchiveObjectWithData:dataRepresentingSavedArray];
        if (oldSavedArray != nil)
            helicopters = [[NSMutableArray alloc] initWithArray:oldSavedArray];
        else
            helicopters = [[NSMutableArray alloc] init];
    }
    [self addHelicopterButtons];
    
    lastupdate_helicopters = [defaults objectForKey:@"lastupdate_helicopters"];
    lastupdate_crew = [defaults objectForKey:@"lastupdate_crew"];
    crew_lastLocation = [defaults objectForKey:@"crew_lastLocation"];
    
    
    
    //LOAD crew objects into array
    
    dataRepresentingSavedArray = [defaults objectForKey:@"crew_sectioned"];
    if (dataRepresentingSavedArray != nil)
    {
        NSArray *oldSavedArray = [NSKeyedUnarchiver unarchiveObjectWithData:dataRepresentingSavedArray];
        if (oldSavedArray != nil)
            crew_sectioned = [[NSMutableArray alloc] initWithArray:oldSavedArray];
        else
            crew_sectioned = [[NSMutableArray alloc] init];
    }
    
    //LOAD crew types into array
    
    crew_types = [[NSMutableArray alloc] initWithArray:[[[NSUserDefaults standardUserDefaults] objectForKey:@"crew_types"] mutableCopy]];

    CrewDataLoaded = [defaults  floatForKey:@"CrewDataLoaded"];
    
    
    
    
    // load legSettingsDictionary   *****************************************************************
    
    
    
    ACCategory = [legSettingsDictionary objectForKey: @"_legACCategory"];
    ACmanufacturer = [legSettingsDictionary objectForKey: @"_legACmanufacturer"];
    AC_Type = [legSettingsDictionary objectForKey: @"_legAC_Type"];
    ACVariant = [legSettingsDictionary objectForKey: @"_legACVariant"];
    _vFlightTypeField.text = [legSettingsDictionary objectForKey: @"_vFlightTypeField"];
    
    // change global setting
    [[NSUserDefaults standardUserDefaults]  setObject:ACCategory                    forKey:@"ACCategory"];
    [[NSUserDefaults standardUserDefaults]  setObject:ACmanufacturer                forKey:@"ACmanufacturer"];
    [[NSUserDefaults standardUserDefaults]  setObject:AC_Type                       forKey:@"AC_Type"];
    [[NSUserDefaults standardUserDefaults]  setObject:ACVariant                     forKey:@"ACVariant"];
    
    [self loadPerfChartData];
    
    
    
    _vFlightIDName.text = [legSettingsDictionary objectForKey: @"_vFlightIDName"];
    _vHOMSA.text = [legSettingsDictionary objectForKey: @"_vHOMSA"];
    [ arrayBaseName setArray: [[legSettingsDictionary objectForKey: @"arrayBaseName"]  mutableCopy]];
    [ arrayConfigurationName setArray: [[legSettingsDictionary objectForKey: @"arrayConfigurationName"]  mutableCopy]];
    [ arrayPackageName setArray: [[legSettingsDictionary objectForKey: @"arrayPackageName"]  mutableCopy]];
    [ arrayConfigItemName setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemName"]  mutableCopy]];
    [ arrayConfigItemWeight setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemWeight"]  mutableCopy]];
    [ arrayConfigItemArmLong setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemArmLong"]  mutableCopy]];
    [ arrayConfigItemMomLong setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemMomLong"]  mutableCopy]];
    [ arrayConfigItemArmLat setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemArmLat"]  mutableCopy]];
    [ arrayConfigItemMomLat setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemMomLat"]  mutableCopy]];
    [ arrayConfigIteminOut setArray: [[legSettingsDictionary objectForKey: @"arrayConfigIteminOut"]  mutableCopy]];
    [ arrayConfigItemLocked setArray: [[legSettingsDictionary objectForKey: @"arrayConfigItemLocked"]  mutableCopy]];
    _dropDownBaseID.text = [legSettingsDictionary objectForKey: @"_dropDownBaseID"];
    _inputDocumentPreparedTime.text = [legSettingsDictionary objectForKey: @"_inputDocumentPreparedTime"];
    _inputDocumentPreparedDate.text = [legSettingsDictionary objectForKey: @"_inputDocumentPreparedDate"];
    _input_documentPreparedBy.text = [legSettingsDictionary objectForKey: @"_input_documentPreparedBy"];
    inputFuelFlowOverride.text = [legSettingsDictionary objectForKey: @"inputFuelFlowOverride"];
    vFlightRegistration.text = [legSettingsDictionary objectForKey: @"vFlightRegistration"];
    _manifestTimeStamp.text = [legSettingsDictionary objectForKey: @"_manifestTimeStamp"];
    timeStampForPDF = [legSettingsDictionary objectForKey: @"timeStampForPDF"];
    _labelDepartureTimeLocal.text = [legSettingsDictionary objectForKey: @"_labelDepartureTimeLocal"];
    _labellandingtimeLocal.text = [legSettingsDictionary objectForKey: @"_labellandingtimeLocal"];
    _labelDepartureTimeGMT.text = [legSettingsDictionary objectForKey: @"labelDepartureTimeGMT"];
    _inputPaxOnBoard.text = [legSettingsDictionary objectForKey: @"_inputPaxOnBoard"];
    vBEW.text = [legSettingsDictionary objectForKey: @"vBEW"];
    vBEWMom.text = [legSettingsDictionary objectForKey: @"vBEWMom"];
    vBEWMomLat.text = [legSettingsDictionary objectForKey: @"vBEWMomLat"];
    vFlightDeparture.text = [legSettingsDictionary objectForKey: @"vFlightDeparture"];
    vFlightDestination.text = [legSettingsDictionary objectForKey: @"vFlightDestination"];
    _labelFlightTimeMinutes.text = [legSettingsDictionary objectForKey: @"_labelFlightTimeMinutes"];
    sliderOATforOGE.value = [[legSettingsDictionary objectForKey: @"sliderOATforOGE"] floatValue];
    sliderHp.value = [[legSettingsDictionary objectForKey: @"sliderHp"] floatValue];
    sliderISADiff.value = [[legSettingsDictionary objectForKey: @"sliderISADiff"] floatValue];
    _sliderMSL.value = [[legSettingsDictionary objectForKey: @"_sliderMSL"] floatValue];
    sliderQNH.value = [[legSettingsDictionary objectForKey: @"sliderQNH"] floatValue];
    _sliderFuelMain1.value = [[legSettingsDictionary objectForKey: @"_sliderFuelMain1"] floatValue];
    _sliderFuelLanding.value = [[legSettingsDictionary objectForKey: @"_sliderFuelLanding"] floatValue];
    activeConfigButton = [[legSettingsDictionary objectForKey: @"activeConfigButton"] floatValue];
    listEnd = [[legSettingsDictionary objectForKey: @"listEnd"] floatValue];
    configuration = [[legSettingsDictionary objectForKey: @"configuration"] floatValue];
    guidanceLegCheckOK = [[legSettingsDictionary objectForKey: @"guidanceLegCheckOK"] integerValue];
    guidanceDictionary = [[legSettingsDictionary objectForKey: @"guidanceDictionary"] mutableCopy];
    
    _vFlightTimeMinutes.text = [legSettingsDictionary objectForKey: @"_vFlightTimeMinutes"];
    _vFlightTimeHours.text = [legSettingsDictionary objectForKey: @"_vFlightTimeHours"];
    
    _vEngineStarts1.text = [legSettingsDictionary objectForKey: @"_vEngineStarts1"];
    _vEngineStarts2.text = [legSettingsDictionary objectForKey: @"_vEngineStarts2"];
    _vRIN.text = [legSettingsDictionary objectForKey: @"_vRIN"];
    
    _vCockpitSeatLeft.text = [legSettingsDictionary objectForKey: @"_vCockpitSeatLeft"];
    _vCockpitSeatRight.text = [legSettingsDictionary objectForKey: @"_vCockpitSeatRight"];
    
    loadedSignatureImage = [UIImage imageWithData:[legSettingsDictionary objectForKey: @"signatureImage"] ];
    
    linePilot = [[legSettingsDictionary objectForKey: @"linePilot"] integerValue];
    
    calculatePerformanceClass_.mcgInputAirportElevationMSL.text = [legSettingsDictionary objectForKey: @"mcgInputAirportElevationMSL"];   
    calculatePerformanceClass_.mcgSliderAirportElevationMSL.value = [ [legSettingsDictionary objectForKey: @"mcgInputAirportElevationMSL"] floatValue];
    //NSLog(@"loading  mcgInputAirportElevationMSL = %@", calculatePerformanceClass_.mcgInputAirportElevationMSL.text);
   
    
    [self mountSignatureImageToLoadManifest];
   
    
    [ self.arrayName1 setArray: [[legSettingsDictionary objectForKey: @"_arrayName1"]  mutableCopy]];
    [ self.arrayName2 setArray: [[legSettingsDictionary objectForKey: @"_arrayName2"]  mutableCopy]];
    [ self.arrayName3 setArray: [[legSettingsDictionary objectForKey: @"_arrayName3"]  mutableCopy]];
    [ self.arrayName4 setArray: [[legSettingsDictionary objectForKey: @"_arrayName4"]  mutableCopy]];
    [ self.arrayName5 setArray: [[legSettingsDictionary objectForKey: @"_arrayName5"]  mutableCopy]];
    [ self.arrayName6 setArray: [[legSettingsDictionary objectForKey: @"_arrayName6"]  mutableCopy]];
    [ self.arrayName7 setArray: [[legSettingsDictionary objectForKey: @"_arrayName7"]  mutableCopy]];
    [ self.arrayName8 setArray: [[legSettingsDictionary objectForKey: @"_arrayName8"]  mutableCopy]];
    [ self.arrayName9 setArray: [[legSettingsDictionary objectForKey: @"_arrayName9"]  mutableCopy]];
    [ self.arrayName10 setArray: [[legSettingsDictionary objectForKey: @"_arrayName10"]  mutableCopy]];
    [ self.arrayName11 setArray: [[legSettingsDictionary objectForKey: @"_arrayName11"]  mutableCopy]];
    [ self.arrayName12 setArray: [[legSettingsDictionary objectForKey: @"_arrayName12"]  mutableCopy]];
    [ self.arrayName13 setArray: [[legSettingsDictionary objectForKey: @"_arrayName13"]  mutableCopy]];
    [ self.arrayName14 setArray: [[legSettingsDictionary objectForKey: @"_arrayName14"]  mutableCopy]];
    [ self.arrayName15 setArray: [[legSettingsDictionary objectForKey: @"_arrayName15"]  mutableCopy]];
    [ self.arrayName16 setArray: [[legSettingsDictionary objectForKey: @"_arrayName16"]  mutableCopy]];
    [ self.arrayName17 setArray: [[legSettingsDictionary objectForKey: @"_arrayName17"]  mutableCopy]];
    [ self.arrayName18 setArray: [[legSettingsDictionary objectForKey: @"_arrayName18"]  mutableCopy]];
    [ self.arrayName19 setArray: [[legSettingsDictionary objectForKey: @"_arrayName19"]  mutableCopy]];
    [ self.arrayName20 setArray: [[legSettingsDictionary objectForKey: @"_arrayName20"]  mutableCopy]];
    [ self.arrayName21 setArray: [[legSettingsDictionary objectForKey: @"_arrayName21"]  mutableCopy]];
    [ self.arrayName22 setArray: [[legSettingsDictionary objectForKey: @"_arrayName22"]  mutableCopy]];
    [ self.arrayName23 setArray: [[legSettingsDictionary objectForKey: @"_arrayName23"]  mutableCopy]];
    [ self.arrayName24 setArray: [[legSettingsDictionary objectForKey: @"_arrayName24"]  mutableCopy]];
    [ self.arrayName25 setArray: [[legSettingsDictionary objectForKey: @"_arrayName25"]  mutableCopy]];
    
    
    //NSLog (@"LoadValues");
    [self setBasicsForConfiguration];
   
    
    [self addLegButtons];

    
    // *************************************************************************************************************************
    
    
    
    
    [self makeConfigButtons];
    
    
    
    [self computeSpecialEquipmentTotals];
    
    [self.arrayName2 replaceObjectAtIndex:3 withObject: vBEW.text];
    [self.arrayName4 replaceObjectAtIndex:3 withObject: vBEWMom.text];
    [self.arrayName6 replaceObjectAtIndex:3 withObject: vBEWMomLat.text];
    armlong = [vBEWMom.text doubleValue] / [vBEW.text doubleValue];
    armlat  = [vBEWMomLat.text doubleValue]   / [vBEW.text doubleValue];
    lBEWArm.text = [NSString stringWithFormat:@"%.2f",armlong];
    lBEWArmLat.text = [NSString stringWithFormat:@"%.3f",armlat];
    [self.arrayName3 replaceObjectAtIndex:3 withObject: lBEWArm.text];
    [self.arrayName5 replaceObjectAtIndex:3 withObject: lBEWArmLat.text];
    
 
    
    inputPressureAlt.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderHp.value];
    
    labelOATforOGE.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderOATforOGE.value];
    
    labelISAdiff.text = [ [NSString alloc] initWithFormat:@"%.0f", sliderISADiff.value];
    
    
    if (warningsOnOff == 1) {
        switchWarnings.on = YES;
    } else {
        switchWarnings.on = NO;
    }
    
    
    if (warningsOnOffIGEOGE == 1) {
        _switchWarningsIGEOGE.on = YES;
    } else {
        _switchWarningsIGEOGE.on = NO;
    }
    
    if (warningOnOff_MTOW == 1) {
        _switchWarningMTOW.on = YES;
    } else {
        _switchWarningMTOW.on = NO;
    }


    
    // *************************************************************************************************************************

    
    
    
    
    [self createListoItemsSlidersAndInterior];
    

    
    return;
    


    
    
    
    
    
}





- (void) SaveValues {
    
    //NSLog(@"SaveValues");
    
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    
    [defaults  setObject: [NSKeyedArchiver archivedDataWithRootObject:helicopters] forKey:@"helicopters"];
    [defaults  setObject: [NSKeyedArchiver archivedDataWithRootObject:crew_sectioned] forKey:@"crew_sectioned"];
   
    [defaults  setObject: vFlightID                                     forKey:@"vFlightID"];
    [defaults  setObject: _inputSliderIncrement.text                    forKey:@"_inputSliderIncrement"];
    [defaults  setObject: _inputQuickLoadPreset.text                    forKey:@"_inputQuickLoadPreset"];
    [defaults  setObject: _defaultEmailAddress.text                     forKey:@"_defaultEmailAddress"];
    [defaults  setObject: _defaultEmailAddressCC.text                   forKey:@"_defaultEmailAddressCC"];
    [defaults  setObject: self.tableViewDataName                        forKey:@"tableViewDataName"];
    [defaults  setObject: self.tableViewDataWeight                      forKey:@"tableViewDataWeight"];
    [defaults  setObject: _inputSpecificFuelMassPerVolume.text          forKey:@"_inputSpecificFuelMassPerVolume"];
    [defaults  setObject: lastupdate_helicopters                        forKey:@"lastupdate_helicopters"];
    [defaults  setObject: lastupdate_crew                               forKey:@"lastupdate_crew"];
    [defaults  setObject: crew_lastLocation                             forKey:@"crew_lastLocation"];
    [defaults  setObject: crew_types                                    forKey:@"crew_types"];
    [defaults  setObject: arrayAvailableListIDs                         forKey:@"arrayAvailableListIDs"];
    [defaults  setObject: inputWarningFuelReserveTime.text              forKey:@"inputWarningFuelReserveTime"];
    [defaults  setFloat:  connectedToFleetControl                       forKey:@"connectedToFleetControl"];
    [defaults  setFloat:  warningPercentMargin                          forKey:@"warningPercentMargin"];
    [defaults  setFloat:  warningsOnOff                                 forKey:@"warningsOnOff"];
    [defaults  setFloat:  warningsOnOffIGEOGE                           forKey:@"warningsOnOffIGEOGE"];
    [defaults  setFloat:  warningOnOff_MTOW                             forKey:@"warningOnOff_MTOW"];
    [defaults  setFloat:  nvgMode                                       forKey:@"nvgMode"];
    [defaults  setFloat:  _sliderNVG.value                              forKey:@"_sliderNVG"];
    [defaults  setFloat:  datepickInterval                              forKey:@"datepickInterval"];
    [defaults  setObject: _inputSafetyMargin.text                       forKey:@"_inputSafetyMargin"];
    [defaults  setObject: _inputFuelIncrement.text                       forKey:@"_inputFuelIncrement"];
    

    
    [defaults  setObject: _inputOverrideBEW.text                       forKey:@"_inputOverrideBEW"];
    [defaults  setObject: _inputOverrideMoment.text                    forKey:@"_inputOverrideMoment"];
    [defaults  setObject: _inputOverrideMomentLat.text                 forKey:@"_inputOverrideMomentLat"];
    [defaults  setObject: _inputOverrideRegistration.text              forKey:@"_inputOverrideRegistration"];
    [defaults  setObject: inputFuelFlowOverride.text                    forKey:@"inputFuelFlowOverride"];
    
    [defaults setBool:[_switchGuidance isOn] forKey:@"_switchGuidance"];
    [defaults setBool:[_switchAutoLandingFuel isOn] forKey:@"_switchAutoLandingFuel"];
    
    [defaults  setInteger: _segmentFuelVolumeOrMass.selectedSegmentIndex        forKey:@"_segmentFuelVolumeOrMass"];
    [defaults  setInteger: _segmentCGAutoCheck.selectedSegmentIndex             forKey:@"_segmentCGAutoCheck"];
    [defaults  setInteger: _segmentFlightLegMode.selectedSegmentIndex           forKey:@"_segmentFlightLegMode"];
    [defaults  setInteger: _segmentPlanMode.selectedSegmentIndex                forKey:@"_segmentPlanMode"];
    [defaults  setInteger: _segmentSeatLoadOptions.selectedSegmentIndex         forKey:@"_segmentSeatLoadOptions"];
    [defaults  setInteger: _segmentNamesOnSeats.selectedSegmentIndex            forKey:@"_segmentNamesOnSeats"];
    [defaults  setInteger: _segmentSwapMode.selectedSegmentIndex                forKey:@"_segmentSwapMode"];
    
    
    legSettingsDictionary = [[NSMutableDictionary alloc] init];
  
    
    
    legSettingsDictionary[@"_legACCategory"] = ACCategory; // Heli
    legSettingsDictionary[@"_legACmanufacturer"] = ACmanufacturer; // Airbus
    legSettingsDictionary[@"_legAC_Type"] = AC_Type ; // H175
    legSettingsDictionary[@"_legACVariant"] = ACVariant; // NONE
    legSettingsDictionary[@"_vFlightTypeField"] = _vFlightTypeField.text ;
    
    legSettingsDictionary[@"_vFlightIDName"] = _vFlightIDName.text ;
    legSettingsDictionary[@"_vHOMSA"] = _vHOMSA.text ;
    legSettingsDictionary[@"arrayBaseName"] = arrayBaseName ;
    legSettingsDictionary[@"arrayConfigurationName"] = arrayConfigurationName ;
    legSettingsDictionary[@"arrayPackageName"] = arrayPackageName ;
    legSettingsDictionary[@"arrayConfigItemName"] = arrayConfigItemName ;
    legSettingsDictionary[@"arrayConfigItemWeight"] = arrayConfigItemWeight ;
    legSettingsDictionary[@"arrayConfigItemArmLong"] = arrayConfigItemArmLong ;
    legSettingsDictionary[@"arrayConfigItemMomLong"] = arrayConfigItemMomLong ;
    legSettingsDictionary[@"arrayConfigItemArmLat"] = arrayConfigItemArmLat ;
    legSettingsDictionary[@"arrayConfigItemMomLat"] = arrayConfigItemMomLat ;
    legSettingsDictionary[@"arrayConfigIteminOut"] = arrayConfigIteminOut ;
    legSettingsDictionary[@"arrayConfigItemLocked"] = arrayConfigItemLocked ;
    legSettingsDictionary[@"_dropDownBaseID"] = _dropDownBaseID.text ;
    legSettingsDictionary[@"_inputDocumentPreparedTime"] = _inputDocumentPreparedTime.text ;
    legSettingsDictionary[@"_inputDocumentPreparedDate"] = _inputDocumentPreparedDate.text ;
    legSettingsDictionary[@"_input_documentPreparedBy"] = _input_documentPreparedBy.text ;
    legSettingsDictionary[@"inputFuelFlowOverride"] = inputFuelFlowOverride.text ;
    legSettingsDictionary[@"vFlightRegistration"] = vFlightRegistration.text ;
    legSettingsDictionary[@"_manifestTimeStamp"] = _manifestTimeStamp.text ;
    legSettingsDictionary[@"timeStampForPDF"] = timeStampForPDF ;
    legSettingsDictionary[@"_labelDepartureTimeLocal"] = _labelDepartureTimeLocal.text ;
    legSettingsDictionary[@"_labellandingtimeLocal"] = _labellandingtimeLocal.text ;
    legSettingsDictionary[@"labelDepartureTimeGMT"] = _labelDepartureTimeGMT.text ;
    legSettingsDictionary[@"_inputPaxOnBoard"] = _inputPaxOnBoard.text ;
    legSettingsDictionary[@"vBEW"] = vBEW.text ;
    legSettingsDictionary[@"vBEWMom"] = vBEWMom.text ;
    legSettingsDictionary[@"vBEWMomLat"] = vBEWMomLat.text ;
    legSettingsDictionary[@"vFlightDeparture"] = vFlightDeparture.text ;
    legSettingsDictionary[@"vFlightDestination"] = vFlightDestination.text ;
    legSettingsDictionary[@"_labelFlightTimeMinutes"] = _labelFlightTimeMinutes.text ;
    legSettingsDictionary[@"sliderOATforOGE"] = [NSString stringWithFormat:@"%.4f", sliderOATforOGE.value  ];
    legSettingsDictionary[@"sliderHp"] = [NSString stringWithFormat:@"%.4f", sliderHp.value  ];
    legSettingsDictionary[@"sliderISADiff"] = [NSString stringWithFormat:@"%.4f", sliderISADiff.value  ];
    legSettingsDictionary[@"_sliderMSL"] = [NSString stringWithFormat:@"%.4f", _sliderMSL.value  ];
    legSettingsDictionary[@"sliderQNH"] = [NSString stringWithFormat:@"%.4f", sliderQNH.value  ];
    legSettingsDictionary[@"_sliderFuelMain1"] = [NSString stringWithFormat:@"%.4f", _sliderFuelMain1.value  ];
    legSettingsDictionary[@"_sliderFuelLanding"] = [NSString stringWithFormat:@"%.4f", _sliderFuelLanding.value  ];
    legSettingsDictionary[@"activeConfigButton"] = [NSString stringWithFormat:@"%.4f", activeConfigButton  ];
    legSettingsDictionary[@"listEnd"] = [NSString stringWithFormat:@"%.4f", listEnd  ];
    legSettingsDictionary[@"configuration"] = [NSString stringWithFormat:@"%d", configuration  ];
    legSettingsDictionary[@"guidanceLegCheckOK"] = [NSString stringWithFormat:@"%d", guidanceLegCheckOK  ];
    
    legSettingsDictionary[@"_vFlightTimeHours"] = _vFlightTimeHours.text ;
    legSettingsDictionary[@"_vFlightTimeMinutes"] = _vFlightTimeMinutes.text ;
    
    legSettingsDictionary[@"labelCGTakeoff"] = labelCGTakeoff.text;
    legSettingsDictionary[@"MTOW"] = [_arrayName21 objectAtIndex:9];
    
    legSettingsDictionary[@"legFlightTimeMinutes"] = [NSString stringWithFormat:@"%d", legFlightTimeMinutes  ];
    legSettingsDictionary[@"_labelGuidanceLegTime"] = _labelGuidanceLegTime.text;
    
    
    //NSLog(@"saveing legFlightTimeMinutes %d", legFlightTimeMinutes);
    
    legSettingsDictionary[@"_vEngineStarts1"] = _vEngineStarts1.text ;
    legSettingsDictionary[@"_vEngineStarts2"] = _vEngineStarts2.text ;
    legSettingsDictionary[@"_vRIN"] = _vRIN.text ;
    
    legSettingsDictionary[@"_cgFWDlimit"] = _cgFWDlimit.text;
    legSettingsDictionary[@"_cgAFTlimit"] = _cgAFTlimit.text;
    
    legSettingsDictionary[@"_labelGuidanceFuel"] = _labelGuidanceFuel.text;
    
    
    
    legSettingsDictionary[@"_vCockpitSeatLeft"] = _vCockpitSeatLeft.text ;
    legSettingsDictionary[@"_vCockpitSeatRight"] = _vCockpitSeatRight.text ;
    
    legSettingsDictionary[@"_labelBaseName"] = _labelBaseName.text ;
    
    legSettingsDictionary[@"linePilot"] = [NSString stringWithFormat:@"%d", linePilot  ];
    
    legSettingsDictionary[@"mcgInputAirportElevationMSL"] = calculatePerformanceClass_.mcgInputAirportElevationMSL.text;
    //NSLog(@"saving  mcgInputAirportElevationMSL = %@", calculatePerformanceClass_.mcgInputAirportElevationMSL.text);
    
    
    
    // get PersonsOnBoard
    
    arrayPersonsOnBoard = [[NSMutableArray alloc] init];
    
    for (int i = 0; i < _arrayName10.count ; i++) {
        
        if ( [[_arrayName10 objectAtIndex:i] isEqualToString:@"seat"] ) {
            
            
            if ( [[_arrayName7 objectAtIndex:i] isEqualToString:@"-"] || [[_arrayName7 objectAtIndex:i] isEqualToString:@""] ) {
                continue;
            }
            
            if ( [[_arrayName1 objectAtIndex:i] isEqualToString:@"PIC"] || [[_arrayName2 objectAtIndex:i] isEqualToString:@"Pilot"] ) {
                continue;
            }
            
            if ( [[_arrayName1 objectAtIndex:i] isEqualToString:@"SIC"] ) {
                continue;
            }
            
            
            [arrayPersonsOnBoard addObject:[_arrayName7 objectAtIndex:i]];
        }
        
    }
    
    
    _labelPaxOnBoard.text = @"";
    
    for(int i=0; i<arrayPersonsOnBoard.count; i++) {
        
        _labelPaxOnBoard.text = [_labelPaxOnBoard.text stringByAppendingString:[arrayPersonsOnBoard objectAtIndex: i ]   ];
        _labelPaxOnBoard.text = [_labelPaxOnBoard.text stringByAppendingString:@" / "   ];
    }
    
    
    //NSLog(@"_labelPaxOnBoard.text %@", _labelPaxOnBoard.text  );

    
    
    legSettingsDictionary[@"arrayPersonsOnBoard"] = arrayPersonsOnBoard;
    legSettingsDictionary[@"_labelPaxOnBoard"] = _labelPaxOnBoard.text;
    
    
    
    
    legSettingsDictionary[@"vTOW"] = [NSString stringWithFormat:@"%.1f", vTOW  ];
    legSettingsDictionary[@"vLDW"] = [NSString stringWithFormat:@"%.1f", vLDW  ];
    legSettingsDictionary[@"legID"] = vLegID ;
    
    legSettingsDictionary[@"signatureImage"] = signatureImageData ;
    
    legSettingsDictionary[@"guidanceDictionary"] = guidanceDictionary ;
    
    legSettingsDictionary[@"_arrayName1"] = _arrayName1 ;
    legSettingsDictionary[@"_arrayName2"] = _arrayName2 ;
    legSettingsDictionary[@"_arrayName3"] = _arrayName3 ;
    legSettingsDictionary[@"_arrayName4"] = _arrayName4 ;
    legSettingsDictionary[@"_arrayName5"] = _arrayName5 ;
    legSettingsDictionary[@"_arrayName6"] = _arrayName6 ;
    legSettingsDictionary[@"_arrayName7"] = _arrayName7 ;
    legSettingsDictionary[@"_arrayName8"] = _arrayName8 ;
    legSettingsDictionary[@"_arrayName9"] = _arrayName9 ;
    legSettingsDictionary[@"_arrayName10"] = _arrayName10 ;
    legSettingsDictionary[@"_arrayName11"] = _arrayName11 ;
    legSettingsDictionary[@"_arrayName12"] = _arrayName12 ;
    legSettingsDictionary[@"_arrayName13"] = _arrayName13 ;
    legSettingsDictionary[@"_arrayName14"] = _arrayName14 ;
    legSettingsDictionary[@"_arrayName15"] = _arrayName15 ;
    legSettingsDictionary[@"_arrayName16"] = _arrayName16 ;
    legSettingsDictionary[@"_arrayName17"] = _arrayName17 ;
    legSettingsDictionary[@"_arrayName18"] = _arrayName18 ;
    legSettingsDictionary[@"_arrayName19"] = _arrayName19 ;
    legSettingsDictionary[@"_arrayName20"] = _arrayName20 ;
    legSettingsDictionary[@"_arrayName21"] = _arrayName21 ;
    legSettingsDictionary[@"_arrayName22"] = _arrayName22 ;
    legSettingsDictionary[@"_arrayName23"] = _arrayName23 ;
    legSettingsDictionary[@"_arrayName24"] = _arrayName24 ;
    legSettingsDictionary[@"_arrayName25"] = _arrayName25 ;
    
   
    
    
    
   
    if (flagResetAllLegs == 1) {
        allLegsPerFlightArray = [[NSMutableArray alloc] init];
         //NSLog(@"allLegsPerFlightArray vLegID %@", vLegID);
         [allLegsPerFlightArray addObject:@"-"];
         [allLegsPerFlightArray addObject:@"-"];
        flagResetAllLegs = 0;
    }
   
    
    
    // save flight settings
    
    flightSettingsDictionary = [[NSMutableDictionary alloc] init];
    
    flightSettingsDictionary[@"keyFlightDate"] =  [_arrayName7 objectAtIndex:linePilot]; // pilot name
    
    
    flightSettingsDictionary[@"numberOfLegsThisFlight"] = [NSString stringWithFormat:@"%d", allLegsPerFlightArray.count -1 ];
    //NSLog(@"saving numberOfLegsThisFlight %d", allLegsPerFlightArray.count -1);
    
    
    
    
    [allLegsPerFlightArray replaceObjectAtIndex:0 withObject:flightSettingsDictionary];
    
    //NSLog(@"saving for leg  %@", vLegID);
    
    //NSLog(@"saving tempFlightSettingsDictionary %@", flightSettingsDictionary);
    
    
    
    [allLegsPerFlightArray replaceObjectAtIndex:[vLegID integerValue] withObject:legSettingsDictionary];
    
    [allFlightsMasterArray replaceObjectAtIndex:[vFlightID integerValue] withObject:allLegsPerFlightArray];
    
    
    
    [defaults  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];
    
    
    
    
    
    return;
    
    
    
      
      
 }






// top bar BUttons


- (void) displayWindows {
    
    
    
    if (configMode == 1) {
        [self setConfigWindow];
    }
    
    [self addLegButtons];
    
    [self.view endEditing:TRUE];
    
    calculatePerformanceClassView_.frame = CGRectMake(0, 114, 646, 634);
    
    _viewHelicopterInCenter.clipsToBounds = YES;
    
    configMode = 0;
    
    _viewDocumentPreparedBy.frame = CGRectMake(680, 1200, 311, 123);
    
    _viewDocumentPreparedBy.backgroundColor = [UIColor whiteColor];
    
  
    
    // set config mode to off
    
    _viewConfigurator.hidden = YES;
    
    _viewInputOptions.hidden = YES;
    
    _viewSpecialEquiplist.hidden = YES;
    
    _viewSignature.hidden = YES;
    
    _viewFlightManager.hidden = YES;
    
    _viewDispatch.hidden = YES;
    
    [viewMain bringSubviewToFront:_viewStationsWindow];
    
    [viewMain bringSubviewToFront:_viewHelicopterInCenter];
    
    [viewMain bringSubviewToFront:_viewButtonsFuelAndConfig];
    
    [viewMain bringSubviewToFront:_viewConfigurations];
    
    [viewOne bringSubviewToFront:viewTopDisplayButtons];
    
    [viewOne bringSubviewToFront:viewTopTop];
    
    [viewMain bringSubviewToFront:_viewCGLong];
    
    
    if (flagIsLandscape == 1) {
         _viewTrennerTop.frame = CGRectMake(645, 115, 3, 634);
        
    }else{
        _viewTrennerTop.frame = CGRectMake(643, 55, 3, 630);
        
    }
  
    
    
    [viewOne bringSubviewToFront:_viewTrennerTop];
    
    _viewSummaryManifest.hidden = YES;
    
    viewEnvironment.hidden = YES;   enterPad.hidden = YES;   viewSetup.hidden = YES;
    
    viewLoadManifest.hidden = YES;   _viewTimers.hidden= YES; _viewAltimetry.hidden = YES;
    
    _viewLowerButtons.hidden  = NO;
    
    [viewOne bringSubviewToFront:_viewLowerButtons];
    
    if (flagIsLandscape == 1) {
        
        _viewLowerButtons.frame         = CGRectMake( 637, 701, 390, 50 ); // landscape
        
    }else{
        _viewLowerButtons.frame         = CGRectMake( 380, 957, 390, 50 ); // portrait
    }
    
    
    
    if (_segmentFlightLegMode.selectedSegmentIndex == 0) {
        
        _viewFlightManagment.hidden  = NO;
        _viewFlightManagment2.hidden  = YES;
        _labelLegManagement.hidden = YES;
        _viewButtonFlightSummary.hidden = YES;
        _displayButtonFlightSummary.hidden = YES;
        
    }else{
        
        _viewFlightManagment.hidden  = YES;
        _viewFlightManagment2.hidden  = NO;
        _labelLegManagement.hidden = NO;
        _viewButtonFlightSummary.hidden = NO;
        _displayButtonFlightSummary.hidden = NO;
    }
    
    
    
 
    if (displayWindow == 1) { // environment
        
        [viewMain bringSubviewToFront:viewEnvironment]; viewEnvironment.hidden = NO;
        
    }
    
    
    if (displayWindow == 10) { //  Setup
        
        viewSetup.hidden = NO;
        
        [viewOne bringSubviewToFront:viewSetup];  [viewOne bringSubviewToFront:viewTopTop];
       
    }
    
    
    if (displayWindow == 11) { //  Load Manifest
        
        [self copyLabelsManifest];
        
         viewLoadManifest.hidden= NO;
        
        [viewOne bringSubviewToFront:viewLoadManifest];   [viewOne bringSubviewToFront:_viewLowerButtons];
       
        if (flagIsLandscape == 0) {
            
            _viewLowerButtons.center = CGPointMake( _viewLowerButtons.center.x , _viewLowerButtons.center.y - 46);
        }
    }

    
    
    if (displayWindow == 12) { //  FLIGHT MANAGER
        
        _viewFlightManager.hidden = NO;
        
        [viewOne bringSubviewToFront:_viewFlightManager];    [viewOne bringSubviewToFront:viewTopTop];
        
        [viewOne bringSubviewToFront:_viewSelectHelicopter];
        
        [self SaveValues];
      
        [self createFlightButtons];
      
        
    }
    
    

    if (displayWindow == 14) { // summary
        
       
        [self copyLabelsManifest];
        
        _viewSummaryManifest.hidden= NO;
        
        [self createSummaryLabels];
        
        [viewOne bringSubviewToFront:_viewSummaryManifest];   _viewLowerButtons.hidden = YES;
        
        [_viewSummaryManifest bringSubviewToFront:_viewSummaryLowerButtons]; _viewSummaryLowerButtons.hidden = NO;
        
        
    }




    if (displayWindow == 15) { //  Timers
        
        _viewTimers.hidden= NO;
        
        [viewOne bringSubviewToFront:_viewTimers];    [viewOne bringSubviewToFront:viewTopTop]; [viewOne bringSubviewToFront:_viewLowerButtons];
        
        
    }

    
     [viewOne bringSubviewToFront:calculatePerformanceClassView_];
    
     [self MainRoutine];
    
   
    
    
}

- (IBAction)buttonActionDisplaySetup:(id)sender {
    
    _viewDlist.hidden = YES;
    
    displayWindow = 10;
    
    [self displayWindows];
    
}






- (IBAction)buttonActionOpenFlightPage:(id)sender {
    
     displayWindow = 12;
    
    [self displayWindows];  
    
    
}


- (IBAction)buttonActionOpenMainPage:(id)sender {
    
    displayWindow = 0;
    
    [self displayWindows];
    
    
}



// Manifest

- (IBAction)buttonActionLoadManifest:(id)sender {
    
    displayWindow = 11;
    [self displayWindows];
    
    
}

- (IBAction)buttonActionCloseLoadManifest:(id)sender {
    
    viewLoadManifest.hidden = YES;
    
     displayWindow = 0;
    
     [self displayWindows]; 
    
}





// ENVIRONMENT sliders

- (IBAction)sliderActionOATforOGE:(id)sender {
    
    int dummy = sliderOATforOGE.value/1;
    sliderOATforOGE.value = dummy * 1;
    
    
    
    [self MainRoutine];

    
}

- (IBAction)sliderActionISAdiff:(id)sender {
    
    int dummy = sliderISADiff.value/1;
    
    sliderISADiff.value = dummy * 1;
    
       
    
    [self MainRoutine];


}


- (IBAction)sliderActionNVG:(id)sender {
    
    int dummy = _sliderNVG.value/1;
    _sliderNVG.value = dummy * 1;
    
    
    
    [self MainRoutine];
    
    
}


- (void) copyLabelsManifest {
    
    
    
    
    [self createItemListForLoadManifest];
    
   
    [self createTimeStamp];

    
    [self animateFuelPathManifest];
    
    _mani_PilotsName.text = [_arrayName7 objectAtIndex:linePilot];
    
    _manifestDate.text = _labelDepartureTimeLocal.text;
    
    
    _mani_Departure.text = vFlightDeparture.text;
    
    _mani_Destination.text = vFlightDestination.text;
    
    _manifestAircraftID.text = vFlightRegistration.text;
    
    _maniFlightIDName.text = _vFlightIDName.text;
    
    
    _maniLegNumber.text = vLegID;
    
    _mani_remarks.text = _vHOMSA.text;;
    
    _mani_DepartureTime.text = _labelDepartureTimeLocal.text;
    
    _mani_flightType.text = _vFlightTypeField.text;
    
    _mani_flightTime.text = [ [NSString alloc] initWithFormat:@"%@h : %@min", _vFlightTimeHours.text , _vFlightTimeMinutes.text ];
    
     
    _input_documentPreparedBy.text = _mani_PilotsName.text;
   
    
    
    _manifestDate2.text = _manifestDate.text;
    _maniFlightIDName2.text = _maniFlightIDName.text;
    _mani_flightType2.text = _mani_flightType.text;
    _manifestAircraftID2.text = _manifestAircraftID.text;
    _manifestTimeStamp2.text = _manifestTimeStamp.text;
    
    //NSLog(@"makePerfLabels1 ");
    
    for(UIView *subview in [_viewPerformanceData subviews]) {
        [subview removeFromSuperview];
    }
    
    [self makePerfLabels];
    
    
    return;
    
    
    
}

- (void) makePerfLabels {
    
    
    

    // add
    
    //NSLog(@"makePerfLabels ");
    
    float labelIncr = 19;
    
    float labelBreite = 280; float labelHoehe = 20;
    
    float topSpace = 30;
    
    
    
    NSArray *perfTagArray   = [[NSArray alloc] initWithObjects: @"Density Alt", @"Penalty", @"Corrected T/O Mass",  @"AEO HOGE TOP Ceiling" , @"OEI HIGE 2min Ceiling" , @"OEI MCP Ceiling" , @"CAT.A VTOL" , @"AVG CLB GRAD" , nil];
  
    
    for (int i = 0; i<perfTagArray.count; ++i) {
        
       
        
        UILabel *textField = [[UILabel alloc] initWithFrame:CGRectMake(7,  topSpace + i * labelIncr, labelBreite, labelHoehe)];
        textField.font = [UIFont boldSystemFontOfSize:14];
        textField.textColor = [UIColor blackColor];
        textField.textAlignment = NSTextAlignmentLeft;
        
        [textField  setText:  [perfTagArray objectAtIndex: i ]  ];
        [_viewPerformanceData addSubview: textField];

        if (i == 7) {
             dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 100 + 4  ];
            
             [textField  setText:  [ [NSString alloc] initWithFormat:@"%@", dL.text]  ];
            
           
        }
            
        
        textField = [[UILabel alloc] initWithFrame:CGRectMake(15 +15,  topSpace + i * labelIncr, labelBreite, labelHoehe)];
        
        // get label value
        
        if (i == 0) {
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", densityalt]  ];
        }
        
        if (i == 1) {
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f kg", penaltyWeight]  ];
        }
        
        if (i == 2) {
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f kg", weightTOW + penaltyWeight]  ];
        }
        
        if (i == 3) {
            
            //AEO_HOGE_TOP_Ceiling
             dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 100 + 6  ];
            NSString *tester = dL.text;
            NSLog(@"tester %@", tester);
            
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 200 + 6  ];
            
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", [dL.text floatValue] ]  ];
        }
        
        
        if (i == 4) {
            
            //OEI_HIGE_2min_Ceiling
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 100 + 7  ];
            NSString *tester = dL.text;
            //NSLog(@"tester %@", tester);
            
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 200 + 7  ];
            
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", [dL.text floatValue] ]  ];
        }
        
        
        if (i == 5) {
            
            //OEI_HIGE_2min_Ceiling
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 100 + 8  ];
            NSString *tester = dL.text;
            //NSLog(@"tester %@", tester);
            
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 200 + 8  ];
            
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", [dL.text floatValue] ]  ];
        }

        

        if (i == 6) {
            
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", catAVtolCeiling  ] ];
        }
        
        if (i == 7) {
            
            dL = [[UILabel alloc] init];  dL = (UILabel *)[self.viewTopDisplayButtons viewWithTag: dL.tag + 200 + 4  ];
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.1f %%", [dL.text floatValue] ] ];
        }
        
        /*
        if (i == 7) {
            
            [textField  setText:  [ [NSString alloc] initWithFormat:@"%.0f ft", PC2ceiling  ] ];
        }
         */
        
        
     
                
       
        textField.font = [UIFont systemFontOfSize:14];
        textField.textAlignment = NSTextAlignmentRight;
        
        [_viewPerformanceData addSubview: textField];
        
       
       
        
    }
    
    
    
    return;
    

    
    
}





- (IBAction)buttonActionToggleOATinput:(id)sender {
    
    if (OATinput == 0) {
        
        OATinput =1; viewSliderISA.hidden = NO;
        
        
        [self iEnviCalcALL];
        
        
        
        
    } else {
        
        OATinput =0; viewSliderISA.hidden = YES;
        
        
        [self iEnviCalcALL];
        
        
        
    }
    
    [self MainRoutine];
    
}






// close keyboard

- (IBAction)closeKeyboard:(id)sender {
    
    
    [self.view endEditing:TRUE];
    
    [self checkGuidance];
    
    [self MainRoutine];
    
}



- (IBAction)closeKeyboardSafetyMargin:(id)sender {
    
    
    
    [self.view endEditing:TRUE];
  
    [self setCGenvelope];
    
    [self MainRoutine];
    
}


- (IBAction)closeKeyboardPaxEntry:(id)sender {
    
    
    
    [self.view endEditing:TRUE];
    
    [self setPaxOnBoard];
    
    [self MainRoutine];
    
}


- (void) setPaxOnBoard {
    
    
    
    NSCountedSet *set = [[NSCountedSet alloc] initWithArray:_arrayName10];
    int numberOfSeats = (unsigned long)[set countForObject:@"seat"];
    //NSLog(@"fwd numberOfSeats %d", numberOfSeats);
    
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = configStationsStart + numberOfSeats-2;
    
    
    
    NSString *averagePaxWeight;
    
    if ([[_arrayName1 objectAtIndex:0] isEqualToString:@"Offshore"]) {
        averagePaxWeight = @"98";
    }else{
        averagePaxWeight = @"86";
    }
    
    
    int availableSeats = 0;
    int allocatedSeats = 0;
    
    for (int i = configStationsStart; i < configStationsEnd ; i++) {
        if ( [[_arrayName8 objectAtIndex:i] floatValue] == 1) {
            availableSeats = availableSeats +1;
        }
    }
    // sanitizing
    if ([_inputPaxOnBoard.text intValue] > availableSeats) {
        _inputPaxOnBoard.text = [ [NSString alloc] initWithFormat:@"%d", availableSeats];
    }
    if ([_inputPaxOnBoard.text intValue] < 0) {
        _inputPaxOnBoard.text = @"0";
    }
    
    int desiredSeats = [_inputPaxOnBoard.text intValue];
    
    for (int i = configStationsStart; i < configStationsEnd ; i++) {
        // check if seat is available
        if ( [[_arrayName8 objectAtIndex:i] floatValue] == 1) {
            // check if we need it
            if (allocatedSeats < desiredSeats) {
                NSString *usedPaxWeight =  averagePaxWeight;
                [_arrayName2 replaceObjectAtIndex:i  withObject:usedPaxWeight ];
                float momentLong = [usedPaxWeight floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
                [_arrayName4 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLong]  ];
                float momentLat = [usedPaxWeight floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
                [_arrayName6 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLat]  ];
                [_arrayName7 replaceObjectAtIndex:i  withObject:@"-" ];
                allocatedSeats = allocatedSeats + 1;
            }else{
                NSString *usedPaxWeight = @"0";
                [_arrayName2 replaceObjectAtIndex:i  withObject:usedPaxWeight ];
                float momentLong = [usedPaxWeight floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
                [_arrayName4 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLong]  ];
                float momentLat = [usedPaxWeight floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
                [_arrayName6 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLat]  ];
                [_arrayName7 replaceObjectAtIndex:i  withObject:@"-" ];
            }
            
            
            
        }else{
            continue;
        }
    }
    
    [self MainRoutine];
}



- (IBAction)actionBringAllPaxFWD:(id)sender {
    
    if (flagRecallSeat == 0) {
        flagRecallSeat = 1;
        
        [self memorizeSeating];
    }
    
    [self setPaxFWD];
    flagDoNOTheckFWDAFTCG = 1;
    [self MainRoutine];
    
}

- (IBAction)actionBringAllPaxAFT:(id)sender {
    
    if (flagRecallSeat == 0) {
        flagRecallSeat = 1;
        
        [self memorizeSeating];
    }
    
    [self setPaxAFT];
    flagDoNOTheckFWDAFTCG = 1;
    [self MainRoutine];
    
    
    
}

- (void) autoCheckFWDAFTCG {
    
    //NSLog(@"autoCheckFWDAFTCG");
    
    if (flagDoNOTheckFWDAFTCG == 1) {
        
        flagDoNOTheckFWDAFTCG = 0;
        
        return;
    }
    
    _labelCGWarning.hidden = YES;
    
    
    [self memorizeSeating];
    
    
    counterAutoCheckFlagStatus = 0;
    
    
    
    //NSLog(@"totalSeatWeight %.0f", totalSeatWeight);
    
    if (totalSeatWeight < 1) {
        return;
    }
    
    [self setPaxFWD];
    [self calculateListo];
    
    if (warningCGoutsideEnvelope.hidden == NO) {
        counterAutoCheckFlagStatus = 1;
    }
    
    if (counterAutoCheckFlagStatus == 3) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"SAFETY MARGIN EXCEEDED\nWITH ALL PAX FWD";
        _labelCGWarning.backgroundColor = yellowSpecialColor;
        _labelCGWarning.textColor = [UIColor blackColor];
        
    }
    
    
    if (counterAutoCheckFlagStatus == 1) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"CG EXCEEDED\nWITH ALL PAX FWD";
        _labelCGWarning.backgroundColor = [UIColor redColor];
        
    }
    if (counterAutoCheckFlagStatus == 2) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"TO IN EXT. ENV.\nWITH ALL PAX FWD";
        _labelCGWarning.backgroundColor = [UIColor orangeColor];
        _labelCGWarning.textColor = [UIColor blackColor];
        
    }
    
    //NSLog(@"1 counterAutoCheckFlagStatus %d", counterAutoCheckFlagStatus);
    
    
    
    counterAutoCheckFlagStatus = 0;
    
    [self setPaxAFT];
    [self calculateListo];
    
    if (warningCGoutsideEnvelope.hidden == NO) {
        counterAutoCheckFlagStatus = 1;
    }
    
    
    if (counterAutoCheckFlagStatus == 3) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"SAFETY MARGIN EXCEEDED\nWITH ALL PAX AFT";
        _labelCGWarning.backgroundColor = yellowSpecialColor;
        _labelCGWarning.textColor = [UIColor blackColor];
        
    }
    
    if (counterAutoCheckFlagStatus == 1) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"CG EXCEEDED\nWITH ALL PAX AFT";
        _labelCGWarning.backgroundColor = [UIColor redColor];
        _labelCGWarning.textColor = [UIColor whiteColor];
        
    }
    if (counterAutoCheckFlagStatus == 2) {
        _labelCGWarning.hidden = NO;
        _labelCGWarning.text = @"IN EXTENDED ENVELOPE\nWITH ALL PAX AFT";
        _labelCGWarning.backgroundColor = [UIColor orangeColor];
        _labelCGWarning.textColor = [UIColor blackColor];
        
    }
    
    /*
     if (_labelCGWarning.hidden == NO) {
     _labelCGWarning.alpha = 1;
     [UIView animateWithDuration:1.5 delay:0.5 options:UIViewAnimationOptionRepeat | UIViewAnimationOptionAutoreverse animations:^{
     _labelCGWarning.alpha = 0;
     } completion:nil];
     }
     */
    
    
    //NSLog(@"2 counterAutoCheckFlagStatus %d", counterAutoCheckFlagStatus);
    
    
    [self recallSeating];
    
    [self calculateListo];
}


- (IBAction)actionBringAllRecall:(id)sender {
    
    
    
    
    [self recallSeating];
    [self MainRoutine];
    
    
    
}


- (void) memorizeSeating {
    
    //NSLog(@"memorizeSeating");
    
    NSCountedSet *set = [[NSCountedSet alloc] initWithArray:_arrayName10];
    int numberOfSeats = (unsigned long)[set countForObject:@"seat"];
    //NSLog(@"fwd numberOfSeats %d", numberOfSeats);
    
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = configStationsStart + numberOfSeats-2;
    
    tempArraySeatWgt = [[NSMutableArray alloc] init];
    tempArraySeatName = [[NSMutableArray alloc] init];
    
    totalSeatWeight = 0;
    
    for (int i = configStationsStart; i < configStationsEnd ; i++) {
        
        [tempArraySeatWgt  addObject: [_arrayName2 objectAtIndex:i] ];
        [tempArraySeatName addObject: [_arrayName7 objectAtIndex:i] ];
        
        totalSeatWeight = totalSeatWeight + [[_arrayName2 objectAtIndex:i] floatValue];
    }
    
    return;
}


- (void) recallSeating {
    
    flagRecallSeat = 0;
    
    //NSLog(@"recallSeating");
    
    if (tempArraySeatWgt.count < 1) {
        
        //NSLog(@"recallSeating return");
        return;
    }
    
    NSCountedSet *set = [[NSCountedSet alloc] initWithArray:_arrayName10];
    int numberOfSeats = (unsigned long)[set countForObject:@"seat"];
    //NSLog(@"fwd numberOfSeats %d", numberOfSeats);
    
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = configStationsStart + numberOfSeats-2;
    
    
    
    for (int i = configStationsStart; i < configStationsEnd ; i++) {
        
        NSString *replacementWeight = [tempArraySeatWgt objectAtIndex:i-configStationsStart];
        
        [_arrayName2 replaceObjectAtIndex:i  withObject:replacementWeight ];
        
        [_arrayName7 replaceObjectAtIndex:i  withObject:[tempArraySeatName objectAtIndex:i-configStationsStart] ];
        
        float momentLong = [replacementWeight floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
        [_arrayName4 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLong]  ];
        float momentLat = [replacementWeight floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
        [_arrayName6 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLat]  ];
    }
    
    return;
    
    
}

- (void) setPaxFWD {
    
    NSMutableArray *tempArraySeatWgtONLY = [[NSMutableArray alloc] init];
    NSMutableArray *tempArraySeatNameONLY = [[NSMutableArray alloc] init];
    for (int i = 0; i < tempArraySeatWgt.count ; i++) {
        if ([[tempArraySeatWgt objectAtIndex:i] floatValue] > 1) {
            [tempArraySeatWgtONLY  addObject: [tempArraySeatWgt objectAtIndex:i] ];
            [tempArraySeatNameONLY addObject: [tempArraySeatName objectAtIndex:i] ];
        }
    }
    //NSLog(@"tempArraySeatWgtONLY %@", tempArraySeatWgtONLY);
    //NSLog(@"tempArraySeatNameONLY %@", tempArraySeatNameONLY);
    
    NSCountedSet *set = [[NSCountedSet alloc] initWithArray:_arrayName10];
    int numberOfSeats = (unsigned long)[set countForObject:@"seat"];
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = configStationsStart + numberOfSeats-2;
    
    
    int counterSeatAllocated =  0;
    
    for (int i = configStationsStart; i < configStationsEnd; i++) {
        
        if ([[_arrayName8 objectAtIndex:i]floatValue] == 0) {
            
            //NSLog(@"i is null this seat can not be used %d", i);
            continue;
        }
        
        
        
        
        NSString *replacementWeight;
        NSString *replacementName;
        
        if (counterSeatAllocated < tempArraySeatWgtONLY.count) {
            replacementWeight = [tempArraySeatWgtONLY objectAtIndex:counterSeatAllocated];
            replacementName   = [tempArraySeatNameONLY objectAtIndex:counterSeatAllocated];
        }else{
            replacementWeight = @"0";
            replacementName = @"-";
        }
        
        //NSLog(@"replacementWeight %@", replacementWeight);
        //NSLog(@"replacementWeight %@", replacementName);
        
        [_arrayName2 replaceObjectAtIndex:i  withObject:replacementWeight ];
        [_arrayName7 replaceObjectAtIndex:i  withObject:replacementName ];
        float momentLong = [replacementWeight floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
        [_arrayName4 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLong]  ];
        float momentLat = [replacementWeight floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
        [_arrayName6 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLat]  ];
        
        counterSeatAllocated = counterSeatAllocated + 1;
    }
    
    
    
}

- (void) setPaxAFT {
    
    NSMutableArray *tempArraySeatWgtONLY = [[NSMutableArray alloc] init];
    NSMutableArray *tempArraySeatNameONLY = [[NSMutableArray alloc] init];
    for (int i = 0; i < tempArraySeatWgt.count ; i++) {
        if ([[tempArraySeatWgt objectAtIndex:i] floatValue] > 1) {
            [tempArraySeatWgtONLY  addObject: [tempArraySeatWgt objectAtIndex:i] ];
            [tempArraySeatNameONLY addObject: [tempArraySeatName objectAtIndex:i] ];
        }
    }
    //NSLog(@"tempArraySeatWgtONLY %@", tempArraySeatWgtONLY);
    
    NSCountedSet *set = [[NSCountedSet alloc] initWithArray:_arrayName10];
    int numberOfSeats = (unsigned long)[set countForObject:@"seat"];
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = configStationsStart + numberOfSeats-3;
    
    //NSLog(@"tempArraySeatWgtONLY.count %d", tempArraySeatWgtONLY.count);
    
    int counterSeatAllocated =  0;
    
    
    for (int i = configStationsEnd; i >= configStationsStart; i--) {
        
        if ([[_arrayName8 objectAtIndex:i]floatValue] == 0) {
            
            //NSLog(@"i is null this seat can not be used %d", i);
            continue;
        }
        
        NSString *replacementWeight;
        NSString *replacementName;
        
        //NSLog(@"configStationsEnd-i %d", configStationsEnd-i);
        
        if (counterSeatAllocated < tempArraySeatWgtONLY.count) {
            replacementWeight = [tempArraySeatWgtONLY objectAtIndex:counterSeatAllocated];
            replacementName   = [tempArraySeatNameONLY objectAtIndex:counterSeatAllocated];
        }else{
            replacementWeight = @"0";
            replacementName = @"-";
        }
        
        //NSLog(@"replacementWeight %@", replacementWeight);
        //NSLog(@"replacementWeight %@", replacementName);
        
        [_arrayName2 replaceObjectAtIndex:i  withObject:replacementWeight ];
        [_arrayName7 replaceObjectAtIndex:i  withObject:replacementName ];
        float momentLong = [replacementWeight floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
        [_arrayName4 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLong]  ];
        float momentLat = [replacementWeight floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
        [_arrayName6 replaceObjectAtIndex:i  withObject: [[NSString alloc] initWithFormat:@"%.0f", momentLat]  ];
        
        counterSeatAllocated = counterSeatAllocated + 1;
        
    }
    
    
    
}


- (IBAction)closeKeyboardLegData:(id)sender {
    
    
    
    
    [self.view endEditing:TRUE];
    
       
    
    
    [self MainRoutine];
    
 
    
}



- (IBAction)closeKeyboardManifest:(id)sender {
    
    _viewDocumentPreparedBy.frame = CGRectMake(680, 1200, 311, 123);
    
    _viewDocumentPreparedBy.backgroundColor = [UIColor whiteColor];
    
    
    [self.view endEditing:TRUE];
    
   
    
}


- (IBAction)moveDocPreparedView:(id)sender {
    
    
    _viewDocumentPreparedBy.frame = CGRectMake(680, 1200 - 150 , 311, 123);
    
    _viewDocumentPreparedBy.backgroundColor = [UIColor yellowColor];
    
}

- (IBAction)actionSaveValues:(id)sender {
    
    alertFlag = 5;
    
    UIAlertView *alert = [[UIAlertView alloc]
                          
                          initWithTitle:@"SETTINGS SAVED"
                          
                          message:@"Settings and values saved successfully. "
                          
                          delegate:self
                          
                          cancelButtonTitle: nil
                          
                          
                          
                          otherButtonTitles:@"OK", nil];
    
    [alert show];
    
    
    
}



- (IBAction)closeKeyboardPressureAlt:(id)sender {
    
    
    [self.view endEditing:TRUE];
    
        
    
    
    if ([inputPressureAlt.text doubleValue] > 20000) {
        inputPressureAlt.text   = [ [NSString alloc] initWithFormat:@"%.0f", 20000.0];
    } 
    
    if ([inputPressureAlt.text doubleValue] < -2000) {
        inputPressureAlt.text   = [ [NSString alloc] initWithFormat:@"%.0f", -2000.0];
    } 
    
      
    sliderHp.value = [inputPressureAlt.text doubleValue];
    
        
    [self MainRoutine];
    
}





- (IBAction)buttonActionEnterOAT:(id)sender {
    
    if (flagButtonPressed == 0) {
        
          [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern YelGlow.png"];
        
        [buttonOAT setImage:buttonmark forState:UIControlStateNormal];
        
         EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        selectedItem = 16;
        
       
        
    } else {[self setButtonMarksNeutral];}
    
}

- (IBAction)buttonActionEnterISA:(id)sender {
    
    NSLog(@"enter isa");
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];

        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern YelGlow.png"];
        
        [buttonISA setImage:buttonmark forState:UIControlStateNormal];
        
         EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        selectedItem = 17;
        
        
    } else {[self setButtonMarksNeutral];}
    
}


- (IBAction)buttonActionEnterPressureAlt:(id)sender {
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern YelGlow.png"];
        
        [buttonPressureAlt setImage:buttonmark forState:UIControlStateNormal];
        
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        selectedItem = 18;
        
        
        
    } else {[self setButtonMarksNeutral];}
    
}



- (IBAction)buttonActionEnterMSLfeet:(id)sender {
    
    
    
    if (flagButtonPressed == 0) {
        
         [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterMSLfeet setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 21;
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}


- (IBAction)buttonActionEnterQNH:(id)sender {
    
    
    
    if (flagButtonPressed == 0) {
        
        
        [self setListoButtonsNeutral];

        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterQNH setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        selectedItem = 22;
        
    } else { [self setButtonMarksNeutral]; [self setListoButtonsNeutral];}
    
    
    
    
    
}


- (IBAction)slideractionQNH:(UISlider *)sender {
    
    labelQNH.text = [ [NSString alloc] initWithFormat:@"%.2f", sliderQNH.value];
    
    
    
    
    [self MainRoutine];
    
    
    
}



- (IBAction)actionSetISA:(id)sender {
    
    sliderQNH.value = 29.92;
    
    calcisa = 15 - (1.98 * (_sliderMSL.value/1000));
    
    sliderOATforOGE.value = calcisa;
    
    sliderISADiff.value = 0;
    
    OAT = sliderOATforOGE.value;
    
    float OATCelsius = OAT;
    
    //float fahrenheit = (OATCelsius * 1.8) + 32;
    
    [self MainRoutine];
    
}



- (void) setButtonMarksNeutral {
    
    //[self setListoButtonsNeutral];
    
    
    
    selectedItem = 0;
    
    
    enterPad.hidden = YES; flagButtonPressed = 0; EnterPadString = @""; calculatorscreen.text = @""; EnterValueTwo = 0;
    
    UIImage *buttonmark = [UIImage imageNamed:@"Klammern.png"];
    
    [_buttonEnterFlightTimeMinutes setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelLanding setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelMain setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelMainPercent setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelLandingPercent setImage:buttonmark forState:UIControlStateNormal];
    
    
    
    [buttonOAT setImage:buttonmark forState:UIControlStateNormal];
    [buttonISA setImage:buttonmark forState:UIControlStateNormal];
    
    
    [buttonPressureAlt setImage:buttonmark forState:UIControlStateNormal];
    [_buttonEnterMSLfeet setImage:buttonmark forState:UIControlStateNormal];
    [_buttonEnterQNH setImage:buttonmark forState:UIControlStateNormal];
    
   
    [self MainRoutine];
     [self MainRoutine];
}



// conversion KG / lbs


- (IBAction)buttonActionKilogram:(id)sender {
    
    
  
}









// ENTER PAD -----------------------------------------------------------------



- (IBAction)padCancelButton:(id)sender {
    
    currentNumber = 0;
    
    calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
    
    
    
    [self MainRoutine];  
   
    
    
    
}

- (IBAction)buttonDigitPressed:(id)sender {
    
    
    if (EnterValueTwo == 0) {
        calculatorscreen.text = @"0"; EnterPadString = @"";
    }
    
    
    currentNumber = 0;
    
    currentNumber = (float) [sender tag];
    
    
    //NSLog (@"buttonDigitPressed currentNumber %@ ", [ [NSString alloc] initWithFormat:@"%.1f ", currentNumber]);
    
    
    
    
    NSString *currentnumber = [NSString stringWithFormat:@"%.0f", currentNumber];
    
    
    EnterPadString = [EnterPadString  stringByAppendingString: currentnumber];  // attach number to help string
    
    
    EnterValueTwo = [EnterPadString doubleValue];  // define Enter Value
    
    if (EnterValueTwo > 14000 && EnterValueTwo < 14000) {
        EnterValueTwo = 14000; }
    
    if (commapressedTwo == 0) {
        calculatorscreen.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo];
    } else {
        calculatorscreen.text = [ [NSString alloc] initWithFormat:@"%.2f", EnterValueTwo];
    }
    
    
}

- (IBAction)buttonComma:(id)sender {
    
    commapressedTwo = 1;
    
    EnterPadString = [EnterPadString stringByAppendingString: @"."];
}

- (IBAction)buttonMinus:(id)sender {
    
    minuspressedTwo = 1;
    
    EnterValueTwo =  EnterValueTwo * -1;
    
    if (commapressedTwo == 0) {
        calculatorscreen.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo];
    } else {
        calculatorscreen.text = [ [NSString alloc] initWithFormat:@"%.2f", EnterValueTwo];
    }
    
}

- (IBAction)padEnterButton:(id)sender {
    
    
    flagButtonListoPressed = 0;
    
    //NSLog (@"ENTER selectedItem %@ ", [ [NSString alloc] initWithFormat:@"%.1f ", selectedItem]);
    
    
    
    if (selectedItem < 16 || selectedItem == 40) {
        
        [self actionENTERpadListo];
        
    }
    
    
    currentNumber = 0;
    
    
    
    
    
    
    
    
    if (selectedItem == 16) {
        
        if ([labelOATforOGE.text floatValue] > 40.0) {
            labelOATforOGE.text   = @"40";
        }
        
        if ([labelOATforOGE.text floatValue] < -40.0) {
            labelOATforOGE.text   = @"-40";
        }
        
        
        sliderOATforOGE.value = EnterValueTwo;
        
        labelOATforOGE.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo];
        
        
        
        //NSLog(@"EnterPadString %@", EnterPadString);
        
        [self setListoButtonsNeutral];
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    if (selectedItem == 17) {
        
        if ([labelISAdiff.text floatValue] > 40.0) {
            labelISAdiff.text   = @"40";
        }
        
        if ([labelISAdiff.text floatValue] < -40.0) {
            labelISAdiff.text   = @"-40";
        }
        
        
        sliderISADiff.value = EnterValueTwo;
        
        labelISAdiff.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo];
        
        
        [self setListoButtonsNeutral];
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    } 
    
    
    if (selectedItem == 18) {
        
        if ([inputPressureAlt.text doubleValue] > 20000.0) {
            inputPressureAlt.text   = @"20000";
        } 
        
        if ([inputPressureAlt.text doubleValue] < -2000.0) {
            inputPressureAlt.text   = @"-2000";
        } 
        
        
        
        
        sliderHp.value = EnterValueTwo;
        
        inputPressureAlt.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo];
        
        
        [self setListoButtonsNeutral];
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    if (selectedItem == 19) {
        
      
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    if (selectedItem == 21) { // msl
        
        _sliderMSL.value = EnterValueTwo;
        
        
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    if (selectedItem == 22) {
        
        sliderQNH.value =  [EnterPadString floatValue] / 33.86530749;  // use this if input is in Millibar!!!
        
        //sliderQNH.value =  [EnterPadString floatValue];
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }


    
    
    if (selectedItem == 25) {
        
        float enterValue = [EnterPadString floatValue];
        
        
        if ([fuelEnterMode isEqualToString:@"mass"]) {
            
            if (enterValue > tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue] ) {
                enterValue = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
            }
            
             _sliderFuelMain1.value =  enterValue / [_inputSpecificFuelMassPerVolume.text floatValue];
            
            
        }else{
            
            if (enterValue > tankCapacityVolume) {
                enterValue = tankCapacityVolume;
            }
            
             _sliderFuelMain1.value =  enterValue;
            
        }
        
        
        
       
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    if (selectedItem == 26) {
        
        
        
        
        float enterValue = [EnterPadString floatValue];
        
        
        if ([fuelEnterMode isEqualToString:@"mass"]) {
            
            if (enterValue > tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue] ) {
                enterValue = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
            }
            
            if (enterValue > _sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue]) {
                enterValue = (_sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue]) - 30;
            }
            
            _sliderFuelLanding.value =  enterValue / [_inputSpecificFuelMassPerVolume.text floatValue];
            
            
        }else{
            
            if (enterValue > tankCapacityVolume) {
                enterValue = tankCapacityVolume;
            }
            
            
            if (enterValue > _sliderFuelMain1.value ) {
                enterValue = _sliderFuelMain1.value  - 30;
            }
            
            _sliderFuelLanding.value =  enterValue;
            
        }
        
        
        
        
        
        
       
        
       
        
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    if (selectedItem == 27) {
        
        float enterValue = [EnterPadString floatValue];
        
        if (enterValue > 100) {
            enterValue = 100;
        }
        
        _sliderFuelMain1.value =  enterValue * (tankCapacityVolume/100.0);
        
        
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    if (selectedItem == 28) {
        
        float enterValue = [EnterPadString floatValue];
        
        if (enterValue > 100) {
            enterValue = 100;
        }
        
        _sliderFuelLanding.value =  enterValue * (tankCapacityVolume/100.0);
        
        
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }
    
    
    
    
    
    if (selectedItem == 29) {
        
        _labelFlightTimeMinutes.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo ];
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
        [self closeEnterPad];
        
    }

    
    if (selectedItem == 30) {
        
        _inputPaxOnBoard.text = [ [NSString alloc] initWithFormat:@"%.0f", EnterValueTwo ];
        
        calculatorscreen.text = @"0"; EnterPadString = @""; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        if (enterpadAutoHide == 1) { enterPad.hidden = YES; }
        
      
        
        
        
        [self setPaxOnBoard];
        
        [self closeEnterPad];
        
        [self memorizeSeating]; flagRecallSeat = 0;
        
        [self MainRoutine];
        
    }

    
    
    
    
    
 // end enter pad



    
    
}


- (void) closeEnterPad {
    
    
    [self setListoButtonsNeutral];
    
    
    
    
    enterPad.hidden = YES; flagButtonPressed = 0;
    
    UIImage *buttonmark = [UIImage imageNamed:@"Klammern.png"];
    
    
    [_buttonEnterFlightTimeMinutes setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelLanding setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelMain setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelMainPercent setImage:buttonmark forState:UIControlStateNormal];
    
    [_buttonEnterFuelLandingPercent setImage:buttonmark forState:UIControlStateNormal];
    
    
    [buttonOAT setImage:buttonmark forState:UIControlStateNormal];
    [buttonISA setImage:buttonmark forState:UIControlStateNormal];
    
    
    [buttonPressureAlt setImage:buttonmark forState:UIControlStateNormal];
    [_buttonEnterMSLfeet setImage:buttonmark forState:UIControlStateNormal];
    [_buttonEnterQNH setImage:buttonmark forState:UIControlStateNormal];
    
    [self MainRoutine];
    [self MainRoutine];
    
}










// email **** ****  email **** ****  email **** ****  email **** ****  email **** ****  


/// check for problems with email

-(void)mailComposeController:(MFMailComposeViewController *)controller didFinishWithResult:(MFMailComposeResult)result error:(NSError *)error {
    
    if (error) {
        
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"error"
                              
                                                        message:[NSString stringWithFormat:@"error %@", [error description]]
                              
                                                       delegate:nil cancelButtonTitle:@"dismiss" otherButtonTitles:nil, nil];
        
        [alert show];
        
        
        
        [self dismissModalViewControllerAnimated:YES];
        
    }
    
    else {
        
        [self dismissModalViewControllerAnimated:YES];
        
    }
    
}     


// this is THE NEW method - create signature, capture scoll view and attach to email


- (IBAction)actionSendSummary:(id)sender {
    
     [self sendSummaryViaEmail];
}

- (IBAction)actionSendManifest:(id)sender {
    
    
    //NSLog(@"statusSignature %.0f ", statusSignature);
    
    
    //NSLog(@"ScrollViewManifest.subviews.count  %d ", ScrollViewManifest.subviews.count);
   
    
    [self sendManifestViaEmail];
    
    
    
}


- (void) createTimeStamp {
    
    
   
    
    
    // Get current  time
    
    NSDate *currentDateTime = [NSDate date];
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"HH:mm"];
    
    NSTimeZone *localTZ = [NSTimeZone localTimeZone];
    [dateFormatter setTimeZone:localTZ];
    
    NSString *localTime = [dateFormatter stringFromDate:currentDateTime];
    
    
    
    
    [dateFormatter setDateFormat:@"MM"];    NSString *dateMonth = [dateFormatter stringFromDate:currentDateTime];
    [dateFormatter setDateFormat:@"dd"];    NSString *dateDay = [dateFormatter stringFromDate:currentDateTime];
    [dateFormatter setDateFormat:@"yyyy"];  NSString *dateYear = [dateFormatter stringFromDate:currentDateTime];
    
    if ([[_arrayName23 objectAtIndex:5] isEqualToString:@"US"]) {
        
        // US
        _manifestTimeStamp.text = [NSString stringWithFormat:@"Print time & date: %@ / %@.%@.%@",  localTime, dateMonth, dateDay, dateYear];
        
        _inputDocumentPreparedDate.text = [NSString stringWithFormat:@"%@-%@-%@",  dateMonth, dateDay, dateYear];
        
        _inputDocumentPreparedTime.text = [NSString stringWithFormat:@"%@",  localTime];
        
        timeStampForPDF = [NSString stringWithFormat:@"%@-%@-%@_%@",   dateMonth, dateDay, dateYear, localTime];
        
    }else{
        
        
        // EU
        
        _manifestTimeStamp.text = [NSString stringWithFormat:@"%@/%@.%@",  vFlightRegistration.text, dateDay, dateMonth];
        
        _inputDocumentPreparedDate.text = [NSString stringWithFormat:@"%@.%@.%@",  dateDay, dateMonth, dateYear];
        
        _inputDocumentPreparedTime.text = [NSString stringWithFormat:@"%@",  localTime];
        
        timeStampForPDF = [NSString stringWithFormat:@"%@.%@.%@_%@",   dateDay, dateMonth, dateYear, localTime];

        
        
    }
    
  
    
    
}


- (void) createDateSummary {
    
    
    
    
    
    // Get current  time
    
    NSDate *currentDateTime = [NSDate date];
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"HH:mm"];
    
    NSTimeZone *localTZ = [NSTimeZone localTimeZone];
    [dateFormatter setTimeZone:localTZ];
    
  
    
    
    
    [dateFormatter setDateFormat:@"MM"];    NSString *dateMonth = [dateFormatter stringFromDate:currentDateTime];
    [dateFormatter setDateFormat:@"dd"];    NSString *dateDay = [dateFormatter stringFromDate:currentDateTime];
    [dateFormatter setDateFormat:@"yyyy"];  NSString *dateYear = [dateFormatter stringFromDate:currentDateTime];
    
    if ([[_arrayName23 objectAtIndex:5] isEqualToString:@"US"]) {
        
        
        // get date format US
        
        summaryDateStamp = [NSString stringWithFormat:@"%@-%@-%@",  dateMonth, dateDay, dateYear];

        
    }else{
        
        summaryDateStamp = [NSString stringWithFormat:@"%@.%@.%@",  dateDay, dateMonth, dateYear];
        
    }
    
    
    
    
}



- (void) sendSummaryViaEmail {
    
    
    
}

- (void) makeScreenshotPC2 {
    
    _screenshotView1.frame = CGRectMake(104, 345, 846, 850);
    _screenshotView2.hidden = YES;
    
    _perfMani_PA.text = [NSString stringWithFormat:@"%.0f ft", Hp ]; 
    _perfMani_OAT.text = [NSString stringWithFormat:@"%.0f ºC", OAT ]; 
    _perfMani_TOM.text = [NSString stringWithFormat:@"%.0f kg", vTOW ]; 
    _perfMani_Fuelkg.text = [NSString stringWithFormat:@"%.0f kg", _sliderFuelMain1.value  * [_inputSpecificFuelMassPerVolume.text floatValue] ]; 
    
    _perfMani_ObstHeadline.text = @"";
    _perfMani_ObstHeight.text = @"";
    _perfManifWithinClearwayLabel.text = @"";
    _perfManiObstHeightLabel.text = @"";

    
    NSNotification *myNotification = [NSNotification notificationWithName:@"notificationMakeScreenshotPC2"
                                                                   object:self //object is usually the object posting the notification
                                                                 userInfo:nil]; //userInfo is an optional dictionary
    
    //Post it to the default notification center
    [[NSNotificationCenter defaultCenter] postNotification:myNotification];
    
    
    
    [viewOne bringSubviewToFront:calculatePerformanceClassView_];
    
    calculatePerformanceClassView_.hidden = NO;
    
    _viewLowerButtons.hidden = YES;
    
    int pixelWidth = calculatePerformanceClassView_.frame.size.width;
    int pixelHeight = calculatePerformanceClassView_.frame.size.height;  // set hight of pdf page here (cut off the bottom)
    
    screenshotData1 = [NSMutableData data];
    
    UIGraphicsBeginPDFContextToData( screenshotData1, CGRectMake(0, 0, pixelWidth, pixelHeight),  nil );
    UIGraphicsBeginPDFPage();
    [calculatePerformanceClassView_.layer renderInContext: UIGraphicsGetCurrentContext()];
    UIGraphicsEndPDFContext();
    
    
    CGRect rect = [calculatePerformanceClassView_ bounds];
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
    [calculatePerformanceClassView_.layer renderInContext:context];
    UIImage *img = UIGraphicsGetImageFromCurrentImageContext();
    [_screenshotView1 setImage:img];
    UIGraphicsEndImageContext();
    
    calculatePerformanceClassView_.hidden = YES;
    
}

- (void) makeScreenshotCATA {
    
    //NSLog(@"makeScreenshotCATA");
    
    _screenshotView1.frame = CGRectMake(90, 315, 500, 500);
    _screenshotView2.frame = CGRectMake(90, 815, 500, 500);
    _screenshotView2.hidden = NO;
    
    _perfMani_PA.text = [NSString stringWithFormat:@"%.0f ft", Hp ]; 
    _perfMani_OAT.text = [NSString stringWithFormat:@"%.0f ºC", OAT ]; 
    _perfMani_TOM.text = [NSString stringWithFormat:@"%.0f kg", vTOW ]; 
    _perfMani_Fuelkg.text = [NSString stringWithFormat:@"%.0f kg", _sliderFuelMain1.value  * [_inputSpecificFuelMassPerVolume.text floatValue] ]; 
    
    _perfMani_ObstHeadline.text = @"Obstacle";
    _perfMani_ObstHeight.text = [NSString stringWithFormat:@"%.0f m", obstHeightExtern ]; 
    _perfManifWithinClearwayLabel.text = @"within Clearway";
    _perfManiObstHeightLabel.text = @"Obstacle Height";
    
    
    NSNotification *myNotification = [NSNotification notificationWithName:@"notificationMakeScreenshotCATA"
                                                                   object:self //object is usually the object posting the notification
                                                                 userInfo:nil]; //userInfo is an optional dictionary
    
    //Post it to the default notification center
    [[NSNotificationCenter defaultCenter] postNotification:myNotification];
        
    
    [viewOne bringSubviewToFront:calculatePerformanceClassView_];    
    calculatePerformanceClassView_.hidden = NO;    
    _viewLowerButtons.hidden = YES;    
    int pixelWidth = calculatePerformanceClassView_.frame.size.width;
    int pixelHeight = calculatePerformanceClassView_.frame.size.height;  // set hight of pdf page here (cut off the bottom)
    
    screenshotData1 = [NSMutableData data];
    
    UIGraphicsBeginPDFContextToData( screenshotData1, CGRectMake(0, 0, pixelWidth, pixelHeight),  nil );
    UIGraphicsBeginPDFPage();
    [calculatePerformanceClassView_.layer renderInContext: UIGraphicsGetCurrentContext()];
    UIGraphicsEndPDFContext();
    
    CGRect rect = [calculatePerformanceClassView_ bounds];
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
    [calculatePerformanceClassView_.layer renderInContext:context];
    UIImage *img = UIGraphicsGetImageFromCurrentImageContext();
    [_screenshotView1 setImage:img];
    UIGraphicsEndImageContext();
    
    
   
    myNotification = [NSNotification notificationWithName:@"notificationMakeScreenshotCATA2"
                                                                   object:self //object is usually the object posting the notification
                                                                 userInfo:nil]; //userInfo is an optional dictionary
    
    //Post it to the default notification center
    [[NSNotificationCenter defaultCenter] postNotification:myNotification];
    
    
    [viewOne bringSubviewToFront:calculatePerformanceClassView_];    
    calculatePerformanceClassView_.hidden = NO;    
    _viewLowerButtons.hidden = YES;    
    pixelWidth = calculatePerformanceClassView_.frame.size.width;
    pixelHeight = calculatePerformanceClassView_.frame.size.height;  // set hight of pdf page here (cut off the bottom)
    
    screenshotData2 = [NSMutableData data];
    
    UIGraphicsBeginPDFContextToData( screenshotData2, CGRectMake(0, 0, pixelWidth, pixelHeight),  nil );
    UIGraphicsBeginPDFPage();
    [calculatePerformanceClassView_.layer renderInContext: UIGraphicsGetCurrentContext()];
    UIGraphicsEndPDFContext();
    
    rect = [calculatePerformanceClassView_ bounds];
    UIGraphicsBeginImageContext(rect.size);
    context = UIGraphicsGetCurrentContext();
    [calculatePerformanceClassView_.layer renderInContext:context];
    UIImage *img2 = UIGraphicsGetImageFromCurrentImageContext();
    [_screenshotView2 setImage:img2];
    UIGraphicsEndImageContext();
    
   
    
    
    myNotification = [NSNotification notificationWithName:@"notificationMakeScreenshotDONE"
                                                   object:self //object is usually the object posting the notification
                                                 userInfo:nil]; //userInfo is an optional dictionary
    
    //Post it to the default notification center
    [[NSNotificationCenter defaultCenter] postNotification:myNotification];
    
    
    
    calculatePerformanceClassView_.hidden = YES;
    
}


- (void) sendManifestViaEmail {
        
     [self createPDFDataFromManifest];
    
    
    
    MFMailComposeViewController *composer = [[MFMailComposeViewController alloc] init];
        
    [composer setMailComposeDelegate: self];
    NSString *MailSubject     = [NSString stringWithFormat:@"Load Manifest + PC2/CAT.A Performance %@, %@   ", vFlightRegistration.text  , _manifestTimeStamp.text ];
    [composer setToRecipients:[NSArray arrayWithObjects: _defaultEmailAddress.text , nil]];
    [composer setCcRecipients:[NSArray arrayWithObjects: _defaultEmailAddressCC.text , nil]];
    [composer setSubject: MailSubject];
    [composer setMessageBody:@"Load Manifest + PC2/CAT.A Performance attached as PDF documents"  isHTML:NO];    
    [composer setModalTransitionStyle:UIModalTransitionStyleCrossDissolve]; 
    
    
    [composer addAttachmentData:pdfData mimeType:@"application/pdf" fileName:[NSString stringWithFormat:@"Preflight_%@.pdf",  vFlightRegistration.text]];
       
  
    [self presentModalViewController:composer animated:YES];
    
   
    
}




    

   





- (void) searchbutSelHeli{
    
    
    float ACnumber = 0;
    
   //NSLog (@"searchbutSelHeli%@", vFlightRegistration.text);
    
    
    int flagHeliFound = 0;
    
    if (helicopters.count > 0) {
        
        for(helicopter *current in helicopters)
        {
            if ([current.callsign isEqualToString:vFlightRegistration.text]) {
                flagHeliFound = 1;
                break;
            }
            
            ACnumber = ACnumber +1;
            
        }
        
        if (flagHeliFound == 0) {
            return;
        }
        
      
        
        // get ac data
        NSString *specialdata3 = [[helicopters objectAtIndex:ACnumber]specialdata3];
        //NSLog (@"specialdata3 %@ " , specialdata3); // ac tyoe
        
        specialdata3 = [specialdata3 stringByReplacingOccurrencesOfString:@" " withString:@""];
        
        NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@","];
        NSArray *arrayComponents = [specialdata3 componentsSeparatedByCharactersInSet:charSet1];
        
        //NSLog (@"arrayComponents.c %d", arrayComponents.count);
        
        //NSLog (@"category %@", [arrayComponents objectAtIndex:0] );
        //NSLog (@"manufacturer %@", [arrayComponents objectAtIndex:1] );
        //NSLog (@"ac type %@", [arrayComponents objectAtIndex:2] );
        
        if (arrayComponents.count == 3) {
            ACCategory = [arrayComponents objectAtIndex:0];
            ACmanufacturer = [arrayComponents objectAtIndex:1];
            AC_Type = [arrayComponents objectAtIndex:2];
            ACVariant = @"NONE";
        }
        
        if (arrayComponents.count > 3) {
            ACCategory = [arrayComponents objectAtIndex:0];
            ACmanufacturer = [arrayComponents objectAtIndex:1];
            AC_Type = [arrayComponents objectAtIndex:2];
            ACVariant = [arrayComponents objectAtIndex:3];
            
        }
        
        
        
        
        [[NSUserDefaults standardUserDefaults]  setObject:ACCategory        forKey:@"ACCategory"];
        [[NSUserDefaults standardUserDefaults]  setObject:ACmanufacturer    forKey:@"ACmanufacturer"];
        [[NSUserDefaults standardUserDefaults]  setObject:AC_Type           forKey:@"AC_Type"];
        [[NSUserDefaults standardUserDefaults]  setObject:ACVariant         forKey:@"ACVariant"];

        
        
        
        
        
        bew = [[helicopters objectAtIndex:ACnumber]bew];
        momlong = [[helicopters objectAtIndex:ACnumber]armlong];
        momlat = [[helicopters objectAtIndex:ACnumber]armlat];
        
        armlong = momlong / bew;
        armlat = momlat   / bew;
        
        vBEW.text = [NSString stringWithFormat:@"%.1f",bew];
        vBEWMom.text = [NSString stringWithFormat:@"%.1f",momlong];
        vBEWMomLat.text = [NSString stringWithFormat:@"%.1f",momlat];
        lBEWArm.text = [NSString stringWithFormat:@"%.1f",armlong];
        lBEWArmLat.text = [NSString stringWithFormat:@"%.1f",armlat];

        
        // replace BEW
        [_arrayName2 replaceObjectAtIndex:3 withObject:vBEW.text];
        [_arrayName3 replaceObjectAtIndex:3 withObject:lBEWArm.text];
        [_arrayName4 replaceObjectAtIndex:3 withObject:vBEWMom.text];
        [_arrayName5 replaceObjectAtIndex:3 withObject:lBEWArmLat.text];
        [_arrayName6 replaceObjectAtIndex:3 withObject:vBEWMomLat.text];
   
        
        /*
        vBEW.text       = [_arrayName2 objectAtIndex:3];
        lBEWArm.text    = [_arrayName3 objectAtIndex:3];
        vBEWMom.text    = [_arrayName4 objectAtIndex:3];
        lBEWArmLat.text = [_arrayName5 objectAtIndex:3];
        vBEWMomLat.text = [_arrayName6 objectAtIndex:3];
        */
        
        
        
        

        //NSLog (@"searchbutSelHeli  vBEW.text %@", vBEW.text);
        
    }// end if helicopters > 0
    
    return;
    
    
}



- (void)butSelHeli:(UIButton*)sender {
    
    
    
    //NSLog (@"ACnumber  sender.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", sender.tag]);
    
    vFlightRegistration.text = [[helicopters objectAtIndex:sender.tag]callsign];
    
    
    bew = [[helicopters objectAtIndex:sender.tag]bew];
    momlong = [[helicopters objectAtIndex:sender.tag]armlong];
    momlat = [[helicopters objectAtIndex:sender.tag]armlat];
    
    armlong = momlong / bew;
    armlat = momlat   / bew;
    
    vBEW.text = [NSString stringWithFormat:@"%.1f",bew];
    vBEWMom.text = [NSString stringWithFormat:@"%.1f",momlong];
    vBEWMomLat.text = [NSString stringWithFormat:@"%.1f",momlat];
    lBEWArm.text = [NSString stringWithFormat:@"%.1f",armlong];
    lBEWArmLat.text = [NSString stringWithFormat:@"%.1f",armlat];
    
    
    // replace BEW
    [_arrayName2 replaceObjectAtIndex:3 withObject:vBEW.text];
    [_arrayName3 replaceObjectAtIndex:3 withObject:lBEWArm.text];
    [_arrayName4 replaceObjectAtIndex:3 withObject:vBEWMom.text];
    [_arrayName5 replaceObjectAtIndex:3 withObject:lBEWArmLat.text];
    [_arrayName6 replaceObjectAtIndex:3 withObject:vBEWMomLat.text];
    
    // get ac data
    NSString *specialdata3 = [[helicopters objectAtIndex:sender.tag]specialdata3];
    //NSLog (@"specialdata3 %@ " , specialdata3); // ac tyoe
    
    specialdata3 = [specialdata3 stringByReplacingOccurrencesOfString:@" " withString:@""];
    
    NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@","];
    NSArray *arrayComponents = [specialdata3 componentsSeparatedByCharactersInSet:charSet1];
    
    //NSLog (@"arrayComponents.c %d", arrayComponents.count);
    
    //NSLog (@"category %@", [arrayComponents objectAtIndex:0] );
    //NSLog (@"manufacturer %@", [arrayComponents objectAtIndex:1] );
    //NSLog (@"ac type %@", [arrayComponents objectAtIndex:2] );
    
    if (arrayComponents.count == 3) {
        ACCategory = [arrayComponents objectAtIndex:0];
        ACmanufacturer = [arrayComponents objectAtIndex:1];
        AC_Type = [arrayComponents objectAtIndex:2];
        ACVariant = @"NONE";
    }
    
    if (arrayComponents.count > 3) {
        ACCategory = [arrayComponents objectAtIndex:0];
        ACmanufacturer = [arrayComponents objectAtIndex:1];
        AC_Type = [arrayComponents objectAtIndex:2];
        ACVariant = [arrayComponents objectAtIndex:3];

    }
    
    
    
    
    [[NSUserDefaults standardUserDefaults]  setObject:ACCategory        forKey:@"ACCategory"];
    [[NSUserDefaults standardUserDefaults]  setObject:ACmanufacturer    forKey:@"ACmanufacturer"];
    [[NSUserDefaults standardUserDefaults]  setObject:AC_Type           forKey:@"AC_Type"];
    [[NSUserDefaults standardUserDefaults]  setObject:ACVariant         forKey:@"ACVariant"];
    
    //NSLog( @"saving ACCategory %@ ", ACCategory );
    //NSLog( @"saving ACmanufacturer %@ ", ACmanufacturer );
    //NSLog( @"saving AC_Type %@ ", AC_Type );
    //NSLog( @"saving ACVariant %@ ", ACVariant );
    
    
    
    

    
    _inputOverrideBEW.text = [NSString stringWithFormat:@"%.1f",bew];
    _inputOverrideMoment.text = [NSString stringWithFormat:@"%.1f",momlong];
    _inputOverrideMomentLat.text = [NSString stringWithFormat:@"%.1f",momlat];    
    _inputOverrideRegistration.text = vFlightRegistration.text;
    
    
    UIImage *greenButton = [UIImage imageNamed:@"button strong green.png"];
     [_buttonUseDataForAircraft setBackgroundImage:greenButton forState:UIControlStateNormal];
    
    
    [self setConfiguration];
    
    [self loadPerfChartData];
    
    [self makeConfigButtons];
    
    
   
    
    //NSLog (@"flagDoCreateNewFlight %d " , flagDoCreateNewFlight);
    /*
     
     _viewSelectHelicopter.hidden = YES;
    if (flagDoCreateNewFlight == 1) {
        [self createNewFlight];
    }else{
        
        [self MainRoutine];
    }
     */
    
    
}


- (void) doCreateFlightSettings {
    
    

    
    _inputTimer1.text = @"";
    _inputTimer2.text = @"";
    _inputTimer3.text = @"";
    _inputTimer4.text = @"";
    _inputTimer5.text = @"";
    _inputTimer6.text = @"";
    
 
    _inputPaxOnBoard.text = @"";
    
    _vFlightIDName.text = @"";
   
    _labelDepartureTimeLocal.text = @"";
    _labelDepartureTimeGMT.text = @"";
    _labellandingtimeLocal.text = @"";
    
    _labelFlightTimeMinutes.text = @"60";
    
    vFlightDeparture.text = @"";
    vFlightDestination.text = @"";
    
    
    _vEngineStarts1.text = @"";
    _vEngineStarts2.text = @"";
    _vRIN.text = @"";
    _vHOMSA.text = @"";
    
 

    
    
    
    
    // load default special equipment
    
    [arrayBaseName setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayBaseName"]] mutableCopy]];
    [arrayConfigurationName setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigurationName"]] mutableCopy]];
    [arrayPackageName setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayPackageName"]] mutableCopy]];
    [arrayConfigItemName setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemName"]] mutableCopy]];
    [arrayConfigItemWeight setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemWeight"]] mutableCopy]];
    [arrayConfigItemArmLong setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemArmLong"]] mutableCopy]];
    [arrayConfigItemMomLong setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemMomLong"]] mutableCopy]];
    [arrayConfigItemArmLat setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemArmLat"]] mutableCopy]];
    [arrayConfigItemMomLat setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemMomLat"]] mutableCopy]];
    [arrayConfigIteminOut setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigIteminOut"]] mutableCopy]];
    [arrayConfigItemLocked setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[@"default" stringByAppendingString:@"arrayConfigItemLocked"]] mutableCopy]];
    
    [self computeSpecialEquipmentTotals];
    
    
   
    
    
   
  
    
    
    
    
    
    previousConfiguration = 999;
    
    [self setConfiguration];
    
    [self makeConfigButtons];
    
    [self MainRoutine];
    
   
    
}



- (void)createNewLeg {
    
    
    
    
    
}

- (IBAction)buttonActionNextFlight:(id)sender {
    
    
    if ( [vFlightID intValue] >= (allFlightsMasterArray.count-1)  ) {
        
        return;
        
    }else{
        
        [self SaveValues];
        
        vFlightID =  [ [NSString alloc] initWithFormat:@"%u", [vFlightID integerValue] +1];
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        //NSLog(@"loading flight  %d ", btn.tag-300);
        
        [defaults  setObject: vFlightID  forKey:@"vFlightID"];
        
        vLegID = @"1";
        
        [self LoadValues];
        
        [self createFlightButtons];
        
        [self MainRoutine];
        
        if (viewLoadManifest.hidden == NO) {
            [self copyLabelsManifest];
        }
        
        if (_viewSpecialEquiplist.hidden == NO) {
            [self createSpecialEquipListItems];
        }
        
    }
    
    
    [self MainRoutine];
    
}

- (IBAction)buttonActionPreviousFlight:(id)sender {
    
    
    if ( [vFlightID intValue] <= 1  ) {
        
        return;
        
    }else{
        
        [self SaveValues];
        
        vFlightID =  [ [NSString alloc] initWithFormat:@"%u", [vFlightID integerValue] -1];
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        //NSLog(@"loading flight  %d ", btn.tag-300);
        
        [defaults  setObject: vFlightID  forKey:@"vFlightID"];
        
        vLegID = @"1";
        
        [self LoadValues];
        
        [self createFlightButtons];
        
         [self MainRoutine];
        
        if (viewLoadManifest.hidden == NO) {
            
             [self copyLabelsManifest];
        }
        
        if (_viewSpecialEquiplist.hidden == NO) {
            [self createSpecialEquipListItems];
        }

        
       
      
    
    }
    
    [self MainRoutine];
    
    
}


- (IBAction)buttonActionNextLeg:(id)sender {
    
    
    if ([vLegID intValue] >= allLegsPerFlightArray.count -1) {
        return;
    }
    
    [self SaveValues];
    
    
    
    
    vLegID = [NSString stringWithFormat:@"%d",  [vLegID intValue] + 1  ];
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject:vLegID                     forKey:@"vLegID"];
    
    
    
    
    
    [self LoadValues];
    
    [self MainRoutine];
    
    if (viewLoadManifest.hidden == NO) {
        [self copyLabelsManifest];
    }
    
    if (_viewSpecialEquiplist.hidden == NO) {
        [self createSpecialEquipListItems];
    }
    
    
    [self MainRoutine];
    
    
    
    
}

- (IBAction)buttonActionPreviousLeg:(id)sender {
    
    
    if ([vLegID intValue] <= 1) {
        return;
    }
    
    
    
    [self SaveValues];
    
    
    
    
    vLegID = [NSString stringWithFormat:@"%d",  [vLegID intValue] - 1  ];
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject:vLegID                     forKey:@"vLegID"];
    
    
    
    [self LoadValues];
    
    [self MainRoutine];

    
    if (viewLoadManifest.hidden == NO) {
        [self copyLabelsManifest];
    }
    
    if (_viewSpecialEquiplist.hidden == NO) {
        [self createSpecialEquipListItems];
    }
    
    
    
    [self MainRoutine];
    
    
    
}




// ALERT VIEW

-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    
    //NSLog (@"buttonIndex %@ ", [ [NSString alloc] initWithFormat:@"%.0d ", buttonIndex]);

    //NSLog (@"alertFlag %@ ", [ [NSString alloc] initWithFormat:@"%.1f ", alertFlag]);
    
    
    
    // 0 ist der LINKE button   1 ist der RECHTE BUTTON (KG)
    
    // alert DELETE FLIGHT
    
    if (alertFlag == 1) { 
        
        if (buttonIndex == 0) {
            [self MainRoutine];
        }
        
        if (buttonIndex == 1) {
            
        }
 
    }
    
    
    
    if (alertFlag == 1001) {
        
        if (buttonIndex == 0) {
        }
        
        if (buttonIndex == 1) {
            
            [self deleteActiveLeg];
        }
        
    }
    
    
    
    if (alertFlag == 1002) {
        
        if (buttonIndex == 0) {
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self addLegToActiveFlight];
        }
        
    }
    
    
    if (alertFlag == 1003) {
        
        if (buttonIndex == 0) {
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self deleteFlightFromManager];
        }
        
    }
    
    
    if (alertFlag == 1004) {
        
        if (buttonIndex == 0) {
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self deleteActiveFlightFromManager];
        }
        
    }
    
    
    
    if (alertFlag == 1005) {
        
        if (buttonIndex == 0) {
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self resetAllFlightsFromManager];
        }
        
    }
    

    
    
    
    
    
    
    // alert DELETE first FLIGHT
    
    if (alertFlag == 2) { 
        
        if (buttonIndex == 0) {
            
              //NSLog (@"Hallo 3  ");
            
            [self MainRoutine]; 
            
        }
        
        
        if (buttonIndex == 1) {
              //NSLog (@"Hallo 4  ");
            
            [self MainRoutine];        
     }
        
        
    }
    
    
    
    
    // alert CREATE new FLIGHT
    
    
    if (alertFlag == 3) { 
        
               
        
        
        if (buttonIndex == 0) {
            
              //NSLog (@"Hallo 5  ");            
            [self MainRoutine]; 
            
        }
        
        
        if (buttonIndex == 1) {
            
              //NSLog (@"Hallo 6  ");
            
             
            
            
            
        }
        
        
    }
    
    
    
    
    
    
    if (alertFlag == 5) { // SAVE SETTINGS
        
        
        
        
        if (buttonIndex == 0) {
            
            [self SaveValues];
                       
            
           
            
        }
        
        
        if (buttonIndex == 1) {
            
            
            
            [self SaveValues];
            
            
            
        }
        
        
    }
    


    
    
    if (alertFlag == 6) { // SAVE SETTINGS
        
        
        
        
        if (buttonIndex == 0) {
            
            
            [self MainRoutine];
            
        }
        
        
        if (buttonIndex == 1) {
            
            
            
            [self sendManifestViaEmail];
            
            
            
            
            
        }
        
        
    }

    
    
    
    
    
      
   
    
    
    
    if (alertFlag == 8) { // helicopter updates
        
                
        
        if (buttonIndex == 0) {
            
            //NSLog(@"button 0 ");
            
            
            [self MainRoutine];  
            
        }
        
        
        if (buttonIndex == 1) {
            
            
            //NSLog(@"button 1 ");
            
            
           // [self loadHelicoptersFromServerVOID];
            
            
        }
        
        
        
               
        
        
    }

    
    
    
    
    if (alertFlag == 31) {
        
        
        
        
        if (buttonIndex == 0) {
            
            
            [self MainRoutine];
            
        }
        
        
        if (buttonIndex == 1) {
            
            // reset all flights
            
            
        }
        
        
    }

    
    
    if (alertFlag == 333) {
        
        
        
        
        if (buttonIndex == 0) {
            
        }
        
        
        if (buttonIndex == 1) {
            
            // try again
            
            [self import_equip_download:1];
            
            
            
            
        }
        
        
    }
    
    
    
    
    if (alertFlag == 210) { // nvg filter
        
        
        if (buttonIndex == 0) {
            
            nvgMode = 0;
            
            
            
            
            [self SaveValues];
            
            [self MainRoutine];
            
        }
        
        
        if (buttonIndex == 1) {
            
            
            nvgMode = 1;
            
            [self SaveValues];
            
            [self MainRoutine];
            
            
            
        }
        
        
    }
    
    
    if (alertFlag == 444) {
        
        if (buttonIndex == 0) {
            
            [self MainRoutine];
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self restoreConfigsAfterUpdate];
            
            displayWindow = 0;
            
            [self displayWindows];
        }
        
        
    }
    
    
    
    
    if (alertFlag == 666) {
        
        if (buttonIndex == 0) {
            
           
            
        }
        
        
        if (buttonIndex == 1) {
            
            [self SaveValues];
            
            // total recall
            
            
             [[NSUserDefaults standardUserDefaults]  setObject:@"yes" forKey:@"totalRecall"];
            //[self dismissModalViewControllerAnimated:YES];
            
            StartPage *second = [[StartPage alloc] initWithNibName:nil bundle:nil];
            second.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
            second.modalPresentationStyle = UIModalPresentationFullScreen;
            [self presentModalViewController:second animated: YES];
            
            
        
        }
        
    }
    
    
    
    
        
       
    [self MainRoutine];
    
    
           
        
        
      
        
        
        
        
 }
    
   



// setup
- (IBAction)actionWebsiteGyroinimo:(UIButton *)sender {
    
    
    [[UIApplication sharedApplication]
     
     openURL:[NSURL URLWithString:@"http://www.gyronimo.com"]];
    
}

- (IBAction)actionVideoTutorial:(id)sender {
    
    
    [[UIApplication sharedApplication]
     
     openURL:[NSURL URLWithString:@"http://www.gyronimo.com"]];
    
    
}

- (IBAction)actionSendEmailAuthor:(id)sender {
    
    
    MFMailComposeViewController *composer = [[MFMailComposeViewController alloc] init];
    
    [composer setMailComposeDelegate: self];
    
    if ([MFMailComposeViewController canSendMail]) {
        
        [composer setToRecipients:[NSArray arrayWithObjects:@"claus.richter@gyronimosystems.com", nil]];
        
        [composer setSubject:@"Performance Pad Pro"];
        
        [composer setMessageBody: @"" isHTML:NO];
        
        [composer setModalTransitionStyle:UIModalTransitionStyleCrossDissolve];
        
        [self presentModalViewController:composer animated:YES];
        
        
    }
    
}

- (IBAction)switchActionWarnings:(id)sender {
    
    if (switchWarnings.on) {
    
        warningsOnOff = 1; [self MainRoutine];
        
            
    }  else {
        
        warningsOnOff = 0;
        
        
        [self MainRoutine];
    
    }

    

    
    
    
}


- (IBAction)switchActionAutoLandingFuel:(id)sender {
    
    if (_switchAutoLandingFuel.on == YES) {
        [self MainRoutine];
        [self MainRoutine];
    }else{
        
        _sliderFuelLanding.enabled = YES;
    }
    
    
    
    
    
}


- (IBAction)switchActionNVG:(id)sender {
    
    if (_switchNVG.on) {
        
        
        
        alertFlag = 210;
        
        
        UIAlertView *alert = [[UIAlertView alloc]
                              
                              initWithTitle:@"NVG Filter"
                              
                              message:@"Before using the NVG filter make sure to dim your iPad backlight all the way down. Then, switch NVG filter ON and use the slider at the bottom to darken the screen even further. To switch off the filter, tapo on the swich again. \n\nNote: Other apps will still be bright! Test function before night flight."
                              
                              delegate:self
                              
                              cancelButtonTitle:@"CANCEL"
                              
                              otherButtonTitles:@"NVG FILTER ON", nil];
        
        [alert show];
        
        
        
        
    }  else {
        
        nvgMode = 0;
        
        [self prefersStatusBarHidden];
        
        [self performSelector:@selector(setNeedsStatusBarAppearanceUpdate)];
        
        [self SaveValues];
        
        [self MainRoutine];
        
    }
    
    
}

- (IBAction)switchActionWarningsIGEOGE:(id)sender {
    
    if (_switchWarningsIGEOGE.on) {
        
        warningsOnOffIGEOGE = 1; [self MainRoutine];
        
        
    }  else {
        
        warningsOnOffIGEOGE = 0;
        
        
        [self MainRoutine];
        
    }
    
    
   
    
    
    
}

- (IBAction)switchActionWarningMTOW:(id)sender {
    
    if (_switchWarningMTOW.on) {
        
        warningOnOff_MTOW = 1; [self MainRoutine];
        
        
    }  else {
        
        warningOnOff_MTOW  = 0;
        
        
        [self MainRoutine];
        
    }
    
    
}





// signature stuff ***************



- (IBAction)buttonActionSignLoadManifest:(id)sender {
    
    
     [ signatureController clearSignature];
    
     _viewSignature.hidden = NO; [viewOne bringSubviewToFront:_viewSignature];
    
    
    
    
}

// delete the signature from the manifest

- (IBAction)buttonActionSignatureDelete:(id)sender {
    
    [ signatureController clearSignature];
    
}


//  put signature in manifest

- (IBAction)buttonActionSignatureSign:(id)sender {
    
    _viewSignature.hidden = YES;
    
    loadedSignatureImage = [ signatureController getSignature];
    
    [self mountSignatureImageToLoadManifest];
    
    [signatureController clearSignature];
    
    
}



- (void) mountSignatureImageToLoadManifest {
    
    [scrollSig removeFromSuperview];
    
    scrollSig = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, loadedSignatureImage.size.width, loadedSignatureImage.size.height)];
    [scrollSig setImage:loadedSignatureImage];
    
    float scaleFactor = MIN(110/loadedSignatureImage.size.height, 1.0);  // was 120
    
    
    scrollSig.transform = CGAffineTransformScale(scrollSig.transform, scaleFactor, scaleFactor);
    
    scrollSig.frame = CGRectMake(70, 1200, scrollSig.frame.size.width, scrollSig.frame.size.height);
    [ ScrollViewManifest addSubview:scrollSig ];
    
    signatureImageData = [NSData dataWithData:UIImagePNGRepresentation(loadedSignatureImage)];

}


- (IBAction)actionSignAsOperationsStaff:(id)sender {
    
    
    signAs = 1;
    
    _viewSignature.hidden = NO; [viewOne bringSubviewToFront:_viewSignature];
    
    
    
    
    
}


- (IBAction)actionSignAsPIC2:(id)sender {
    
    
    signAs = 2;
    
    _viewSignature.hidden = NO; [viewOne bringSubviewToFront:_viewSignature];
    
    
    
    
    
}

- (IBAction)actionSignAsPIC3:(id)sender {
    
    
    signAs = 3;
    
    _viewSignature.hidden = NO; [viewOne bringSubviewToFront:_viewSignature];
    
    
    
    
    
}


- (IBAction)actionSignAsPIC4:(id)sender {
    
    
    signAs = 4;
    
    _viewSignature.hidden = NO; [viewOne bringSubviewToFront:_viewSignature];
    
    
    
    
    
}



- (IBAction)actionSaveSummaryAsImage:(id)sender {
    
    [self saveImageSummary];
    
    
}

- (void)saveImageSummary {
    
    
    int pixelWidth = _scrollViewSummaryManifest.contentSize.width;
    int pixelHeight = summaryBoxHeight +290;  // set hight of pdf page here (cut off the bottom)
    
    CGSize frame=CGSizeMake(pixelWidth, pixelHeight);
    UIGraphicsBeginImageContext(frame);
    
    
    CGPoint savedContentOffset = _scrollViewSummaryManifest.contentOffset;
    CGRect savedFrame = _scrollViewSummaryManifest.frame;
    
    
    _scrollViewSummaryManifest.contentOffset = CGPointZero;
    _scrollViewSummaryManifest.frame = CGRectMake(0, 0, pixelWidth, pixelHeight);
    
    
    [_scrollViewSummaryManifest.layer renderInContext:UIGraphicsGetCurrentContext()];
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    UIImageWriteToSavedPhotosAlbum(image, self,@selector(image:didFinishSavingWithError:contextInfo:), nil);
    
    
    _scrollViewSummaryManifest.contentOffset = savedContentOffset;
    _scrollViewSummaryManifest.frame = savedFrame;
    
    
}




- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo
{
    // Was there an error?
    if (error != NULL)
    {
        // Show error message...
        //NSLog(@"Failed to save image!");
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Failed to Save."
                                                        message:[error localizedDescription]
                                                       delegate:self cancelButtonTitle:@"Ok"
                                              otherButtonTitles:nil];
        [alert show];
    }
    else  // No errors
    {
        // Show message image successfully saved
        //NSLog(@"Saved image!");
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Done! \nTheManifest was saved to your Photos/Camera folder. You can view and print it from there."
                                                        message:[error localizedDescription]
                                                       delegate:self cancelButtonTitle:@"Ok"
                                              otherButtonTitles:nil];
        [alert show];
        
        
        
        
    }
}




//  close signature view

- (IBAction)buttonActionSignatureCancel:(id)sender {
    
    [ signatureController clearSignature];
    _viewSignature.hidden = YES;
    
    
    
}

//  clear signature





- (IBAction)buttonActionSwapDepartDestination:(id)sender {
    
    NSString *depart = vFlightDeparture.text;
    
    NSString *Destin = vFlightDestination.text;
    
    vFlightDeparture.text = Destin;
    
    vFlightDestination.text =depart;
    
    
    
}






// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo// el listo


- (void) addListoItemsByMoment {
    
    //NSLog(@"addListoItemsByMoment");
    
    // add fields in for next
    
    for (int i = packageStart; i < packageEND+1  ; i++) {
        
        // find item i.e. weight
        
       
        
        float weightListo = [[_arrayName2 objectAtIndex:i] floatValue];
        
        float longMomentListo = [[_arrayName4 objectAtIndex:i] floatValue];
        
        float LatMomentListo = [[_arrayName6 objectAtIndex:i] floatValue];
        
        float multiplicator = [[_arrayName8 objectAtIndex:i] floatValue];
        
        //NSLog (@"multiplicator is %@ ", multiplicator);
        
        
        
        
        totalWeightListo = totalWeightListo + ( weightListo * multiplicator);
        
        totallongMomentListo = totallongMomentListo + ( longMomentListo * multiplicator);
        
        totalLatMomentListo = totalLatMomentListo + ( LatMomentListo * multiplicator);
        
        totalArmListo = totallongMomentListo / totalWeightListo;
        
        totalArmLatListo = totalLatMomentListo / totalWeightListo;
    
        
        
    }
    
    
    
    return;
    
    
    
}


- (void) getFuelListoMain {
    
    
    
    
    fuelVolume = _sliderFuelMain1.value;
    
    
    fuelWeight = _sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue];
    
    [self interpolateFuelMomentsLongitudinal];
    
    
 
    
    
    float fuelMomentLong = fuelMoment;
    
    float longArmListo = fuelMomentLong / fuelWeight;
    
    if (fuelWeight <= 1) {longArmListo = 0; fuelMomentLong = 0; }
    
    
    
   
    
    [self interpolateFuelMomentsLateral];
    
    float fuelMomentLateral = fuelMoment;
    
   
    
    
    float longArmListoLat = fuelMomentLateral / fuelWeight;
    
    if (fuelWeight <= 1) {longArmListoLat = 0; fuelMomentLateral = 0; }
    
    
    
    totalWeightListo        = fuelWeight ;
    
    totalArmListo           =  longArmListo ;
    
    totallongMomentListo    = totallongMomentListo + fuelMomentLong;
    
    totalArmLatListo = longArmListoLat;
    
    totalLatMomentListo  = totalLatMomentListo + fuelMomentLateral;

    
    [self overwriteArrays];
    
    
    
    return;
    
    
    
}

- (void) getFuelListoLanding {
    
    
    
    
    fuelVolume = _sliderFuelLanding.value;
    fuelWeight = _sliderFuelLanding.value * [_inputSpecificFuelMassPerVolume.text floatValue];

    
    [self interpolateFuelMomentsLongitudinal];
    
    float fuelMomentLong = fuelMoment;
    
    float longArmListo = fuelMomentLong / fuelWeight;
    
    if (fuelWeight <= 1) {longArmListo = 0; fuelMomentLong = 0; }
    
    
    
    
    
    [self interpolateFuelMomentsLateral];
    
    float fuelMomentLateral = fuelMoment;
    
    //NSLog(@"fuelMomentLateral %.0f", fuelMomentLateral);
    
    
    float longArmListoLat = fuelMomentLateral / fuelWeight;
    
    if (fuelWeight <= 1) {longArmListoLat = 0; fuelMomentLateral = 0; }
    
    
    
    totalWeightListo        = fuelWeight ;
    
    totalArmListo           =  longArmListo ;
    
    totallongMomentListo    = totallongMomentListo + fuelMomentLong;
    
    totalArmLatListo = longArmListoLat;
    
    totalLatMomentListo  = totalLatMomentListo + fuelMomentLateral;
    
    
    [self overwriteArrays];
    
    
    
    return;
    
    
    
}


- (void) overwriteArrays {
    
    //NSLog(@"overwriteArrays listoItemNr %.0f", listoItemNr);
    
    [_arrayName2 replaceObjectAtIndex:listoItemNr withObject: [ [NSString alloc] initWithFormat:@"%.1f", totalWeightListo]];
    
    [_arrayName3 replaceObjectAtIndex:listoItemNr withObject: [ [NSString alloc] initWithFormat:@"%.1f", totalArmListo]];
    
    [_arrayName4 replaceObjectAtIndex:listoItemNr withObject: [ [NSString alloc] initWithFormat:@"%.1f", totallongMomentListo]];
    
    [_arrayName5 replaceObjectAtIndex:listoItemNr withObject: [ [NSString alloc] initWithFormat:@"%.1f", totalArmLatListo]];
    
    [_arrayName6 replaceObjectAtIndex:listoItemNr withObject: [ [NSString alloc] initWithFormat:@"%.1f", totalLatMomentListo]];
       return;
    
}

- (void) updateSeatButtonLabels {
    
    
    
   //NSLog(@"updateSeatButtonLabels listStart %.0f", listStart);
    
   for (int i = listStart; i < listEnd+1 ; i++) {
       
       valueField = (UITextField*)[_viewInterior viewWithTag: 200 + i];
       
       [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName2 objectAtIndex:i ] floatValue]  ]  ];
       
       if (_segmentNamesOnSeats.selectedSegmentIndex == 1 ) {
           
           
           valueField = (UITextField*)[_viewInterior viewWithTag: 700 + i];
           
           [valueField  setText: [_arrayName12 objectAtIndex:i ]   ];
           
           
           // exception pilot/copilot
           
           if (i == linePilot || i == linePilot +1) {
                [valueField  setText: [_arrayName7 objectAtIndex:i ]   ];
           }
          
           
       }
       
       if (_segmentNamesOnSeats.selectedSegmentIndex == 2 ) {
           
           
           valueField = (UITextField*)[_viewInterior viewWithTag: 700 + i];
           
           [valueField  setText: [_arrayName7 objectAtIndex:i ]   ];
           
           
       }
       
     
       
     

       
   }
   
    
    
    
    
}


- (void) getPenaltiesH145 {
    
    //NSLog (@"getPenaltiesH145");
    
    penaltyWeight = 0;
    penaltyFtMin = 0;
    
    for (int i = listStart; i < listEnd+1 ; i++) {
        
        if ([[_arrayName24 objectAtIndex:i]length] > 1  ) {
            
            // read penalty
            
            NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"_"];
            NSArray *items = [[_arrayName24 objectAtIndex:i] componentsSeparatedByCharactersInSet:charSet1];
            
            //NSLog (@"check %d %@  %@", i, [_arrayName1 objectAtIndex:i], [_arrayName8 objectAtIndex:i]);
            
            penaltyWeight = penaltyWeight +  ( [[items objectAtIndex:0] floatValue] * [[_arrayName8 objectAtIndex:i] floatValue] );
            
            
            if (weightTOW >= 3200) {
                penaltyFtMin = penaltyFtMin +  ( [[items objectAtIndex:2] floatValue] * [[_arrayName8 objectAtIndex:i] floatValue] / 100);
            }else{
                penaltyFtMin = penaltyFtMin +  ( [[items objectAtIndex:1] floatValue] * [[_arrayName8 objectAtIndex:i] floatValue] / 100);
            }
            
        }
    }    
    
    UILabel *label =(UILabel*)[_viewOptions viewWithTag: 1000] ;
    [label  setText: [ [NSString alloc] initWithFormat:@"Weight Penalty = %.0f kg", penaltyWeight ] ];
    
    label =(UILabel*)[_viewOptions viewWithTag: 1001] ;
    [label  setText: [ [NSString alloc] initWithFormat:@"Height Gain Penalty = %.2f ft/100ft", penaltyFtMin ] ];
    
    /*
    label =(UILabel*)[_viewOptions viewWithTag: 1002] ;
    [label  setText: [ [NSString alloc] initWithFormat:@"TOM = %.0fkg / Corrected = %.0fkg", weightTOW,  weightTOW + penaltyWeight ] ];
     */
    
    
    //NSLog (@"penaltyWeight %.1f  ", penaltyWeight);
    //NSLog (@"penaltyFtMin %.1f  ", penaltyFtMin);
    
    
}


-(void) calculateListo {
    
    //NSLog (@"calculateListo  ");
    
    
    
    /*
    float totalEquipmentWeight     =  totalSpecialEquipWeight;
    float totalEquipmentMoment     =  totalSpecialEquipMoment;
    float totalEquipmentMomentLat  =  totalSpecialEquipMomentLat;
    float totalEquipmentArm        =  totalSpecialEquipMoment/totalSpecialEquipWeight;
    float totalEquipmentArmLat     =  totalEquipmentMomentLat/totalSpecialEquipWeight;
    */
    
    EquipmentPackages* flightPackage = [self currentFlightEquipmentPackage];
    
    float totalEquipmentWeight     =  [flightPackage.totalWeightString floatValue];
    float totalEquipmentArm        =  [flightPackage.totalArmString floatValue] ;
    float totalEquipmentMoment     =  [flightPackage.totalMomentString floatValue] ;
    float totalEquipmentArmLat     =  [flightPackage.totalArmLatString floatValue];
    float totalEquipmentMomentLat  =  [flightPackage.totalMomentLatString floatValue];
    
    //NSLog(@"totalEquipmentWeight %.0f ", totalEquipmentWeight);
    
    
    // write pic or sic
    /*
    valueField = (UITextField*)[_viewInterior viewWithTag: 3000+linePilot];
    [valueField  setText: _vCockpitSeatRight.text ];
    valueField = (UITextField*)[_viewInterior viewWithTag: 3000+linePilot+1];
    [valueField  setText: _vCockpitSeatLeft.text ];
    
    
    [_arrayName1 replaceObjectAtIndex:linePilot withObject:_vCockpitSeatRight.text];
    [_arrayName1 replaceObjectAtIndex:linePilot+1 withObject:_vCockpitSeatLeft.text];
    */
    
    
    totalWeightListo = totalEquipmentWeight;
    totalArmListo = totalEquipmentArm ;
    
    if (totalEquipmentArm < 1) {
        totalArmListo = 0;
    }
    
    totallongMomentListo = totalEquipmentMoment ;
    totalLatMomentListo = totalEquipmentMomentLat;
    totalArmLatListo = totalEquipmentArmLat;
    if (totalEquipmentMomentLat < 1) {
        totalArmLatListo = 0;
    }
    
    //NSLog(@"lineEquipment %f", lineEquipment);
    
    listoItemNr = lineEquipment;
    [self overwriteArrays];
    

    
    
    
    
    
    
    
    // special Richard
    // calc APS
    
    packageStart    = 3;
    packageEND      = linePilot-1;
    
    totalWeightListo = 0; totallongMomentListo =0; totalLatMomentListo = 0; totalArmListo = 0 ; totalLatMomentListo = 0;
    
    
    [self addListoItemsByMoment];
    
    listoItemNr = linePilot-1;
    
    //NSLog(@"listoItemNr %.0f ", listoItemNr);
    //NSLog(@"totalWeightListo %.0f ", totalWeightListo);
    
    
    [self overwriteArrays];
    
    
    // get Zero Fuel
    
    packageStart    = 1;
    packageEND      = lineZFW-1;
    
    
    totalWeightListo = 0; totallongMomentListo =0; totalLatMomentListo = 0; totalArmListo = 0 ; totalLatMomentListo = 0;
    
    [self addListoItemsByMoment];
    
    listoItemNr = lineZFW;
    
    [self overwriteArrays];
    
    
    lZFW = totalWeightListo;
    
    lZFWArm = totalArmListo;
    
    lZFWMom = totallongMomentListo;
    
    lZFWArmLat = totalArmLatListo;
    
    lZFWMomLAt = totalLatMomentListo;
    
    
    
    float lZFM = totalWeightListo,  lZFMmoment = totallongMomentListo,  lZFMmomlat = totalLatMomentListo; // this is ZFM
    
    
    
    //NSLog (@"storeWgt ZFM %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", lZFM]);
    
    //NSLog (@"storeMom ZFM %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", lZFMmoment]);
    
    
    
    
    //  ***************************************************************************************************************
    
    // get Fuel
    
    packageStart    = lineZFW+1;
    packageEND      = lineTOW-1; // get Fuel
    
    totalWeightListo = 0; totallongMomentListo =0; totalLatMomentListo = 0;
    
    listoItemNr = lineZFW+1;
    
    [self getFuelListoMain];
    
    //NSLog(@"flightTimeMinutesALL %.1f", flightTimeMinutesALL );
    //NSLog(@"[inputFuelFlowOverride.text floatValue] %.1f", [inputFuelFlowOverride.text floatValue] );
    
    if ([_vFlightTimeMinutes.text floatValue] > 59 || [_vFlightTimeMinutes.text floatValue] <= 0 ) {
        _vFlightTimeMinutes.text = @"00";
    }
    
    if ([_vFlightTimeHours.text floatValue] > 59 || [_vFlightTimeHours.text floatValue] <= 0 ) {
        _vFlightTimeHours.text = @"0";
    }
    
    
    flightTimeMinutesALL = ( [_vFlightTimeHours.text floatValue] * 60.0 )    +  [_vFlightTimeMinutes.text floatValue];
    
    float fuelOnBoardKg = _sliderFuelMain1.value  * [_inputSpecificFuelMassPerVolume.text floatValue];
    
    _inputFuelOnBoard.text = [ [NSString alloc] initWithFormat:@"%.0f",  fuelOnBoardKg ];
    
    /*
        
    
    
    _labelFuelReserve.text = [ [NSString alloc] initWithFormat:@"%.0f",   ([_labelFuelEstimatedLanding.text floatValue]  /  [inputFuelFlowOverride.text floatValue]) * 60    ];
    */
    
   
    
    
   
    
    
    float landingFuelMinutes = 0;
    
    if ([_vFlightTypeField.text isEqualToString:@"VFR Day"] ) {
        landingFuelMinutes = 20;
        
        
    }else{
        landingFuelMinutes = 30;
        
    }
    
    
    
    
    
    float landingFuelKg = 0;
    
    landingFuelKg = ( landingFuelMinutes / 60) * [inputFuelFlowOverride.text floatValue];
    
    float landingFuelKgMinForReserve = landingFuelKg;
    
    
    if (_switchAutoLandingFuel.on == YES) {
        
        _labelFuelEstimatedLanding.text = [ [NSString alloc] initWithFormat:@"%.0f",  landingFuelKg     ];
        
        _sliderFuelLanding.value = landingFuelKg / [_inputSpecificFuelMassPerVolume.text floatValue];
        
        _sliderFuelLanding.enabled = NO;
    }else{
        
        
        _labelFuelEstimatedLanding.text = [ [NSString alloc] initWithFormat:@"%.0f",  _sliderFuelLanding.value *  [_inputSpecificFuelMassPerVolume.text floatValue]    ];
        
        landingFuelKg = [_labelFuelEstimatedLanding.text floatValue];
        
        _sliderFuelLanding.enabled = YES;
    }
    
    
    _labelReserveFuelComment.text = [ [NSString alloc] initWithFormat:@"(= %.0f min Reserve)", (landingFuelKg /  [inputFuelFlowOverride.text floatValue]) * 60    ];
    
    
    float enduranceKg = 0;
    
    if (_switchAutoLandingFuel.on == YES) {
        enduranceKg = [_inputFuelOnBoard.text floatValue] - landingFuelKg;
    }else{        
        enduranceKg = fuelOnBoardKg - landingFuelKg;
    }

    
    _labelFuelMission.text = [ [NSString alloc] initWithFormat:@"Endurance Fuel = %.0fkg - %.0fkg = %.0fkg", [_inputFuelOnBoard.text floatValue] , landingFuelKg, enduranceKg     ];
    
    int enduranceHours = enduranceKg / [inputFuelFlowOverride.text floatValue];
    
    float enduranceMinutes = (enduranceKg / [inputFuelFlowOverride.text floatValue]) * 60;
    
    int enduranceMinutesOnly = roundf( enduranceMinutes - (enduranceHours * 60));

    
    if (enduranceMinutesOnly < 10) {
        _labelEnduranceHoursMinutes.text  = [ [NSString alloc] initWithFormat:@"%d:0%d", enduranceHours, enduranceMinutesOnly    ];
    }else{
        _labelEnduranceHoursMinutes.text  = [ [NSString alloc] initWithFormat:@"%d:%d", enduranceHours, enduranceMinutesOnly    ];
        
    }
    
    
    
    
    
    
    // warning

    if ( landingFuelKg < landingFuelKgMinForReserve   ) {
        
        _viewFuelCalc.backgroundColor =[UIColor colorWithRed:167.0f/255.0f green:31.0f/255.0f blue:0.0f/255.0f alpha:1.0f]; // gray
    }else{
        
        _viewFuelCalc.backgroundColor =[UIColor colorWithRed:68.0f/255.0f green:68.0f/255.0f blue:68.0f/255.0f alpha:1.0f]; // gray
        
    }
    
    
    _warningReserveTime.hidden = YES;
    
    if ([_lReserveTime.text floatValue] < landingFuelMinutes ) {
        _warningReserveTime.hidden = NO;
    }
    
    
    
    if ([_lFuelEndurance.text floatValue] < [_labelFlightTimeMinutes.text floatValue] ) {
        _warningLabelFuelEndurance.hidden = NO;
    }
    
    
    

    // end fuel computation ***************************************************************************************************************
    
    
    double lFuel = totalWeightListo,  lFuelMom = totallongMomentListo,  lFuelMomLat = totalLatMomentListo; // this is Fuel
    
    
    fuelTO = lFuel;
    // calc TOW
    totalWeightListo = lZFM +  lFuel ;
    totallongMomentListo = lZFMmoment +  lFuelMom;
    totalLatMomentListo = lZFMmomlat +  lFuelMomLat;
    totalArmListo = totallongMomentListo / totalWeightListo;
    totalArmLatListo = totalLatMomentListo / totalWeightListo;
    
    if (isnan(totalArmLatListo)) {
        totalArmLatListo = 0;
    }
    
    listoItemNr = lineTOW;
    [self overwriteArrays]; // TOW line
    
    
    vTOW = totalWeightListo;
    vTOWArm = totalArmListo;
    vTOWMom = totallongMomentListo;
    vTOWArmLat = totalArmLatListo;
    vTOWMomLAt = totalLatMomentListo;
    
    // to get LDW, first get Landing Fuel
    
    // get LDW
    packageStart    = lineTOW +1;
    packageEND      = lineLDW -1; // Landing Fuel
    
    
    totalWeightListo = 0; totallongMomentListo =0; totalLatMomentListo = 0;
    
    listoItemNr = lineTOW +1;
    
    [self getFuelListoLanding];
    
    double lFuelLanding = totalWeightListo,  lFuelMomLanding = totallongMomentListo,  lFuelMomLatLanding = totalLatMomentListo; // this is Fuel
    
    fuelLD = lFuelLanding;
    
    
    totalWeightListo = lZFM +  lFuelLanding ;
    
    totallongMomentListo = lZFMmoment +  lFuelMomLanding;
    
    totalLatMomentListo = lZFMmomlat +  lFuelMomLatLanding;
    
    totalArmListo = totallongMomentListo / totalWeightListo;
    
    totalArmLatListo = totalLatMomentListo / totalWeightListo;
    
    
    listoItemNr = lineLDW;
    
    [self overwriteArrays]; // LDW line
    
    
    
    
    vLDW = totalWeightListo;
    
    vLDWArm = totalArmListo;
    
    vLDWMom = totallongMomentListo;
    
    vLDWArmLat = totalArmLatListo;
    
    vLDWMomLAt = totalLatMomentListo;
    
    
    
    // color labels   colorlabels new color
    NSString *colorCode = [_arrayName21 objectAtIndex: 47];
    
    // set seat marks
    
    for (int i = 4; i < lineZFW ; i++) {
        
        if ([[_arrayName10 objectAtIndex: i] isEqualToString:@"0"] || [[_arrayName10 objectAtIndex: i] isEqualToString:@""]  ) {
            continue;
        }
        
        // get weight for stations
        float wgt = [[_arrayName2 objectAtIndex:i] floatValue];
        
        // check if item is a show only - not yellow green or dark
        // this is when there is an ! in arrayName10
        if ([[_arrayName10 objectAtIndex: i  ] rangeOfString:@"!"].location != NSNotFound    ) {
            NSString *imageName =  [ [_arrayName10 objectAtIndex: i  ] stringByReplacingOccurrencesOfString:@"!" withString:@""];
            if ([[_arrayName8 objectAtIndex: i  ]isEqualToString:@"1"]) {
                NSString *itemName =  [ [NSString alloc] initWithFormat:@"%@.png", imageName  ];
                UIImageView *stationImage = (UIImageView*)[_viewInterior viewWithTag: 1500 + i];
                UIImage *newImage = [UIImage imageNamed: itemName ];
                [stationImage setImage:newImage ];
            }else{
                UIImageView *stationImage = (UIImageView*)[_viewInterior viewWithTag: 1500 + i];
                if ([[_arrayName10 objectAtIndex: i] length] > 1) {
                    UIImage *newImage = [UIImage imageNamed: @"empty.png" ];
                    [stationImage setImage:newImage ];
                }
            }
            
            
        }else{
            
            //select item name plus color dark, green, yelllow
            if (wgt > 0) {
                NSString *itemName =  [ [NSString alloc] initWithFormat:@"%@%@.png", [_arrayName10 objectAtIndex: i], colorCode ];
                UIImageView *stationImage = (UIImageView*)[_viewInterior viewWithTag: 1500 + i];
                if ([[_arrayName10 objectAtIndex: i] length] > 1) {
                    UIImage *newImage = [UIImage imageNamed: itemName ];
                    [stationImage setImage:newImage ];
                }
            }else{
                NSString *itemName ;
                
                if ([[_arrayName16 objectAtIndex: i  ]isEqualToString:@"standby"] & [[_arrayName8 objectAtIndex: i  ]isEqualToString:@"0"]) {
                    
                    itemName =  [ [NSString alloc] initWithFormat:@"%@.png", [_arrayName16 objectAtIndex: i] ];
                    
                }else{
                    
                    itemName =  [ [NSString alloc] initWithFormat:@"%@%@.png", [_arrayName10 objectAtIndex: i], @"Dark" ];
                }

                
                
                
                UIImageView *stationImage = (UIImageView*)[_viewInterior viewWithTag: 1500 + i];
                if ([[_arrayName10 objectAtIndex: i] length] > 1) {
                    UIImage *newImage = [UIImage imageNamed: itemName ];
                    [stationImage setImage:newImage ];
                }
                
                
                
            }
            
            
            
        }
    }// end for next    
    
    
    [self checkGuidance];
    /*
    if (_segmentFlightLegMode.selectedSegmentIndex == 0) {
        _labelFlightLegID.text =  [ [NSString alloc] initWithFormat:@"Flight: %@ / %u", vFlightID, allFlightsMasterArray.count -1 ];
        _labelFlightLegID2.text = [ [NSString alloc] initWithFormat:@"%@/%u", vFlightID, allFlightsMasterArray.count -1 ];        
        
    }else{
        _labelFlightLegID.text =  [ [NSString alloc] initWithFormat:@"Flight: %@ / Leg: %@ of %u", vFlightID, vLegID,  allLegsPerFlightArray.count-1 ];
        _labelFlightLegID2.text =  [ [NSString alloc] initWithFormat:@"Flight: %@ / Leg: %@ of %u", vFlightID, vLegID,  allLegsPerFlightArray.count-1 ];
        
    }
     */
    
    
    _labelFlightLegID.text =  [ [NSString alloc] initWithFormat:@"Flight: %@ / %u", vFlightID, allFlightsMasterArray.count -1 ];
    _labelFlightLegID2.text = [ [NSString alloc] initWithFormat:@"%@/%u - %@", vFlightID, allFlightsMasterArray.count -1, vFlightRegistration.text ];
    
    
    
    // crosses *************************************
    
    CGLongTOW = vTOWArm ;
    
    CGLongZFW =  lZFWArm ;
    
    CGLongLDW =  vLDWMom / vLDW  ;
    
    
    
    weightTOW = vTOW ;
    
    weightZFW = lZFW ;
    
    weightLDW = vLDW  ;
    
    
    CGLATTOW = vTOWArmLat ;
    
    CGLATZFW = lZFWArmLat  ;
    
    CGLATLDW =  vLDWMomLAt / vLDW   ;
    
  
   
    
    
    // animate crosses   and CG ball
    
    if (configMode == 0) {
      
        
        loopStartSpecific = [NSDate date];
        
        
        [self animateFuelPathAndCheckCG]; 
        
        [self animateFuelPathLateralAndCheckCG];
        
        loopFinishSpecific = [NSDate date];
        loopTimeSpecific = [loopFinishSpecific timeIntervalSinceDate:loopStartSpecific];
        //NSLog(@"loopTimeSpecific %.8f", loopTimeSpecific  );
        
        
       
        [self animateCrossTOW]; [self animateCrossTOWforMail];
        
        [self animateCrossZFW]; [self animateCrossZFWforMail];
        
        [self animateCrossLDW]; [self animateCrossLDWforMail];
        
        
        [self animateCrossLAT]; [self animateCrossLATforMail];
        
        [self animateCrossLATZFW]; [self animateCrossLATforMail_ZFW];
        
        [self animateCrossLATLDW]; [self animateCrossLATforMail_LDW];
        
        

        
    }
    

   _labelAvailableExternalLoad.hidden = YES;
    
    
    if (_arrayName23.count > 40) {
        if ([[_arrayName23 objectAtIndex:29] isEqualToString:@"yes"] ) {
            if ([[_arrayName2 objectAtIndex:lineHoistSystem] floatValue] > 0) {
                // hoist system is installed, so you can show the margin if calc max external is activated
                
                // check if Hoist OP is activated
                
                if ([[_arrayName2 objectAtIndex:lineHoistOP]floatValue] > 1) {
                    _labelAvailableExternalLoad.hidden = NO;
                }
                
                
                [self calcMaxEnternalLoad];
            }else{
                _labelAvailableExternalLoad.hidden = YES;
            }
        }
    }
    
    
    
    
    
    
    
    
    return;
    
    
    
}






-(void)WeightSliderAction:(id)sender{
    
    
     UISlider *slider = (UISlider*)sender;  
       float dummyFactor = [_inputSliderIncrement.text doubleValue] ; 
       
       if ((slider.maximumValue - dummyFactor) < slider.value  ) {
           dummyFactor = 1;
       }
       
       int dummy = slider.value/dummyFactor ;    
       slider.value = dummy * dummyFactor;
    
    //NSLog (@"slider.tag %@ ", [_arrayName1 objectAtIndex:slider.tag]);
       if ([ [_arrayName1 objectAtIndex:slider.tag] isEqualToString:@"MedEquipAP"]) {
           if (slider.value < 2) {
               slider.value = 2;
           }
       }
       
       //NSLog (@"_inputSliderIncrement.text %@ ", _inputSliderIncrement.text);
       weightValue = slider.value;  
    
    
    //NSLog (@"slider.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", slider.tag]);
    
   
    
    
    [self setSliderValues:weightValue tagValue:slider.tag];
    
    if (slider.value < 1) {
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ slider.tag];
        
        [valueField  setText: @"-"  ];
        
        [_arrayName7 replaceObjectAtIndex:slider.tag withObject:@"-"];

    }
    
    
    
    [self MainRoutine];
    
    
}

- (void) setSliderValues:  (float)sliderWeightValue  tagValue:(float)sliderTag {
    
    
    // update weight label 1000
    
    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + sliderTag];
    
    [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", sliderWeightValue]  ];
    
    

    
    totalWeightListo = sliderWeightValue;
    
    totalArmListo = [[_arrayName3 objectAtIndex:sliderTag] floatValue];
    
    totallongMomentListo = totalWeightListo * totalArmListo;
    
    totalArmLatListo = [[_arrayName5 objectAtIndex:sliderTag] floatValue];
    
    totalLatMomentListo  = totalWeightListo * totalArmLatListo;
    
    listoItemNr = sliderTag;
    
    [self overwriteArrays];
    
    
    return;
    
    
    
    
}




// enter weights ************************************************************************************************


-(void)actionTapOnStation :(id)sender{
    
    //NSLog(@"actionTapOnStation");
    
    guidanceDictionary[@"guidanceBtnCrew"] =  @"ok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"ok";
    
    UIButton *btn = (UIButton*)sender;
    buttonIDtransfer = btn.tag;
    
    //NSLog(@"buttonIDtransfer %d", buttonIDtransfer);
    //NSLog(@"actionTapOnStation buttonIDtransfer %d", buttonIDtransfer);
    //NSLog(@"_arrayName10 %@", [_arrayName10 objectAtIndex:buttonIDtransfer - 1600]);
    
    if (_viewPilotList.hidden == NO) {
        [self actionEnterViaCrewListWhileOpen: btn.tag];
        
    }else{
        
        if (_segmentSeatLoadOptions.selectedSegmentIndex == 0) {
            // quick load
            [self actionEnterViaQuickLoad: btn.tag];
        }
        
        if (_segmentSeatLoadOptions.selectedSegmentIndex == 1) {
            // crew list
            if ([[_arrayName10 objectAtIndex:buttonIDtransfer - 1600] isEqualToString:@"seat"]) {
                [self actionEnterViaCrewList];
            }else{
                //[self actionEnterViaCrewListDirectStationInput];
                selectedItem = 40;
                calculatorscreen.text = @"" ; EnterPadString = @"";
                enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
                
            }
        }
    }
    
     [self MainRoutine];
    
}


- (IBAction)actionClearSeat:(id)sender {
    
    if (flagEnterCrewListMode == 2) {
        
        flagEnterCrewListMode = 0;
        
        weightValue = 0;
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ buttonIDtransfer- 1600];
        
        [valueField  setText: @"-"  ];
        
        [_arrayName7 replaceObjectAtIndex:buttonIDtransfer- 1600 withObject:@"-"];
        
        
        [self updateSlider: buttonIDtransfer];
        
        _viewPilotList.hidden = YES;

        
    }
    
    
    
}

- (IBAction)actionEnterRideAlong:(id)sender {
    
    
    _inputSeatWeight.keyboardType = UIKeyboardTypeNumberPad;
    
    _inputSeatName.keyboardType = UIKeyboardTypeDefault;
    
    _inputSeatName.autocorrectionType = UITextAutocorrectionTypeNo;
    
    _inputSeatName.autocapitalizationType = UITextAutocapitalizationTypeWords;
    
    
    
    
    rideAlongSeat = buttonIDtransfer -300;
    
    
    //NSLog (@"buttonIDtransfer %@ ", [ [NSString alloc] initWithFormat:@"%d ", buttonIDtransfer]);
    
    
    _inputSeatName.text =@""; _inputSeatWeight.text =@"";
    
    _viewSeatOptions.hidden = NO;
    
    [_viewPilotList bringSubviewToFront:_viewSeatOptions];
    
    
}





-(void)actionEnterViaQuickLoad:(int)buttonTag{
    
    //NSLog(@"use quick load ");

    
    //NSLog(@"use quick load ");
    
    // use Quick Load:
    
    float fieldWeight = [[_arrayName2 objectAtIndex:buttonTag - 1600] floatValue];
    
    if ([ [_arrayName1 objectAtIndex:buttonTag - 1600] isEqualToString:@"MedEquipAP"]) {
        
        if (fieldWeight == 2) {
            fieldWeight = 0;
        }
        
    }
    
    if (fieldWeight >0) {
        
        weightValue = 0;
        
        if ([ [_arrayName1 objectAtIndex:buttonTag - 1600] isEqualToString:@"MedEquipAP"]) {
           weightValue = 2;
        }
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ buttonTag- 1600];
        
        [valueField  setText: @"-"  ];
        
        [_arrayName7 replaceObjectAtIndex:buttonTag- 1600 withObject:@"-"];
        
        
        
    }else{
        weightValue = [_inputQuickLoadPreset.text  doubleValue];
        
        
        if ([[_arrayName18 objectAtIndex: buttonTag-1600 ] rangeOfString:@"quick"].location != NSNotFound  ) {
                
                weightValue = [[_arrayName18 objectAtIndex: buttonTag -1600 ]  doubleValue] ;
                
                //NSLog(@"weight value %.0f", weightValue);
        }
        
        
            }

    
    [self updateSlider: buttonTag];
    
   
    
    
}


- (void) updateSlider: (int)buttonTag {
    
    
    buttonTag = buttonTag- 1600;
    
    totalWeightListo = weightValue;
    
    totalArmListo = [[_arrayName3 objectAtIndex:buttonTag] floatValue];
    
    totallongMomentListo = totalWeightListo * totalArmListo;
    
    totalArmLatListo = [[_arrayName5 objectAtIndex:buttonTag] floatValue];
    
    totalLatMomentListo  = totalWeightListo * totalArmLatListo;
    
    listoItemNr = buttonTag;
    
    [self overwriteArrays];
    
    
    // update weight label 1000
    
    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + buttonTag];
    
    [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", weightValue]  ];
    
    
    
    // update slider
    
    UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  buttonTag];
    
    slider.value = weightValue;
    
    [self MainRoutine];
    
    
    
    
    
}



-(void)actionEnterViaCrewListDirectStationInput {
    
    
    flagEnterCrewListMode = 2; // tap a station to open crew list and select just one item
    
    _inputSeatWeight.keyboardType = UIKeyboardTypeNumberPad;
    
    _inputSeatName.keyboardType = UIKeyboardTypeDefault;
    
    _inputSeatName.autocorrectionType = UITextAutocorrectionTypeNo;
    
    _inputSeatName.autocapitalizationType = UITextAutocapitalizationTypeWords;
    
    rideAlongSeat = buttonIDtransfer -300;
    
    //NSLog (@"btn.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", btn.tag]);
    
    _inputSeatName.text =@""; _inputSeatWeight.text =@"";
    
    _viewPilotList.hidden = NO;
    [viewOne bringSubviewToFront:_viewPilotList];   [viewOne bringSubviewToFront:viewTopTop];
    
    _viewSeatOptions.hidden = NO;
    
    [_viewPilotList bringSubviewToFront:_viewSeatOptions];
    
    [_inputSeatWeight becomeFirstResponder];

    
}

-(void)actionEnterViaCrewList {
    
     //NSLog(@"actionEnterViaCrewList");
    
    flagEnterCrewListMode = 2; // tap a station to open crew list and select just one item
    
     _viewPilotList.hidden = NO;
    [viewOne bringSubviewToFront:_viewPilotList];   [viewOne bringSubviewToFront:viewTopTop];

    
    
}

-(void)actionEnterViaCrewListWhileOpen: (int)buttonTag {
    
    //NSLog(@"actionEnterViaCrewListWhileOpen");
    
    flagEnterCrewListMode = 0; // tap a station to open crew list and select just one item
    
   
    weightValue = 0;
    
    
    if (_viewPilotList.hidden == NO & CrewDataLoaded == 1) {
        
        NSIndexPath *selectedPath = [self.tableView indexPathForSelectedRow];
        _labelPilotCheck.text = [self nameForRow:selectedPath.row AndSection:selectedPath.section];
        
        selectedPathTransfer = selectedPath;
        
        if ( selectedPath != nil){
            
            
            NSString *nameOnly = [self nameForRow:selectedPath.row AndSection:selectedPath.section];
            
            
            //NSLog(@"name from crew list %@", nameOnly);
            
            float s1 = [[self weightForRow:selectedPath.row AndSection:selectedPath.section] doubleValue];
            
            //NSLog (@"s1 %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", s1]);
            
            weightValue = s1;
            
            // set name in list and on slider
            
            [_arrayName7 replaceObjectAtIndex:buttonTag- 1600 withObject:nameOnly];
            
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ buttonTag- 1600];
            
            [valueField  setText: nameOnly ];
            
            //NSLog(@"name from crew list %d", btn.tag);
            
           

            
            
            
            
            
           
            
        }else{
            
            //NSLog(@"nil actionEnterViaCrewListWhileOpen");
            
            weightValue = 0;
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ buttonTag- 1600];
            
            [valueField  setText: @"-"  ];
            
            [_arrayName7 replaceObjectAtIndex:buttonTag- 1600 withObject:@"-"];

            _viewPilotList.hidden = YES;
            
        }
        
        
         [self updateSlider: buttonTag];
        
        
        
    }

    
    
    
}



- (void) loadSeatFromCrewList {
    
    flagEnterCrewListMode = 0;
    
    //NSLog(@"loadSeatFromCrewList buttonIDtransfer %d", buttonIDtransfer);
    
    NSIndexPath *selectedPath = [self.tableView indexPathForSelectedRow];
    _labelPilotCheck.text = [self nameForRow:selectedPath.row AndSection:selectedPath.section];

    
    
    if ( selectedPath != nil){
        
        NSString *nameOnly = [self nameForRow:selectedPath.row AndSection:selectedPath.section];
        
        
        //NSLog(@"name from crew list %@", nameOnly);
        
        float s1 = [[self weightForRow:selectedPath.row AndSection:selectedPath.section] doubleValue];
        
        //NSLog (@"s1 %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", s1]);
        
        weightValue = s1;
        
        
        // set name in list and on slider
        
        [_arrayName7 replaceObjectAtIndex:buttonIDtransfer- 1600 withObject:nameOnly];
        
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ buttonIDtransfer- 1600];
        
        [valueField  setText: nameOnly ];
        
        //NSLog(@"name from crew list %d", btn.tag);
        
        
        
     }
    
    _viewPilotList.hidden = YES;
    
    [self updateSlider: buttonIDtransfer];
  

}







-(void)buttonActionEnterRideAlong:(id)sender{
    
    //NSLog (@"buttonActionEnterRideAlong ");
    
    UIButton *btn = (UIButton*)sender;
    
    
    rideAlongSeat = [btn tag];

   _viewSeatOptions.hidden=NO;
    
    if (_viewPilotList.hidden == NO & CrewDataLoaded == 1) {
        
        NSIndexPath *selectedPath = [self.tableView indexPathForSelectedRow];
        _labelPilotCheck.text = [self nameForRow:selectedPath.row AndSection:selectedPath.section];
        selectedPathTransfer = selectedPath;
        
        if ( selectedPath != nil){
            
            NSString *nameOnly = [self nameForRow:selectedPath.row AndSection:selectedPath.section];
            //NSLog(@"name from crew list %@", nameOnly);
            float s1 = [[self weightForRow:selectedPath.row AndSection:selectedPath.section] doubleValue];
            //NSLog (@"s1 %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", s1]);
            weightValue = s1;
            // set name in list and on slider
            [_arrayName7 replaceObjectAtIndex:rideAlongSeat- 1300 withObject:nameOnly];
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ rideAlongSeat- 1300];
            [valueField  setText: nameOnly ];
            //NSLog(@"btn.tagt %d", btn.tag);
            
        }else{
            
            //NSLog(@"nil actionEnterViaCrewListWhileOpen");
            
            weightValue = 0;
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ rideAlongSeat- 1300];
            [valueField  setText: @"-"  ];
            [_arrayName7 replaceObjectAtIndex:rideAlongSeat- 1300 withObject:@"-"];
            _viewPilotList.hidden = YES;
        }
        [self updateSlider: rideAlongSeat-1300 + 1600];
        
    }else{
        
        
        //NSLog (@"2 buttonActionEnterRideAlong rideAlongSeat %.0f", rideAlongSeat);
        
        _inputSeatWeight.keyboardType = UIKeyboardTypeNumberPad;
        
        _inputSeatName.keyboardType = UIKeyboardTypeDefault;
        
        _inputSeatName.autocorrectionType = UITextAutocorrectionTypeNo;
        
        _inputSeatName.autocapitalizationType = UITextAutocapitalizationTypeWords;
        
        
      
        
        
        if (rideAlongSeat - 1300 == lineFreeLoad) {
            _viewFreeLoad.hidden = NO;
            
            _inputSeatArmLong.text = [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName3 objectAtIndex: lineFreeLoad] floatValue]  ];
            _inputSeatArmLat.text = [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName5 objectAtIndex: lineFreeLoad] floatValue]  ];
            
            
        }else{
            
            _viewFreeLoad.hidden = YES;
            
        }
        
        
        
        
        //NSLog (@"rideAlongSeat %.0f ", rideAlongSeat);
        
        //NSLog (@"lineFreeLoad %.0f ", lineFreeLoad);
        
       
        if (_viewPilotList.hidden == YES) {
            
            _viewPilotList.hidden = NO; [viewOne bringSubviewToFront:_viewPilotList]; [viewOne bringSubviewToFront:viewTopTop];
            
            _inputSeatName.text = [_arrayName7 objectAtIndex: rideAlongSeat - 1300];
            
            _inputSeatWeight.text = [_arrayName2 objectAtIndex: rideAlongSeat - 1300];
            
            [_viewPilotList bringSubviewToFront:_viewSeatOptions];
            
        }else{
            
            _viewPilotList.hidden = YES;
        }

      
        
        
        
        
    }
    
    
    
    
   
    
}


- (IBAction)buttonActionSaveSeatOptions:(id)sender {
    
    
    [self.view endEditing:TRUE];
    
    
    //NSLog(@"rideAlongSeat %.0f ", rideAlongSeat);
    
    
    
    [_arrayName7 replaceObjectAtIndex:rideAlongSeat - 1300 withObject:_inputSeatName.text];
    
    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ rideAlongSeat - 1300];
    [valueField  setText: _inputSeatName.text ];
    _viewPilotList.hidden = YES;
    
    
    
    [_arrayName2 replaceObjectAtIndex:rideAlongSeat - 1300 withObject:_inputSeatWeight.text]; // weight
     //NSLog(@"_inputSeatWeight.text %@", _inputSeatWeight.text );
    
    
    
    
    // update weight label 1000
    
    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + rideAlongSeat - 1300];
    [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [_inputSeatWeight.text floatValue]]  ];
    
    
    
    
    // update slider
    
    UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  rideAlongSeat - 1300];
    slider.value = [_inputSeatWeight.text floatValue];
    
    
    
    totalWeightListo = [_inputSeatWeight.text floatValue];
    totalArmListo = [[_arrayName3 objectAtIndex:rideAlongSeat - 1300] floatValue];
    totallongMomentListo = totalWeightListo * totalArmListo;
    totalArmLatListo = [[_arrayName5 objectAtIndex:rideAlongSeat - 1300] floatValue];
    totalLatMomentListo  = totalWeightListo * totalArmLatListo;
    listoItemNr = rideAlongSeat - 1300;
    
    [self overwriteArrays];
    
   if (btnHOLDidTransfer == lineFreeLoad) {
       
       //NSLog(@"overwrite free hold %.0f ", rideAlongSeat);
       [_arrayName3 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLong.text];
       [_arrayName5 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLat.text];
       
       [self createListoItemsSlidersAndInterior];
       
       actypeForConfig = AC_Type;
       defaultConfigName = arrayConfigurations[configuration];
       [self saveArrayListo];
       [self SaveValues];
       [self.view endEditing:TRUE];
   
       

       
   }

   
    _viewFreeLoad.hidden = YES;
    
    _viewStationOptions.hidden = YES;
    
    [self MainRoutine];
    
    
}





- (IBAction)buttonActionConfigurations:(id)sender {
    
    
    
    guidanceDictionary[@"guidanceBtnSetConfiguration"] =  @"ok";

    
    if (_viewConfigurations.hidden == YES) {
        
        _viewConfigurations.hidden = NO;   [viewMain bringSubviewToFront:_viewConfigurations];
        
    }else{
        
      _viewConfigurations.hidden = YES;
        
    }
    
    
    [self MainRoutine];
    
}

- (void) actionENTERpadListo { // after click on ENTER on enter Pad
    
    
    
    float enterTag = previousButton - 1300;
    
    
    if (selectedItem == 40) {
        enterTag =  buttonIDtransfer - 1600;
        
    }

    
    
     //NSLog (@"enterTag %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", enterTag]);
    
    
    weightValue =  [EnterPadString doubleValue] ;
    
    
    float maxWeightForStation = [[self.arrayName9 objectAtIndex: enterTag ] doubleValue];
    
    //NSLog (@"maxWeightForStation %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", maxWeightForStation  ]);
    
    
    if (weightValue > maxWeightForStation) {
        weightValue = maxWeightForStation;
    }
    
    
    
    
    totalWeightListo = weightValue;
    
    totalArmListo = [[_arrayName3 objectAtIndex:enterTag] floatValue];
    
    totallongMomentListo = totalWeightListo * totalArmListo;
    
    totalArmLatListo = [[_arrayName5 objectAtIndex:enterTag] floatValue];
    
    totalLatMomentListo  = totalWeightListo * totalArmLatListo;
    
    listoItemNr = enterTag;
    
    [self overwriteArrays];
    
    
    
    // update weight label 1000
    
    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + enterTag];
    
    [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", weightValue]  ];
    
    
    // update slider
    
    UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  enterTag ];
    
    slider.value = weightValue;
    
    
    if (weightValue < 1) {
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+ enterTag];
        
        [valueField  setText: @"-"  ];
        
        [_arrayName7 replaceObjectAtIndex:enterTag withObject:@"-"];

    }
    
    enterPad.hidden = YES;  [self setListoButtonsNeutral];
    
    [self MainRoutine];
    
}

- (IBAction)buttonActionEnterPadListo:(id)sender{
    
    
    UIButton *btn = (UIButton*)sender;
    
    //NSLog(@"btn  %d", btn.tag);
    
    
    [self setButtonMarksNeutral];
    
    
    
    
    if (flagButtonListoPressed == 0) {
        
        
       

        
        // button pressed first time
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonListoPressed = btn.tag ; previousButton = btn.tag;
        
        
        // get current value for enter pad screen
        
      
        
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: previousButton - 300];
        
        calculatorscreen.text = valueField.text ; EnterPadString = valueField.text; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
        
        
        
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern YelGlow.png"];
        
        [btn setImage:buttonmark forState:UIControlStateNormal];
        
        btn.alpha = 1.0;
        
        
    }else{
        
        
        
        if (btn.tag == previousButton) {
            
            
            
            // same button pressed
            
            enterPad.hidden = YES; flagButtonListoPressed = 0;
            
            [self setListoButtonsNeutral];
            
            

        }else{
            
            
            
            // other button pressed
            
            [self setListoButtonsNeutral];
            
            
            // get current value for enter pad screen
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: btn.tag - 300];
            
            calculatorscreen.text = valueField.text ; EnterPadString = valueField.text; EnterValueTwo = 0; commapressedTwo =0; minuspressedTwo = 0;
            
            
            
            
            enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonListoPressed = btn.tag ; previousButton = btn.tag;
            
            UIImage *buttonmark = [UIImage imageNamed:@"Klammern YelGlow.png"];
            
            [btn setImage:buttonmark forState:UIControlStateNormal];
            
             btn.alpha = 1.0;
            
            
        }
       
        
        
        
        
    }
    
    
   
    
    
    
     [self MainRoutine];
    
    

}

- (void) setListoButtonsNeutral {
    
    //[self setButtonMarksNeutral];


     enterPad.hidden = YES;
    
    for (int i = listStart; i < listEnd+1 ; i++) {
        
        
        
        UIButton *btnClear = (UIButton*)[_viewStationsSlider viewWithTag: 1300 + i];
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern.png"];
        
        [btnClear setImage:buttonmark forState:UIControlStateNormal];
        
        btnClear.alpha = 1.0;
        
        
        
    }
    
    return;
    
}

- (void) createItemListForLoadManifest {
    
    for(UIView *subview in [_viewManifestListo subviews]) {
        [subview removeFromSuperview];
    }
    
    float fontSize = 13;
    float yInc = 40;
    float bHeight = 30;
    xPos1 = 74;
    width1 = 130;
    width2 = 91;
    yPosTable = 0 - yInc;
    float yPix = 0;
    float lineDelta = 0;

    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    //                                                                 MAKE items for Manifest
    
    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    //NSLog(@"make items");
    
  
    float EquipmentACweight = 0;
    float EquipmentACarm = 0;
    float EquipmentACmom = 0;
    float EquipmentACarmLat = 0;
    float EquipmentACmomLat = 0;

    
    for (int i = listStart; i < listEnd+1 ; i++) {
        
        
        
    
        float itemNr = i;
        float lineWidth = 1;
        float itemInOut = 1;
        float sliderInOut = 1;
        float isFuelSlider = 0;
        float isSingleLine = 0;
        lineDelta = 0;
        

        
        if  ([[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Skis"] ||
             [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Hoist System"] ||
             [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Cargo Mirror"] ||
             [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Trakka"] ||
             [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Pads"] ||
             [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Seats"]
             
             
             ) {
            
            EquipmentACweight = EquipmentACweight + ([[_arrayName2 objectAtIndex: itemNr ] doubleValue] * [[_arrayName8 objectAtIndex: itemNr ] doubleValue]);
            
            EquipmentACmom =  EquipmentACmom + ([[_arrayName4 objectAtIndex: itemNr ] doubleValue] * [[_arrayName8 objectAtIndex: itemNr ] doubleValue]);
            
            EquipmentACmomLat =  EquipmentACmomLat + ([[_arrayName6 objectAtIndex: itemNr ] doubleValue] * [[_arrayName8 objectAtIndex: itemNr ] doubleValue]);
            
            
            //NSLog(@"EquipmentACweight %.1f ", EquipmentACweight);
            
            
            if  ([[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Equipment AC"] ){
                //NSLog(@"list EquipmentAC %.1f ", EquipmentACweight);
            }else{
                continue;
                
            }
            
            
        }
        
        
        if  ([[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Equipment AC"] ){
            
            [_arrayName2 replaceObjectAtIndex:itemNr withObject:[ [NSString alloc] initWithFormat:@"%.1f", EquipmentACweight  ]];
            
            
            [_arrayName3 replaceObjectAtIndex:itemNr withObject:[ [NSString alloc] initWithFormat:@"%.0f", EquipmentACmom / EquipmentACweight  ]];
            
            [_arrayName4 replaceObjectAtIndex:itemNr withObject:[ [NSString alloc] initWithFormat:@"%.0f", EquipmentACmom  ]];
            
            [_arrayName5 replaceObjectAtIndex:itemNr withObject:[ [NSString alloc] initWithFormat:@"%.0f", EquipmentACmomLat / EquipmentACweight   ]];
            
            [_arrayName6 replaceObjectAtIndex:itemNr withObject:[ [NSString alloc] initWithFormat:@"%.1f", EquipmentACmomLat  ]];
            
            
            //NSLog(@"list EquipmentACweight %.1f ", EquipmentACweight);
        }
        
        
        
        // check multiplicator
        if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
            sliderInOut = 0; itemInOut = 0;
        }
        if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
            sliderInOut = 1;
        }
        
       
        
        // check specials and seat names
        if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"single"].location != NSNotFound) {
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
                itemInOut = 0; sliderInOut = 0; ;
            }
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
                //lineDelta = - 12;  itemInOut = 1; sliderInOut = 0; isSingleLine = 1;
                isSingleLine = 1; lineDelta = - 12; 
            }
        }
        
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"picOnly"]) {
            //sliderInOut = 2;
            
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
                itemInOut = 0; sliderInOut = 0; ;
            }
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
                //lineDelta = - 12;  itemInOut = 1; sliderInOut = 0; isSingleLine = 1;
                isSingleLine = 1; lineDelta = - 12;
            }
            
        }

        
        
        
        if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"fuel"].location != NSNotFound) {
            isFuelSlider = 1; sliderInOut = 1; itemInOut = 1;
        }
        
        
        
        
        if  ( [[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"equip"] ) {
            //NSLog (@"equip %@ ", [ [NSString alloc] initWithFormat:@"%.0f  -  %.0f ", itemNr, [[self.arrayName8 objectAtIndex: itemNr ] doubleValue] ]);
            // check multiplicator
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
                itemInOut = 0; sliderInOut = 1;
            }
            
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
                //lineDelta = - 12;  itemInOut = 1; sliderInOut = 0; isSingleLine = 1;
                lineDelta = -12;   sliderInOut = 0; isSingleLine = 1;
            }
            
        }
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"noSlider"]) {
            lineDelta = - 12;   sliderInOut = 0; isSingleLine = 1;
           
        }

        
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"result"]) {
            //NSLog(@"this is a result line ");
            lineDelta = - 12;
            isSingleLine = 1;
            itemInOut = 1; sliderInOut = 0;
            lineWidth = 3;
        }
        
        if  ([[self.arrayName14 objectAtIndex: itemNr +1 ]  isEqualToString:@"result"]) {
            //NSLog(@"this is a result line ");
            lineDelta = - 12;
            isSingleLine = 1;
            itemInOut = 1; sliderInOut = 0;
            lineWidth = 3;
        }
        
        
        if  ( [[_arrayName1 objectAtIndex: itemNr +1 ]  isEqualToString:@"Med Equipment"] ){
            // if THIS item is result, then make thick line
            
            lineWidth = 1;
        }

        
        
        if  ( [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Med Equipment"] ){
            // if THIS item is result, then make thick line
          
            lineWidth = 1;
        }
       
        
        
        if  ( [[_arrayName1 objectAtIndex: itemNr  ]  isEqualToString:@"Equipment AC"]){
            // if NEXT item is result, then make thick line.
           lineWidth = 1;
        }
        
        
        
        
        if (itemInOut == 0) {
            continue;
        }
        
        
        yPix = yPix + yInc;
        // make lines on load manifest
        // draw from 66 - 672 = 606
        
        if (itemNr == 2 || itemNr == 3 ) {
            lineWidth = 3;
        }
        if (itemNr == 1  ) {
            lineWidth = 0; lineDelta = - 22;
        }
        
        UIImageView *line =[[UIImageView alloc] initWithFrame:CGRectMake(66, (yPosTable + yPix + yInc + lineDelta   ), 606, lineWidth) ];
        line.backgroundColor = [UIColor blackColor];
        line.alpha = 0.6;
        
        if (itemInOut == 1) {
            [_viewManifestListo addSubview: line];
        }
        
        
        if (itemNr == lineZFW) {
            lineWidth = 4;
            UIImageView *line =[[UIImageView alloc] initWithFrame:CGRectMake(66, (yPosTable + yPix + yInc - 42   ), 606, lineWidth) ];
            line.backgroundColor = [UIColor blackColor];
            line.alpha = 0.6;
            [_viewManifestListo addSubview: line];
        }
        
        // make all buttons on load manifest (and on view OPTIONS)
        
        // station name
        UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1, (yPosTable + yPix ), width1, bHeight)];
        label.font = [UIFont boldSystemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentLeft;
        [label  setText: [self.arrayName1 objectAtIndex: itemNr ]  ];
        if (itemNr == 1 || itemNr == 2 ) {             [label  setText: [self.arrayName1 objectAtIndex: itemNr ]  ];    }
        
        [_viewManifestListo addSubview: label];
     
        
        // weight
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + width1, (yPosTable + yPix ), width2, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentRight;
        NSString *valueText =  [ [NSString alloc] initWithFormat:@"%.1f", [[self.arrayName2 objectAtIndex: itemNr ] doubleValue]  ];
        [label  setText: valueText ];
        if (itemNr == 1 || itemNr == 2 ) {             [label  setText: [self.arrayName2 objectAtIndex: itemNr ]  ];     }
        [_viewManifestListo addSubview: label];
        
        
        NSString *numberFormat;
        if ([[_arrayName21 objectAtIndex:5] isEqualToString:@"kg"]) {
            numberFormat = @"%.0f";
            [decimalFormatter setFormatWidth:2];
            [decimalFormatter setGroupingSeparator:@","];
            [decimalFormatter setGroupingSize:3];
            [decimalFormatter setUsesGroupingSeparator:YES];
            decimalFormatter.maximumFractionDigits = 0;
            decimalFormatter.minimumFractionDigits = 0;
        }else{
            numberFormat = @"%.1f";
        }
        
        // arm long
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + width1 + 1 * width2, (yPosTable + yPix ), width2, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentRight;
        valueText =  [ [NSString alloc] initWithFormat:numberFormat, [[self.arrayName3 objectAtIndex: itemNr ] doubleValue]  ];
        [label  setText: valueText ];
        if (itemNr == 1|| itemNr == 2 ) {             [label  setText: [self.arrayName3 objectAtIndex: itemNr ]  ];       }
        [_viewManifestListo addSubview: label];
        
        // moment long
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + width1 + 2 * width2, (yPosTable + yPix  ), width2, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentRight;
        //valueText =  [ [NSString alloc] initWithFormat:numberFormat, [[self.arrayName4 objectAtIndex: itemNr ] doubleValue]  ];
        
        valueText = [NSString stringWithFormat:@"%@", [decimalFormatter stringFromNumber:[NSNumber numberWithDouble: [[self.arrayName4 objectAtIndex: itemNr ] doubleValue] ]]];
        if ([[self.arrayName4 objectAtIndex: itemNr ] doubleValue] == 0) {
            valueText = @"0";
        }
        [label  setText: valueText ];
         if (itemNr == 1|| itemNr == 2 ) {             [label  setText: [self.arrayName4 objectAtIndex: itemNr ]  ];       }
        [_viewManifestListo addSubview: label];
        
        
        // arm LAT
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + width1 + 3 * width2, (yPosTable + yPix ), width2, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentRight;
        valueText =  [ [NSString alloc] initWithFormat:numberFormat, [[self.arrayName5 objectAtIndex: itemNr ] doubleValue]  ];
        [label  setText: valueText ];
        if (itemNr == 1|| itemNr == 2 ) {             [label  setText: [self.arrayName5 objectAtIndex: itemNr ]  ];       }
        [_viewManifestListo addSubview: label];
        
        // moment LAT
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + width1 + 4 * width2, (yPosTable + yPix ), width2, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentRight;
        valueText =  [ [NSString alloc] initWithFormat:numberFormat, [[self.arrayName6 objectAtIndex: itemNr ] doubleValue]  ];
        [label  setText: valueText ];
        if (itemNr == 1|| itemNr == 2 ) {             [label  setText: [self.arrayName6 objectAtIndex: itemNr ]  ];    }
        [_viewManifestListo addSubview: label];
        
        
        // remarks = occupant name
        label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 , (yPosTable + yPix + 16 ), width1, bHeight)];
        label.font = [UIFont systemFontOfSize:fontSize];
        label.textAlignment = NSTextAlignmentLeft;
        if (isSingleLine == 1) {
            label.hidden = YES;
        }else{
            label.textColor = [UIColor blackColor];
        }
        [label  setText: [self.arrayName7 objectAtIndex: itemNr ]  ];
        [_viewManifestListo addSubview: label];
        
        
        
        yPix = yPix + lineDelta;
        if (itemInOut == 0) {
            yPix = yPix - yInc;
        }
        
        
        float topY = 2; // top line of manifest
        
        float yBottom = yPix - topY;
        
        if (i == listEnd) {
            
            
            UIImageView * vline =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + width1 , topY, 1.0,  yBottom  ) ];
            vline.backgroundColor = [UIColor blackColor];
            vline.alpha = 0.6;
            [_viewManifestListo addSubview: vline];
            
            
            vline =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + width1 + 1 * width2 + 10 , topY, 1.0,  yBottom  ) ];
            vline.backgroundColor = [UIColor blackColor];
            vline.alpha = 0.6;
            [_viewManifestListo addSubview: vline];
            
            vline =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + width1 + 2 * width2 + 10 , topY, 1.0,  yBottom  ) ];
            vline.backgroundColor = [UIColor blackColor];
            vline.alpha = 0.6;
            [_viewManifestListo addSubview: vline];
            
            
            vline =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + width1 + 3 * width2 + 10 , topY, 1.0,  yBottom  ) ];
            vline.backgroundColor = [UIColor blackColor];
            vline.alpha = 0.6;
            [_viewManifestListo addSubview: vline];
            
            vline =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + width1 + 4 * width2 + 10 , topY, 1.0,  yBottom  ) ];
            vline.backgroundColor = [UIColor blackColor];
            vline.alpha = 0.6;
            [_viewManifestListo addSubview: vline];
            
            
            _EASAtextLoadManifest.frame = CGRectMake(80, yPix + 210, 570, 104);
            
            
        }
    }// end make al to list End
    

    
    return;
    
    
} // buttons sliders and interior


- (void) setSliders {
    
    
    for (int i = 0; i < lineZFW ; i++) {
      
        
        // check if station is on
        if ([[_arrayName8 objectAtIndex:i] isEqualToString:@"1"]) {
            
            // check if station is a slider
            
            if ([[_arrayName14 objectAtIndex:i] isEqualToString:@"-"]) {
                
             //NSLog(@"slider is i %d ", i);
                
                
                UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  i];
                slider.value = [[_arrayName2 objectAtIndex:i] floatValue];
                
                valueField = (UITextField*)[_viewStationsSlider viewWithTag: i + 1000];
                [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName2 objectAtIndex:i]  floatValue]]  ];
                
            }
            
            
            
            
        }
        
        
       
        
    }
    
    
}


- (void) createListoItemsSlidersAndInterior {
    
    //NSLog(@"createListoItemsSlidersAndInterior *************************************");
    
    [self findLines];
    
    [self setCGenvelope];
    
    for(UIView *subview in [_viewStationsSlider subviews]) {
        [subview removeFromSuperview];
    }
    for(UIView *subview in [_viewInterior subviews]) {
        [subview removeFromSuperview];
    }
    for(UIView *subview in [_viewOptions subviews]) {
        [subview removeFromSuperview];
    }
    
    [self createSegments];
    
    ghostImage =[[UIImageView alloc] initWithFrame:CGRectMake(0, 0, 90 , 90) ];
    ghostImage.image=[UIImage imageNamed:@"swapStation.png"];
    [self.viewInterior addSubview:ghostImage];
    ghostImage.hidden = YES;
    
    float yInc = 40;
    xPos1 = 74;
    width1 = 130;
    width2 = 91;
    yPosTable = 0 - yInc;
    float yPix = 0;  float yPixSlider = 0;
    float lineDeltaSlider = 0;
    
    
    // slider settings   **************************************************************************************************************
    
    float sliderWindowWidth = 200;
    float stationYincrement = 70;  // pixel vertical gap
    float gapLeft = 5;
    float gapRight= 40;
    float sliderYposition = 135 - stationYincrement;  // top of all sliders
    float sliderLR = 0;
    float countLeft = 0;
    float countRight = 0;
    
    
    // AC topview
    
    // check AC type and set measures
    ACtop = [UIImage imageNamed:  [NSString stringWithFormat:@"%@_topViewOK.png", AC_Type] ];
    ACtop_Warning = [UIImage imageNamed:  [NSString stringWithFormat:@"%@_topViewRED.png", AC_Type] ];
    
    if (_switchAdjustACTopView.on == YES) {
        if ([_iacACType.text isEqualToString:@""]) {
            _iacACType.text = AC_Type;
        }
        _iacACType.text = AC_Type;
        ACtop = [UIImage imageNamed:  [NSString stringWithFormat:@"%@_topViewOK.png", _iacACType.text] ];
        ACtop_Warning = [UIImage imageNamed:  [NSString stringWithFormat:@"%@_topViewRED.png", _iacACType.text] ];
    }
    
    [_ACtopView setImage:ACtop ];
    
    
    // other preparations
    
    // scale of interor view
    _viewMeasureRearSeats.hidden = YES;
    _viewMeasureLatRight.hidden = YES;
    _viewMeasureCenter.hidden = YES;
    _viewMeasureFrontSeats.hidden = YES;
    _viewSeatSize.hidden = YES;
    
    for(int i=0; i<_labelCollectionWeightUnits.count; i++) {
        UITextField* field = [_labelCollectionWeightUnits objectAtIndex: i  ];
        [field  setText: [_arrayName21 objectAtIndex:5  ]]; // weight units
    }
    
    for(int i=0; i<_labelCollectionCGunits.count; i++) {
        if ([[_arrayName21 objectAtIndex: 5  ] isEqualToString:@"lbs"]) {
            UITextField* field = [_labelCollectionCGunits objectAtIndex: i  ];
            [field  setText: @"In"];
        }else{
            UITextField* field = [_labelCollectionCGunits objectAtIndex: i  ];
            [field  setText: @"mm"];
        }
    }

    
    
    
    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    //                                                                 MAKE items for Heli Top View
    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    
    
    
    for (int i = listStart; i < listEnd+1 ; i++) {
        //NSLog(@"i   listEnd  %d  %.0f", i,  listEnd);
        
        float itemNr = i;
        float sliderInOut = 1;
        int flagMakeSeatLabels = 1;  // if HOIST or EQUIP then make no seat labels and no quick load
        lineDeltaSlider = 0;
        
        // check multiplicator
        if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
            sliderInOut = 0;
        }
        
        // make standby symbol
        if ([[self.arrayName16 objectAtIndex: itemNr ] isEqualToString:@"standby"]) {
            sliderInOut = 3;
        }
        
        if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
            sliderInOut = 1;
        }
        
        // check specials and seat names
        if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"NoLabel"].location != NSNotFound) {
            flagMakeSeatLabels = 0;
        }
        if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"single"].location != NSNotFound) {
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
                sliderInOut = 0;
            }
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
                 lineDeltaSlider = - 0;
            }
        }
        
        
        if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"fuel"].location != NSNotFound) {
            sliderInOut = 1;
        }
        
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"equip"]) {
            // check multiplicator
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] < 1) {
                 sliderInOut = 2; ;
            }
            if ([[self.arrayName8 objectAtIndex: itemNr ] doubleValue] == 1) {
                //lineDelta = - 12;  itemInOut = 1; sliderInOut = 0; isSingleLine = 1;
                sliderInOut = 2;
            }
        }
        
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"noSlider"]) {
             sliderInOut = 0;
        }
        
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"picOnly"]) {
            sliderInOut = 2;
        }
        
        
        // if NEXT item is result, then make thick line
        if  ([[self.arrayName14 objectAtIndex: itemNr  ]  isEqualToString:@"result"]) {
            //NSLog(@"this is a result line ");
             sliderInOut = 0;
        }
        
        
        
        yPix = yPix + yInc;
        
        
        
        
        
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        
        //                                                                 MAKE SLIDERS
        
        
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        // ****************************************************************************************************************************************************
        
        
        //NSLog(@"sliderInOut %.0f", sliderInOut);
        
        
        
        if (sliderInOut >= 1 ) {
            
            
        
            
            if (sliderInOut == 1) {
                
                
                //NSLog (@"making slider i %@ ", [ [NSString alloc] initWithFormat:@"%d ", i]);
                float tagNr = i ;
                
                yPixSlider = yPixSlider + stationYincrement;
                
                // get Lat Postiion for station
                float itemLatPos = [[_arrayName5 objectAtIndex:i] floatValue];
                
                // check if item contains LH or RH to position the slider right or left
                if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"LH"].location != NSNotFound){
                    //NSLog (@"found LH %.0f", itemNr);
                    itemLatPos = -1;
                }
                
                if ([[self.arrayName14 objectAtIndex: itemNr  ] rangeOfString:@"RH"].location != NSNotFound){
                    //NSLog (@"found RH %.0f", itemNr);
                    itemLatPos = 1;
                }
                
                if (itemLatPos < 0.0 || [ [self.arrayName16 objectAtIndex: tagNr  ]  isEqualToString:@"L"]) {
                    // left
                    sliderLR = 0;
                    yPixSlider = countLeft * stationYincrement;
                    countLeft = countLeft +1;
                }else{
                    if (itemLatPos >= 0.0 || [ [self.arrayName16 objectAtIndex: tagNr  ]  isEqualToString:@"R"]) {
                        // right
                        sliderLR = 450;
                        yPixSlider = countRight * stationYincrement;
                        countRight = countRight + 1;
                    }
                }

                
                
                // |||||||||||||| make sliders  in yellow with slider scale
                
                CGRect sliderFrame = CGRectMake(sliderLR+gapLeft, sliderYposition + yPixSlider, (sliderWindowWidth -  gapLeft - gapRight +35) , 10.0);
                UISlider *slider = [[UISlider alloc] initWithFrame:sliderFrame];
                [slider addTarget:self action:@selector(WeightSliderAction:) forControlEvents:UIControlEventValueChanged];
                [slider setBackgroundColor:[UIColor clearColor]];
                slider.minimumValue = 0.0;
                
                // get max weight for slider
                
                slider.maximumValue = [[self.arrayName9 objectAtIndex: itemNr ] doubleValue];
                slider.continuous = YES;
                
                
                UIImageView *sliderScale =[[UIImageView alloc] initWithFrame:CGRectMake(sliderLR+gapLeft+5, sliderYposition + yPixSlider - 13, (sliderWindowWidth -  gapLeft - gapRight) -10 +35 , 12.0) ];
                sliderScale.image=[UIImage imageNamed:@"sliderScale_wide20forPA-01.png"]; // sliderScale120-01.png  // sliderScale_wide20forPA-01.png
                sliderScale.alpha = 0.6;
                [self.viewStationsSlider addSubview:sliderScale];
                
                
                UIImage *sliderImage = [UIImage imageNamed:@"sliderEmpty.png"];
                UIImage *sliderThumb = [UIImage imageNamed:@"triangle3.png"];
                UIImage *sliderImageEmpty = [UIImage imageNamed:@"sliderYellowLine thin.png"];
                
                [slider setMaximumTrackImage:sliderImage forState:UIControlStateNormal];
                [slider setMinimumTrackImage:sliderImageEmpty forState:UIControlStateNormal];
                [slider setThumbImage:sliderThumb forState:UIControlStateNormal];
                
                
                
                // set slider to weight
                slider.value = [[_arrayName2 objectAtIndex:tagNr] floatValue];
                slider.tag = tagNr;
                //NSLog(@"adding slider tag %d ", slider.tag );
                [self.viewStationsSlider addSubview:slider];
                
                
                
                
                // |||||||||||||| make slider weightLabels
                UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(sliderLR+gapLeft+18, sliderYposition + yPixSlider - 46, (sliderWindowWidth -  gapLeft - gapRight - 23), 15.0)];
                label.font = [UIFont boldSystemFontOfSize:17.0];
                label.textColor = [UIColor whiteColor];
                label.textAlignment = NSTextAlignmentRight;
                label.text = [ [NSString alloc] initWithFormat:@"%.0f", slider.value   ];
                label.tag = tagNr + 1000;
                [self.viewStationsSlider addSubview:label];
                
                
                
                // |||||||||||||| make station names
                //NSLog(@"lineDeltaSlider %.0f ", lineDeltaSlider);
                label= [[UILabel alloc] initWithFrame:CGRectMake(sliderLR+gapLeft + 10, sliderYposition + yPixSlider - 47 - lineDeltaSlider, (sliderWindowWidth -  gapLeft - gapRight), 17.0)];
                label.font = [UIFont boldSystemFontOfSize:15.0];
                //label.textColor =[UIColor colorWithRed:140.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
                label.textColor = [UIColor whiteColor];
                label.alpha = 0.9;
                // get name for station
                label.text = [_arrayName1 objectAtIndex:tagNr];
                label.tag = tagNr + 1100;
                [self.viewStationsSlider addSubview:label];
                
                
                
                // |||||||||||||| make occupant names
                label= [[UILabel alloc] initWithFrame:CGRectMake(sliderLR+gapLeft + 10, sliderYposition + yPixSlider - 29 , (sliderWindowWidth -  gapLeft - gapRight), 17.0) ];
                label.font = [UIFont systemFontOfSize:15.0];
                label.textColor =[UIColor colorWithRed:140.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
                //label.textColor = [UIColor whiteColor];
                label.alpha = 1.0;
                if (lineDeltaSlider < 0) {
                    label.hidden = YES;
                }else{
                    label.hidden = NO;
                    
                }
                
                // get name for station ( 0is station name, 700 is remarks or Name of occupant)
                label.text = [_arrayName7 objectAtIndex:tagNr];
                label.tag = tagNr + 1200;
                [self.viewStationsSlider addSubview:label];
                
                
                // |||||||||||||| make enter pad buttons
                UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
                btn.frame = CGRectMake(sliderLR+sliderWindowWidth - gapRight - 45, sliderYposition + yPixSlider - 49 , 50, 20); // pos x, pos y, width x, width y
                [btn addTarget:self  action:@selector(buttonActionEnterPadListo:)  forControlEvents:UIControlEventTouchUpInside];
                btn.tag = tagNr + 1300;
                btn.backgroundColor = [UIColor clearColor];
                btn.alpha = 1.0;
                UIImage *buttonKlammern = [UIImage imageNamed:@"Klammern.png"];
                [btn  setBackgroundImage:buttonKlammern forState:UIControlStateNormal];
                
                [self.viewStationsSlider addSubview:btn];
                
                
                // |||||||||||||| make ride along button
                btn = [UIButton buttonWithType:UIButtonTypeCustom];
                btn.frame = CGRectMake(sliderLR+gapLeft + 10, sliderYposition + yPixSlider - 50 , 90, 42) ;
                [btn addTarget:self  action:@selector(buttonActionEnterRideAlong:)  forControlEvents:UIControlEventTouchUpInside];
                btn.tag = tagNr + 1300;
                btn.backgroundColor = [UIColor clearColor];
                [self.viewStationsSlider addSubview:btn];
                
                // |||||||||||||| make unit labels
                label= [[UILabel alloc] initWithFrame:CGRectMake(sliderLR+sliderWindowWidth - gapRight +9, sliderYposition + yPixSlider - 53 , 35, 27) ];
                label.font = [UIFont systemFontOfSize:15.0];
                label.textColor =[UIColor colorWithRed:140.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
                //label.textColor = [UIColor whiteColor];
                label.alpha = 1.0;
                label.textAlignment = NSTextAlignmentLeft;
                label.text = [_arrayName21 objectAtIndex: 5  ];
                label.tag = tagNr + 1400;
                [self.viewStationsSlider addSubview:label];
                unitsWeight.text = [_arrayName21 objectAtIndex: 5  ];
            }
            
            
            
            
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            
            //                                                                 MAKE INTERIOR  (seats tag = 1500,   quick load tag = 1600
            
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            // ****************************************************************************************************************************************************
            
            
 
            
            if (i >= linePilot  & i <= lineZFW-1 ) {
                
                // get Long Postiion for station
                float itemLong = [[_arrayName3 objectAtIndex:i] floatValue];
                // get Lat Postiion for station
                float itemLat = [[_arrayName5 objectAtIndex:i] floatValue];
                
                float LongScale = (_viewMeasureRearSeats.center.y - _viewMeasureFrontSeats.center.y) / (LongArmRearSeat - LongArmFrontSeat) ;
                float LatPixLeftSeat    = _viewMeasureCenter.center.x;
                float LatPixRightSeat  = _viewMeasureLatRight.center.x;
                float LatScale = (LatPixRightSeat - LatPixLeftSeat) / (LatArmRightSeat - LatArmLeftSeat) ;
                
                
                //NSLog (@"LatArmRightSeat %f@ ", LatArmRightSeat);
                float itemWidth = _viewSeatSize.layer.frame.size.width;
                float itemHeight = _viewSeatSize.layer.frame.size.height;
                
                float LongPixPosition = 0;
                float LatPixPosition = 0;
                //NSLog (@"itemLong  %@ ", [ [NSString alloc] initWithFormat:@"%.1f ", itemLong ]);
                //NSLog (@"LongPixPosition  %@ ", [ [NSString alloc] initWithFormat:@"%.1f ", LongPixPosition ]);
                
                
                float yOffset = [[self.arrayName11 objectAtIndex: i  ] doubleValue];
                float latOffset = [[self.arrayName13 objectAtIndex: i  ] doubleValue];
                
                UIImageView *interiorItem =[[UIImageView alloc] initWithFrame:CGRectMake(LatPixPosition + latOffset, LongPixPosition + yOffset, itemWidth , itemHeight ) ];                
                //NSLog(@"[self.arrayName10 objectAtIndex: i  ]  %@", [self.arrayName10 objectAtIndex: i  ]);
                //NSLog(@"station  %@", [_arrayName1 objectAtIndex: i  ]);
                
                
                if ([[_arrayName10 objectAtIndex: i  ]  isEqualToString:@"0"] || [[self.arrayName10 objectAtIndex: i  ]  isEqualToString:@""] ) {                    
                    interiorItem.image=[UIImage imageNamed: @"empty.png" ];
                    itemWidth = 0;
                    itemHeight = 0;
                    
                }
                
                if ([[_arrayName10 objectAtIndex: i  ] rangeOfString:@"!"].location != NSNotFound    ) {
                    interiorItem.image=[UIImage imageNamed: @"empty.png" ];
                    //NSLog(@"!!!!!!!!!!  got it symbol%@", [_arrayName10 objectAtIndex: i  ]);
                }
                
                
                int isIndividualSize = 0;
                // set special size (if entered in Excel)
                if ( ![[self.arrayName19 objectAtIndex: i  ]  isEqualToString:@""]      ) {
                    itemWidth =  [[self.arrayName19 objectAtIndex: i  ]floatValue];
                    itemHeight = [[self.arrayName20 objectAtIndex: i  ]floatValue];
                    interiorItem.frame = CGRectMake(LatPixPosition + latOffset, LongPixPosition + yOffset, itemWidth , itemHeight );
                    isIndividualSize = 1;
                }
                
                LongPixPosition =  (( (LongScale * (itemLong - LongArmFrontSeat)) + _viewMeasureFrontSeats.center.y  )  - (itemHeight/2))   ;
                LatPixPosition =   ( (LatScale *  (itemLat -  LatArmLeftSeat))   + LatPixLeftSeat      )  - (itemWidth/2);
                interiorItem.frame = CGRectMake(LatPixPosition + latOffset, LongPixPosition + yOffset, itemWidth , itemHeight );
                
                
                interiorItem.alpha = 1.0;
                interiorItem.tag = i + 1500;
                
                float rotationAngle = [[_arrayName15 objectAtIndex: i] floatValue];
                if (rotationAngle != 0) {
                    float angleRadiants =  rotationAngle * 0.01745;
                    interiorItem.transform =CGAffineTransformMakeRotation(angleRadiants);                    
                }
                
                [self.viewInterior addSubview:interiorItem];
                
                if (sliderInOut == 1 & flagMakeSeatLabels == 1 ) {
                    
                    int seatIsForward = 0;
                    if (rotationAngle < -95) {
                        seatIsForward = 0;
                    }else if (rotationAngle > 95)  {
                        seatIsForward = 0;
                    }else{
                        seatIsForward = 1;
                    }
                    
                    float yOffsetLabel1 = 0;
                    float yOffsetLabel2= 0;
                    if (seatIsForward == 1) {
                        yOffsetLabel1 = -15;
                        yOffsetLabel2 = 2;
                    }else{
                        // rearward seat
                        yOffsetLabel1 = -7;
                        yOffsetLabel2 = 9;
                    }
                    
                    
                    // ||||||||||||||   make seat labels
                    
                    if (_segmentNamesOnSeats.selectedSegmentIndex == 0 ) {
                        //old style
                        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(LatPixPosition + latOffset, LongPixPosition + yOffset, itemWidth , itemHeight ) ];
                        label.font = [UIFont systemFontOfSize:14.0];
                        //label.textColor =[UIColor colorWithRed:160.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
                        label.textColor = [UIColor blackColor];
                        label.textAlignment = NSTextAlignmentCenter;
                        label.text = [self.arrayName12 objectAtIndex: i  ];
                        label.tag = i ;
                        [self.viewInterior addSubview:label];
                    }
                    
                    if (_segmentNamesOnSeats.selectedSegmentIndex == 1 || _segmentNamesOnSeats.selectedSegmentIndex == 2) {
                        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(LatPixPosition + latOffset, LongPixPosition + yOffset + yOffsetLabel1, itemWidth , itemHeight ) ];
                        if (isIndividualSize == 1) {
                            label.frame = CGRectMake(interiorItem.frame.origin.x, interiorItem.frame.origin.y + (interiorItem.frame.size.height/2) - 18, interiorItem.frame.size.width, 25);
                        }
                        label.font = [UIFont systemFontOfSize:14.0];
                        label.textColor = [UIColor blackColor];
                        label.textAlignment = NSTextAlignmentCenter;
                        label.text = [NSString stringWithFormat:@"%.0f", [[_arrayName2 objectAtIndex: i  ] floatValue]];
                        label.tag = i + 200 ;
                        [self.viewInterior addSubview:label];
                        label= [[UILabel alloc] initWithFrame:CGRectMake(LatPixPosition + latOffset + 2, LongPixPosition + yOffset + yOffsetLabel2, itemWidth - 4 , itemHeight ) ];
                        if (isIndividualSize == 1) {
                            label.frame = CGRectMake(interiorItem.frame.origin.x, interiorItem.frame.origin.y + (interiorItem.frame.size.height/2) -5, interiorItem.frame.size.width, 25);
                        }
                        
                        label.font = [UIFont systemFontOfSize:9.5];
                        //label.textColor =[UIColor colorWithRed:160.0f/255.0f green:186.0f/255.0f blue:253.0f/255.0f alpha:1.0f]; // light blue
                        label.numberOfLines = 2;
                        label.textColor = [UIColor blackColor];
                        label.textAlignment = NSTextAlignmentCenter;
                        label.tag = i + 700 ;
                        [self.viewInterior addSubview:label];
                    }
                    
                    //NSLog(@"make quick load buttons  %d  %@", i, [_arrayName1 objectAtIndex:i]);
                    
                    // |||||||||||||| make quick load buttons
                    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
                    btn.frame = CGRectMake(LatPixPosition + latOffset , LongPixPosition + yOffset, itemWidth , itemHeight ) ;
                    [btn addTarget:self  action:@selector(actionTapOnStation:)  forControlEvents:UIControlEventTouchUpInside];
                    [btn addTarget:self  action:@selector(actionTapOnStationHOLD:)  forControlEvents:UIControlEventTouchDown];
          
                    
                    btn.tag = i + 1600;
                    btn.backgroundColor = [UIColor clearColor];
                    [self.viewInterior addSubview:btn];
                    
                    UILongPressGestureRecognizer *recognizerTapAndHold = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(actionTapAndHold:)];
                    [btn addGestureRecognizer:recognizerTapAndHold];
                    
                    
                    
                    
                } // end if slider IN - this adds names and seat labels
                
                
                if (sliderInOut == 3  ) {
                    
                    //  make quick load buttons for STANDBY (open pilot list)
                    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
                    btn.frame = CGRectMake(LatPixPosition + latOffset , LongPixPosition + yOffset, itemWidth , itemHeight ) ;
                    [btn addTarget:self  action:@selector(actionTapOnStationStandby:)  forControlEvents:UIControlEventTouchUpInside];
                    [btn addTarget:self  action:@selector(actionTapOnStationHOLD:)  forControlEvents:UIControlEventTouchDown];
                    
                    btn.tag = i + 1600;
                    btn.backgroundColor = [UIColor clearColor];
                    [self.viewInterior addSubview:btn];
                    
                    UILongPressGestureRecognizer *recognizerTapAndHold = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(actionTapAndHold:)];
                    [btn addGestureRecognizer:recognizerTapAndHold];
                    
                }
                
                
                
                
            } // for next end make interior
            
            
        }// ende make a slider
        
        
        
        
      
        
    }// end make al to list End
    
    
    previousConfiguration = configuration;
    [self searchbutSelHeli];
    
    return;
    
    
} // buttons sliders and interior








- (void) createSegments {
    
    //NSLog(@"createSegments ");
    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    //                                                                 MAKE Options  make segment controls
    
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    // ****************************************************************************************************************************************************
    
    
   
        
        // |||||||||||||| make segements
        
        float segmentYStart = 10;
        float segmentYIncrement = 45;
        float yfact = 0 ;
        float yfactAdd = 0.8;
        _labelExtrasOnHeli.text = @"";
        
        for (int segNr = lineOptions+1; segNr < lineEnd ; segNr++) {
            
            // segment name
            // check if segment is a drilling
            if ([[self.arrayName1 objectAtIndex: segNr ] isEqualToString:@"3Segments"]) {
                // get ON / OFF values for segment:
                NSArray *itemArray = [NSArray arrayWithObjects: [self.arrayName8 objectAtIndex: segNr ]    , [self.arrayName9 objectAtIndex: segNr ]  , [self.arrayName10 objectAtIndex: segNr ],  nil];
                UISegmentedControl *segmentedControl = [[UISegmentedControl alloc] initWithItems:itemArray];
                                segmentedControl.frame = CGRectMake(3,  segmentYStart - 3 + yfact * segmentYIncrement, 328, 28);
                
                [segmentedControl addTarget:self action:@selector(segmentAction:) forControlEvents: UIControlEventValueChanged];
                segmentedControl.tag = segNr;
                segmentedControl.backgroundColor = [UIColor darkGrayColor]; 
                [_viewOptions addSubview:segmentedControl];
                yfact = yfact + yfactAdd;
                
            }else{
                
                UILabel *textField = [[UILabel alloc] initWithFrame:CGRectMake(5, segmentYStart + yfact * segmentYIncrement , 320, 20)];
                textField.font = [UIFont boldSystemFontOfSize:15];
                textField.textAlignment = NSTextAlignmentLeft;
                textField.textColor = [UIColor whiteColor];
                [textField  setText: [self.arrayName1 objectAtIndex: segNr ]  ];
                [_viewOptions addSubview:textField];
                
                // get ON / OFF values for segment:
                NSArray *itemArray = [NSArray arrayWithObjects: [self.arrayName8 objectAtIndex: segNr ]    , [self.arrayName9 objectAtIndex: segNr ],  nil];
                UISegmentedControl *segmentedControl = [[UISegmentedControl alloc] initWithItems:itemArray];
                segmentedControl.frame = CGRectMake(180,  segmentYStart - 3 + yfact * segmentYIncrement, 150, 28);
                [segmentedControl addTarget:self action:@selector(segmentAction:) forControlEvents: UIControlEventValueChanged];
                segmentedControl.tag = segNr;
                segmentedControl.backgroundColor = [UIColor darkGrayColor]; 
                [_viewOptions addSubview:segmentedControl];
                
                yfact = yfact +yfactAdd;                
            }
            
       }// end make segments
    
    
    
    
    UILabel *textField = [[UILabel alloc] initWithFrame:CGRectMake(5, segmentYStart + yfact * segmentYIncrement , 320, 20)];
    textField.font = [UIFont boldSystemFontOfSize:15];
    textField.textAlignment = NSTextAlignmentLeft;
    textField.textColor = [UIColor whiteColor];
    [textField  setText: @""  ];
    textField.tag = 1000;
    
    [_viewOptions addSubview:textField];
    
    yfact = yfact +0.5;
    
    textField = [[UILabel alloc] initWithFrame:CGRectMake(5, segmentYStart + yfact * segmentYIncrement , 320, 20)];
    textField.font = [UIFont boldSystemFontOfSize:15];
    textField.textAlignment = NSTextAlignmentLeft;
    textField.textColor = [UIColor whiteColor];
    [textField  setText: @""  ];
    textField.tag = 1001;
    
    [_viewOptions addSubview:textField];
    
    yfact = yfact +0.5;
    
    
    textField = [[UILabel alloc] initWithFrame:CGRectMake(5, segmentYStart + yfact * segmentYIncrement , 320, 20)];
    textField.font = [UIFont boldSystemFontOfSize:15];
    textField.textAlignment = NSTextAlignmentLeft;
    textField.textColor = [UIColor whiteColor];
    [textField  setText: @""  ];
    textField.tag = 1002;
    
    [_viewOptions addSubview:textField];
    

    
    
    // set segments
    
    //NSLog(@"set segments ");
    
    [self setSegments];
    
    [self setSliders];
    
    
}


- (void) setSegments {
    
    
    for (int segNr = lineOptions+1; segNr < lineEnd ; segNr++) {
        
        //NSLog (@"segNr %d ", segNr);
        
        UISegmentedControl* segment =(UISegmentedControl*)[_viewOptions viewWithTag: segNr] ;
        
        if ([[_arrayName2 objectAtIndex:segNr] isEqualToString:@"1"]) {
            segment.selectedSegmentIndex = 1;
            segment.tintColor = [UIColor whiteColor];
        }
        
        if ([[_arrayName2 objectAtIndex:segNr] isEqualToString:@"2"]) {
            segment.selectedSegmentIndex = 2;
            segment.tintColor = [UIColor whiteColor];
        }
        
        
        if ([[_arrayName2 objectAtIndex:segNr] isEqualToString:@"0"]) {
            segment.selectedSegmentIndex = 0;
            segment.tintColor = [UIColor lightGrayColor];
        }
        
    }
    
    
    
    
}


- (void)segmentAction :(UISegmentedControl *)segment{
    
    
   //NSLog (@"segNr selected %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.selectedSegmentIndex  ]);
   //NSLog (@"segment.tag %d ", segment.tag );
    
    if ([[self.arrayName3 objectAtIndex: segment.tag  ] rangeOfString:@"&"].location != NSNotFound   ) {
        
        // switch multiple items on or off
        // collect items
        NSArray *componentItems  = [[self.arrayName3 objectAtIndex: segment.tag  ] componentsSeparatedByString:@"&"];
        //NSLog (@"componentItems %@", componentItems);
        for(int i=0; i<componentItems.count; i++) {
            NSString *compItem = [componentItems objectAtIndex:i];
            
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: compItem  ] ) {
                    //NSLog (@"Switch is connected to item %@ ", [ [NSString alloc] initWithFormat:@"%d ", itemIndex ]);
                    if (segment.selectedSegmentIndex == 1) {
                        [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"1"];
                        //NSLog (@"1 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
                    }else{
                        [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"0"];
                        //NSLog (@"0 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
                    }
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: [self.arrayName2 objectAtIndex: segment.tag ]  ];
                    
                    break;
                }
            }// end for itemIndex
        }// end for comp items
        
        
        //[self setSegments];
        [self createListoItemsSlidersAndInterior];
        [self MainRoutine];
        
        
        
    }else  if ([[self.arrayName1 objectAtIndex: segment.tag ] isEqualToString:@"3Segments"]) {
        
        //NSLog (@"3Segments !");
        // look for item that is selected, switch it on, then switch the other off.
        // if it is the 0 item, switch both off
        
        
        if (segment.selectedSegmentIndex == 1) {
            // get line for selected item 1
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName9 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch on item 1
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"1" ];
                    break;
                }
            }
            // get line for selected item 2
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName10 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch off item 2
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"0" ];
                    break;
                }
            }
            
           
        }
        
        
        if (segment.selectedSegmentIndex == 2) {
            // get line for selected item 2
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName10 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch on item 2
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"1" ];
                    break;
                }
            }
            // get line for selected item 1
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName9 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch off item 2
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"0" ];
                    break;
                }
            }
        }
        
        
        
        if (segment.selectedSegmentIndex == 0) {
            // get line for selected item 1
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName9 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch on item 1
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"0" ];
                    break;
                }
            }
            // get line for selected item 2
            for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
                if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName10 objectAtIndex: segment.tag ]] ) {
                    //NSLog (@"line 1 is %d", itemIndex);
                    
                    //switch off item 2
                    [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: @"0" ];
                    break;
                }
            }
        }
        
        [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: [[NSString alloc] initWithFormat:@"%d", segment.selectedSegmentIndex] ];
        
        //NSLog (@"replacing with  %@",  [[NSString alloc] initWithFormat:@"%d", segment.selectedSegmentIndex]);

        
        //[self setSegments];
        [self createListoItemsSlidersAndInterior];
        [self MainRoutine];
        
        
        
        
        
    }else{
        
        //NSLog (@"Standard Segments");
        // check if switch is connected to an item:
        int flagItemIsConnected = 0;
        for (int itemIndex = listStart; itemIndex < listEnd+1 ; itemIndex++) {
            if ( [[self.arrayName1 objectAtIndex: itemIndex ] isEqualToString: [self.arrayName3 objectAtIndex: segment.tag ]] ) {
                //NSLog (@"Switch is connected to item %@ ", [ [NSString alloc] initWithFormat:@"%d ", itemIndex ]);
                flagItemIsConnected = 1;
                if (segment.selectedSegmentIndex == 1) {
                    [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"1"];
                    //NSLog (@"1 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
                }else{
                    [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"0"];
                    //NSLog (@"0 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
                }
                
                [self.arrayName8 replaceObjectAtIndex:itemIndex withObject: [self.arrayName2 objectAtIndex: segment.tag ]  ];
                
                //[self setSegments];
                
                [self createListoItemsSlidersAndInterior];
                
                break;
            }
            
        }
        
        
        if (flagItemIsConnected == 0) {
            
            //NSLog (@"not connected ******************************************");
            // switch the segment that is not connected
            
            if (segment.selectedSegmentIndex == 1) {
                
                [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"1"];
                //NSLog (@"1 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
                
            }else{
                
                [self.arrayName2 replaceObjectAtIndex:segment.tag withObject: @"0"];
                //NSLog (@"0 segment.tag %@ ", [ [NSString alloc] initWithFormat:@"%d ", segment.tag]);
            }
            
            
            [self createListoItemsSlidersAndInterior];
            
            
        }
        
        
        [self MainRoutine];

        
        
        
        
        
    }
    
    
 
    
    
}






- (void)saveArrayListo {
    
    
    
    // save list
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    
    NSString *configSetup  = [NSString stringWithFormat:@"%@_%@", actypeForConfig, defaultConfigName ];

    //NSLog(@"saveArrayListo configSetup  %@", configSetup);
    
    [defaults  setObject:self.arrayName1       forKey:[configSetup stringByAppendingString:@"arrayName1"]];
    [defaults  setObject:self.arrayName2       forKey:[configSetup stringByAppendingString:@"arrayName2"]];
    [defaults  setObject:self.arrayName3       forKey:[configSetup stringByAppendingString:@"arrayName3"]];
    [defaults  setObject:self.arrayName4       forKey:[configSetup stringByAppendingString:@"arrayName4"]];
    [defaults  setObject:self.arrayName5       forKey:[configSetup stringByAppendingString:@"arrayName5"]];
    [defaults  setObject:self.arrayName6       forKey:[configSetup stringByAppendingString:@"arrayName6"]];
    [defaults  setObject:self.arrayName7       forKey:[configSetup stringByAppendingString:@"arrayName7"]];
    [defaults  setObject:self.arrayName8       forKey:[configSetup stringByAppendingString:@"arrayName8"]];
    [defaults  setObject:self.arrayName9       forKey:[configSetup stringByAppendingString:@"arrayName9"]];
    [defaults  setObject:self.arrayName10      forKey:[configSetup stringByAppendingString:@"arrayName10"]];
    [defaults  setObject:self.arrayName11      forKey:[configSetup stringByAppendingString:@"arrayName11"]];
    [defaults  setObject:self.arrayName12      forKey:[configSetup stringByAppendingString:@"arrayName12"]];
    [defaults  setObject:self.arrayName13      forKey:[configSetup stringByAppendingString:@"arrayName13"]];
    [defaults  setObject:self.arrayName14      forKey:[configSetup stringByAppendingString:@"arrayName14"]];
    [defaults  setObject:self.arrayName15      forKey:[configSetup stringByAppendingString:@"arrayName15"]];
    [defaults  setObject:self.arrayName16      forKey:[configSetup stringByAppendingString:@"arrayName16"]];
    [defaults  setObject:self.arrayName17      forKey:[configSetup stringByAppendingString:@"arrayName17"]];
    [defaults  setObject:self.arrayName18      forKey:[configSetup stringByAppendingString:@"arrayName18"]];
    [defaults  setObject:self.arrayName19      forKey:[configSetup stringByAppendingString:@"arrayName19"]];
    [defaults  setObject:self.arrayName20      forKey:[configSetup stringByAppendingString:@"arrayName20"]];
    [defaults  setObject:self.arrayName21      forKey:[configSetup stringByAppendingString:@"arrayName21"]];
    [defaults  setObject:self.arrayName22      forKey:[configSetup stringByAppendingString:@"arrayName22"]];
    [defaults  setObject:self.arrayName23      forKey:[configSetup stringByAppendingString:@"arrayName23"]];
    [defaults  setObject:self.arrayName24      forKey:[configSetup stringByAppendingString:@"arrayName24"]];
    [defaults  setObject:self.arrayName25      forKey:[configSetup stringByAppendingString:@"arrayName25"]];

    
     //NSLog(@"saving  arrayName1  %@", _arrayName1 );
    //NSLog(@"saving  arrayName22  %@", _arrayName22 );
    
    return;
    
    
    
    
    
}


- (void)loadArrayListo {
    
    
    //NSLog(@"loadArrayListo ACType   %@", AC_Type);
    
    [arrayConfigurations setArray: [[[NSUserDefaults standardUserDefaults] objectForKey: [NSString stringWithFormat:@"arrayConfigurations%@", AC_Type] ] mutableCopy]];
    
    //NSLog(@"arrayConfigurations   %@", arrayConfigurations);
    
    
    //NSLog(@"loadArrayListo configSetup  %d", configuration);
    
    NSString *configName = [arrayConfigurations objectAtIndex:configuration];
    
    //NSLog(@"configName configSetup  %@", configName);
    
    
    NSString *configSetup  = [NSString stringWithFormat:@"%@_%@", AC_Type, configName  ];
    
    //NSLog(@"loadArrayListo configSetup  %@", configSetup);
    
    //NSString *configSetup = defaultConfigName;
 
    
    [self.arrayName1 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName1"]]  mutableCopy]];
    
    [self.arrayName2 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName2"]]  mutableCopy]];
    
    [self.arrayName3 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName3"]]  mutableCopy]];
    
    [self.arrayName4 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName4"]]  mutableCopy]];
    
    [self.arrayName5 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName5"]]  mutableCopy]];
    
    [self.arrayName6 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName6"]]  mutableCopy]];
    
    [self.arrayName7 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName7"]]  mutableCopy]];
    
    [self.arrayName8 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName8"]]  mutableCopy]];
    
    [self.arrayName9 setArray:  [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName9"]]  mutableCopy]];
    
    [self.arrayName10 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName10"]] mutableCopy]];
    
    [self.arrayName11 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName11"]] mutableCopy]];
    
    [self.arrayName12 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName12"]] mutableCopy]];
    
    [self.arrayName13 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName13"]] mutableCopy]];
    
    [self.arrayName14 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName14"]] mutableCopy]];
    
    [self.arrayName15 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName15"]] mutableCopy]];
    
    [self.arrayName16 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName16"]] mutableCopy]];
    
    [self.arrayName17 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName17"]] mutableCopy]];
    
    [self.arrayName18 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName18"]] mutableCopy]];
    
    [self.arrayName19 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName19"]] mutableCopy]];

    [self.arrayName20 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName20"]] mutableCopy]];
    
    [self.arrayName21 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName21"]] mutableCopy]];
    
    [self.arrayName22 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName22"]] mutableCopy]];
    
    [self.arrayName23 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName23"]] mutableCopy]];
    
    [self.arrayName24 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName24"]] mutableCopy]];
    
    [self.arrayName25 setArray: [[[NSUserDefaults standardUserDefaults] objectForKey:[configSetup stringByAppendingString:@"arrayName25"]] mutableCopy]];
    
    [self guidanceResetTotal];
    
    [self setDefaultsForConfig];
    
    //NSLog(@"loadArrayListo");
    [self setBasicsForConfiguration];
    
    
     return;
    
    
    
}





// END el listo  END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo END el listo


- (IBAction)buttonActionCheckE6B:(id)sender {
    
    
        [self SaveValues];
    

    
    
}




- (IBAction)button :(id)sender {
    
     [self SaveValues]; // unter altem Namen alles speichern
    
    
    _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
    
    [self checkForUpdates_Helicopter];
   
    
}




- (IBAction)butSelHeli_Cancel:(id)sender {
    
    _viewSelectHelicopter.hidden = YES;
    
    
    
    
}








-(void) interpolateFuelMomentsLongitudinal {
    
    //NSLog(@"AC_Type %@", AC_Type);
  
    NSString *URL = [ [NSString alloc] initWithFormat:@"%@%@",  AC_Type, @"_FuelInterpolation" ];
    NSString *path = [[NSBundle mainBundle] pathForResource:URL ofType:@"txt"];
    NSString *loadedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];

    NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *arrayComponents = [loadedText componentsSeparatedByCharactersInSet:charSet1];
    
    NSArray *componentItems  = [[arrayComponents objectAtIndex:0] componentsSeparatedByString:@","];
    
    NSMutableArray *arrayFuelVolume = [[NSMutableArray alloc] init];
    NSMutableArray *arrayFuelMoment = [[NSMutableArray alloc] init];
    
    
    
    for (int i = 0; i<componentItems.count/2; i++) {
        [arrayFuelVolume addObject:[componentItems objectAtIndex: i*2 ] ];
        [arrayFuelMoment addObject:[componentItems objectAtIndex: i*2 + 1 ] ];
    }
    
    //NSLog(@"arrayFuelVolume %@", arrayFuelVolume);
    
    float GroupAkg = fuelVolume;
    
    //NSLog(@"GroupAkg %f", GroupAkg);
    
    fuelMoment = 0; OutLow2 = 0; OutHigh2 = 0; InLow2 = 0; InHigh2 = 0;
    
    for (int i = 0; i<arrayFuelVolume.count-1; i++) {
     
        //NSLog (@"i %d ", i );
        
       if (GroupAkg >= [[arrayFuelVolume objectAtIndex:i] floatValue]     & GroupAkg < [[arrayFuelVolume objectAtIndex:i+1] floatValue]    ) {
            
            OutLow2 = [[arrayFuelMoment objectAtIndex:i] floatValue];
            OutHigh2 = [[arrayFuelMoment objectAtIndex:i +1] floatValue];
            InLow2 = [[arrayFuelVolume objectAtIndex:i] floatValue];
            InHigh2 = [[arrayFuelVolume objectAtIndex:i+1] floatValue];
            break;
        }
    }
    
   

    
    fuelMoment =  OutLow2  +  ((OutHigh2 - OutLow2)  *  (((GroupAkg - InLow2) * (100 / (InHigh2 - InLow2))) / 100 ))    ;
    
    if (OutLow2 + OutHigh2 + InLow2 + InHigh2 == 0) {
        fuelMoment = 0;
    }
    
    if (GroupAkg < 1) {
        fuelMoment = 0;
    }
    
    
    return;
    
}


-(void) interpolateFuelMomentsLateral {
    
    
    NSString *URL = [ [NSString alloc] initWithFormat:@"%@%@_FuelInterpolation", @"", AC_Type ];
    NSString *path = [[NSBundle mainBundle] pathForResource:URL ofType:@"txt"];
    NSString *loadedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    
    //NSLog (@"loadedText %@", loadedText);
    
    NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *arrayComponents = [loadedText componentsSeparatedByCharactersInSet:charSet1];
    
    NSArray *componentItems  = [[arrayComponents objectAtIndex:1] componentsSeparatedByString:@","];
    
    //NSLog (@"componentItems %@", componentItems);
    
    NSMutableArray *arrayFuelVolume = [[NSMutableArray alloc] init];
    NSMutableArray *arrayFuelMoment = [[NSMutableArray alloc] init];
    
    
    
    for (int i = 0; i<componentItems.count/2; i++) {
        [arrayFuelVolume addObject:[componentItems objectAtIndex: i*2 ] ];
        [arrayFuelMoment addObject:[componentItems objectAtIndex: i*2 + 1 ] ];
    }
    
   
    
    float GroupAkg = fuelVolume;
    
    //NSLog(@"GroupAkg %.0f", GroupAkg);
    
    fuelMoment = 0; OutLow2 = 0; OutHigh2 = 0; InLow2 = 0; InHigh2 = 0;
    
    for (int i = 0; i<arrayFuelVolume.count-1; i++) {
        
        
        if (GroupAkg >= [[arrayFuelVolume objectAtIndex:i] floatValue]     & GroupAkg < [[arrayFuelVolume objectAtIndex:i+1] floatValue]    ) {
            
            OutLow2 = [[arrayFuelMoment objectAtIndex:i] floatValue];
            OutHigh2 = [[arrayFuelMoment objectAtIndex:i +1] floatValue];
            InLow2 = [[arrayFuelVolume objectAtIndex:i] floatValue];
            InHigh2 = [[arrayFuelVolume objectAtIndex:i+1] floatValue];
            
            break;
        }
    }
   
    
    fuelMoment =  OutLow2  +  ((OutHigh2 - OutLow2)  *  (((GroupAkg - InLow2) * (100 / (InHigh2 - InLow2))) / 100 ))    ;
    
    
    
    if (GroupAkg < 1) {
        fuelMoment = 0;
    }
    
    
    return;
    

    
    
    
}





// Slider for Performance 


- (IBAction)buttonActionShowPickerTime:(UIButton *)sender {
    
    [self.view endEditing:TRUE];
    
   

    
    
    NSLocale *locale = [[NSLocale alloc] initWithLocaleIdentifier: [_arrayName23 objectAtIndex:9] ];
    
   // NSLocale *locale = [[NSLocale alloc] initWithLocaleIdentifier:@"en_JM"]; //@"de_CH"]; // @"en_US" // @"en_US", en_US_POSIX = us am/pm, en_NZ, en_GU, en_CA  =am/pm
    [self.datepick setLocale:locale];
    

    
    
    flagSetPickerTimeForFields = sender.tag;
    
    _viewDatePicker.hidden = NO;
    
    datepick.datePickerMode = UIDatePickerModeDateAndTime;
    
    [viewOne bringSubviewToFront:_viewDatePicker];
    
    
    
    
}




- (IBAction) datepickSetToNowButton {
    
    
    NSDate *now = [[NSDate alloc] init];
    NSCalendar *cal = [NSCalendar currentCalendar];
    NSDateComponents *comps = [cal components: NSYearCalendarUnit|NSMonthCalendarUnit|NSDayCalendarUnit|NSHourCalendarUnit|NSMinuteCalendarUnit|NSSecondCalendarUnit fromDate:now];
    
    
    NSDate *date = [cal dateFromComponents:comps];
    
    [self.datepick setDate:date animated:TRUE];
    
    
    NSDateFormatter* df = [[NSDateFormatter alloc]init] ;
    
    df.dateFormat = [_arrayName23 objectAtIndex: 38] ;
    
    
    // set GMT and Local Time
    
    NSDate *currentTime = datepick.date;
    
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    
    [dateFormatter setDateFormat: [_arrayName23 objectAtIndex: 38] ];
    
    NSTimeZone *gmt = [NSTimeZone timeZoneWithAbbreviation:@"GMT"];
    [dateFormatter setTimeZone:gmt];
    
    
    NSString *resultString = [dateFormatter stringFromDate: currentTime];
    
    NSTimeZone *localTZ = [NSTimeZone localTimeZone];
    [dateFormatter setTimeZone:localTZ];
    
    NSString *localTimeString = [dateFormatter stringFromDate: currentTime];
    
    
    //NSLog(@"-------- GMT Time %@", resultString);
    
    //NSLog(@"-------- Local    %@", localTimeString);
    
    
    resultString = [resultString stringByAppendingString:@" [GMT]"];
    
    localTimeString = [localTimeString stringByAppendingString:@""];
    
    if (flagSetPickerTimeForFields == 1) {
        _labelDepartureTimeLocal.text = localTimeString;
        
        _labelDepartureTimeGMT.text = resultString;

    }else{
        
        _labellandingtimeLocal.text = localTimeString;
        
        
    }
    
}





- (IBAction) datepickButtonOK {
    
    [_depp becomeFirstResponder];
    
    [self.view endEditing:TRUE];
    
    _viewDatePicker.hidden = YES;
    
    
    //[_labelDepartureTimeLocal resignFirstResponder];
    
    
    //NSLog (@"flagSetPickerTimeForFields %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", flagSetPickerTimeForFields]);
    
    
    NSDateFormatter* df = [[NSDateFormatter alloc]init] ;
    
    df.dateFormat = [_arrayName23 objectAtIndex: 38];
    
    // set GMT or Local Time
    
    NSDate *currentTime = datepick.date;
    
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    
    [dateFormatter setDateFormat: [_arrayName23 objectAtIndex: 38] ];
    
    NSTimeZone *localTZ = [NSTimeZone localTimeZone];
    [dateFormatter setTimeZone:localTZ];
    
    NSString *localTimeString = [dateFormatter stringFromDate: currentTime];
    
    localTimeString = [localTimeString stringByAppendingString:@""]; //@" [LOCAL]"];
    
    
    if (flagSetPickerTimeForFields == 1) {
        _labelDepartureTimeLocal.text = localTimeString;
        
    }else{
        _labellandingtimeLocal.text = localTimeString;
        
    }
    
    
    [self MainRoutine];
    
    
}








- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event{
    
    
    
    //NSLog(@"touchesBegan:withEvent:");
    [self.view endEditing:YES];
    
    [_depp becomeFirstResponder];
    
    [self.view endEditing:TRUE];
    [super touchesBegan:touches withEvent:event];
}


- (void) findLines {
    
    //NSLog(@"findLines arrayName1 %@", _arrayName1);
    
    lineJackets = 0;
    lineSeats = 0;
    lineSeatsOccupied = 0;
    lineHoistOP = 0;
    lineHoistInstructor = 0;
    
    for (int i = 1; i < 48  ; i++) {
        
        // find lines
        
        
        
        // find ZFW
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"ZFW"].location != NSNotFound     ||[[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"ZFM"].location != NSNotFound                   ) {
            
            lineZFW = i;
            
            
            
        }
        
        
        // find lineHoistOP
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Hoist OP"].location != NSNotFound     ) {
            
            lineHoistOP = i;
            
            
        }
        
        
        // find lineHoistInstructor
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Hoist INSTR"].location != NSNotFound     ) {
            
            lineHoistInstructor = i;
            
            
        }
        
        
        
        
        // find patient
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"PATIENT"].location != NSNotFound     ) {
            
            linePatient = i;
            
            
        }
        
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Free Load"].location != NSNotFound     ) {
            
            lineFreeLoad = i;
            
            
        }


        
        
        // find TOW
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"TOW"].location != NSNotFound     ||[[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"TOM"].location != NSNotFound                   ) {
            
            lineTOW = i;
            
            //NSLog (@"lineTOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", lineTOW]);
            
            
            
        }
        
        
        
        // find LDW
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"LDW"].location != NSNotFound     ||[[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"LDM"].location != NSNotFound                   ) {
            
            lineLDW = i;
            listEnd = i;
            
        }
        
        // find MCM
        
        if ([[self.arrayName1 objectAtIndex: i  ] isEqualToString:@"MCM"] ) {
            lineMCM = i;
        }
        
        
        
        // find "Seats
        
        if ([[self.arrayName1 objectAtIndex: i  ] isEqualToString:@"Seats"] ) {
            lineSeats = i;
        }
        
        if ([[self.arrayName1 objectAtIndex: i  ] isEqualToString:@"Seats Occupied"] ) {
            lineSeatsOccupied = i;
        }
        
        
         if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Wt. Jackets"].location != NSNotFound    ) {
            lineJackets = i;
        }

        
        
        
        // find "Equipment
        
        if ([[self.arrayName1 objectAtIndex: i  ] isEqualToString:@"Med Equipment"] ) {
            lineEquipment = i;
        }
        
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"External"].location != NSNotFound   ) {
            lineExternal = i;
        }
        
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Dual Controls"].location != NSNotFound   ) {
            lineDualControls = i;
            
        }
        
        
        // find "Hoist
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Hoist Load"].location != NSNotFound  ) {
            
            lineHoistLoad = i;
            
            
        }
        
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Hoist System"].location != NSNotFound  ) {
            
            lineHoistSystem = i;
            
            
        }
        
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Cargo Load"].location != NSNotFound                     ) {
            
            lineCargoLoad = i;
            
            
        }
        
        
        lineFriesArmKit = 28;
        
        
        
        
        
        
        // find Options
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"Options"].location != NSNotFound  ) {
            
           
            lineOptions = i;
            
            
            //NSLog (@"lineLDW %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", lineLDW]);
            
            
            //NSLog (@"listEnd %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", listEnd]);
            
            
            
        }
        
        
        // find End
        
        if ([[self.arrayName1 objectAtIndex: i  ] rangeOfString:@"End"].location != NSNotFound  ) {
            
            
            lineEnd = i;
            
            
            
            //NSLog (@"lineLDW %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", lineLDW]);
            
            
            //NSLog (@"1 listEnd %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", listEnd]);
            
            
            break;
            
        }
        

        
    }

    
    
    
    
    return;
    
    
}











// add buttons





- (void) addPerformanceButtons {
    
    amountOfButtons = amountButtonsNeeded ;
    
    //NSLog(@"addPerformanceButtons amountButtonsNeeded %f", amountButtonsNeeded);
    
    if (flagIsLandscape == 1) {
        
           viewTopDisplayButtons.frame = CGRectMake( -2, 54, 1031, 73 ) ;
        
          _triangleWhite.frame = CGRectMake( 188, 13, 19, 38 );
        
        
       
        _viewButtonOATPA.frame = CGRectMake( -1, 6, 186, 52 );  buttonDisplayEnvironment.frame = CGRectMake( 1, 0, 182, 52 );
        _viewButtonOATlabelOAT.frame = CGRectMake( 2, 1, 90, 23 ); labelDisplayOAT.frame = CGRectMake( 2, 22, 92, 23 );
        _viewButtonOATLabelPA.frame = CGRectMake( 82, 1, 90, 23 ); labelDisplayPA.frame = CGRectMake( 75, 22, 92, 23 );
        
       
        
        
    }else{
        
         viewTopDisplayButtons.frame = CGRectMake( 645, 54, 150, 650 ) ;
        
        _triangleWhite.frame = CGRectMake( 45, 105, 38, 19 );
        
        float yGapEnvi = 5;
        _viewButtonOATPA.frame = CGRectMake( -1, 3, 128, 95 );  buttonDisplayEnvironment.frame = CGRectMake( 0, 0, 128, 95 ) ;
        _viewButtonOATlabelOAT.frame = CGRectMake( 0, yGapEnvi, 128, 23 ) ; labelDisplayOAT.frame = CGRectMake( 0, yGapEnvi+20, 128, 23 ) ;
        _viewButtonOATLabelPA.frame = CGRectMake( 0, yGapEnvi+20+20, 128, 23 ) ; labelDisplayPA.frame = CGRectMake( 0, yGapEnvi+20+20+20, 128, 23 ) ;
        
         _viewTrennerTop.hidden = NO;
        
        
    }
    
  
    
    _viewUniversalButtons.backgroundColor = [UIColor clearColor];
    
    viewTopDisplayButtons.backgroundColor = [UIColor clearColor];
    
    
    for(UIView *subview in [_viewUniversalButtons subviews]) {
        [subview removeFromSuperview];
    }
    
    
    float bGap = 0;
    float xEdgeLeft =  0;
    float xEdgeRight  = 0;
    float buttonWidth = 0;
    float xStartLeft = 0;
    float yCoord=0;
    float buttonHeight=0;
    
    
    // create buttons for each Performance item
    
    if (flagIsLandscape == 1) {
        
        bGap = 2;
        
        xEdgeLeft =  8;  // next to triangle
        xEdgeRight  = (amountOfButtons * 120)   + ( amountOfButtons * bGap);
        
        xEdgeRight  = 1200;
        //buttonWidth =   ( (xEdgeRight - xEdgeLeft + (amountOfButtons) )    )    / amountOfButtons;
        
        
       
        if (_arrayName23.count > 40) {
            
            if ([[_arrayName23 objectAtIndex:42] floatValue] > 0) {
                buttonWidth = [[_arrayName23 objectAtIndex:42] floatValue];
            }
            
        }
       
        
        buttonWidth =  130 ;

        
        xStartLeft = xEdgeLeft ;
        
        yCoord=6;
        
        buttonHeight=52;
        
        _scrollViewUniversalButtons.frame     = CGRectMake(  209, 0, 822, 73  );
        
        [_scrollViewUniversalButtons setScrollEnabled:YES];
        
        _viewUniversalButtons.frame     = CGRectMake(  0, 0, xEdgeRight + 100, 73  );
        
        [_scrollViewUniversalButtons setContentSize:CGSizeMake(_viewUniversalButtons.frame.size.width, 73)];

        
    }else{
        
        // this is just for scrolling to the button
        bGap = 2;
        xEdgeLeft =  8;
        xEdgeRight  = (amountOfButtons * 180)   + ( amountOfButtons * bGap);
        buttonWidth =   ( (xEdgeRight - xEdgeLeft + (amountOfButtons) )    )    / amountOfButtons;

        
        // if portrait
        
        xEdgeLeft =  0;  // next to triangle
        xEdgeRight  = 150;
        
        buttonWidth = 140.0;
        
        xStartLeft = xEdgeLeft ;
        
        yCoord=6;
        
        buttonHeight=65;
        
        _scrollViewUniversalButtons.frame     = CGRectMake(  -1, 130, 150, 500  );
        
        [_scrollViewUniversalButtons setScrollEnabled:YES];
        
        _viewUniversalButtons.frame     = CGRectMake(  0, 0, xEdgeRight, amountOfButtons * buttonHeight  );
        
        [_scrollViewUniversalButtons setContentSize:CGSizeMake(_viewUniversalButtons.frame.size.width , _viewUniversalButtons.frame.size.height)];
        
        _viewTrennerTop.hidden = NO;
        
        
    }
    
    
    
   
    
   
    
    
    
    //the helicopters array contains all helicopter objects that came from the server
    
    float xPosButton = 0;
    
    for(int p=1; p<amountOfButtons+1; p++) {
        
       
        xPosButton = xPosButton + 1;
        
        UIButton *perfButton = [UIButton buttonWithType:UIButtonTypeCustom];
      
        
        if (flagIsLandscape == 1) {
            perfButton.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap ))  , yCoord, buttonWidth, buttonHeight );

        }else{
            
            perfButton.frame     = CGRectMake(   xStartLeft  , (xPosButton-1) * buttonHeight, buttonWidth, buttonHeight );
            
        }
        
        
        [perfButton setTag:p];
        
        [perfButton addTarget:self action:@selector(actionPerfbuttons:) forControlEvents:UIControlEventTouchUpInside];
        
        
        
        //NSLog(@"button tag %d ", p);
        
        
        // create labels Headline
        
        UILabel *label = [[UILabel alloc] init];
        label.tag = p+100;
        
        
        
        
        if (flagIsLandscape == 1) {
            //label.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap ))  , yCoord-12, buttonWidth, buttonHeight );
            label.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap )) +5 , yCoord-12, buttonWidth - 10, buttonHeight );
            
             [label setFont:[UIFont systemFontOfSize:14]];
            
        }else{
            
            //label.frame     = CGRectMake( xStartLeft  , ((xPosButton-1) * buttonHeight) -12, buttonWidth, buttonHeight );
             label.frame     = CGRectMake( xStartLeft  +5 , ((xPosButton-1) * buttonHeight) -12, buttonWidth - 10, buttonHeight );
             [label setFont:[UIFont systemFontOfSize:14]];
            
        }

        
        
       
        
        
        label.textColor = [UIColor colorWithRed:216.0/255.0f green:216.0/255.0f blue:216.0/255.0f alpha:1.0f];
        
        label.textAlignment = NSTextAlignmentCenter;
        
        label.shadowColor = [UIColor blackColor];
        label.shadowOffset = CGSizeMake(1.0, 1.0);
        label.adjustsFontSizeToFitWidth = YES;   // trick to shrink fonts            
        label.minimumScaleFactor = 0.3; 
      
        
        // create labels Values
        
        
        UILabel *label2 = [[UILabel alloc] init];
        label2.tag = p+200;
        
        
        
        if (flagIsLandscape == 1) {
            //label2.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap ))  , yCoord+6, buttonWidth, buttonHeight );
            label2.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap )) + 5  , yCoord+6, buttonWidth-10, buttonHeight );
            
        }else{
            
            //label2.frame     = CGRectMake( xStartLeft  , ((xPosButton-1) * buttonHeight) +8, buttonWidth, buttonHeight );
            label2.frame     = CGRectMake( xStartLeft +5 , ((xPosButton-1) * buttonHeight) +8, buttonWidth -10, buttonHeight ); 
        }
        
        
        
        
        [label2 setFont:[UIFont boldSystemFontOfSize:17]];
        
        label2.textColor = [UIColor whiteColor];
        
        label2.textAlignment = NSTextAlignmentCenter;
        
        label2.shadowColor = [UIColor blackColor];
        label2.shadowOffset = CGSizeMake(1.0, 1.0);
        
        
        
        
        
        
        
        
        UIImage *bg = [UIImage imageNamed:@"bg.png"];
        
        UIImage *bb = [UIImage imageNamed:@"bb.png"];
        
        
        [perfButton setBackgroundImage:bg forState:UIControlStateNormal];
        
        [perfButton setBackgroundImage:bb forState:UIControlStateHighlighted];
        
        [perfButton setBackgroundImage:bb forState:UIControlStateSelected];
        
    
        
        
        if ([arrayButtonsToHide containsObject:[ [NSString alloc] initWithFormat:@"%d", p-1] ]) {
            // ...
            
            //NSLog(@"Hello show hide this one: %d", p);
            
            [_viewUniversalButtons addSubview:perfButton];
            
            [_viewUniversalButtons addSubview:label];
            
            [_viewUniversalButtons addSubview:label2];

            
           
        }else{
             xPosButton = xPosButton - 1;
            

            
            
            
        }
        
        
        
        
        
       
        
    }
    
    
    
    //signalStripe
    UIView *signalStripe = [[UIView alloc] init];
    signalStripe.tag = 999;
    
    signalStripe.backgroundColor = [UIColor lightGrayColor];
    //buttonSignalStripe.frame     = CGRectMake(  ( xStartLeft - buttonWidth )  +  (xPosButton * (buttonWidth -bGap ))  , yCoord+50, buttonWidth, 5 );
    
    signalStripe.frame     = CGRectMake(  ( xStartLeft - buttonWidth )    , yCoord+50, buttonWidth, 5 );
    signalStripe.hidden = YES;
    [_viewUniversalButtons addSubview:signalStripe];

    
    
   
    
    return;
    
    
}

- (void) addPerfBox {
    
    
    
    displayWindow = 0; [self displayWindows];
    
    for(UIView *subview in [_viewUniversalButtons subviews]) {
        [subview removeFromSuperview];
    }
    
    
    float bGap = 0;
    float xEdgeLeft =  0;
    float xEdgeRight  = 0;
    float buttonWidth = 0;
    float xStartLeft = 0;
    float yCoord=0;
    float buttonHeight=0;
    
    float lineCounter = 1;
    float buttonCounter = 0;
    
    float buttonPerRow = 4;
    
    
    // create buttons for each Performance item
    
    if (flagIsLandscape == 1) {
        
        _viewButtonOATPA.frame = CGRectMake( -1, 6, 186, 52 );  buttonDisplayEnvironment.frame = CGRectMake( 1, 0, 182, 52 );
        _viewButtonOATlabelOAT.frame = CGRectMake( 2, 1, 90, 23 ); labelDisplayOAT.frame = CGRectMake( 2, 22, 92, 23 );
        _viewButtonOATLabelPA.frame = CGRectMake( 82, 1, 90, 23 ); labelDisplayPA.frame = CGRectMake( 75, 22, 92, 23 );
        
        
        
        viewTopDisplayButtons.frame = CGRectMake( -2, 54, 648, 1024 ) ; [viewOne bringSubviewToFront: viewTopDisplayButtons];
        
        _triangleWhite.frame = CGRectMake( 188, 13, 19, 38 );
        
        _viewUniversalButtons.backgroundColor = [UIColor blackColor];
        
        [viewMain bringSubviewToFront:viewEnvironment]; viewEnvironment.hidden =NO;
        
        bGap = 2;
        
        xEdgeLeft =  0;  // next to triangle
        xEdgeRight  = (amountOfButtons * 180)   + ( amountOfButtons * bGap);
        
        buttonWidth =   ( (xEdgeRight - xEdgeLeft + (amountOfButtons) )    )    / amountOfButtons;
        
        buttonWidth = viewTopDisplayButtons.frame.size.width / buttonPerRow;
        
        xStartLeft = xEdgeLeft ;
        
       
        
        buttonHeight=60;
        
        _scrollViewUniversalButtons.frame     = CGRectMake(  0, 60, viewTopDisplayButtons.frame.size.width, 1024  );
        
        [_scrollViewUniversalButtons setScrollEnabled:NO];
        
        [_scrollViewUniversalButtons setContentSize:CGSizeMake(_viewUniversalButtons.frame.size.width, _viewUniversalButtons.frame.size.height)];
        
        _viewUniversalButtons.frame     = CGRectMake(  0, -77, viewTopDisplayButtons.frame.size.width, viewTopDisplayButtons.frame.size.height  );
        
        [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake( 1,1,1,1 ) animated:NO];

        
        
    }else{
        
        _viewButtonOATPA.frame = CGRectMake( -1, 6, 186, 52 );  buttonDisplayEnvironment.frame = CGRectMake( 1, 0, 182, 52 );
        _viewButtonOATlabelOAT.frame = CGRectMake( 2, 1, 90, 23 ); labelDisplayOAT.frame = CGRectMake( 2, 22, 92, 23 );
        _viewButtonOATLabelPA.frame = CGRectMake( 82, 1, 90, 23 ); labelDisplayPA.frame = CGRectMake( 75, 22, 92, 23 );
        
        
        _viewTrennerTop.hidden = YES;
        
        buttonPerRow = 5;
        
        //NSLog(@"portrait ");
        
        _triangleWhite.frame = CGRectMake( 220, 13, 50, 30 );
        
        viewTopDisplayButtons.frame = CGRectMake( -2, 54, 770, 630 ) ; [viewOne bringSubviewToFront: viewTopDisplayButtons];
        
        _scrollViewUniversalButtons.frame     = CGRectMake(  0, 60, viewTopDisplayButtons.frame.size.width, viewTopDisplayButtons.frame.size.height -60 );
        
        [_scrollViewUniversalButtons setScrollEnabled:NO];
        
        [_scrollViewUniversalButtons setContentSize:CGSizeMake(_viewUniversalButtons.frame.size.width, _viewUniversalButtons.frame.size.height)];
        
        _viewUniversalButtons.frame     = CGRectMake(  0, -77, viewTopDisplayButtons.frame.size.width, viewTopDisplayButtons.frame.size.height  );
        
        [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake( 1,1,1,1 ) animated:NO];
        
        
        
        viewTopDisplayButtons.backgroundColor = [UIColor blackColor];
        
        _viewUniversalButtons.backgroundColor = [UIColor blackColor];
        
        [viewMain bringSubviewToFront:viewEnvironment]; viewEnvironment.hidden =NO;
        
        bGap = 2;
        
        xEdgeLeft =  0;  // next to triangle
        xEdgeRight  = (amountOfButtons * 180)   + ( amountOfButtons * bGap);
        
        buttonWidth =   ( (xEdgeRight - xEdgeLeft + (amountOfButtons) )    )    / amountOfButtons;
        
        buttonWidth = viewTopDisplayButtons.frame.size.width / buttonPerRow;
        
        xStartLeft = xEdgeLeft ;
        
        
        
        buttonHeight=60;
        
       
        
        
        
    }
    

    
    for(int p=1; p<amountOfButtons-1; p++) {
        
        
        buttonCounter = buttonCounter + 1;
        
        if (buttonCounter == buttonPerRow + 1) {
            
            buttonCounter = 1;
            
            lineCounter = lineCounter +1;
        }
        
        yCoord= buttonHeight * lineCounter + 15;

       
        
        UIButton *perfButton = [UIButton buttonWithType:UIButtonTypeCustom];
        
        
        if (flagIsLandscape == 1) {
            
            perfButton.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord, buttonWidth, buttonHeight );
            
            
            
            
        }else{
            
            perfButton.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord, buttonWidth, buttonHeight );
        }
        
        
        [perfButton setTag:p];
        
        [perfButton addTarget:self action:@selector(actionPerfbuttons:) forControlEvents:UIControlEventTouchUpInside];
        
        
        
        // create labels Headline
        
        UILabel *label = [[UILabel alloc] init];
        label.tag = p+100;
        
        
        
        if (flagIsLandscape == 1) {
            
            label.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord - 12, buttonWidth, buttonHeight );
            
            [label setFont:[UIFont systemFontOfSize:16]];
            
        }else{
            
            label.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord - 12, buttonWidth, buttonHeight );
            
            [label setFont:[UIFont systemFontOfSize:16]];
            
        }
        
        
        
        
        label.textColor = [UIColor colorWithRed:216.0/255.0f green:216.0/255.0f blue:216.0/255.0f alpha:1.0f];
        
        label.textAlignment = NSTextAlignmentCenter;
        
        label.shadowColor = [UIColor blackColor];
        label.shadowOffset = CGSizeMake(1.0, 1.0);
        
        label.adjustsFontSizeToFitWidth = YES;
        
        
        // create labels Values
        
        
        UILabel *label2 = [[UILabel alloc] init];
        label2.tag = p+200;
        
        
        
        if (flagIsLandscape == 1) {
            label2.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord + 6, buttonWidth, buttonHeight );

            
        }else{
            
            label2.frame     = CGRectMake( (buttonCounter * buttonWidth) -  buttonWidth , yCoord + 6, buttonWidth, buttonHeight );
            
        }
        
        
        
        
        [label2 setFont:[UIFont boldSystemFontOfSize:17]];
        
        label2.textColor = [UIColor whiteColor];
        
        label2.textAlignment = NSTextAlignmentCenter;
        
        
        label2.shadowColor = [UIColor blackColor];
        label2.shadowOffset = CGSizeMake(1.0, 1.0);
        
        
        
        label2.adjustsFontSizeToFitWidth = YES;
        
        
        
        
        UIImage *bg = [UIImage imageNamed:@"bg.png"];
        
        UIImage *bb = [UIImage imageNamed:@"bb.png"];
        
        
        [perfButton setBackgroundImage:bg forState:UIControlStateNormal];
        
        [perfButton setBackgroundImage:bb forState:UIControlStateHighlighted];
        
        [perfButton setBackgroundImage:bb forState:UIControlStateSelected];
        
        
        
        [_viewUniversalButtons addSubview:perfButton];
        
        [_viewUniversalButtons addSubview:label];
        
        [_viewUniversalButtons addSubview:label2];
        
    }
    
    return;
    
    
}

- (IBAction)actionTrianglePerfButtons:(id)sender {
    
    if (flagPerfBoxOn == 0) {
        
        flagPerfBoxOn = 1;
        
        
         //NSLog(@"actionTrianglePerfButtons addPerfBox ");
        
        [self addPerfBox];
        
      
        
        [self displayWindows];
        
        
    }else{
        
        flagPerfBoxOn = 0;
        
         //NSLog(@"actionTrianglePerfButtons addPerformanceButtons ");
        
        [self addPerformanceButtons];

        [self displayWindows];
    }
    
    
    [self MainRoutine];
    
}







- (IBAction)buttonActionDisplayEnvironment:(id)sender {
    
    
    if (displayWindow == 1) {
        
        displayWindow = 0;
    } else {
        displayWindow = 1;
        
    }
    
    [self displayWindows];
    
    
    
}

- (IBAction)buttonActionChangeServer:(id)sender {
    
    if (_viewSelectServer.hidden == YES) {
        _viewSelectServer.hidden = NO; [viewSetup bringSubviewToFront:_viewSelectServer];
    }else{
        
      _viewSelectServer.hidden = YES;
    }
    
    
}

- (IBAction)buttonActionSelectServer:(id)sender {
    
    UIButton *btn = (UIButton*)sender;
    
    if (btn.tag == 1) {
        
        // set Standard Server
        
        _labelServer.text =@"Standard Server";
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        
        [defaults  setObject: _labelServer.text                     forKey:@"_labelServer"];
        
        
        serverpath      = serverpath_standard;
        serverpath_new  = serverpath_new_standard;
        serverhost      = serverhost_standard;
        
        [self MainRoutine];
        
        
    }
    
    
    if (btn.tag == 2) {
        
        // set Alternate Server
        
        _labelServer.text =@"Alternate Server";
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        
        [defaults  setObject: _labelServer.text                     forKey:@"_labelServer"];
        
        serverpath      = serverpath_alternate;
        serverpath_new  = serverpath_alternate;
        serverhost      = serverhost_alternate;
        
        [self MainRoutine];
        
        
        
    }
    
    
    
    
    if (btn.tag == 3) {
        
     
        _viewSelectServer.hidden = YES;
        
        [self MainRoutine];
        
    }
    
    
    
}







- (void) createConfigViewItemList {
    
    
    
    
}

- (IBAction)closeKeyboardEditStations:(id)sender {
    
    
     [self.view endEditing:TRUE];
    
    
    float enterValue = [_inputFuelOnBoard.text floatValue];
    
    
    if ([fuelEnterMode isEqualToString:@"mass"]) {
        
        if (enterValue > tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue] ) {
            enterValue = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
        }
        
        _sliderFuelMain1.value =  enterValue / [_inputSpecificFuelMassPerVolume.text floatValue];
        
        
    }else{
        
        if (enterValue > tankCapacityVolume) {
            enterValue = tankCapacityVolume;
        }
        
        _sliderFuelMain1.value =  enterValue;
        
    }
    
    
    [self MainRoutine];
    
[self MainRoutine];
    
    
    
   
    
    
}



- (void)actionItemInOut:(UIButton*)sender {



    //UIButton *perfButton = (UIButton *)sender;



    float itemNr = sender.tag;
    
    //NSLog (@"itemNr %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", itemNr]);
    
    
    if  ([[self.arrayName8 objectAtIndex: itemNr-100 ] doubleValue] >= 1) {
        
        
         [self.arrayName8 replaceObjectAtIndex:itemNr-100 withObject: @"0"  ];
        
        [self createListoItemsSlidersAndInterior];
        
        [self createConfigViewItemList];
        
        
        
        
    }else{
        
        [self.arrayName8 replaceObjectAtIndex:itemNr-100 withObject: @"1"  ];
        
        [self createListoItemsSlidersAndInterior];
        
        [self createConfigViewItemList];
        
        
        
        
    }

    
    
    


    //[self.arrayName5 replaceObjectAtIndex:tag-1600 withObject: [ [NSString alloc] initWithFormat:@"%.1f", LatArm  ] ];


}



- (void)actionConnectorOnOff:(UIButton*)sender {
    
    
    
    //UIButton *perfButton = (UIButton *)sender;
    
    
    
    float itemNr = sender.tag;
    
    //NSLog (@"itemNr %@ ", [ [NSString alloc] initWithFormat:@"%.0f ", itemNr]);
    
    
    if  ([[self.arrayName16 objectAtIndex: itemNr-0 ] doubleValue] >= 1) {
        
        
        [self.arrayName16 replaceObjectAtIndex:itemNr-0 withObject: @"0"  ];
        
        [self createListoItemsSlidersAndInterior];
        
        [self createConfigViewItemList];
        
        
        
        
    }else{
        
        [self.arrayName16 replaceObjectAtIndex:itemNr-0 withObject: @"1"  ];
        
        [self createListoItemsSlidersAndInterior];
        
        [self createConfigViewItemList];
        
        
        
        
    }
    
    
    
    
    
    
    //[self.arrayName5 replaceObjectAtIndex:tag-1600 withObject: [ [NSString alloc] initWithFormat:@"%.1f", LatArm  ] ];
    
    
}





// **************************************************************************************************************************************************************************
// *************************************************************************************************************************************************************************
// *************************************************************************************************************************************************************************
// *************************************************************************************************************************************************************************


- (void) makeConfigButtons {
    
    //NSLog(@"makeConfigButtons");
    //NSLog (@" makeConfigButtonsbutton count %d" , arrayConfigurations.count );
    
    for(UIView *subview in [_viewConfigButtons subviews]) {
        [subview removeFromSuperview];
    }
    
    _viewConfigButtons.frame = CGRectMake(_viewConfigButtons.frame.origin.x, _viewConfigButtons.frame.origin.y, _viewConfigButtons.frame.size.width, arrayConfigButtons.count * 51);
    
    _viewSelectOptions.frame = CGRectMake(_viewSelectOptions.frame.origin.x, _viewConfigButtons.frame.origin.y + _viewConfigButtons.frame.size.height, _viewSelectOptions.frame.size.width, _viewSelectOptions.frame.size.width);
    
    // load array with configurations
    [arrayConfigurations setArray: [[[NSUserDefaults standardUserDefaults] objectForKey: [NSString stringWithFormat:@"arrayConfigurations%@", AC_Type] ] mutableCopy]];
    [arrayConfigButtons setArray: [[[NSUserDefaults standardUserDefaults] objectForKey: [NSString stringWithFormat:@"arrayConfigButtons%@", AC_Type] ] mutableCopy]];
    
    
    //NSLog(@"makeConfigButtons for actype %@  count %d", ACType, arrayConfigButtons.count );
    
    
    for (int i = 1; i < arrayConfigButtons.count  ; i++) {
        
        //NSLog (@" btn.tag = configNumber  %d" ,configNumber );
        
        // make button to change Seat Symbol
        
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        btn.frame = CGRectMake(15, 5 + ((i-1) * 60) , 340, 57);
        
        [btn addTarget:self
                action:@selector(actionSetConfiguration:)
      forControlEvents:UIControlEventTouchUpInside];
        
        // name the button
        btn.tag = i ;
        btn.backgroundColor = [UIColor clearColor];
        btn.hidden = NO;
        [btn  setBackgroundImage:[UIImage imageNamed: @"button generic dark.png"] forState:UIControlStateNormal];
        
        
        NSString *configNameSaved = [arrayConfigurations objectAtIndex: i  ] ; // get actual config name
        [btn setTitle:configNameSaved forState:UIControlStateNormal];
        int savedConfigNumber = [[arrayConfigButtons objectAtIndex: i  ] doubleValue]; // get actual confi number saved
        
        
        //NSLog(@"tag title   %d  - %@" , i ,configNameSaved );
        if (configuration == savedConfigNumber) {
            [btn  setBackgroundImage:[UIImage imageNamed: @"button generic yellow.png"] forState:UIControlStateNormal];
        }
        
        [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        btn.titleLabel.font = [UIFont systemFontOfSize:15];
        
        [_viewConfigButtons addSubview:btn];
        
    }
    
    
    return;
    
}

- (void) actionSetConfiguration :(UIButton*)sender {
    
    //NSLog(@"old configuration  %d" , configuration);
    
    activeConfigButton = sender.tag;
    
    configuration = activeConfigButton;
    
    [self setConfiguration];
    
    [self setCGenvelope];
    
     [[EquipPackagesManager sharedInstance] resetPackageForKey:Flight.text fromConfig:configuration-1];
    
    [self searchbutSelHeli];
    
    [self SaveValues];
    
    [self MainRoutine];
    
}


- (void) setDefaultsForConfig {
    
   

    
    linePilot = [[_arrayName23 objectAtIndex: 27 ] intValue];
    
    fuelUnits = [_arrayName21 objectAtIndex: 15 ];
    
    [tempArraySeatWgt removeAllObjects];
    [tempArraySeatName removeAllObjects];
    
    
    if ([fuelUnits isEqualToString:@"lbs"]) {
        _inputSpecificFuelMassPerVolume.text = [_arrayName21 objectAtIndex: 20 ] ; // lbs/gal
    }else{
        _inputSpecificFuelMassPerVolume.text = [_arrayName21 objectAtIndex: 22 ] ; // kg/ltr
        
    }
    
        [self setDefaultsForSetup];
    
}


- (void) setDefaultsForSetup {
    
    // set this only when USER is changed  = on initial start or reset
    

     _inputQuickLoadPreset.text = [_arrayName21 objectAtIndex: 33 ];
    
    if ([[_arrayName21 objectAtIndex: 24 ] isEqualToString:@"volume"]) {
        _segmentFuelVolumeOrMass.selectedSegmentIndex = 0;
    }else{
        _segmentFuelVolumeOrMass.selectedSegmentIndex = 1;
        
    }
    
    if ([[_arrayName21 objectAtIndex: 35 ] isEqualToString:@"Individual"]) {
        _segmentPlanMode.selectedSegmentIndex = 0;
    }else{
        _segmentPlanMode.selectedSegmentIndex = 1;
        
    }
    
    
    
    if ([[_arrayName21 objectAtIndex: 41 ] isEqualToString:@"off"]) {
        _segmentSwapMode.selectedSegmentIndex = 0;
    }else{
        _segmentSwapMode.selectedSegmentIndex = 1;
        
    }
    
    if ([[_arrayName21 objectAtIndex: 43 ] isEqualToString:@"q"]) {
        _segmentSeatLoadOptions.selectedSegmentIndex = 0;
    }else{
        _segmentSeatLoadOptions.selectedSegmentIndex = 1;
        
    }
    
    
   
    if ([[_arrayName21 objectAtIndex: 45 ] isEqualToString:@"ID"]) {
        _segmentNamesOnSeats.selectedSegmentIndex = 0;
      
    }
    if ([[_arrayName21 objectAtIndex: 45 ] isEqualToString:@"WID"]) {
        _segmentNamesOnSeats.selectedSegmentIndex = 1;
       
    }
    if ([[_arrayName21 objectAtIndex: 45 ] isEqualToString:@"WN"]) {
        _segmentNamesOnSeats.selectedSegmentIndex = 2;
        
    }
    
    if ([[_arrayName23 objectAtIndex: 34 ] isEqualToString:@"off"]) {
        _segmentCGAutoCheck.selectedSegmentIndex = 0;
    }else{
        _segmentCGAutoCheck.selectedSegmentIndex = 1;
        
    }
    
  
   
    
}



- (void) setFuelTankSettings {
    
    //NSLog(@"setFuelTankSettings tankCapacityVolume %.0f", tankCapacityVolume);
    
    fuelUnits = [_arrayName21 objectAtIndex: 15 ];
    
    tankCapacityVolume = [[_arrayName21 objectAtIndex: 17 ] floatValue];
    
    if (_segmentFuelVolumeOrMass.selectedSegmentIndex == 0) {
       fuelEnterMode = @"volume";
    }else{
       fuelEnterMode = @"mass";
    }
    
    _sliderFuelMain1.maximumValue = tankCapacityVolume;
    _sliderFuelLanding.maximumValue = tankCapacityVolume - (tankCapacityVolume * 0.05);
    
    
   
    
    if (_sliderFuelMain1.value >  tankCapacityVolume) {
        _sliderFuelMain1.value =  tankCapacityVolume;
    }
    
    inputFuelFlowOverride.text = [_arrayName21 objectAtIndex: 27 ];
    _sliderFuelMain1.value = [[_arrayName21 objectAtIndex: 29 ] floatValue] / [_inputSpecificFuelMassPerVolume.text floatValue];
    _sliderFuelLanding.value = [[_arrayName21 objectAtIndex: 31 ] floatValue];
    
    
    //NSLog(@"set inputFuelFlowOverride  %@" , inputFuelFlowOverride.text);
    
    
    //NSLog(@"set _sliderFuelMain1  %.0f" , _sliderFuelMain1.value);

}

- (void) setOptionalButtons {
    
    
    if ( ![[_arrayName23 objectAtIndex: 15 ] isEqualToString:@"yes"]) {
        _optionalButtonExportLoadManifestAsPDF.hidden = YES;
    }else{
        _optionalButtonExportLoadManifestAsPDF.hidden = NO;
        
    }
    
    if ( ![[_arrayName23 objectAtIndex: 17 ] isEqualToString:@"yes"]) {
        _optionalButtonExportSummaryAsPDF.hidden = YES;
    }else{
        _optionalButtonExportSummaryAsPDF.hidden = NO;
        
    }

    
    
    
    if ( ![[_arrayName23 objectAtIndex: 19 ] isEqualToString:@"yes"]) {
        _optionalButtonEditConfigurations.hidden = YES;
    }else{
        _optionalButtonEditConfigurations.hidden = NO;
        
    }
    
    
    
}

- (void) setItemsFlightLegData  {
    
    // handle Elements for Guidance
    
    
    if ([[_arrayName23 objectAtIndex:40]length] <1) {
        return;
    }    
    
    itemsGuidance = [[NSArray alloc] init];
    
    NSArray *componentItems  = [[_arrayName23 objectAtIndex:40] componentsSeparatedByString:@"x"];
    
    //NSLog(@"componentItems %@", componentItems);
    
       
    NSArray *itemsOnOff = [[componentItems objectAtIndex:0] componentsSeparatedByString:@"_"];
    NSArray *itemsCellHeight  = [[componentItems objectAtIndex:1] componentsSeparatedByString:@"_"];
    itemsGuidance  = [[componentItems objectAtIndex:2] componentsSeparatedByString:@"_"];

    float yPosFrame = 50;
    
    for (int i = 0; i<itemsOnOff.count; i++) {
        
        UIView *viewElement = (UIButton*)[_viewLegDataItems viewWithTag: 10000 + i ];
        
        if ([[itemsOnOff objectAtIndex:i] isEqualToString:@"1"]) {
            viewElement.hidden = NO;           
            
            float CellHeight = [[itemsCellHeight objectAtIndex: i]floatValue];
            
            viewElement.center = CGPointMake( viewElement.center.x ,  yPosFrame);
           
             yPosFrame = yPosFrame + CellHeight/2;
            
            if (i < itemsOnOff.count - 1) {
                
                float CellHeight = [[itemsCellHeight objectAtIndex: i+1]floatValue];
                yPosFrame = yPosFrame + CellHeight/2;
            }
            
        }else{
            viewElement.hidden = YES;
        }
    }
    
    
    [_scrollViewLegData setContentSize:CGSizeMake(_viewLegData.frame.size.width, yPosFrame + 250)];
    
    
   
    
}


- (void) setBasicsForConfiguration {
    
    //NSLog(@"setBasicsForConfiguration %.0f fuelVolume", fuelVolume);
    
    [self setItemsFlightLegData];
    
    
    
    _viewHeliCenterLabels.frame = CGRectMake(0, 0, 232, 556);
    
    [self setOptionalButtons];
  
    [self setGuidanceNeutral];
    
    [self setInteriorMeasures];
    
    [self setFuelTankSettings];
    
    
    datepick.minuteInterval = [[_arrayName23 objectAtIndex:7] integerValue];
    
    
    float zoomScale = 1.0;
    _scrollViewHeliCenter.zoomScale = zoomScale;
    _scrollViewHeliCenter.contentOffset = CGPointMake(0, 0);
    
    
    // standard mode ********************************************************************************************************************
    
    [_scrollViewHeliCenter setContentSize:CGSizeMake(260, 456 + 150)];
    
    if (_segmentPlanMode.selectedSegmentIndex == 0) {
        
        _viewButtonSet1.hidden = NO;
        _viewButtonSet2.hidden = YES;
        
        _viewStationsWindow.hidden = NO;
        _viewLegData.hidden = YES;
        
        float yUpHeliIndividual = [[_arrayName21 objectAtIndex:37] floatValue];
        
        //yUpHeliIndividual = 55;
        
        
        
        
        if (flagIsLandscape == 1) {
            
            float xMove = 0;
            float yMove = 0;
            _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 + yMove, 260, 456 + 150);
            _scrollViewHeliCenter.frame = CGRectMake( 0, 0 , _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
            _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
            _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y + yUpHeliIndividual);
            
            _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551, _viewButtonsFuelAndConfig.frame.size.width, 198 );
            
            if (flagFuelVisisble == 1) {
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 , _viewButtonsFuelAndConfig.frame.size.width, 230 );
            }else{
                
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 + 167, _viewButtonsFuelAndConfig.frame.size.width, 230 );
            }

            
        }else{
            
            
            float xMove = 0;
            float yMove = -57;
            _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 + yMove, 260, 456 + 150);
            _scrollViewHeliCenter.frame = CGRectMake( 0, 0 , _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
            _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
            _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y + yUpHeliIndividual);
            
            
            _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49, _viewButtonsFuelAndConfig.frame.size.width, 198);
            
            
            if (flagFuelVisisble == 1) {
                
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 , _viewButtonsFuelAndConfig.frame.size.width, 198);
                
            }else{
                
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 + 157, _viewButtonsFuelAndConfig.frame.size.width, 35);
                
            }
            
            
        }
        
    }
    
    
    
    // plan mode here we are  ********************************************************************************************************************
    
    if (_segmentPlanMode.selectedSegmentIndex == 1) {
        
        _viewButtonSet1.hidden = YES;
        _viewButtonSet2.hidden = NO;
        
        _viewStationsWindow.hidden = YES;
        _viewLegData.hidden = NO;
        
        [viewMain bringSubviewToFront:_viewLegData];
        [viewMain bringSubviewToFront:_viewHelicopterInCenter];
        [viewMain bringSubviewToFront:_viewButtonsFuelAndConfig];
        
        
       

        float yUpHeliPlan = [[_arrayName21 objectAtIndex:39] floatValue];
        
        yUpHeliPlan = 10;
        
        
        if (flagIsLandscape == 1) {
            
            float xMove = 110;
            float yMove = 0;
            _viewHelicopterInCenter.frame = CGRectMake( 207 + xMove, 125 + yMove, 300, 456 + 150);
            _scrollViewHeliCenter.frame = CGRectMake( 0, 0 + yUpHeliPlan, _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
            _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
            _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
            
           
            
            _viewLegData.frame = CGRectMake(0, 100, 290, 663);
            _viewLegDataItems.frame = CGRectMake(0, -8, _viewLegData.frame.size.width, _viewLegDataItems.frame.size.height);
            _scrollViewLegData.frame = CGRectMake(0, 42, _viewLegData.frame.size.width, _viewLegData.frame.size.height - 30);
            
         
            
            if (flagFuelVisisble == 1) {
                 _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 , _viewButtonsFuelAndConfig.frame.size.width, 230 );
            }else{
                
                 _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 + 167, _viewButtonsFuelAndConfig.frame.size.width, 230 );
            }
            
            
            
            
        }else{
            
            
            
            float yUpHeliIndividual = -55;
            
            
            float xMove = 110;
            float yMove = -57;
            _viewHelicopterInCenter.frame = CGRectMake( 207 + xMove, 125 + yMove, 300, 456 + 150);
            _scrollViewHeliCenter.frame = CGRectMake( 0, 0+ yUpHeliPlan +30 , _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
            _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
            _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y + yUpHeliIndividual);
            
           
            
            _viewLegData.frame = CGRectMake(0, 117 - 49, 290, 625);
            _viewLegDataItems.frame = CGRectMake(0, -8, _viewLegData.frame.size.width, _viewLegDataItems.frame.size.height);
            _scrollViewLegData.frame = CGRectMake(0, 42, _viewLegData.frame.size.width, _viewLegData.frame.size.height - 30);

           
            
            
            if (flagFuelVisisble == 1) {

                 _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 , _viewButtonsFuelAndConfig.frame.size.width, 198);
                
            }else{
                
                 _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 + 157, _viewButtonsFuelAndConfig.frame.size.width, 35);
                
            }
            
            
          
        }
        
        
        
        if (flagShowSliders == 1) {
            
            zoomScale = 1.0;
            _scrollViewHeliCenter.zoomScale = zoomScale;
            _scrollViewHeliCenter.contentOffset = CGPointMake(0, 0);
            
            [_buttonToggleLegWeights setTitle:@"Show Leg Info" forState:UIControlStateNormal];
            
            
            _viewStationsWindow.hidden = NO;
            _viewLegData.hidden = YES;
            
            float yUpHeliIndividual = [[_arrayName21 objectAtIndex:37] floatValue];
            
            yUpHeliIndividual = 55;
            
            if (flagIsLandscape == 1) {
                
                float xMove = 0;
                float yMove = -40;
                _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 + yMove, 260, 456 + 150);
                _scrollViewHeliCenter.frame = CGRectMake( 0, 0 , _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
                _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
                _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y + yUpHeliIndividual);
                
                 //_viewHelicopterInCenter.layer.transform = CATransform3DMakeScale(0.5, 0.5, 0);
                
                //NSLog(@"setting zoom scale");
                
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551, _viewButtonsFuelAndConfig.frame.size.width, 198 );
                
                
                if (flagFuelVisisble == 1) {
                    _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 , _viewButtonsFuelAndConfig.frame.size.width, 230 );
                }else{
                    
                    _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 + 167, _viewButtonsFuelAndConfig.frame.size.width, 230 );
                }
                
            }else{
                
                
                float xMove = 0;
                float yMove = -57;
                _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 + yMove, 260, 456 + 150);
                _scrollViewHeliCenter.frame = CGRectMake( 0, 0 , _viewHelicopterInCenter.frame.size.width, _viewHelicopterInCenter.frame.size.height);
                _scrollViewHeliCenter.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y);
                _viewHeliCenterLabels.center = CGPointMake( _viewHelicopterInCenter.frame.size.width / 2, _scrollViewHeliCenter.center.y + yUpHeliIndividual);
                
                
                _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49, _viewButtonsFuelAndConfig.frame.size.width, 198);
                
                
                
                if (flagFuelVisisble == 1) {
                    
                    _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 , _viewButtonsFuelAndConfig.frame.size.width, 198);
                    
                }else{
                    
                    _viewButtonsFuelAndConfig.frame = CGRectMake(0, 551 -49 + 157, _viewButtonsFuelAndConfig.frame.size.width, 35);
                    
                }
                
            }

        }
        
        if (flagShowSliders == 0) {
            
            [_buttonToggleLegWeights setTitle:@"Enter Station Weights" forState:UIControlStateNormal];
            
        }
        
        
        
        
    }
    
    
    
   
    
    self.scrollViewHeliCenter.delegate = self;
 
   
    
    
    
    _viewStationsSlider.frame = CGRectMake(0.0, 0, 643, 900);
    
    _scrollViewStations.frame = CGRectMake(0.0,0 , 643, sliderWindowHeight);
    
    [_scrollViewStations setScrollEnabled:YES];
    
    [_scrollViewStations setContentSize:CGSizeMake(643, 900  )];

    
    
    
}


- (void) setInteriorMeasures {
    
    //NSLog(@"1 setInteriorMeasures");
    //NSLog(@"2 setInteriorMeasures _arrayName22 %@", _arrayName22);
    
    LongArmFrontSeat = [[_arrayName22 objectAtIndex: 5 ]floatValue] ;
    
    LongArmRearSeat = [[_arrayName22 objectAtIndex: 7 ]floatValue] ;
    
    LatArmLeftSeat = [[_arrayName22 objectAtIndex: 9 ]floatValue] ;
    
    LatArmRightSeat = [[_arrayName22 objectAtIndex: 11 ]floatValue] ;
    
    
    _iacMeasureFrontSeatsY.text =   [_arrayName22 objectAtIndex: 14 ];
    _iacMeasureRearSeatsY.text =    [_arrayName22 objectAtIndex: 16 ];
    
    _iacSeatWidth.text =            [_arrayName22 objectAtIndex: 18 ];
    _iacSeatHeight.text =           [_arrayName22 objectAtIndex: 20 ];
    
    _iacLatCenter.text =            [_arrayName22 objectAtIndex: 22 ];
    _iacLatRight.text =             [_arrayName22 objectAtIndex: 24 ];
    
    _iacACX.text =                  [_arrayName22 objectAtIndex: 26 ];
    _iacACY.text =                  [_arrayName22 objectAtIndex: 28 ];
    _iacACwidth.text =              [_arrayName22 objectAtIndex: 30 ];
    _iacACheight.text =             [_arrayName22 objectAtIndex: 32 ];
    
    
    
    _viewMeasureFrontSeats.frame = CGRectMake(_viewMeasureFrontSeats.frame.origin.x, [_iacMeasureFrontSeatsY.text floatValue], _viewMeasureFrontSeats.frame.size.width, _viewMeasureFrontSeats.frame.size.height);
    _viewMeasureRearSeats.frame = CGRectMake(_viewMeasureRearSeats.frame.origin.x, [_iacMeasureRearSeatsY.text floatValue], _viewMeasureRearSeats.frame.size.width, _viewMeasureRearSeats.frame.size.height);
    
    _viewSeatSize.frame = CGRectMake(_viewSeatSize.frame.origin.x, _viewSeatSize.frame.origin.y, [_iacSeatWidth.text floatValue] , [_iacSeatHeight.text floatValue]);
    
    _viewMeasureCenter.frame = CGRectMake([_iacLatCenter.text floatValue], _viewMeasureCenter.frame.origin.y, _viewMeasureCenter.frame.size.width , _viewMeasureCenter.frame.size.height);
    
    _viewMeasureLatRight.frame = CGRectMake([_iacLatCenter.text floatValue] + [_iacLatRight.text floatValue], _viewMeasureLatRight.frame.origin.y, _viewMeasureLatRight.frame.size.width , _viewMeasureLatRight.frame.size.height);

    
    _ACtopView.frame = CGRectMake([_iacACX.text floatValue], [_iacACY.text floatValue], [_iacACwidth.text floatValue], [_iacACheight.text floatValue]);
    
   
    
    return;
    
    
}


- (void) setConfiguration {
    
    //NSLog(@"setConfiguration ");
    
    flagRefreshSpecialEquipmentList = 1;
    
    _inputPaxOnBoard.text = @"";
    
    _dropDownBaseID.text = @"";
    
    
    for (int i = 1; i < arrayConfigurations.count+1  ; i++) {
        
        UIButton* btn = (UIButton*)[_viewConfigButtons viewWithTag: i ];
        UIImage *btnImage = [UIImage imageNamed:@"button generic dark.png"];
        [btn  setBackgroundImage:btnImage forState:UIControlStateNormal];
      }
    
    
    
   // retain fuel weight
    
    float presentFuel = _sliderFuelMain1.value;
    float presentFuelLD = _sliderFuelLanding.value;
    
    // pilot name to retain crew weights
   
    NSString *pilotName = [_arrayName7 objectAtIndex:linePilot];
   
    NSString *pilotWeight = [_arrayName2 objectAtIndex:linePilot];
    
    NSString *copilotName = [_arrayName7 objectAtIndex:linePilot+1];
   
    NSString *copilotWeight = [_arrayName2 objectAtIndex:linePilot+1];
    
    NSString *mcmName = [_arrayName7 objectAtIndex:lineMCM];
    
    NSString *mcmWeight = [_arrayName2 objectAtIndex:lineMCM];
    
    

    //NSLog(@"pilotName %@ ", pilotName);
    
    
    // color the active button
    
    UIButton* btn = (UIButton*)[_viewConfigButtons viewWithTag: activeConfigButton];
    
    UIImage *btnImage = [UIImage imageNamed:@"button generic blue.png"];
    
    
    [btn  setBackgroundImage:btnImage forState:UIControlStateNormal];
    
    
    [self loadArrayListo];
   
    [self createSpecialEquipListItems];
   
    [self createListoItemsSlidersAndInterior];
    
    [self computeSpecialEquipmentTotals];
    
    
    float lineCoPilot = linePilot +1;
    
    
    if ( [mcmWeight floatValue] > 1  ) {
        
        // change pilot name
        [_arrayName7 replaceObjectAtIndex:lineMCM withObject:mcmName];
        // change pilot name in  _viewStationsSlider
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+lineMCM];
        [valueField  setText: mcmName ];
        // change weight
        [_arrayName2 replaceObjectAtIndex:lineMCM withObject:mcmWeight];
        // get Arm Long
        NSString *arm = [_arrayName3 objectAtIndex:lineMCM];
        //NSLog(@"pilot arm %@", arm);
        
        // change moment
        [_arrayName4 replaceObjectAtIndex:lineMCM withObject: [[NSString alloc] initWithFormat:@"%.1f", [mcmWeight floatValue] * [arm floatValue]]  ];
        //NSLog(@"pilot momentLong %@", momentLong);
        // get Arm Lat
        NSString *armLat = [_arrayName5 objectAtIndex:lineMCM];
        //NSLog(@"pilot armLat %@", armLat);
        // change momentLat
        [_arrayName6 replaceObjectAtIndex:lineMCM withObject:[[NSString alloc] initWithFormat:@"%.1f", [mcmWeight floatValue] * [armLat floatValue]]  ];
        //NSLog(@"pilot momentLat %@", momentLat);
        // update weight label 1000
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000+lineMCM];
        [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [mcmWeight floatValue]]  ];
        // update slider
        UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  lineMCM];
        slider.value = [mcmWeight floatValue];
    }
    
    
  

    if ( [pilotWeight floatValue] > 1  ) {
        
        // change pilot name
        [_arrayName7 replaceObjectAtIndex:linePilot withObject:pilotName];
        // change pilot name in  _viewStationsSlider
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+linePilot];
        [valueField  setText: pilotName ];
        // change weight
        [_arrayName2 replaceObjectAtIndex:linePilot withObject:pilotWeight];
        // get Arm Long
        NSString *arm = [_arrayName3 objectAtIndex:linePilot];
        //NSLog(@"pilot arm %@", arm);
        
        // change moment
        [_arrayName4 replaceObjectAtIndex:linePilot withObject: [[NSString alloc] initWithFormat:@"%.1f", [pilotWeight floatValue] * [arm floatValue]]  ];
        //NSLog(@"pilot momentLong %@", momentLong);
        // get Arm Lat
        NSString *armLat = [_arrayName5 objectAtIndex:linePilot];
        //NSLog(@"pilot armLat %@", armLat);
        // change momentLat
        [_arrayName6 replaceObjectAtIndex:linePilot withObject:[[NSString alloc] initWithFormat:@"%.1f", [pilotWeight floatValue] * [armLat floatValue]]  ];
        //NSLog(@"pilot momentLat %@", momentLat);
        // update weight label 1000
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000+linePilot];
        [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [pilotWeight floatValue]]  ];
        // update slider
        UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  linePilot];
        slider.value = [pilotWeight floatValue];
    }
    
    
    if ( [copilotWeight floatValue] > 1  ) {
        
        // change pilot name
        [_arrayName7 replaceObjectAtIndex:lineCoPilot withObject:copilotName];
        
        // change pilot name in  _viewStationsSlider
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200+lineCoPilot];
        [valueField  setText: copilotName ];
        
        
        // change weight
        [_arrayName2 replaceObjectAtIndex:lineCoPilot withObject:pilotWeight];
        
        // get Arm Long
        NSString *arm = [_arrayName3 objectAtIndex:lineCoPilot];
        //NSLog(@"pilot arm %@", arm);
        
        
        // change moment
        [_arrayName4 replaceObjectAtIndex:lineCoPilot withObject: [[NSString alloc] initWithFormat:@"%.1f", [copilotWeight floatValue] * [arm floatValue]]  ];
        //NSLog(@"pilot momentLong %@", momentLong);
        
        
        
        
        // get Arm Lat
        NSString *armLat = [_arrayName5 objectAtIndex:lineCoPilot];
        //NSLog(@"pilot armLat %@", armLat);
        
        // change momentLat
        [_arrayName6 replaceObjectAtIndex:lineCoPilot withObject: [[NSString alloc] initWithFormat:@"%.1f", [copilotWeight floatValue] * [armLat floatValue]]  ];
        //NSLog(@"pilot momentLat %@", momentLat);
        
        
        // update weight label 1000
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000+lineCoPilot];
        [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [copilotWeight floatValue]]  ];
        
        
        // update slider
        UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag: lineCoPilot];
        slider.value = [copilotWeight floatValue];
        
        
        
    }
    
 
   
    _sliderFuelMain1.value = presentFuel;
    _sliderFuelLanding.value = presentFuelLD;

    [self addPerformanceButtons];
    
    [self MainRoutine];
    
    
    
    
}






- (void) animateCrossTOW {
    
    float xCGpos = leftBorderOfMeasureBox + ( (CGLongTOW -xAxisLeft) * xPixelFactor );
    float yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - weightTOW ) * yPixelFactor );
    
    crossTOW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
    
    
}

- (void) animateCrossZFW {
    
    float xCGpos = leftBorderOfMeasureBox + ( (CGLongZFW -xAxisLeft) * xPixelFactor );
    float yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - weightZFW ) * yPixelFactor );
    
    crossZFW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
    
    
}

- (void) animateCrossLDW {
    
    float xCGpos = leftBorderOfMeasureBox + ( (CGLongLDW -xAxisLeft) * xPixelFactor );
    float yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - weightLDW ) * yPixelFactor );
    
    crossLDW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}





- (void) animateCrossTOWforMail {
    
    float xCGpos = leftBorderOfMeasureBox2 + ( (CGLongTOW -xAxisLeft2) * xPixelFactor2 );
    float yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - weightTOW ) * yPixelFactor2 );
    
    _crossMailTow.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
    
    
    
    return;
    
    
    
}

- (void) animateCrossZFWforMail {
    
    
    float xCGpos = leftBorderOfMeasureBox2 + ( (CGLongZFW -xAxisLeft2) * xPixelFactor2 );
    float yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - weightZFW ) * yPixelFactor2 );
    
    
    
    _crossMailZFW.center = CGPointMake( xCGpos, yCGpos);
    
    
    
    
    
    
    return;
    
    
    
}

- (void) animateCrossLDWforMail {
    
    
    float xCGpos = leftBorderOfMeasureBox2 + ( (CGLongLDW -xAxisLeft2) * xPixelFactor2 );
    float yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - weightLDW ) * yPixelFactor2 );
    
    
    
    _crossMailLDW.center = CGPointMake( xCGpos, yCGpos);
    
    
    
    
    
    
    return;
    
    
    
}



- (void) animateCrossLAT {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT + ( (CGLATTOW -xAxisLeftLAT) * xPixelFactorLAT );
    float yCGpos = topBorderOfMeasureBoxLAT  + (  (yAxisTopLAT - weightTOW ) * yPixelFactorLAT );
    
    
    
    
    
    //NSLog (@"1 leftBorderOfMeasureBoxLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", leftBorderOfMeasureBoxLAT]);
    
    
    //NSLog (@"1 xAxisLeftLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xAxisLeftLAT]);
    
    //NSLog (@"1 xPixelFactorLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xPixelFactorLAT]);
    
    //NSLog (@"1 xCGpos %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xCGpos]);
    
    crossLatTOW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}

- (void) animateCrossLATLDW {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT + ( (CGLATLDW -xAxisLeftLAT) * xPixelFactorLAT );
    float yCGpos = topBorderOfMeasureBoxLAT  + (  (yAxisTopLAT - weightLDW ) * yPixelFactorLAT );
    
    
    //NSLog (@"1 leftBorderOfMeasureBoxLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", leftBorderOfMeasureBoxLAT]);
    
    
    //NSLog (@"1 xAxisLeftLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xAxisLeftLAT]);
    
    //NSLog (@"1 xPixelFactorLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xPixelFactorLAT]);
    
    //NSLog (@"1 xCGpos %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xCGpos]);
    
    _crossLatLDW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}


- (void) animateCrossLATZFW {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT + ( (CGLATZFW -xAxisLeftLAT) * xPixelFactorLAT );
    float yCGpos = topBorderOfMeasureBoxLAT  + (  (yAxisTopLAT - weightZFW ) * yPixelFactorLAT );
    
    
    //NSLog (@"1 leftBorderOfMeasureBoxLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", leftBorderOfMeasureBoxLAT]);
    
    
    //NSLog (@"1 xAxisLeftLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xAxisLeftLAT]);
    
    //NSLog (@"1 xPixelFactorLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xPixelFactorLAT]);
    
    //NSLog (@"1 xCGpos %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xCGpos]);
    
    _crossLatZFW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}



- (void) animateCrossLATforMail {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT2 + ( (CGLATTOW -xAxisLeftLAT2) * xPixelFactorLAT2 );
    
    //NSLog (@"2 leftBorderOfMeasureBoxLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", leftBorderOfMeasureBoxLAT2]);
    
    
    //NSLog (@"2 xAxisLeftLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xAxisLeftLAT2]);
    
    //NSLog (@"2 xPixelFactorLAT2 %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xPixelFactorLAT2]);
    
    //NSLog (@"2 xCGpos %@ ", [ [NSString alloc] initWithFormat:@"%.3f ", xCGpos]);
    
    
    float yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - weightTOW ) * yPixelFactorLAT2 );
    
    _crossMailLAT.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}

- (void) animateCrossLATforMail_LDW {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT2 + ( (CGLATLDW -xAxisLeftLAT2) * xPixelFactorLAT2 );
    
    
    
    float yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - weightLDW ) * yPixelFactorLAT2 );
    
    _crossMailLATLDW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}

- (void) animateCrossLATforMail_ZFW {
    
    
    
    
    float xCGpos = leftBorderOfMeasureBoxLAT2 + ( (CGLATZFW -xAxisLeftLAT2) * xPixelFactorLAT2 );
    
    
    
    float yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - weightZFW ) * yPixelFactorLAT2 );
    
    _crossMailLATZFW.center = CGPointMake( xCGpos, yCGpos);
    
    return;
    
}






- (void) drawCGenvelope {
    
    colorModeForCGenvelope =  0;
    
    for(UIView *subview in [_viewCGenvelopeFrame subviews]) {
        [subview removeFromSuperview];
    }
    
    [self.viewCGenvelopeFrame.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    _viewMeasureCGenvelope.backgroundColor = [UIColor clearColor];
    
    if (colorModeForCGenvelope == 0) { _viewCGenvelopeFrame.backgroundColor = [UIColor clearColor];  }else{ _viewCGenvelopeFrame.backgroundColor = [UIColor whiteColor];    }
    
    
    
    // CG x and y labels
    xAxisLeft     = [[self.arrayCG1 objectAtIndex: 0 ] floatValue];
    xAxisRight    = [[self.arrayCG1 objectAtIndex: 1 ] floatValue];
    float xIncrement    = [[self.arrayCG1 objectAtIndex: 2 ] floatValue];
    
    yAxisBottom   = [[self.arrayCG1 objectAtIndex: 3 ] floatValue];
    yAxisTop      = [[self.arrayCG1 objectAtIndex: 4 ] floatValue];
    float yIncrement    = [[self.arrayCG1 objectAtIndex: 5 ] floatValue];
    
    float fontSize     = [[self.arrayCG1 objectAtIndex: 6 ] floatValue];
    
    
    // statics
    float labelWidth = 90;
    float labelHeight = 15;
    float xPos = 0, yPos = 0;
    
    leftBorderOfMeasureBox =   _viewMeasureCGenvelope.center.x - (_viewMeasureCGenvelope.layer.frame.size.width / 2.0) ;
    measureBoxWidth = _viewMeasureCGenvelope.layer.frame.size.width;
    
    float xIncrementValue = (xAxisRight - xAxisLeft) / xIncrement;
    float xIncrementPixel = measureBoxWidth / xIncrement;
    
    
    topBorderOfMeasureBox =   _viewMeasureCGenvelope.center.y - (_viewMeasureCGenvelope.layer.frame.size.height / 2.0) ;
    measureBoxHeight = _viewMeasureCGenvelope.layer.frame.size.height;
    
    float yIncrementValue = (yAxisTop - yAxisBottom) / yIncrement;
    float yIncrementPixel = measureBoxHeight / yIncrement;
    
    
    // make X labels
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        if (xAxisLeft + ( xIncrementValue * i) > xAxisRight) {
            // plot labels only if fit in frame
            continue;
        }
        
        
        xPos =  leftBorderOfMeasureBox + (xIncrementPixel * i);
        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(xPos-(labelWidth/2), topBorderOfMeasureBox - labelHeight-2, labelWidth, labelHeight)];
        label.textAlignment = NSTextAlignmentCenter;
        if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
        label.font = [UIFont boldSystemFontOfSize:fontSize];
        
        NSString *labelFormat;
        if ([unitsWeight.text isEqualToString:@"kg"]) {
            labelFormat = @"%.0fmm";
        }else{
            
            labelFormat = @"%.0f In";
        }
        
        if (i == 0) {
            NSString *labelText = [ [NSString alloc] initWithFormat:labelFormat, xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];

        }else{
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];

        }
        
        
        [_viewCGenvelopeFrame addSubview: label];
    }
    
    
    
    // make X lines
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        xPos =  leftBorderOfMeasureBox + (xIncrementPixel * i);
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( xPos, topBorderOfMeasureBox )];
        [path addLineToPoint:CGPointMake( xPos, topBorderOfMeasureBox+ measureBoxHeight  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame.layer addSublayer:shapeLayer];
        
    }
    
    
    // make y labels
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        if (i == 0) { // make first label the LBS label
            
            
            yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox-labelWidth-4, yPos-(labelHeight/2)+(yIncrementPixel/3), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText;
            
            if ([unitsWeight.text isEqualToString:@"kg"]) {
                labelText = @"kg";
            }else{
                
                labelText = @"[lbs]";
            }

            [label  setText: labelText  ];
            [_viewCGenvelopeFrame addSubview: label];
            
            
            
        }else{
            
            yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox-labelWidth-4, yPos-(labelHeight/2), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", yAxisTop - ( yIncrementValue * i)  ];
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame addSubview: label];
        }
        
    }
    
    
    // make y lines
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
        
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( leftBorderOfMeasureBox, yPos )];
        [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, yPos  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame.layer addSublayer:shapeLayer];
    }
    
    
    
    // make frame
    
    UIBezierPath *path = [UIBezierPath bezierPath];
    [path moveToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox )];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, topBorderOfMeasureBox  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, topBorderOfMeasureBox+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox  )  ];
    CAShapeLayer *shapeLayer = [CAShapeLayer layer];
    shapeLayer.path = [path CGPath];
    if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor whiteColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
    shapeLayer.lineWidth = 1.5;
    shapeLayer.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame.layer addSublayer:shapeLayer];
    
    
    
    
    float numberOfPoints = 0;
    xPixelFactor = measureBoxWidth  / (xAxisRight-xAxisLeft);
    yPixelFactor = measureBoxHeight / (yAxisTop-yAxisBottom);
    
    // ******************************************************************************************************
    // ******************************************************************************************************
    
    // cge1
    // dotted envelope 1 for margin
    
    // ******************************************************************************************************
    // ******************************************************************************************************
    
    

    if ([[_arrayName23 objectAtIndex:25] isEqualToString:@"yes"]) {
        
        //NSLog(@"margin ************************");
        
        // make dotted CG line
        
        float marginCGx = [_inputSafetyMargin.text floatValue] * xPixelFactor;
        
       
        
        UIBezierPath *pathCGline = [UIBezierPath bezierPath];
        
        numberOfPoints = 0;
        
        int flagfirstMoveToRight = 0;
        
        for (int i = 7; i < _arrayCG1MarginLine.count ; i++) {
            
            NSString *Xstring     = [_arrayCG1MarginLine objectAtIndex: i ];
            NSString *searchKeyword = @"/";
            NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
            
            if ([Xstring isEqualToString: @""]) {
                break;
            }
            
            NSString *XstringNext     = [_arrayCG1MarginLine objectAtIndex: i+1];
            if ([XstringNext isEqualToString: @""]) {
                XstringNext = Xstring;
            }
            
            searchKeyword = @"/";
            NSRange rangeOfYourStringNext = [XstringNext rangeOfString:searchKeyword];
            
            xVal = @"";
            yVal = @"";
            
            NSString *xValNext = @"";
            NSString *yValNext = @"";
            
            
            float xCGpos = 0;
            float yCGpos = 0;
            
            float xCGposNext = 0;
            float yCGposNext = 0;

            
            float xCGposMargined = 0;
            float yCGposMargined = 0;

            
            
            if(rangeOfYourString.location == NSNotFound)
            {
                // error condition — the text searchKeyword wasn't in 'string'
            }
            else{
                
                 //NSLog(@"------");
                
                
                xVal = [Xstring substringToIndex:rangeOfYourString.location];
                yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
                
                xValNext = [XstringNext substringToIndex:rangeOfYourStringNext.location];
                yValNext = [XstringNext substringFromIndex:rangeOfYourStringNext.location+1];
                
                //NSLog(@"xVal %@", xVal);
                //NSLog(@"xValNext %@", xValNext);
                
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                
                xCGposNext = leftBorderOfMeasureBox + ( ([xValNext floatValue]-xAxisLeft) * xPixelFactor );
                yCGposNext = topBorderOfMeasureBox  + (  (yAxisTop - [yValNext floatValue]) * yPixelFactor );
                
               
                int caseIsFound = 0;
                
                
                //NSLog(@"xCGpos %f", xCGpos);
                
                if (xCGpos < xCGposNext & yCGpos > yCGposNext) {
                    caseIsFound = 1;                    
                    //NSLog(@"moving to the right and up" );
                    xCGposMargined = xCGpos + marginCGx ;
                    yCGposMargined = yCGpos;
                }
                
                if (xCGpos == xCGposNext & yCGpos > yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"not moving and up" );
                    xCGposMargined = xCGpos + marginCGx ;
                    yCGposMargined = yCGpos;
                }
                
                if (xCGpos == xCGposNext & yCGpos < yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"not moving and down" );
                    xCGposMargined = xCGpos - marginCGx;
                    yCGposMargined = yCGpos;
                }
                
                
                if (xCGpos < xCGposNext & yCGpos == yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving to the right and steady" );
                    xCGposMargined = xCGpos + marginCGx;
                    yCGposMargined = yCGpos;
                    if (flagfirstMoveToRight == 0) {
                        //NSLog(@"moving to the right and steady first time" );
                        xCGposMargined = xCGpos + marginCGx;
                        yCGposMargined = yCGpos;
                        flagfirstMoveToRight = 1;
                    }else{
                        //NSLog(@"moving to the right and steady second time " );
                        xCGposMargined = xCGpos - marginCGx;
                        yCGposMargined = yCGpos;
                    }
                }
                
                
                if (xCGpos < xCGposNext & yCGpos < yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving to the right and down" );
                    xCGposMargined = xCGpos - marginCGx;
                    yCGposMargined = yCGpos;
                }
                
                if (xCGpos > xCGposNext & yCGpos == yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving to the left  and steady" );
                    xCGposMargined = xCGpos - marginCGx;
                    yCGposMargined = yCGpos;
                }
                
                if (xCGpos > xCGposNext & yCGpos > yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving to the left and up" );
                    xCGposMargined = xCGpos + marginCGx;
                    yCGposMargined = yCGpos;
                }
                
                if (xCGpos > xCGposNext & yCGpos < yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving to the left and down" );
                    xCGposMargined = xCGpos - marginCGx;
                    yCGposMargined = yCGpos;
                }
                
                
                if (xCGpos == xCGposNext & yCGpos == yCGposNext) {
                    caseIsFound = 1;
                    //NSLog(@"moving back to start" );
                    xCGposMargined = xCGpos + marginCGx;
                    yCGposMargined = yCGpos;
                    
                }

                if (caseIsFound == 0) {
                    //NSLog(@"---------------------------------------------- view caseIsFound 0");
                }
                
                //NSLog(@"xCGposMargined %f", xCGposMargined);
                if (numberOfPoints == 0) {
                    [pathCGline moveToPoint:CGPointMake( xCGposMargined, yCGposMargined )];
                   
                }else{
                     [pathCGline addLineToPoint:CGPointMake( xCGposMargined, yCGposMargined )];
                }
                
                              numberOfPoints = numberOfPoints + 1;
                
                
            }// end add to path
            
            
            
        }// end for next make path
        
        
        
        shapeLayerCGMargin = [CAShapeLayer layer];
        shapeLayerCGMargin.path = [pathCGline CGPath];
        
        shapeLayerCGMargin.lineWidth = 1.5;
        shapeLayerCGMargin.fillColor = [[UIColor clearColor] CGColor];
        
        [shapeLayerCGMargin setLineDashPattern:
        [NSArray arrayWithObjects:[NSNumber numberWithInt:10],
        [NSNumber numberWithInt:5],nil]];
        
        //[self.viewCGenvelopeFrame.layer addSublayer:shapeLayerCGMargin];
        
      } // end if check margin
    
    
    
    
    
    // ******************************************************************************************************
    // ******************************************************************************************************
    // cge1
    // envelope 1
    
    numberOfPoints = 0;
    UIBezierPath *pathCG = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG1.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [_arrayCG1 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];        
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        xVal = @"";
        yVal = @"";
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            if (numberOfPoints == 0) { // first point only
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    shapeLayerCG1 = [CAShapeLayer layer];
    shapeLayerCG1.path = [pathCG CGPath];
    shapeLayerCG1.lineWidth = 3.5;
    shapeLayerCG1.fillColor = [[UIColor clearColor] CGColor];
   
    
    // ******************************************************************************************************
    // ******************************************************************************************************
    // cge2
    // envelope 2
    
    numberOfPoints = 0;
    pathCG = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG2.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [_arrayCG2 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        xVal = @"";
        yVal = @"";
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            if (numberOfPoints == 0) { // first point only
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    shapeLayerCG2 = [CAShapeLayer layer];
    shapeLayerCG2.path = [pathCG CGPath];
    shapeLayerCG2.lineWidth = 3.5;
    shapeLayerCG2.fillColor = [[UIColor clearColor] CGColor];
    
    [self.viewCGenvelopeFrame.layer addSublayer:shapeLayerCG2];
    
    [self.viewCGenvelopeFrame.layer addSublayer:shapeLayerCG1];
    

    
    /*
    // arrange sublayers:
   
    CALayer *superlayer = shapeLayerCG1.superlayer;
    [shapeLayerCG1 removeFromSuperlayer];
    [superlayer insertSublayer:shapeLayerCG1 atIndex:1];
    
    superlayer = shapeLayerCG2.superlayer;
    [shapeLayerCG2 removeFromSuperlayer];
    [superlayer insertSublayer:shapeLayerCG2 atIndex:0];
    */
    
    
     
    // ******************************************************************************************************
    // ******************************************************************************************************
    
    
   
    
    
    
    
    /// make dots
    
    
    for (int i = 7; i < _arrayCG1.count ; i++) { /// make dots
        
        
        // get point coordinates
        
        
        NSString *Xstring     = [self.arrayCG1 objectAtIndex: i ];
        
        NSString *searchKeyword = @"/";
        
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        
        
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        
        xVal = @"";
        
        yVal = @"";
        
        float xCGpos = 0;
        
        float yCGpos = 0;
        
        
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            
            
            xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
            yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
            
            
            float dotSize = 10;
            
            
            CAShapeLayer *circleLayer = [CAShapeLayer layer];
            
            [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
            
            [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
            
            // Create a circle path.
            
            UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
            
            // Set the path on the layer
            [circleLayer setPath:[pathC CGPath]];
            
            
            // Set the stroke color
            [circleLayer setStrokeColor:[[UIColor blackColor] CGColor]];
            
            [circleLayer setFillColor:[[UIColor whiteColor] CGColor]];
            
            // Set the stroke line width
            [circleLayer setLineWidth:2.0f];
            
            
            [self.viewCGenvelopeFrame.layer addSublayer:circleLayer];
            
            
            if (flagCGEnvelopeLarge == 1) {
                
                
                // make labels
                
                float labelWidth = xVal.length * 10 ;
                float labelHeight = 15;
                
                UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xCGpos - (labelWidth/2), yCGpos - labelHeight-8 , labelWidth, labelHeight)];
                label.font = [UIFont systemFontOfSize:13];
                label.textAlignment = NSTextAlignmentCenter;
                label.textColor = [UIColor whiteColor];
                label.backgroundColor = [UIColor blackColor];
                
                [label  setText: xVal ];
                
                [self.viewCGenvelopeFrame addSubview:label];
                
                
                
                
                labelWidth = yVal.length * 10;
                labelHeight = 15;
                
                label = [[UILabel alloc] initWithFrame:CGRectMake(xCGpos - labelWidth - 8, yCGpos - (labelHeight/2) , labelWidth, labelHeight)];
                label.font = [UIFont systemFontOfSize:13];
                label.textAlignment = NSTextAlignmentCenter;
                label.textColor = [UIColor whiteColor];
                label.backgroundColor = [UIColor blackColor];
                
                [label  setText: yVal ];
                
                [self.viewCGenvelopeFrame addSubview:label];
                

                
            }
            
            
  
            
            
        }// end add to path
        
        
        
        
    }// end for next make path
    
    
    
    
    
    return;
    
    
    
}

- (void) drawCGenvelope2 {
   
    
    colorModeForCGenvelope =  1;
    
    for(UIView *subview in [_viewCGenvelopeFrame2 subviews]) {
        [subview removeFromSuperview];
    }
    
    
    [self.viewCGenvelopeFrame2.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    
    _viewMeasureCGenvelope2.backgroundColor = [UIColor clearColor];
    
    if (colorModeForCGenvelope == 0) { _viewCGenvelopeFrame2.backgroundColor = [UIColor blackColor];  }else{ _viewCGenvelopeFrame2.backgroundColor = [UIColor whiteColor];    }
    
    
    
    
    
    
    // CG x and y labels
    
    
    xAxisLeft2     = [[self.arrayCG1 objectAtIndex: 0 ] floatValue];
    xAxisRight2    = [[self.arrayCG1 objectAtIndex: 1 ] floatValue];
    float xIncrement    = [[self.arrayCG1 objectAtIndex: 2 ] floatValue];
    
    yAxisBottom2   = [[self.arrayCG1 objectAtIndex: 3 ] floatValue];
    yAxisTop2      = [[self.arrayCG1 objectAtIndex: 4 ] floatValue];
    float yIncrement    = [[self.arrayCG1 objectAtIndex: 5 ] floatValue];
    
    float fontSize     = [[self.arrayCG1 objectAtIndex: 6 ] floatValue];
    
    
    
    
    
    // statics
    
    float labelWidth = 90;
    
    float labelHeight = 15;
    
    float xPos = 0, yPos = 0;
    
    
    
    
    leftBorderOfMeasureBox2 =   _viewMeasureCGenvelope2.center.x - (_viewMeasureCGenvelope2.layer.frame.size.width / 2.0) ;
    measureBoxWidth2 = _viewMeasureCGenvelope2.layer.frame.size.width;
    
    float xIncrementValue = (xAxisRight2 - xAxisLeft2) / xIncrement;
    float xIncrementPixel = measureBoxWidth2 / xIncrement;
    
    
    
    
    
    
    topBorderOfMeasureBox2 =   _viewMeasureCGenvelope2.center.y - (_viewMeasureCGenvelope2.layer.frame.size.height / 2.0) ;
    measureBoxHeight2 = _viewMeasureCGenvelope2.layer.frame.size.height;
    
    float yIncrementValue = (yAxisTop2 - yAxisBottom2) / yIncrement;
    float yIncrementPixel = measureBoxHeight2 / yIncrement;
    
    
    // make X labels
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        
        if (xAxisLeft + ( xIncrementValue * i) > xAxisRight) {
            // plot labels only if fit in frame
            continue;
        }
        
        
        
        xPos =  leftBorderOfMeasureBox2 + (xIncrementPixel * i);
        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(xPos-(labelWidth/2), topBorderOfMeasureBox2 - labelHeight-2, labelWidth, labelHeight)];
        label.textAlignment = NSTextAlignmentCenter;
        if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
        label.font = [UIFont boldSystemFontOfSize:fontSize];
        if (i == 0) {
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0fmm", xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }else{
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }

      
        [_viewCGenvelopeFrame2 addSubview: label];
    }
    
    
    
    // make X lines
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        xPos =  leftBorderOfMeasureBox2 + (xIncrementPixel * i);
        
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( xPos, topBorderOfMeasureBox2 )];
        [path addLineToPoint:CGPointMake( xPos, topBorderOfMeasureBox2+ measureBoxHeight2  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame2.layer addSublayer:shapeLayer];
        
    }
    
    
    
    
    
    // make y labels
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        if (i == 0) { // make first label the LBS label
            
            
            yPos =  topBorderOfMeasureBox2 + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox2-labelWidth-4, yPos-(labelHeight/2)+(yIncrementPixel/3), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            
            NSString *labelText;
            
            if ([unitsWeight.text isEqualToString:@"kg"]) {
                 labelText = @"kg";
            }else{
                
                 labelText = @"[lbs]";
            }
            
           
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame2 addSubview: label];
            
            
            
        }else{
            
            yPos =  topBorderOfMeasureBox2 + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox2-labelWidth-4, yPos-(labelHeight/2), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", yAxisTop - ( yIncrementValue * i)  ];
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame2 addSubview: label];
        }
        
        
        
        
        
        
        
        
    }
    
    
    // make y lines
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        yPos =  topBorderOfMeasureBox2 + (yIncrementPixel * i);
        
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( leftBorderOfMeasureBox2, yPos )];
        [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox2+ measureBoxWidth2, yPos  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame2.layer addSublayer:shapeLayer];
    }
    
    
    
    // make frame
    
    UIBezierPath *path = [UIBezierPath bezierPath];
    
    [path moveToPoint:CGPointMake( leftBorderOfMeasureBox2, topBorderOfMeasureBox2 )];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox2+ measureBoxWidth2, topBorderOfMeasureBox2  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox2+ measureBoxWidth2, topBorderOfMeasureBox2+measureBoxHeight2  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox2, topBorderOfMeasureBox2+measureBoxHeight2  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox2, topBorderOfMeasureBox2  )  ];
    
    CAShapeLayer *shapeLayer = [CAShapeLayer layer];
    shapeLayer.path = [path CGPath];
    if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor whiteColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
    shapeLayer.lineWidth = 1.5;
    shapeLayer.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame2.layer addSublayer:shapeLayer];
    
    
    
    
    
    
    
    
    
    
    // ******************************************************************************************
    
    xPixelFactor2 = measureBoxWidth2  / (xAxisRight2-xAxisLeft2);
    
    yPixelFactor2 = measureBoxHeight2 / (yAxisTop2-yAxisBottom2);
    
    
    float numberOfPoints = 0;
    
    UIBezierPath *pathCG = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG1.count ; i++) {
        
        NSString *Xstring     = [self.arrayCG1 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        
        xValcg = @"";
        yValcg = @"";
        
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xValcg = [Xstring substringToIndex:rangeOfYourString.location];
            yValcg = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            if (numberOfPoints == 0) { // first point only
                xCGpos = leftBorderOfMeasureBox2 + ( ([xValcg floatValue]-xAxisLeft2) * xPixelFactor2 );
                yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - [yValcg floatValue]) * yPixelFactor2 );
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
                
            }else{
                
                xCGpos = leftBorderOfMeasureBox2 + ( ([xValcg floatValue]-xAxisLeft2) * xPixelFactor2 );
                yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - [yValcg floatValue]) * yPixelFactor2 );
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    CAShapeLayer *shapeLayer1manifest = [CAShapeLayer layer];
    shapeLayer1manifest.path = [pathCG CGPath];
    shapeLayer1manifest.strokeColor = [[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];
    if (colorModeForCGenvelope == 0) {  shapeLayer1manifest.strokeColor =[[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];  }else{ shapeLayer1manifest.strokeColor = [[UIColor redColor] CGColor];    }
    shapeLayer1manifest.lineWidth = 3.5;
    shapeLayer1manifest.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame2.layer addSublayer:shapeLayer1manifest];
    
    
    
    // ******************************************************************************************
    
    xPixelFactor2 = measureBoxWidth2  / (xAxisRight2-xAxisLeft2);
    
    yPixelFactor2 = measureBoxHeight2 / (yAxisTop2-yAxisBottom2);
    
    
    numberOfPoints = 0;
    
    pathCG = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG2.count ; i++) {
        
        NSString *Xstring     = [_arrayCG2 objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        
        xValcg = @"";
        yValcg = @"";
        
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xValcg = [Xstring substringToIndex:rangeOfYourString.location];
            yValcg = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            if (numberOfPoints == 0) { // first point only
                xCGpos = leftBorderOfMeasureBox2 + ( ([xValcg floatValue]-xAxisLeft2) * xPixelFactor2 );
                yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - [yValcg floatValue]) * yPixelFactor2 );
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
                
            }else{
                
                xCGpos = leftBorderOfMeasureBox2 + ( ([xValcg floatValue]-xAxisLeft2) * xPixelFactor2 );
                yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - [yValcg floatValue]) * yPixelFactor2 );
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    CAShapeLayer *shapeLayer2manifest = [CAShapeLayer layer];
    shapeLayer2manifest.path = [pathCG CGPath];
    shapeLayer2manifest.strokeColor = [[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];
    if (colorModeForCGenvelope == 0) {  shapeLayer2manifest.strokeColor =[[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];  }else{ shapeLayer2manifest.strokeColor = [[UIColor redColor] CGColor];    }
    shapeLayer2manifest.lineWidth = 3.5;
    shapeLayer2manifest.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame2.layer addSublayer:shapeLayer2manifest];

    
    
     // ******************************************************************************************
    
    
    
    
    
    
    
    
    
    
    
    for (int i = 7; i < _arrayCG1.count ; i++) { /// make dots
        
        
        // get point coordinates
        
        
        NSString *Xstring     = [self.arrayCG1 objectAtIndex: i ];
        
        NSString *searchKeyword = @"/";
        
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        xValcg = @"";
        
        yValcg = @"";
        
        float xCGpos = 0;
        
        float yCGpos = 0;
        
        
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xValcg = [Xstring substringToIndex:rangeOfYourString.location];
            
            yValcg = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            
            
            xCGpos = leftBorderOfMeasureBox2 + ( ([xValcg floatValue]-xAxisLeft2) * xPixelFactor2 );
            yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - [yValcg floatValue]) * yPixelFactor2 );
            
            
            float dotSize = 7;
            
            
            CAShapeLayer *circleLayer = [CAShapeLayer layer];
            
            [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
            
            [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
            
            // Create a circle path.
            
            UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
            
            // Set the path on the layer
            [circleLayer setPath:[pathC CGPath]];
            
            
            // Set the stroke color
            [circleLayer setStrokeColor:[[UIColor blackColor] CGColor]];
            
            [circleLayer setFillColor:[[UIColor whiteColor] CGColor]];
            
            // Set the stroke line width
            [circleLayer setLineWidth:2.0f];
            
            
            [self.viewCGenvelopeFrame2.layer addSublayer:circleLayer];
            
            
            
            
            
            
        }// end add to path
        
        
        
        
    }// end for next make path
    
    
    
    
    
    return;
    
    
    
}

- (void) drawCGenvelopeLAT {
    
    colorModeForCGenvelope =  0;
    
    for(UIView *subview in [_viewCGenvelopeFrame_LAT subviews]) {
        [subview removeFromSuperview];
    }
    
    [self.viewCGenvelopeFrame_LAT.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    _viewMeasureCGenvelope_LAT.backgroundColor = [UIColor clearColor];
    if (colorModeForCGenvelope == 0) { _viewCGenvelopeFrame_LAT.backgroundColor = [UIColor clearColor];  }else{ _viewCGenvelopeFrame_LAT.backgroundColor = [UIColor whiteColor];    }
    
    
    // CG x and y labels
    xAxisLeft     = [[self.arrayCG1_LAT objectAtIndex: 0 ] floatValue];
    xAxisRight    = [[self.arrayCG1_LAT objectAtIndex: 1 ] floatValue];
    float xIncrement    = [[self.arrayCG1_LAT objectAtIndex: 2 ] floatValue];
    yAxisBottom   = [[self.arrayCG1_LAT objectAtIndex: 3 ] floatValue];
    yAxisTop      = [[self.arrayCG1_LAT objectAtIndex: 4 ] floatValue];
    float yIncrement    = [[self.arrayCG1_LAT objectAtIndex: 5 ] floatValue];
    float fontSize     = [[self.arrayCG1_LAT objectAtIndex: 6 ] floatValue];
    
    // statics
    float labelWidth = 50;
    float labelHeight = 15;
    float xPos = 0, yPos = 0;
    
    leftBorderOfMeasureBox =   _viewMeasureCGenvelope_LAT.center.x - (_viewMeasureCGenvelope_LAT.layer.frame.size.width / 2.0) ;
    measureBoxWidth = _viewMeasureCGenvelope_LAT.layer.frame.size.width;
    float xIncrementValue = (xAxisRight - xAxisLeft) / xIncrement;
    float xIncrementPixel = measureBoxWidth / xIncrement;
    
    
    topBorderOfMeasureBox =   _viewMeasureCGenvelope_LAT.center.y - (_viewMeasureCGenvelope_LAT.layer.frame.size.height / 2.0) ;
    measureBoxHeight = _viewMeasureCGenvelope_LAT.layer.frame.size.height;
    
    float yIncrementValue = (yAxisTop - yAxisBottom) / yIncrement;
    float yIncrementPixel = measureBoxHeight / yIncrement;
    
    
    // make X labels
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        if (xAxisLeft + ( xIncrementValue * i) > xAxisRight) {
            // plot labels only if fit in frame
            continue;
        }
        
        
        xPos =  leftBorderOfMeasureBox + (xIncrementPixel * i);
        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(xPos-(labelWidth/2), topBorderOfMeasureBox - labelHeight-2, labelWidth, labelHeight)];
        label.textAlignment = NSTextAlignmentCenter;
        if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
        label.font = [UIFont boldSystemFontOfSize:fontSize];
        //NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeft + ( xIncrementValue * i)  ];
        
        if (i == 0) {
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0fmm", xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }else{
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeft + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }
        
        
        
        //[label  setText: labelText  ];
        [_viewCGenvelopeFrame_LAT addSubview: label];
    }
    
    
    
    // make X lines
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        xPos =  leftBorderOfMeasureBox + (xIncrementPixel * i);
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( xPos, topBorderOfMeasureBox )];
        [path addLineToPoint:CGPointMake( xPos, topBorderOfMeasureBox+ measureBoxHeight  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame_LAT.layer addSublayer:shapeLayer];
    }
    
    
    
    
    
    // make y labels
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        if (i == 0) {
            yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox-labelWidth-4, yPos-(labelHeight/2)+(yIncrementPixel/3), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText;
            if ([unitsWeight.text isEqualToString:@"kg"]) {
                labelText = @"kg";
            }else{
                labelText = @"[lbs]";
            }
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame_LAT addSubview: label];
            
        }else{
            yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBox-labelWidth-4, yPos-(labelHeight/2), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", yAxisTop - ( yIncrementValue * i)  ];
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame_LAT addSubview: label];
        }
    }
    
    
    // make y lines
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        yPos =  topBorderOfMeasureBox + (yIncrementPixel * i);
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( leftBorderOfMeasureBox, yPos )];
        [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, yPos  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame_LAT.layer addSublayer:shapeLayer];
    }
    
    
    
    // make frame
    
    UIBezierPath *path = [UIBezierPath bezierPath];
    
    [path moveToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox )];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, topBorderOfMeasureBox  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox+ measureBoxWidth, topBorderOfMeasureBox+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBox, topBorderOfMeasureBox  )  ];
    CAShapeLayer *shapeLayer = [CAShapeLayer layer];
    shapeLayer.path = [path CGPath];
    if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor whiteColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
    shapeLayer.lineWidth = 1.5;
    shapeLayer.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame_LAT.layer addSublayer:shapeLayer];
    
    
    
    
    // ******************************************************************************************
    
    xPixelFactor = measureBoxWidth  / (xAxisRight-xAxisLeft);
    yPixelFactor = measureBoxHeight / (yAxisTop-yAxisBottom);
    
    
    float numberOfPoints = 0;
    UIBezierPath *pathCG = [UIBezierPath bezierPath];
    for (int i = 7; i < _arrayCG1_LAT.count ; i++) { /// make path
        
        // get point coordinates
        NSString *Xstring     = [self.arrayCG1_LAT objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        xVal = @"";
        yVal = @"";
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound) {
            // error condition — the text searchKeyword wasn't in 'string'
        }else{
            
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            if (numberOfPoints == 0) { // first point only
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
            }else{
                xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
                yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
            }
            numberOfPoints = numberOfPoints + 1;
        }// end add to path
    }// end for next make path
    
    
    shapeLayerCG1Lat= [CAShapeLayer layer];
    shapeLayerCG1Lat.path = [pathCG CGPath];
    shapeLayerCG1Lat.lineWidth = 3.5;
    shapeLayerCG1Lat.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame_LAT.layer addSublayer:shapeLayerCG1Lat];
    
    for (int i = 7; i < _arrayCG1_LAT.count ; i++) { /// make dots
        
        // get point coordinates
        
        NSString *Xstring     = [self.arrayCG1_LAT objectAtIndex: i ];
        NSString *searchKeyword = @"/";
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        xVal = @"";
        yVal = @"";
        
        float xCGpos = 0;
        float yCGpos = 0;
        
        if(rangeOfYourString.location == NSNotFound){
            // error condition — the text searchKeyword wasn't in 'string'
        }else{
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            xCGpos = leftBorderOfMeasureBox + ( ([xVal floatValue]-xAxisLeft) * xPixelFactor );
            yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - [yVal floatValue]) * yPixelFactor );
            
            float dotSize = 10;
            
            CAShapeLayer *circleLayer = [CAShapeLayer layer];
            [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
            [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
            
            // Create a circle path.
            UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
            
            // Set the path on the layer
            [circleLayer setPath:[pathC CGPath]];
            
            // Set the stroke color
            [circleLayer setStrokeColor:[[UIColor blackColor] CGColor]];
            
            [circleLayer setFillColor:[[UIColor whiteColor] CGColor]];
            
            // Set the stroke line width
            [circleLayer setLineWidth:2.0f];
            
            [self.viewCGenvelopeFrame_LAT.layer addSublayer:circleLayer];
            
            
            
        }// end add to path
        
    }// end for next make path
    
    
    
    leftBorderOfMeasureBoxLAT = leftBorderOfMeasureBox;
    
    xAxisLeftLAT = xAxisLeft;
    
    xPixelFactorLAT = xPixelFactor;
    
    topBorderOfMeasureBoxLAT = topBorderOfMeasureBox;
    
    yAxisTopLAT = yAxisTop;
    
    yPixelFactorLAT = yPixelFactor;
    
    
    
    
    
    return;
    
    
    
}

- (void) drawCGenvelopeLAT2 {
    
    
    
    colorModeForCGenvelope =  1;
    
    
    for(UIView *subview in [_viewCGenvelopeFrame2_LAT subviews]) {
        [subview removeFromSuperview];
    }
    
    
    [self.viewCGenvelopeFrame2_LAT.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    
    
    _viewMeasureCGenvelope2_LAT.backgroundColor = [UIColor clearColor];
    
    if (colorModeForCGenvelope == 0) { _viewCGenvelopeFrame2_LAT.backgroundColor = [UIColor clearColor];  }else{ _viewCGenvelopeFrame2_LAT.backgroundColor = [UIColor whiteColor];    }
    
    
    
    
    
    
    
    // CG x and y labels
    
    
    xAxisLeftLAT2     = [[self.arrayCG1_LAT objectAtIndex: 0 ] floatValue];
    xAxisRight    = [[self.arrayCG1_LAT objectAtIndex: 1 ] floatValue];
    float xIncrement    = [[self.arrayCG1_LAT objectAtIndex: 2 ] floatValue];
    
    yAxisBottom   = [[self.arrayCG1_LAT objectAtIndex: 3 ] floatValue];
    yAxisTopLAT2      = [[self.arrayCG1_LAT objectAtIndex: 4 ] floatValue];
    float yIncrement    = [[self.arrayCG1_LAT objectAtIndex: 5 ] floatValue];
    
    float fontSize     = [[self.arrayCG1_LAT objectAtIndex: 6 ] floatValue];
    
    
    
    
    
    // statics
    
    float labelWidth = 50;
    
    float labelHeight = 15;
    
    float xPos = 0, yPos = 0;
    
    
    
    
    
    leftBorderOfMeasureBoxLAT2 =   _viewMeasureCGenvelope2_LAT.center.x - (_viewMeasureCGenvelope2_LAT.layer.frame.size.width / 2.0) ;
    measureBoxWidth = _viewMeasureCGenvelope2_LAT.layer.frame.size.width;
    
    float xIncrementValue = (xAxisRight - xAxisLeftLAT2) / xIncrement;
    float xIncrementPixel = measureBoxWidth / xIncrement;
    
    
    
    
    
    
    topBorderOfMeasureBoxLAT2 =   _viewMeasureCGenvelope2_LAT.center.y - (_viewMeasureCGenvelope2_LAT.layer.frame.size.height / 2.0) ;
    measureBoxHeight = _viewMeasureCGenvelope2_LAT.layer.frame.size.height;
    
    float yIncrementValue = (yAxisTopLAT2 - yAxisBottom) / yIncrement;
    float yIncrementPixel = measureBoxHeight / yIncrement;
    
    
    // make X labels
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        /*
        if (xAxisLeft + ( xIncrementValue * i) > xAxisRight) {
            // plot labels only if fit in frame
            continue;
        }
         */
        
        
        
        xPos =  leftBorderOfMeasureBoxLAT2 + (xIncrementPixel * i);
        UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(xPos-(labelWidth/2), topBorderOfMeasureBoxLAT2 - labelHeight-2, labelWidth, labelHeight)];
        label.textAlignment = NSTextAlignmentCenter;
        if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
        label.font = [UIFont boldSystemFontOfSize:fontSize];
        //NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeftLAT2 + ( xIncrementValue * i)  ];
        
        if (i == 0) {
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0fmm", xAxisLeftLAT2 + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }else{
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", xAxisLeftLAT2 + ( xIncrementValue * i)  ];
            [label  setText: labelText  ];
            
        }
        
        
        //[label  setText: labelText  ];
        [_viewCGenvelopeFrame2_LAT addSubview: label];
    }
    
    
    
    // make X lines
    
    for (int i = 0; i < xIncrement+1 ; i++) {
        
        xPos =  leftBorderOfMeasureBoxLAT2 + (xIncrementPixel * i);
        
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( xPos, topBorderOfMeasureBoxLAT2 )];
        [path addLineToPoint:CGPointMake( xPos, topBorderOfMeasureBoxLAT2+ measureBoxHeight  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame2_LAT.layer addSublayer:shapeLayer];
        
    }
    
    
    
    
    
    // make y labels
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        if (i == 0) { // make first label the LBS label
            
            
            yPos =  topBorderOfMeasureBoxLAT2 + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBoxLAT2-labelWidth-4, yPos-(labelHeight/2)+(yIncrementPixel/3), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText = @"kg";
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame2_LAT addSubview: label];
            
            
            
        }else{
            
            yPos =  topBorderOfMeasureBoxLAT2 + (yIncrementPixel * i);
            UILabel *label= [[UILabel alloc] initWithFrame:CGRectMake(leftBorderOfMeasureBoxLAT2-labelWidth-4, yPos-(labelHeight/2), labelWidth, labelHeight)];
            label.textAlignment = NSTextAlignmentRight;
            if (colorModeForCGenvelope == 0) { label.textColor = [UIColor whiteColor];  }else{ label.textColor = [UIColor blackColor];    }
            label.font = [UIFont boldSystemFontOfSize:fontSize];
            NSString *labelText = [ [NSString alloc] initWithFormat:@"%.0f", yAxisTopLAT2 - ( yIncrementValue * i)  ];
            [label  setText: labelText  ];
            [_viewCGenvelopeFrame2_LAT addSubview: label];
        }
        
        
        
        
        
        
        
        
    }
    
    
    // make y lines
    
    for (int i = 0; i < yIncrement+1 ; i++) {
        
        yPos =  topBorderOfMeasureBoxLAT2 + (yIncrementPixel * i);
        
        UIBezierPath *path = [UIBezierPath bezierPath];
        [path moveToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2, yPos )];
        [path addLineToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2+ measureBoxWidth, yPos  )  ];
        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
        shapeLayer.path = [path CGPath];
        if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor lightGrayColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
        shapeLayer.lineWidth = 0.5;
        shapeLayer.fillColor = [[UIColor clearColor] CGColor];
        [self.viewCGenvelopeFrame2_LAT.layer addSublayer:shapeLayer];
    }
    
    
    
    // make frame
    
    UIBezierPath *path = [UIBezierPath bezierPath];
    
    [path moveToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2, topBorderOfMeasureBoxLAT2 )];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2+ measureBoxWidth, topBorderOfMeasureBoxLAT2  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2+ measureBoxWidth, topBorderOfMeasureBoxLAT2+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2, topBorderOfMeasureBoxLAT2+measureBoxHeight  )  ];
    [path addLineToPoint:CGPointMake( leftBorderOfMeasureBoxLAT2, topBorderOfMeasureBoxLAT2  )  ];
    
    CAShapeLayer *shapeLayer = [CAShapeLayer layer];
    shapeLayer.path = [path CGPath];
    if (colorModeForCGenvelope == 0) { shapeLayer.strokeColor = [[UIColor whiteColor] CGColor];;  }else{ shapeLayer.strokeColor = [[UIColor blackColor] CGColor];    }
    shapeLayer.lineWidth = 1.5;
    shapeLayer.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame2_LAT.layer addSublayer:shapeLayer];
    
    
    
    
    
    
    
    
    // ******************************************************************************************
    
    xPixelFactorLAT2 = measureBoxWidth  / (xAxisRight-xAxisLeftLAT2);
    
    yPixelFactorLAT2 = measureBoxHeight / (yAxisTopLAT2-yAxisBottom);
    
    
    float numberOfPoints = 0;
    
    UIBezierPath *pathCG = [UIBezierPath bezierPath];
    
    for (int i = 7; i < _arrayCG1_LAT.count ; i++) { /// make path
        
        
        // get point coordinates
        
        
        NSString *Xstring     = [self.arrayCG1_LAT objectAtIndex: i ];
        
        NSString *searchKeyword = @"/";
        
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        xVal = @"";
        
        yVal = @"";
        
        float xCGpos = 0;
        
        float yCGpos = 0;
        
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            if (numberOfPoints == 0) { // first point only
                
                xCGpos = leftBorderOfMeasureBoxLAT2 + ( ([xVal floatValue]-xAxisLeftLAT2) * xPixelFactorLAT2 );
                yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - [yVal floatValue]) * yPixelFactorLAT2 );
                
                [pathCG moveToPoint:CGPointMake( xCGpos, yCGpos )];
                
            }else{
                
                xCGpos = leftBorderOfMeasureBoxLAT2 + ( ([xVal floatValue]-xAxisLeftLAT2) * xPixelFactorLAT2 );
                
                yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - [yVal floatValue]) * yPixelFactorLAT2 );
                
                [pathCG addLineToPoint:CGPointMake( xCGpos, yCGpos )];
                
            }
            
            
            
            
            
            numberOfPoints = numberOfPoints + 1;
            
            
        }// end add to path
        
        
        
    }// end for next make path
    
    
    
    CAShapeLayer *shapeLayer2 = [CAShapeLayer layer];
    shapeLayer2.path = [pathCG CGPath];
    shapeLayer2.strokeColor = [[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];
    if (colorModeForCGenvelope == 0) {  shapeLayer2.strokeColor =[[UIColor colorWithRed:255.0/255.0f green:218.0/255.0f blue:0.0/255.0f alpha:1.0f] CGColor];  }else{ shapeLayer2.strokeColor = [[UIColor redColor] CGColor];    }
    shapeLayer2.lineWidth = 3.5;
    shapeLayer2.fillColor = [[UIColor clearColor] CGColor];
    [self.viewCGenvelopeFrame2_LAT.layer addSublayer:shapeLayer2];
    
    
    
    
    
    
    
    
    
    for (int i = 7; i < _arrayCG1_LAT.count ; i++) { /// make dots
        
        
        // get point coordinates
        
        
        NSString *Xstring     = [self.arrayCG1_LAT objectAtIndex: i ];
        
        NSString *searchKeyword = @"/";
        
        NSRange rangeOfYourString = [Xstring rangeOfString:searchKeyword];
        if ([Xstring isEqualToString: @""]) {
            break;
        }
        
        xVal = @"";
        
        yVal = @"";
        
        float xCGpos = 0;
        
        float yCGpos = 0;
        
        
        
        if(rangeOfYourString.location == NSNotFound)
        {
            // error condition — the text searchKeyword wasn't in 'string'
        }
        else{
            
            xVal = [Xstring substringToIndex:rangeOfYourString.location];
            
            yVal = [Xstring substringFromIndex:rangeOfYourString.location+1];
            
            
            
            
            xCGpos = leftBorderOfMeasureBoxLAT2 + ( ([xVal floatValue]-xAxisLeftLAT2) * xPixelFactorLAT2 );
            yCGpos = topBorderOfMeasureBoxLAT2  + (  (yAxisTopLAT2 - [yVal floatValue]) * yPixelFactorLAT2 );
            
            
            float dotSize = 10;
            
            
            CAShapeLayer *circleLayer = [CAShapeLayer layer];
            
            [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
            
            [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
            
            // Create a circle path.
            
            UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
            
            // Set the path on the layer
            [circleLayer setPath:[pathC CGPath]];
            
            
            // Set the stroke color
            [circleLayer setStrokeColor:[[UIColor blackColor] CGColor]];
            
            [circleLayer setFillColor:[[UIColor whiteColor] CGColor]];
            
            // Set the stroke line width
            [circleLayer setLineWidth:2.0f];
            
            
            [self.viewCGenvelopeFrame2_LAT.layer addSublayer:circleLayer];
            
            
            
            
            
            
        }// end add to path
        
        
        
        
    }// end for next make path
    
    
    
    
    
    
    
    
    return;
    
    
    
}




// *************************************************************************************************************************************************************************
// *************************************************************************************************************************************************************************
// *************************************************************************************************************************************************************************

// *************************************************************************************************************************************************************************



- (void) setCGenvelope {
    
    //NSLog (@"setCGenvelope");
    
    [self initializeCGArrays];
    
    [self drawCGenvelopeLAT2];
    
    [self drawCGenvelopeLAT];
    
    [self drawCGenvelope];
    
    [self drawCGenvelope2];
    
    
    
}


-(void) initializeCGArrays {
    
    //NSLog (@"initializeCGArrays ");
    
    NSString *URL = [ [NSString alloc] initWithFormat:@"%@%@_CGenvelope", @"", AC_Type ];
    
    NSString *path = [[NSBundle mainBundle] pathForResource:URL ofType:@"txt"];
    NSString *loadedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    
    NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *arrayComponents = [loadedText componentsSeparatedByCharactersInSet:charSet1];
    
    //NSLog (@"arrayComponents %@", arrayComponents);
    
    _arrayCG1 = [[NSMutableArray alloc] init];
    _arrayCG2 = [[NSMutableArray alloc] init];
    _arrayCG1_LAT = [[NSMutableArray alloc] init];
    _arrayCG1MarginLine = [[NSMutableArray alloc] init];
    
    
    
    
    NSArray *componentItems  = [[arrayComponents objectAtIndex:0] componentsSeparatedByString:@","];
    for (int i = 0; i<componentItems.count; i++) {
        [_arrayCG1 addObject:[componentItems objectAtIndex:i] ];
       
        
    }

    
    componentItems  = [[arrayComponents objectAtIndex:1] componentsSeparatedByString:@","];
    for (int i = 0; i<componentItems.count; i++) {
        [_arrayCG1_LAT addObject:[componentItems objectAtIndex:i] ];
    }
  
    
    componentItems  = [[arrayComponents objectAtIndex:2] componentsSeparatedByString:@","];
    for (int i = 0; i<componentItems.count; i++) {
        [_arrayCG2 addObject:[componentItems objectAtIndex:i] ];
    }
    

    
    componentItems  = [[arrayComponents objectAtIndex:3] componentsSeparatedByString:@","];
    for (int i = 0; i<componentItems.count; i++) {
        [_arrayCG1MarginLine addObject:[componentItems objectAtIndex:i] ];
    }
   
    //NSLog (@"_arrayCG1 %@", _arrayCG1);
    
    //NSLog (@"_arrayCG2 %@", _arrayCG2);
    
    //NSLog (@"_arrayCG1_LAT %@", _arrayCG1_LAT);
    
    //NSLog (@"_arrayCG1MarginLine %@", _arrayCG1MarginLine);

    
    
    
    [self setLogoOnly];
    
    [self makeFreakViewShape1];
    
    [self makeFreakViewShape2];
    
    [self makeFreakViewLateral];
    
    [self makeFreakViewShapeMargin];
    
    
    
  
    
    
    
    return;
    
    
    
}

- (void) setLogoOnly {
    
    //NSLog(@"setLogoOnly AC_Type %@ ", AC_Type);
    
    
     UIImage *logoOnly = [UIImage imageNamed:  [NSString stringWithFormat:@"%@_logoOnly.png", AC_Type] ];
    
     [_logoOnly setImage:logoOnly];

    
    
    
}


    
    

// dList **********************************************************************************************************


- (IBAction)actionEnterText:(UITextField *)sender {
    
    
  
    
    dListInputFieldTag = sender.tag;
    
    //NSLog(@"123 dListInputFieldTag %f", dListInputFieldTag);
    
    UITextField* field = (UITextField*)[_viewDepartureDestinationFields viewWithTag: dListInputFieldTag];
    
    field.enabled = NO;
    
    _viewDlist.hidden = NO;
    
    [viewOne bringSubviewToFront:_viewDlist];
    
    [dListClass_ activateTextfield];
    
  

    
    
}


- (IBAction)actionDListButton:(UIButton*)sender  {
    
    dListInputFieldTag = sender.tag;
    
    _viewDlist.hidden = NO;
    
    [viewOne bringSubviewToFront:_viewDlist];
    
    [dListClass_ activateTextfield];
    
    
    
    
}



-(void) dListSetInputField {
    
    
  
    
    UITextField* field = (UITextField*)[_viewDepartureDestinationFields viewWithTag: dListInputFieldTag];
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    
    NSString *dListInputText    = [defaults  stringForKey:@"dListInputText"];
    
    [field setText: dListInputText];
    
    field.enabled = YES;

    _viewDlist.hidden = YES;
    
    [self calculateListo];
    
    

}




-(void) dListCancel {
    
    
    
    _viewDlist.hidden = YES;
    
    
    
}





// dList end **********************************************************************************************************







- (void)handleSingleTapOnCGEnvelope:(UIPanGestureRecognizer *)recognizer {
    
    //NSLog(@"handleSingleTapOnCGEnvelope");
  
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDuration:0.4];
    
    if (flagCGEnvelopeLarge == 0) {
        flagCGEnvelopeLarge = 1;
        //_viewTrennerTop.hidden = YES;
    }else{
        flagCGEnvelopeLarge = 0;
        //_viewTrennerTop.hidden = NO;
    }
    
    
    [self setCGenvelope];
    [UIView commitAnimations];
    [self MainRoutine];
    
    
}





- (IBAction)sliderActionKIAS:(id)sender {
    
    int dummy = _sliderKIAS.value/2;
    _sliderKIAS.value = dummy * 2;

    
    [self MainRoutine];
    
   
}



- (IBAction)sliderActionFuelMain1:(id)sender {
    
    
    int dummy = _sliderFuelMain1.value/10;
    _sliderFuelMain1.value = dummy * 10;
    
     if (_sliderFuelMain1.value > tankCapacityVolume - 20 ) {
         
         _sliderFuelMain1.value = tankCapacityVolume;
         
     }
    
    if (_sliderFuelLanding.value >= _sliderFuelMain1.value ) {
        _sliderFuelLanding.value = _sliderFuelMain1.value - (_sliderFuelMain1.value * 0.05);
    }
    
    
    [self MainRoutine];
    
}


- (IBAction)sliderActionFuelLanding:(id)sender {
    
    if (_switchAutoLandingFuel.on == YES) {
        return;
    }
    
    
    int dummy = _sliderFuelLanding.value/10;
    _sliderFuelLanding.value = dummy * 10;
    
    if (_sliderFuelLanding.value >= _sliderFuelMain1.value ) {
        _sliderFuelLanding.value = _sliderFuelMain1.value - (_sliderFuelMain1.value * 0.05);
    }
    
    
    [self MainRoutine];
    
}


- (IBAction)buttonActionEnterFuelMain:(id)sender {
    
    
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterFuelMain setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 25;
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}




- (IBAction)buttonActionEnterFuelLanding:(id)sender {
    
    
    if (_switchAutoLandingFuel.on == YES) {
        return;
    }
    
    
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterFuelLanding setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 26;
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}






- (IBAction)buttonActionEnterFuelMainPercent:(id)sender {
    
    
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterFuelMainPercent setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 27;
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}


- (IBAction)buttonActionEnterFuelLandingPercent:(id)sender {
    
    
    if (_switchAutoLandingFuel.on == YES) {
        return;
    }
    
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterFuelLandingPercent setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 28;
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}


- (IBAction)buttonActionEnterFlightTimeMinutes:(id)sender {
    
    
    if (flagButtonPressed == 0) {
        
        [self setListoButtonsNeutral];
        
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
        
        UIImage *buttonmark = [UIImage imageNamed:@"Klammern_Yel.png"];
        
        [_buttonEnterFlightTimeMinutes setImage:buttonmark forState:UIControlStateNormal];
        
        EnterPadString = @"0"; calculatorscreen.text = @"0"; EnterValueTwo = 0;
        
        
        
        selectedItem = 29;
        
        
    } else {[self setButtonMarksNeutral];}
    
    
    
    
    
}




- (IBAction)actionDisplayTimers:(id)sender {
    
    if (displayWindow == 15) {
        
        displayWindow = 0;
    } else {
        displayWindow = 15;
    }
    
    [self displayWindows];
    
    
}
- (IBAction)buttonActionTimer:(UIButton*)sender {
    
 
    NSDate *currentTime = datepick.date;
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    
    [dateFormatter setDateFormat:@"HH:mm"];
    
    NSTimeZone *gmt = [NSTimeZone timeZoneWithAbbreviation:@"GMT"];
    [dateFormatter setTimeZone:gmt];
    
    NSTimeZone *localTZ = [NSTimeZone localTimeZone];
    [dateFormatter setTimeZone:localTZ];
    
    NSString *localTimeString = [dateFormatter stringFromDate: currentTime];
    
    
    
    
    if (sender.tag == 1) {
        _inputTimer1.text = localTimeString;
    }
    
    if (sender.tag == 2) {
        _inputTimer2.text = localTimeString;
    }
    
    if (sender.tag == 3) {
        _inputTimer3.text = localTimeString;
    }
    
    if (sender.tag == 4) {
        _inputTimer4.text = localTimeString;
    }
    
    if (sender.tag == 5) {
        _inputTimer5.text = localTimeString;
    }
    
    if (sender.tag == 6) {
        _inputTimer6.text = localTimeString;
    }
    
    
    
}



- (void)actionFullScreenPerfChart: (float)receivedChartState{
    
    //NSLog(@"doing actionFullScreenPerfChart receivedChartState = %f",receivedChartState );
    
    
    if (receivedChartState == 0) {
        calculatePerformanceClassView_.frame = CGRectMake(0, 114, 646, 634);
    }else{
        
        calculatePerformanceClassView_.frame = CGRectMake(0, 114, 1024, 634);
        
    }
    
}



- (void)actionPerfbuttons :(UIButton*)sender {
    
    selectedChartButton = sender.tag;
    
        
    // reset view
    
    pinchScale= 1.0;
    moveupDown = 0; moveLeftRight = 0;
  
    
    
    //NSLog(@"2 previousdButton %.0f ", previousdButton);
    
    UIView *signalStripe = (UIView *)[_viewUniversalButtons viewWithTag:999];
    
    
    UIButton *perfButton = (UIButton *)sender;
    
    displayWindow = sender.tag + 100;
    
    if (previousdButton == sender.tag) {
        
        if (perfButton.selected == NO) {
            
            perfButton.selected = YES;
            
            signalStripe.frame = CGRectMake(perfButton.frame.origin.x, signalStripe.frame.origin.y, signalStripe.frame.size.width, signalStripe.frame.size.height);

            
            //NSLog(@"1 actionPerfbuttons gleicher button wie vorher und er war NICHT selected %d", flagPerfBoxOn);
            
            
            if (flagPerfBoxOn == 1) {
                
                flagPerfBoxOn = 0;
                
                [self addPerformanceButtons];
                
                displayWindow = sender.tag + 100;
                
                
                // scroll to the damn button
                /*
                if (flagIsLandscape == 1) {
                    
                    float yPositionButton  = (182) * (sender.tag-1)-2;
                    
                    [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake(_scrollViewUniversalButtons.frame.origin.x, _scrollViewUniversalButtons.frame.origin.y, yPositionButton + (_scrollViewUniversalButtons.frame.size.width - 208), _scrollViewUniversalButtons.frame.size.height ) animated:YES];
                }
                
                if (flagIsLandscape == 0) {
                    
                    float yPositionButton  = (63) * (sender.tag-1);
                    
                    [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake(_scrollViewUniversalButtons.frame.origin.x, _scrollViewUniversalButtons.frame.origin.y, _scrollViewUniversalButtons.frame.size.width , yPositionButton + _scrollViewUniversalButtons.frame.size.height - 130) animated:YES];
                }
                */
                
                
                
                [self displayWindows];
                
            }
            
            
            
            
            
        }else{
            
           
            
            //NSLog(@"2  actionPerfbuttons gleicher button wie vorher und er war DOCH selected  %d", flagPerfBoxOn);
            
            perfButton.selected = NO; displayWindow = 0; [self displayWindows]; [self MainRoutine];
            
        }
        
    }
    
    
    
    
    
    if (previousdButton != sender.tag) {
        
        //NSLog(@"3  anderer button  %d", flagPerfBoxOn);
        
        UIButton *prevButt = (UIButton *)[self.viewTopDisplayButtons viewWithTag:previousdButton];
        
        prevButt.selected = NO;
        
        perfButton.selected = YES;
        previousdButton = sender.tag;
        

         signalStripe.frame = CGRectMake(perfButton.frame.origin.x, signalStripe.frame.origin.y, signalStripe.frame.size.width, signalStripe.frame.size.height);
        
        
        
        if (flagPerfBoxOn == 1) {
            
            flagPerfBoxOn = 0;
            
            [self addPerformanceButtons];
            
            displayWindow = sender.tag + 100;
            
                      
            
            // scroll to the damn button
            /*
            if (flagIsLandscape == 1) {
                
                float yPositionButton  = (182) * (sender.tag-1) - 2;
                
                
                
                [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake(_scrollViewUniversalButtons.frame.origin.x, _scrollViewUniversalButtons.frame.origin.y, yPositionButton + (_scrollViewUniversalButtons.frame.size.width - 208), _scrollViewUniversalButtons.frame.size.height ) animated:YES];
            }
            
            if (flagIsLandscape == 0) {
                
                float yPositionButton  = (63) * (sender.tag-1);
                
                [_scrollViewUniversalButtons scrollRectToVisible:CGRectMake(_scrollViewUniversalButtons.frame.origin.x, _scrollViewUniversalButtons.frame.origin.y, _scrollViewUniversalButtons.frame.size.width , yPositionButton + _scrollViewUniversalButtons.frame.size.height - 130) animated:YES];
            }
            */
            
            
            
            [self displayWindows];
            
        }
        
    }
    
    
    if (displayWindow > 100) {
        signalStripe.hidden = NO;
    }else{
        signalStripe.hidden = YES;
        
        
    }
    
    
    
    [self MainRoutine];
    
    
    
    
    
    
}

// performance ***********************************************************************************
// performance ***********************************************************************************
// performance ***********************************************************************************




- (void) loadPerfChartData {
    
    //NSLog(@"loadPerfChartData ");
    
    
    
    // get chart names from chartsArray
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer, AC_Type, ACVariant, @"availableCharts" ];
    
     //NSLog( @"loading arrayKey %@ ", arrayKey );
    
    chartsArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    //NSLog( @"loadPerfChartData chartsArray %@ ", chartsArray );
    
    [perfButtonChartNames removeAllObjects];
    [perfButtonUserNames removeAllObjects];
    
    
    arrayButtonsToHide = [[NSMutableArray alloc] init];
    arrayChartsToShow = [[NSMutableArray alloc] init];
    
    [arrayChartsToShow addObject: @"Check" ];
    
    [arrayChartsToShow addObject: @"AEO_HOGE_TOP_Ceiling" ];
    [arrayChartsToShow addObject: @"OEI_HIGE_2min_Ceiling" ];
    [arrayChartsToShow addObject: @"OEI_MCP_Ceiling" ];
    [arrayChartsToShow addObject: @"ClmbGrad_<3200kg" ];
    [arrayChartsToShow addObject: @"ClmbGrad_3700kg" ];
    [arrayChartsToShow addObject: @"ClmbGrad_2min_Vy" ];
    
    amountButtonsNeeded = 0;
    
    //NSLog(@"chartsArray.count  %d", chartsArray.count);
    
    
    // get info file data for each chart name
    for(int i =0; i<chartsArray.count; i++) {
        
        //NSLog(@"i  %d", i);
        // get info General files
        
        chartNameForThisInfoFile = [chartsArray objectAtIndex:i];
        //NSLog(@"chartNameForThisInfoFile %@", chartNameForThisInfoFile );
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@", chartNameForThisInfoFile, @"infoGeneral" ];
        //NSLog(@"infoGeneral  %@", [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] );
        
        infoFilesGeneral = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        
        
        
        // create array for performance buttons
        
        //NSLog(@" [infoFilesGeneral objectAtIndex:0] %@", [infoFilesGeneral objectAtIndex:0]);
        //NSLog(@" [infoFilesGeneral objectAtIndex:1] %@", [infoFilesGeneral objectAtIndex:1] );
        //NSLog(@" [infoFilesGeneral objectAtIndex:2] %@", [infoFilesGeneral objectAtIndex:2]);
        
        //NSLog(@"[infoFilesGeneral objectAtIndex:3] %@", [infoFilesGeneral objectAtIndex:3]);
        
        
        
        // check if button should be shown
        
         if ([arrayChartsToShow containsObject: [infoFilesGeneral objectAtIndex:1]] ) {
             
             //NSLog(@"we want to show this:  %@", [infoFilesGeneral objectAtIndex:1]);
             [arrayButtonsToHide addObject: [ [NSString alloc] initWithFormat:@"%d", i]];

             
         }
        
        
        if (infoFilesGeneral.count >= 4) {
            
            if ([[infoFilesGeneral objectAtIndex:3] rangeOfString:@"next"].location != NSNotFound  ) {
                //NSLog(@"case1");
                amountButtonsNeeded = amountButtonsNeeded + 1;
                [perfButtonChartNames addObject:chartNameForThisInfoFile];
            }else if ([[infoFilesGeneral objectAtIndex:3] isEqualToString:@""]  ) {
                //NSLog(@"case2");
                //NSLog(@"nothing  found - make a button but do not write info");
                amountButtonsNeeded = amountButtonsNeeded + 1;
                [perfButtonChartNames addObject:chartNameForThisInfoFile];                
            }else{
                //NSLog(@"case3 dfghjhgfdfghjkgfdfghjkgfdfghjkhgfdfgh");
                amountButtonsNeeded = amountButtonsNeeded + 1;
                [perfButtonChartNames addObject:chartNameForThisInfoFile];
            }
            
        }else{
            //NSLog(@"case4***************");
            amountButtonsNeeded = amountButtonsNeeded + 1;
            [perfButtonChartNames addObject:chartNameForThisInfoFile];
        }
        
        
      
        
    }
    
    
      
    
    NSLog(@"amountButtonsNeeded %f", amountButtonsNeeded);
   
    [self addPerformanceButtons];
    
    
    
}




- (void) calcPerformance {
    
    if ([AC_Type isEqualToString:@"H145"]) {
        
        [self getPenaltiesH145];
        
    }
    
   
    
    //NSLog(@"calcPerformance displayWindow %.0f ", displayWindow);
    
    [_arrayExternalLoadRestrictions removeAllObjects];
    
    float sendFuelWeightKg = _sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue];
    
    
    if (_viewPenaltyOverride.hidden == NO) {
        penaltyWeight = _sliderTestWeightPenalty.value * -1;
        penaltyFtMin = _sliderTestHeightGainPenalty.value * -1;
        
        _labelSliderTestWeightPenalty.text = [ [NSString alloc] initWithFormat:@"%.1f kg", penaltyWeight ];
        
        _labelSliderTestHeightGainPenalty.text = [ [NSString alloc] initWithFormat:@"%.2f ft/100ft", penaltyFtMin ];
        
    }
   
    
   
    
    [calculatePerformanceClass_ transferMethod:OAT sendPA:Hp  sendHeadWindKts:_sliderHeadwind2.value   sendACweight:weightTOW sendSelectedChartButton:selectedChartButton  sendISADiff:ISAdif   sendAltimeterInches:sliderQNH.value sendPenaltyWeight:penaltyWeight sendPenaltyFtMin:penaltyFtMin sendFuelWeight:sendFuelWeightKg sendDA:densityalt sendISADIFF:sliderISADiff.value];

    
    
    if (displayWindow > 100) {
        [viewOne bringSubviewToFront:calculatePerformanceClassView_];
        
        [viewMain bringSubviewToFront:viewEnvironment]; viewEnvironment.hidden = NO;
        
        calculatePerformanceClassView_.hidden = NO;
    }else{
        
         calculatePerformanceClassView_.hidden = YES;
        
        calculatePerformanceClassView_.frame = CGRectMake(0, 114, 646, 634);

    }

    
    //- (void) testMethod:  (float)receivedOAT  sendPA:(float)receivedPA  sendSelectedChartButton:(float)receivedSelectedChartButton
    
    
}// end calcPerformance










- (IBAction)actionReloadPerfData:(id)sender {
    
    importPerfData *_importPerfData = [[importPerfData alloc]init];
    //[_importPerfData checkIfPerfDataIsLoaded];
    [_importPerfData loadDataFromDisk];
    
    [self loadPerfChartData];
    
    [calculatePerformanceClass_ resetPreviousChartName ];
    
    [self addPerformanceButtons];
    
    [self MainRoutine];
    
    
}





- (IBAction)actionRestoreConfigsAfterUpdate:(id)sender {
    
    alertFlag = 444;
    
    
    UIAlertView *alert = [[UIAlertView alloc]
                          
                          initWithTitle:@"Reload Configurations"
                          
                          message:@"Are you sure you want to reload? Current flight data will be deleted."
                          
                          delegate:self
                          
                          cancelButtonTitle:@"CANCEL"
                          
                          
                          
                          otherButtonTitles:@"RELOAD", nil];
    
    [alert show];
    
    
    
    
    
}




- (void) updateAvailableACTypes : (int)flagLoadFromDisk {
    
    
    [availableACTypes removeAllObjects];
    
    // for load from online:
    
    NSString *availableACTypesURL;
    
    if (flagLoadFromDisk == 1) {
        
        availableACTypesURL = @"availableACTypes";
        
    }else{
        NSString *inputCommunicationKey   = [[NSUserDefaults standardUserDefaults]  stringForKey:@"_inputCommunicationKey"];
        availableACTypesURL = [ [NSString alloc] initWithFormat:@"%@%@%@", serverUrl, inputCommunicationKey, @"availableACTypes" ];
        
        
    }
    
    NSString *path = [[NSBundle mainBundle] pathForResource:availableACTypesURL ofType:@"txt"];
    
    importedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@" " withString:@""];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
    
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
    
    for(int i =0; i<components.count; i++) {
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        if (componentItems.count > 1) {
            
            AC_Type = [componentItems objectAtIndex:2];
            [availableACTypes addObject:AC_Type];
        }
    }
    
    // save array
    arrayKey = @"availableACTypesArray" ;
    [[NSUserDefaults standardUserDefaults]  setObject:availableACTypes       forKey:arrayKey ];
    

    return;
    
    
}





- (void) importConfigurationsAndSaveDefaults: (int)flagLoadFromDisk {
    
    //NSLog(@"importConfigurationsAndSaveDefaults flagLoadFromDisk %d", flagLoadFromDisk);
    
    
    
    
    NSString *configText;
    
    [self updateAvailableACTypes:1];
    
    //NSLog(@"loading availableACTypes Array = %@", availableACTypes);
    
    
    
    for (int acTypeNumber = 0; acTypeNumber<availableACTypes.count; acTypeNumber++) {
        
        
        
        
        
        [arrayConfigButtons removeAllObjects];
        [arrayConfigButtons addObject:@"-"];
        
        [arrayConfigurations removeAllObjects];
        [arrayConfigurations addObject:@"-"];
        
        
        actypeForConfig = [availableACTypes objectAtIndex:acTypeNumber];
        
        //NSLog(@"creating defaults for actypeForConfig %@", actypeForConfig );
        
        if (flagLoadFromDisk == 1) {            
            
             NSString *availableConfigurationNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_configurations", @"", actypeForConfig ];
             NSString *path = [[NSBundle mainBundle] pathForResource:availableConfigurationNameUrl ofType:@"txt"];
             configText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
             configText = [configText substringToIndex:[configText length] - 1];
            
             //NSLog(@"availableConfigurationNameUrl: %@", availableConfigurationNameUrl ) ;
             //NSLog(@"loaded from disk configText %@", configText ) ;
            
        }else{
            
            //ftp://gyronimo:@gyronimo.online/public_html/0aaGyroData/regatest/H145_configurations.txt
            
            if (!([self is_online])) {
                UIAlertView *alert = [[UIAlertView alloc]
                                      initWithTitle:@"Error"
                                      message:@"Cannot reach server. Please check if this device is online."
                                      delegate:self
                                      cancelButtonTitle:@"OK"
                                      otherButtonTitles:nil];
                [alert show];
            }else{
                NSString *availableConfigurationNameUrl = @"https://www.gyronimo.online/0aaGyroData/regatest/H145_configurations.txt";
                //NSLog( @"availableConfigurationNameUrl %@", availableConfigurationNameUrl);
                NSURL *URL = [NSURL URLWithString: availableConfigurationNameUrl];
                [[NSURLCache sharedURLCache] removeAllCachedResponses];
                [[NSURLCache sharedURLCache] setDiskCapacity:0];
                [[NSURLCache sharedURLCache] setMemoryCapacity:0];
                NSStringEncoding encoding;
                NSError *error;
                
                configText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
                configText = [configText substringToIndex:[configText length] - 1];
                
                if (configText.length > 1) {
                    [[NSNotificationCenter defaultCenter] postNotificationName:@"NotificationataReceived"
                                                                        object:self];
                    
                    
                    UIAlertView *alert = [[UIAlertView alloc]
                                          initWithTitle:@"Import"
                                          message:@"All configurations imported successfully."
                                          delegate:self
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
                    [alert show];
                    
                    
                    
                    [arrayConfigurations removeAllObjects];
                    [arrayConfigButtons removeAllObjects];
                    
                    [arrayConfigurations addObject:@"-"];
                    [arrayConfigButtons addObject:@"-"];
                }
                //NSLog(@"imported configText %@", configText ) ;
                
            }
           
            
            
        }
     
        //NSLog(@"configText %@", configText);

        
        
        // separate loaded string into configurations
        NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"^"];
        NSArray *configurations = [configText componentsSeparatedByCharactersInSet:charSet1];
        
        
        maxConfigs = configurations.count ;
        //NSLog(@"maxConfigs %.0f", maxConfigs );
        
        // read each configuration, get name and allocate to arrays
        for (int i = 0; i<configurations.count; i++) {
            
            [_arrayName1 removeAllObjects];
            [_arrayName2 removeAllObjects];
            [_arrayName3 removeAllObjects];
            [_arrayName4 removeAllObjects];
            [_arrayName5 removeAllObjects];
            [_arrayName6 removeAllObjects];
            [_arrayName7 removeAllObjects];
            [_arrayName8 removeAllObjects];
            [_arrayName9 removeAllObjects];
            [_arrayName10 removeAllObjects];
            [_arrayName11 removeAllObjects];
            [_arrayName12 removeAllObjects];
            [_arrayName13 removeAllObjects];
            [_arrayName14 removeAllObjects];
            [_arrayName15 removeAllObjects];
            [_arrayName16 removeAllObjects];
            [_arrayName17 removeAllObjects];
            [_arrayName18 removeAllObjects];
            [_arrayName19 removeAllObjects];
            [_arrayName20 removeAllObjects];
            [_arrayName21 removeAllObjects];
            [_arrayName22 removeAllObjects];
            [_arrayName23 removeAllObjects];
            [_arrayName24 removeAllObjects];
            [_arrayName25 removeAllObjects];
            
            
            NSString *configString = [configurations objectAtIndex:i];
            
            NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
            NSArray *components = [configString componentsSeparatedByCharactersInSet:charSet];
            
            NSArray* componentItems;
            componentItems  = [[components objectAtIndex:1] componentsSeparatedByString:@","];
            
            // get name
            //NSLog(@"importing config name %@", [componentItems objectAtIndex:0] );
            
            NSString *tempConfigName = [componentItems objectAtIndex:0] ;
            
            
            
            
            componentItems  = [[components objectAtIndex:1] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName1 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:2] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName2 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:3] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName3 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:4] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName4 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:5] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName5 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:6] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName6 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:7] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName7 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:8] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName8 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:9] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName9 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:10] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName10 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:11] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName11 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:12] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName12 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:13] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName13 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:14] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName14 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:15] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName15 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:16] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName16 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:17] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName17 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:18] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName18 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:19] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName19 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:20] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName20 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:21] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName21 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:22] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName22 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:23] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName23 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:24] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName24 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:25] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName25 addObject:[componentItems objectAtIndex:i] ];  }
            
            
            
            defaultConfigName =tempConfigName;
            [arrayConfigurations addObject: tempConfigName];
            [arrayConfigButtons addObject: [ [NSString alloc] initWithFormat:@"%d", i+1  ]];
           
          
            
            [self saveArrayListo];
            
            
        }
      
        
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigurations     forKey:[NSString stringWithFormat:@"arrayConfigurations%@", actypeForConfig]   ];
   
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigButtons      forKey:[NSString stringWithFormat:@"arrayConfigButtons%@", actypeForConfig]   ];
        
    
        
        //NSLog(@"saving arrayConfigButtons %@ ", arrayConfigButtons);
                                            
                                            
                                            
        
    }

    
    
    
    
    return;
}





- (IBAction)actionReloadConfigData:(id)sender {
    
    //NSLog(@" actionReloadConfigData %@", AC_Type);


    
     [self importConfigurationsAndSaveDefaults: 1];  // 1 = load from disk
    
    
    
    configuration = 1;
    
    
    [self setConfiguration];
    
    [self makeConfigButtons];
    
    configuration = activeConfigButton;
    
    [self setConfiguration];
    
    [self searchbutSelHeli];
    
    [self SaveValues];
    
    [self MainRoutine];


}


- (void) actionDataReceived {
    
    //NSLog(@"data received");
    
    configuration = 1;
    
  
    
    [self makeConfigButtons];
    
    configuration = activeConfigButton;
    
    [self setConfiguration];
    
    [self searchbutSelHeli];
    
    [self SaveValues];
    
    [self MainRoutine];

    
    
}


- (IBAction)actionImportConfigDataFromFleetControl:(id)sender {
    
    [self importConfigurationsAndSaveDefaults: 0];  // 1 = load from disk
    
    configuration = 1;
    
    
    
    // load initial config
    
    [self loadArrayListo];
    
    [self setConfiguration];
    [self SaveValues];
    
    [self createListoItemsSlidersAndInterior];
    
    
    [self makeConfigButtons];
    
    
    
    
}



- (void) restoreConfigsAfterUpdate {
    
}


- (void) animateEnvironment {
    
    
    
    
    // Y Position
    
    
    float OGEscaleYstartPixel  = 571; // bottom of graphic
    float OGEscaleYendPixel    = 58; // top
    
    float OGEscaleYstartValue  = 0; // bottom start value
    float OGEscaleYendValue    = 22000; // top value
    
    
    
    
    
    float OGEpixelDiffy = OGEscaleYendPixel - OGEscaleYstartPixel;
    float OGEvalueDiffy = OGEscaleYendValue - OGEscaleYstartValue;
    float OGEpixStepy = OGEpixelDiffy/OGEvalueDiffy ; //
    
    float OGEywert =   sliderHp.value - OGEscaleYstartValue; // wert ist null wenn ganz UNTEN
    
    float OGEyposition = OGEscaleYstartPixel + (OGEpixStepy* OGEywert) ;
    
    
    
    
    _graphicHeli.center = CGPointMake( 292, (OGEyposition+20 - (MSLtoHpDifference * 0.021)) );
    
    
    
    
    
    
    
    // BAR Heli
    
    _barHeliMSL.center = CGPointMake( 319, 598); // BAR Pressue Alt  moving LEFT RIGHT
    
    _barHeliMSL.layer.anchorPoint = CGPointMake(0.5, 1); // 0.5 = mitte    -0.5 + unterkante = oberkante // 6.89 = 100%
    
    float totalHeightKgBar = (60.0 / 24000) * (Hp +  MSLtoHpDifference )   ;
    
    _barHeliMSL.layer.transform = CATransform3DMakeScale(1, totalHeightKgBar, 0); // breit / hoch 20.5 = 800
    
    
    
    
    
    OGEscaleYstartPixel  = 667; // bottom of graphic
    OGEscaleYendPixel    = 155; // top
    
    OGEscaleYstartValue  = 0; // bottom start value
    OGEscaleYendValue    = 22000; // top value
    
    
    
    
    
    OGEpixelDiffy = OGEscaleYendPixel - OGEscaleYstartPixel;
    OGEvalueDiffy = OGEscaleYendValue - OGEscaleYstartValue;
    OGEpixStepy = OGEpixelDiffy/OGEvalueDiffy ; //
    
    
    
    OGEywert =   [_labelOGEceiling.text floatValue] - OGEscaleYstartValue; // wert ist null wenn ganz UNTEN
    
    OGEyposition = OGEscaleYstartPixel + (OGEpixStepy* OGEywert) ;
    
    _graphicOGECeiling.center = CGPointMake( 322, (OGEyposition - (MSLtoHpDifference * 0.021)) );
    
    
    
    
    
    
    return;
    
    
    
    
}


- (IBAction)actionSegment:(id)sender {
    
    [self MainRoutine];
    
}

// special equipment list /***********************************************************************************************'




- (void) createEquipmentArrays {
    
    //NSLog(@"createEquipmentArrays");
    
    // check loaded arrays:
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    NSString *downloadedEquipDataString = @"";
    downloadedEquipDataString    = [defaults  stringForKey:@"downloadedEquipDataString"];
    //NSLog(@"downloadedEquipDataString %@ ", downloadedEquipDataString);
    
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [downloadedEquipDataString componentsSeparatedByCharactersInSet:charSet];
    //NSLog( @"components %@", components);
    
    [arrayBaseName             removeAllObjects];
    [arrayConfigurationName     removeAllObjects];
    [arrayPackageName           removeAllObjects];
    [arrayConfigItemName        removeAllObjects];
    [arrayConfigItemWeight      removeAllObjects];
    [arrayConfigItemArmLong     removeAllObjects];
    [arrayConfigItemMomLong     removeAllObjects];
    [arrayConfigItemArmLat      removeAllObjects];
    [arrayConfigItemMomLat      removeAllObjects];
    [arrayConfigIteminOut       removeAllObjects];
    [arrayConfigItemLocked      removeAllObjects];

    
    // cData, Standard, Eimer,10,2000,20000,0,0,in,unlocked
    
    for(int i =0; i<components.count-1; i++) {
        
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        //NSLog( @"componentItems %@", componentItems);
        //component = [component stringByReplacingOccurrencesOfString:@" " withString:@""];
        [arrayBaseName              addObject: componentItems [1]];
        [arrayConfigurationName     addObject: componentItems [2]];
        [arrayPackageName           addObject: componentItems [3]];
        [arrayConfigItemName        addObject: componentItems [4]];
        [arrayConfigItemWeight      addObject: [componentItems[5] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
        [arrayConfigItemArmLong     addObject: [componentItems[6] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
        [arrayConfigItemMomLong     addObject: [componentItems[7] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
        [arrayConfigItemArmLat      addObject: [componentItems[8] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
        [arrayConfigItemMomLat      addObject: [componentItems[9] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
        [arrayConfigIteminOut       addObject: [componentItems[10] stringByReplacingOccurrencesOfString:@" " withString:@""]   ];
        [arrayConfigItemLocked      addObject: [componentItems[11] stringByReplacingOccurrencesOfString:@" " withString:@""]   ];
        
    }
    
    
    //NSLog( @"arrayConfigItemName %@", arrayConfigItemName);
    //NSLog( @"arrayConfigItemName %@", arrayConfigItemName);
    
    // create defaults
    NSOrderedSet *orderedSet = [NSOrderedSet orderedSetWithArray:arrayBaseName];
    //arrayAvailableListIDs = [orderedSet array];
    
    arrayAvailableListIDs = [[NSMutableArray alloc] init];
    for(int i =0; i<[orderedSet array].count; i++) {
        
       //NSLog( @"adding  %@", [orderedSet array] [i] );
        [arrayAvailableListIDs addObject:[orderedSet array] [i] ];
        
        
        
        
    }
    
    [defaults  setObject:arrayBaseName              forKey:[@"default" stringByAppendingString:@"arrayBaseName"]];
    [defaults  setObject:arrayConfigurationName     forKey:[@"default" stringByAppendingString:@"arrayConfigurationName"]];
    [defaults  setObject:arrayPackageName           forKey:[@"default" stringByAppendingString:@"arrayPackageName"]];
    [defaults  setObject:arrayConfigItemName        forKey:[@"default" stringByAppendingString:@"arrayConfigItemName"]];
    [defaults  setObject:arrayConfigItemWeight      forKey:[@"default" stringByAppendingString:@"arrayConfigItemWeight"]];
    [defaults  setObject:arrayConfigItemArmLong     forKey:[@"default" stringByAppendingString:@"arrayConfigItemArmLong"]];
    [defaults  setObject:arrayConfigItemMomLong     forKey:[@"default" stringByAppendingString:@"arrayConfigItemMomLong"]];
    [defaults  setObject:arrayConfigItemArmLat      forKey:[@"default" stringByAppendingString:@"arrayConfigItemArmLat"]];
    [defaults  setObject:arrayConfigItemMomLat      forKey:[@"default" stringByAppendingString:@"arrayConfigItemMomLat"]];
    [defaults  setObject:arrayConfigIteminOut       forKey:[@"default" stringByAppendingString:@"arrayConfigIteminOut"]];
    [defaults  setObject:arrayConfigItemLocked      forKey:[@"default" stringByAppendingString:@"arrayConfigItemLocked"]];
    
    [self SaveValues];
    
    return;
    
}


- (IBAction)actionViewSpecialEquipList:(id)sender {
    
      guidanceDictionary[@"guidanceBtnSetEquipment"] =  @"ok";
    
    if (_viewSpecialEquiplist.hidden == YES) {
        _viewSpecialEquiplist.hidden = NO;
        
        [viewOne bringSubviewToFront:_viewSpecialEquiplist];
        
        [viewOne bringSubviewToFront:viewTopTop];
        
        [self createSpecialEquipListItems];
        
      /*
        if (flagRefreshSpecialEquipmentList == 1 || flagOrientationHasChanged == 1) {
            
            _viewSpecialEquiplist.hidden = YES;
            
            flagOrientationHasChanged = 0;
            
            flagRefreshSpecialEquipmentList = 0;
            
             [self createSpecialEquipListItems];
        }
       
  
        */
       
        
        
    }else{
        
        _viewSpecialEquiplist.hidden = YES;
        
    }
    
    [self SaveValues];
    
    [self MainRoutine];
    
    
}

- (IBAction)dropDown1DidEndOnExit:(id)sender {
    
    
    [self createSpecialEquipListItems];
}


- (void) createSpecialEquipListItems {
    
    //NSLog(@"createSpecialEquipListItems ");
    
    if ([[_arrayName21 objectAtIndex: 5  ] isEqualToString:@"lbs"]) {
        
        _labelSpecialEquipUnitMass.text = @"lbs";
        _labelSpecialEquipUnitMass2.text = @"lbs";
        
        _labelSpecialEquipUnitLong.text = @"lbs.In";
        _labelSpecialEquipUnitLong2.text = @"lbs.In";
        
        _labelSpecialEquipUnitLat.text = @"lbs.In";
        _labelSpecialEquipUnitLat2.text = @"lbs.In";

        
        
    }else{
        
        
        _labelSpecialEquipUnitMass.text = @"kg";
        _labelSpecialEquipUnitMass2.text = @"kg";
        
        _labelSpecialEquipUnitLong.text = @"kg.mm";
        _labelSpecialEquipUnitLong2.text = @"kg.mm";
        
        _labelSpecialEquipUnitLat.text = @"kg.mm";
        _labelSpecialEquipUnitLat2.text = @"kg.mm";
        
        
    }

    
    
    
    
    //NSLog(@"configuration %d ", configuration);
    
    for(UIView *subview in [_viewSpecialEquipItems subviews]) {
        [subview removeFromSuperview];
    }
    [self.viewSpecialEquipItems.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    
    _dropDownBaseID.items   =  arrayAvailableListIDs;
    
    
    //NSLog(@"1 arrayAvailableListIDs  %@", arrayAvailableListIDs);
    
    
    
    
   
    if ([_dropDownBaseID.text isEqualToString:@""]) {
        //_dropDownBaseID.text = [arrayAvailableListIDs objectAtIndex:0];       ;
        
        _dropDownBaseID.text = [_arrayName23 objectAtIndex:32];
    }
    
    
    
    currentBaseName = _dropDownBaseID.text;
    
    //_labelConfigOnHeliCenter.text = arrayConfigurations[configuration];
    
    
    currentConfigName = arrayConfigurations[configuration];
    
    //NSLog(@"currentConfigName %@", currentConfigName);
    
    
    
    _labelSpecialEquipConfigName.text = currentConfigName;
    
    _labelSpecialEquipBaseName.text = currentBaseName;
    
   
    
    //NSLog(@"arrayConfigItemNameSorted %@", arrayConfigItemNameSorted);
    
    
    float xPos1 = 10;
    float yGap = 40;
    float xGap = 90;
    
    float xGap2 = 80;
    
    int itemCount = -1;
    
    float kneiffer = 0;
    float kneiffer2 = 0;
    
    if (flagIsLandscape == 1) {
        kneiffer = 0;
        kneiffer2 = 0;
    }else{
        
        kneiffer = -120;
        kneiffer2 = -90;
    }
    
    _viewSpecialEquipItems.frame = CGRectMake(0, 0, 1024, arrayConfigItemName.count * yGap + 250);
    
    [_scrollViewSpecialEquipList setContentSize:CGSizeMake(_scrollViewSpecialEquipList.frame.size.width, arrayConfigItemName.count * yGap + 250 )];
    
    //NSLog(@"arrayConfigItemLocked %@", arrayConfigIteminOut);
    
    for(int i =0; i<arrayConfigItemName.count; i++) {
        
        if (![[arrayBaseName objectAtIndex: i ] isEqualToString: currentBaseName ]) {
            
            //NSLog(@"currentBaseName 1");
            
            continue;
        }
        
        if (![[arrayConfigurationName objectAtIndex: i ] isEqualToString: currentConfigName ]) {
            
            //NSLog(@"currentConfigName 2");
            
            continue;
        }
        
        
        
        itemCount = itemCount + 1;
        
        
        
        if ([[arrayConfigItemName objectAtIndex: i ] isEqualToString:@"DrawLine"]) {
            
            
            
            // DrawLine
            
            UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(xPos1 + 10 , 20+ (itemCount *yGap)  , 900, 30)];
            textField.borderStyle = UITextBorderStyleNone;
            textField.minimumFontSize = 5;
            textField.font = [UIFont boldSystemFontOfSize:14];
            textField.autocorrectionType = UITextAutocorrectionTypeNo;
            textField.textAlignment = NSTextAlignmentLeft;
            textField.enabled = NO;
            textField.backgroundColor = [UIColor clearColor];
            textField.textColor = [UIColor whiteColor];
            
            [textField addTarget:self
                          action:@selector(closeKeyboard:)
                forControlEvents:UIControlEventEditingDidEndOnExit];
            
            [textField  setText: @"--------------------------------------------------------------------------------------------------------------------------"];
            
            textField.tag = i+1000;
            
            [_viewSpecialEquipItems addSubview: textField];
            
            
        }else if ([[arrayConfigItemName objectAtIndex: i ] isEqualToString:@"PackageName"]) {
            
            
            // package name
            
            UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(0 ,  (itemCount *yGap)  , 1024, 35)];
            textField.borderStyle = UITextBorderStyleNone;
            textField.minimumFontSize = 5;
            textField.font = [UIFont boldSystemFontOfSize:17];
            textField.autocorrectionType = UITextAutocorrectionTypeNo;
            textField.textAlignment = NSTextAlignmentLeft;
            textField.enabled = NO;
            textField.backgroundColor = [UIColor lightGrayColor];
            textField.textColor = [UIColor blackColor];
            
            [textField addTarget:self
                          action:@selector(closeKeyboard:)
                forControlEvents:UIControlEventEditingDidEndOnExit];
            
            
            
            [textField  setText: [arrayPackageName objectAtIndex: i ]   ];
            
            
            [textField  setText: [NSString stringWithFormat:@"     Package: %@", [arrayPackageName objectAtIndex: i ]  ]   ];
            
            
            
            
            textField.tag = i+1000;
            
            [_viewSpecialEquipItems addSubview: textField];
            
            
            // package in / out button
            
            UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame = CGRectMake(xPos1 + ( 7 * xGap) + xGap2 + 50 + kneiffer,  (itemCount *yGap)  , 120, 35);
            [btn addTarget:self
                    action:@selector(actionPackageInOut:)
          forControlEvents:UIControlEventTouchUpInside];
            
            btn.tag = i+30000;
            
            //NSLog(@"make btn.tag %d", btn.tag);
            
            
            [btn setTitle: @"ALL IN/OUT" forState: UIControlStateNormal];
            btn.backgroundColor = [UIColor whiteColor];
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
            
            
            if ([[arrayConfigItemLocked objectAtIndex: i ] isEqualToString:@"locked"]) {
                btn.enabled = NO;
                
                [btn setTitle: @"LOCKED" forState: UIControlStateNormal];
                [btn setTitleColor:[UIColor darkGrayColor] forState:UIControlStateNormal];
                
            }else{
                btn.enabled = YES;
            }
            
            //[btn  setBackgroundImage:[UIImage imageNamed: @"button minus red.png" ] forState:UIControlStateNormal];
            [_viewSpecialEquipItems addSubview:btn];

            
            
            
            
            
            
            
            
            
            
            
        }else{
            
            
            // item name
            
            UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + 10 ,  (itemCount *yGap)  , 300 + + kneiffer2, 30)];
            label.font = [UIFont boldSystemFontOfSize:14];
            label.textAlignment = NSTextAlignmentLeft;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemName objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            // item weight
            
            label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + ( 2 * xGap) + xGap2 + kneiffer2,  (itemCount *yGap)  , 100, 30)];
            label.font = [UIFont boldSystemFontOfSize:15];
            label.textAlignment = NSTextAlignmentRight;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemWeight objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            
            
            // item arm
            
            label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + ( 3 * xGap) + xGap2 + kneiffer2,  (itemCount *yGap)  , 100, 30)];
            label.font = [UIFont boldSystemFontOfSize:15];
            label.textAlignment = NSTextAlignmentRight;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemArmLong objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            
            
            // item mom
            
            label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + ( 4 * xGap) + xGap2 + kneiffer2,  (itemCount *yGap)  , 100, 30)];
            label.font = [UIFont boldSystemFontOfSize:15];
            label.textAlignment = NSTextAlignmentRight;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemMomLong objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            
            // item armlat
            
            label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + ( 5 * xGap) + xGap2 + kneiffer2,  (itemCount *yGap)  , 100, 30)];
            label.font = [UIFont boldSystemFontOfSize:15];
            label.textAlignment = NSTextAlignmentRight;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemArmLat objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            
            // item momlat
            
            label = [[UILabel alloc] initWithFrame:CGRectMake(xPos1 + ( 6 * xGap) + xGap2 + kneiffer2,  (itemCount *yGap)  , 100, 30)];
            label.font = [UIFont boldSystemFontOfSize:15];
            label.textAlignment = NSTextAlignmentRight;
            label.textColor = [UIColor whiteColor];
            [label  setText: [arrayConfigItemMomLat objectAtIndex: i ] ];
            [_viewSpecialEquipItems addSubview: label];
            
            
            // in / out button
            
            UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame = CGRectMake(xPos1 + ( 7 * xGap) + xGap2 + 50 + kneiffer2,  (itemCount *yGap)  , 50, 30);
            [btn addTarget:self
                    action:@selector(actionSpecialEquipmentInOut:)
          forControlEvents:UIControlEventTouchUpInside];
            
            btn.tag = i+20000;
            
            //NSLog(@"make btn.tag %d", btn.tag);
            
            
            if ([[arrayConfigIteminOut objectAtIndex: i ] floatValue] == 0) {
                
                [btn setTitle: @"OUT" forState: UIControlStateNormal];
                btn.backgroundColor = [UIColor redColor];
                [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
                
                
            }else{
                
                [btn setTitle: @"IN" forState: UIControlStateNormal];
                btn.backgroundColor = [UIColor greenColor];
                [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
                
                
                
            }
            
            
            if ([[arrayConfigItemLocked objectAtIndex: i ] isEqualToString:@"locked"]) {
                btn.enabled = NO;
                
            }else{
                
                btn.enabled = YES;
                
            }
            
            
            //[btn  setBackgroundImage:[UIImage imageNamed: @"button minus red.png" ] forState:UIControlStateNormal];
            [_viewSpecialEquipItems addSubview:btn];
            
            
            
            if ([[arrayConfigItemLocked objectAtIndex: i ] isEqualToString:@"locked"]) {
                
                UIImageView *image =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + ( 8 * xGap) + xGap2 + 20  + kneiffer2, (itemCount *yGap) ,36,30)];
                image.image=[UIImage imageNamed:@"lock - locked-01.png"];
                [_viewSpecialEquipItems addSubview:image];
                
                UIImageView *darkImage =[[UIImageView alloc] initWithFrame:CGRectMake( xPos1 + ( 7 * xGap) + xGap2 + 50  + kneiffer2,  (itemCount *yGap) ,50,30)];
                darkImage.backgroundColor = [UIColor blackColor];
                darkImage.alpha = 0.3;
                [_viewSpecialEquipItems addSubview:darkImage];
                
                
            }
            
            
            /*
             else{
             
             UIImageView *image =[[UIImageView alloc] initWithFrame:CGRectMake(xPos1 + ( 8 * xGap) + xGap2 + 20 ,20+ (itemCount *yGap) ,36,30)];
             image.image=[UIImage imageNamed:@"lock - UNlocked-01.png"];
             [_viewSpecialEquipItems addSubview:image];
             
             }
             */
            
            
            
            
            
            
        }       // end else is line
        
        
        
        
        
        
        
        
        
        
        
        
    }
    
    
    
    [self computeSpecialEquipmentTotals];
    
}



- (void)actionPackageInOut:(UIButton*)sender {

    float itemNr = sender.tag - 30000;
    
    //get package name
    NSString *packageNameToSet = [arrayPackageName objectAtIndex: itemNr ];
    
    //NSLog(@"package packageNameToSet %@ ", packageNameToSet );
    
    
    for(int i =0; i<arrayConfigItemName.count; i++) {
        
        if ([[arrayPackageName objectAtIndex: i ] isEqualToString:packageNameToSet]) {
            
            
            if ([[arrayConfigItemLocked objectAtIndex: i ] isEqualToString:@"locked"]) {
                continue;
            }
            
            if (toggleItemsInOut == 0) {
                
                [arrayConfigIteminOut replaceObjectAtIndex:i withObject: @"0"  ];
                
                UIButton *btn = (UIButton *)[_viewSpecialEquipItems viewWithTag: i + 20000 ];
                
                [btn setTitle: @"OUT" forState: UIControlStateNormal];
                btn.backgroundColor = [UIColor redColor];
                [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
                
              
            }else{
                
                [arrayConfigIteminOut replaceObjectAtIndex:i withObject: @"1"  ];
                
                UIButton *btn = (UIButton *)[_viewSpecialEquipItems viewWithTag: i + 20000 ];
                
                [btn setTitle: @"IN" forState: UIControlStateNormal];
                btn.backgroundColor = [UIColor greenColor];
                [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
                
            }
           
            
        }
        
    }
    
    if (toggleItemsInOut == 0) {
        
        toggleItemsInOut = 1;
        
    }else{
        toggleItemsInOut = 0;
        
    }
    
    
    [self computeSpecialEquipmentTotals];
    
    
}


- (void)actionSpecialEquipmentInOut:(UIButton*)sender {
    
    
    //NSLog(@"actionSpecialEquipmentInOut");
    
    float itemNr = sender.tag - 20000;
    
    
    if ([[arrayConfigIteminOut objectAtIndex: itemNr ] floatValue] == 0) {
        
        [arrayConfigIteminOut replaceObjectAtIndex:itemNr withObject: @"1"  ];
        
        
        UIButton *btn = (UIButton *)[_viewSpecialEquipItems viewWithTag: itemNr + 20000 ];
        
        
        [btn setTitle: @"IN" forState: UIControlStateNormal];
        btn.backgroundColor = [UIColor greenColor];
        [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        
        
        
    }else{
        
        [arrayConfigIteminOut replaceObjectAtIndex:itemNr withObject: @"0"  ];
        
        UIButton *btn = (UIButton *)[_viewSpecialEquipItems viewWithTag: itemNr + 20000];
        
        [btn setTitle: @"OUT" forState: UIControlStateNormal];
        btn.backgroundColor = [UIColor redColor];
        [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        
        
        
        
    }
    
    
    
    [self computeSpecialEquipmentTotals];
    
    
    
    
    
    
    
}


- (void) computeSpecialEquipmentTotals {
    
    
    currentConfigName = arrayConfigurations[configuration];
    
    //currentBaseName = @"Base1";
    currentBaseName = _dropDownBaseID.text;
    
    //NSLog(@"currentBaseName %@", currentBaseName);
    
    _labelSpecialEquipConfigName.text = currentConfigName;
    _labelSpecialEquipBaseName.text = currentBaseName;
    
    
    
   //NSLog(@"computeSpecialEquipmentTotals");
   // create new drop down list based on actual data
    
     arrayAvailableListIDs = [[NSMutableArray alloc] init];
    [arrayAvailableListIDs removeAllObjects];
    
   
    
   
    //NSLog(@"AC_Type -%@-", AC_Type);
    
    for(int i =0; i<arrayBaseName.count; i++) {
            
        //NSLog(@"arrayBaseName  %@", [arrayBaseName objectAtIndex: i]);
        
        if ( [[arrayBaseName objectAtIndex: i]  rangeOfString:AC_Type].location != NSNotFound ) {
            
            // if the ac type is  included
            //NSLog(@"AC_Type  is included: %@", AC_Type);
            
            
            if ([[arrayConfigurationName objectAtIndex: i ] isEqualToString: currentConfigName ]) {
                
                 //NSLog(@"currentConfigName  is included: %@", currentConfigName);
                
                [arrayAvailableListIDs addObject:[arrayBaseName objectAtIndex: i] ];
            }else{
                
                continue;
            }

            
            
            
            
        }else{
            
            continue;
        }
        
        
    }
    
    
    //NSLog(@"arrayAvailableListIDs %@", arrayAvailableListIDs);
    
     NSOrderedSet *orderedSet = [NSOrderedSet orderedSetWithArray:arrayAvailableListIDs];
     //NSLog(@"orderedSet %@", orderedSet);
    
    _dropDownBaseID.items   =  [orderedSet array];


    
    
    totalSpecialEquipWeight = 0;
    
    totalSpecialEquipMoment = 0;
    
    totalSpecialEquipMomentLat = 0;
    
    
    
    float specialEquipWeight = 0;
    
    float specialEquipMoment = 0;
    
    float specialEquipMomentLat = 0;
    
    
    
    for(int i =0; i<arrayConfigItemName.count; i++) {
        
        
        if ( [[arrayBaseName objectAtIndex: i]  rangeOfString:currentBaseName].location == NSNotFound ) {
            
            // if the base name 'Base 1' is not included
            
            continue;
            
        }else{
            
            
            
            if ( [[arrayBaseName objectAtIndex: i]  rangeOfString:AC_Type].location == NSNotFound ) {
                
                // if the ac type is not cincluded
                
                continue;
                
            }
            
        }
        
        
        
        if (![[arrayConfigurationName objectAtIndex: i ] isEqualToString: currentConfigName ]) {
            
            //NSLog(@"currentConfigName 2");
            
            continue;
        }
        
        
        specialEquipWeight =  [[arrayConfigItemWeight objectAtIndex: i ] floatValue] * [[arrayConfigIteminOut objectAtIndex: i ] floatValue]   ;
        
        specialEquipMoment =  [[arrayConfigItemMomLong objectAtIndex: i ] floatValue] * [[arrayConfigIteminOut objectAtIndex: i ] floatValue]   ;
        
        specialEquipMomentLat =  [[arrayConfigItemMomLat objectAtIndex: i ] floatValue] * [[arrayConfigIteminOut objectAtIndex: i ] floatValue]   ;
        
        totalSpecialEquipWeight = totalSpecialEquipWeight + specialEquipWeight;
        
        totalSpecialEquipMoment = totalSpecialEquipMoment + specialEquipMoment;
        
        totalSpecialEquipMomentLat = totalSpecialEquipMomentLat + specialEquipMomentLat;
        
        
    }
    
    
    _labelSEtotalWeight.text = [NSString stringWithFormat:@"%.1f",totalSpecialEquipWeight];
    
    _labelSEtotalMoment.text = [NSString stringWithFormat:@"%.0f",totalSpecialEquipMoment];
    
    _labelSEtotalMomentLat.text = [NSString stringWithFormat:@"%.0f",totalSpecialEquipMomentLat];
    
    _labelSEtotalArm.text = [NSString stringWithFormat:@"%.0f",totalSpecialEquipMoment / totalSpecialEquipWeight];
    
    _labelSEtotalArmLat.text = [NSString stringWithFormat:@"%.0f",totalSpecialEquipMomentLat / totalSpecialEquipWeight];
    
    
    
    
}



// pdf merger

// NSString *fileNameSuffix = [NSString stringWithFormat:@"Load Manifest %@, %@   ", vFlightRegistration.text  , _manifestTimeStamp.text ];

- (IBAction)sendToGoodReader:(UIButton*)sender {
    
    [self createPDFDataFromManifest];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    
    NSString *documentsDirectory = [paths objectAtIndex:0];
    
     NSString *fileNameSuffix = [NSString stringWithFormat:@"Preflight_%@.pdf",  vFlightRegistration.text];
    
    //NSString *fileNameSuffix = [NSString stringWithFormat:@"LM %@_%@.pdf",   displayHeliRegistration.text, _manifestDate.text ];
    //sdf
    //NSLog(@"fileNameSuffix  -%@- ", fileNameSuffix);
    
    NSString* fileName = [documentsDirectory stringByAppendingPathComponent:fileNameSuffix];
    [pdfData writeToFile:fileName atomically:YES];
    
    NSURL *url = [NSURL fileURLWithPath:fileName];
    
    //use the UIDocInteractionController API to get list of devices that support the file type
    docController = [UIDocumentInteractionController interactionControllerWithURL:url];
    
    
    //present a drop down list of the apps that support the file type, click an item in the list will open that app while passing in the file.
    
    // use this if view is where the button is
    //[docController presentOpenInMenuFromRect:[self.view convertRect:sender.frame fromView:sender.superview] inView:self.view animated:YES];
    
    [docController presentOpenInMenuFromRect:[self.ScrollViewManifest convertRect:self.ScrollViewManifest.frame fromView:self.ScrollViewManifest.superview] inView:self.view animated:YES];
    
}

- (void)createPDFDataFromManifest {
    
    
    
    _viewAllPDF.hidden = NO;
    for(UIView *subview in [_viewAllPDF subviews]) {
        [subview removeFromSuperview];
    }
    
    _viewLowerButtons.hidden = YES;
    
    _viewManifest1.hidden = NO;
    _viewManifest2.hidden = YES;
    
    int pixelWidth = ScrollViewManifest.contentSize.width*1.6;
    int pixelHeight = ScrollViewManifest.contentSize.height*0.86;  // set hight of pdf page here (cut off the bottom)
    
    pdfData = [NSMutableData data];
    
    UIGraphicsBeginPDFContextToData( pdfData, CGRectMake(0, 0, pixelWidth, pixelHeight),  nil );
    UIGraphicsBeginPDFPage();
    CGPoint savedContentOffset = ScrollViewManifest.contentOffset;
    CGRect savedFrame = ScrollViewManifest.frame;
    
    ScrollViewManifest.contentOffset = CGPointZero;
    ScrollViewManifest.frame = CGRectMake(0, 0, pixelWidth, pixelHeight);    
    [ScrollViewManifest.layer renderInContext: UIGraphicsGetCurrentContext()];    
    ScrollViewManifest.contentOffset = savedContentOffset;
    ScrollViewManifest.frame = savedFrame;
    
    
    scrollSig.hidden = YES;
    
    //
    UIGraphicsBeginPDFPage();
    
    [self makeScreenshotPC2];    
    _viewManifest2.hidden = NO;    
    ScrollViewManifest.contentOffset = CGPointZero;
    ScrollViewManifest.frame = CGRectMake(0, 0, pixelWidth, pixelHeight);    
    [ScrollViewManifest.layer renderInContext: UIGraphicsGetCurrentContext()];    
    ScrollViewManifest.contentOffset = savedContentOffset;
    ScrollViewManifest.frame = savedFrame;
    
    
    //
    UIGraphicsBeginPDFPage();
    
    [self makeScreenshotCATA];    
    _viewManifest2.hidden = NO;    
    ScrollViewManifest.contentOffset = CGPointZero;
    ScrollViewManifest.frame = CGRectMake(0, 0, pixelWidth, pixelHeight);    
    [ScrollViewManifest.layer renderInContext: UIGraphicsGetCurrentContext()];    
    ScrollViewManifest.contentOffset = savedContentOffset;
    ScrollViewManifest.frame = savedFrame;
    
    
    
    UIGraphicsEndPDFContext();
    scrollSig.hidden = NO;
    _viewAllPDF.hidden = YES;
    _viewManifest2.hidden = YES;
    
    _viewManifest1.hidden = NO;
    _viewManifest2.hidden = YES;
    _viewLowerButtons.hidden = NO;
    
    
}

static UIDocumentInteractionController* docController;


- (void) animateFuelPathAndCheckCG {
    
    
    
    
    
    //NSLog (@"animateFuelPathAndCheckCG");
    
    if (fuelVolume <1) {
        return;
    }
    
    for(UIView *subview in [_viewFuelPathCG subviews]) {
        [subview removeFromSuperview];
    }
    
    float xCGpos = 0;
    float yCGpos = 0;
    float fuelPathSteps = 20;
    [self.viewFuelPathCG.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    float stepWeight = 0;
    float simulatedAircraftWeight = 0;
    float simulatedFuelMoment = 0;
    float simulatedTotalMoment = 0;
    
    float fuelUnitsInEnvelope1 = 0;
    float fuelUnitsInEnvelope2 = 0;
    float fuelUnitsOutsideEnvelopes = 0;
    float fuelUnitsOutsideMargin = 0;
    
    int flagIsInEnvelope = 0;
    
    float weightUnit = 0;
    
    mostFWDCGpoint = 99999;

    //NSLog(@"************");
          
    
    for (int i = 0; i < fuelPathSteps ; i++) { /// make dots fuel
      
        stepWeight = i * (([labelWeightTakeoff.text floatValue] - [labelWeightZeroFuel.text floatValue]) / fuelPathSteps);
        weightUnit = ([labelWeightTakeoff.text floatValue] - [labelWeightZeroFuel.text floatValue]) / fuelPathSteps ;
        
        // get fuel moment
        fuelVolume = stepWeight / [_inputSpecificFuelMassPerVolume.text floatValue];
        fuelWeight = stepWeight;
        [self interpolateFuelMomentsLongitudinal]; // here we get fuel moment
        //NSLog (@"fuelMoment %.0f", fuelMoment);
        simulatedFuelMoment = fuelMoment;
        // compute CG
        simulatedTotalMoment = ([labelWeightZeroFuel.text floatValue] * lZFWArm) + simulatedFuelMoment;
        simulatedAircraftWeight = [labelWeightZeroFuel.text floatValue]  + stepWeight;
        
        if (i == fuelPathSteps - 1) {
            simulatedAircraftWeight = weightTOW;
            simulatedTotalMoment =weightTOW * CGLongTOW;
            //NSLog(@"lsimulatedAircraftWeight %.1f", simulatedAircraftWeight);
            //NSLog(@"simulatedTotalMoment     %.1f", simulatedTotalMoment);
            //NSLog(@"simulatedTotal Arm check %.1f", simulatedTotalMoment / simulatedAircraftWeight);
        }
        
        // get point coordinates
        float xCGval = simulatedTotalMoment / simulatedAircraftWeight;
        float yCGval = simulatedAircraftWeight;
        
        //NSLog(@"xCGval %.0f", xCGval);
        //NSLog(@"CGLongLDW %.0f", CGLongLDW);
        
        if (xCGval <= mostFWDCGpoint & yCGval >= weightLDW) {
            mostFWDCGpoint = xCGval;
            mostFWDweight = yCGval;
            
           //NSLog(@"changing mostFWDCGpoint %.0f ", mostFWDCGpoint );
        }
        
        
       
        if (simulatedAircraftWeight > weightLDW) {
            //NSLog(@"found ldw i %d", i);
            
            // check CG **************************************************************************************************
            [self checkCGwarningLongitudinal: xCGval transferWeightTOW:yCGval ];
            // check CG **************************************************************************************************
            
            if (CGwithinEnvelope1 == 1) {
                fuelUnitsInEnvelope1 = fuelUnitsInEnvelope1 + weightUnit;
                flagIsInEnvelope = 1;
            }
            if (CGwithinEnvelope2 == 1) {
                fuelUnitsInEnvelope2 = fuelUnitsInEnvelope2 + weightUnit;
                flagIsInEnvelope = 2;
            }
            if (CGwithinEnvelope1 == 0 & CGwithinEnvelope2 == 0) {
                fuelUnitsOutsideEnvelopes = fuelUnitsOutsideEnvelopes + weightUnit;
                flagIsInEnvelope = 0;
            }
            if (CGwithinMargin == 0 ) {
                fuelUnitsOutsideMargin = fuelUnitsOutsideMargin + weightUnit;
            }
        }
        
        xCGpos = leftBorderOfMeasureBox + ( (xCGval-xAxisLeft) * xPixelFactor );
        yCGpos = topBorderOfMeasureBox  + (  (yAxisTop - yCGval) * yPixelFactor );
        
        
        float dotSize = 5;
        CAShapeLayer *circleLayer = [CAShapeLayer layer];
        [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
        [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
        
        UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
        [circleLayer setPath:[pathC CGPath]];
        [circleLayer setStrokeColor:[[UIColor clearColor] CGColor]];
        
        if (CGwithinEnvelope1 == 0 ) {
            [circleLayer setFillColor:[[UIColor redColor] CGColor]];
        }
        if (CGwithinEnvelope1 == 1 ) {
            [circleLayer setFillColor:[lightBlueColor CGColor]];
        }
        if (CGwithinEnvelope2 == 1 ) {
            [circleLayer setFillColor:[orangeSpecialColor CGColor]];
        }
        [circleLayer setLineWidth:0.0f];
        
        if (i > 1 & simulatedAircraftWeight > weightLDW) {
            [self.viewFuelPathCG.layer addSublayer:circleLayer];
        }
        
    }// end for next make path
    
    
    shapeLayerCG1.strokeColor = [GreenColor CGColor];
    
    shapeLayerCGMargin.strokeColor = [verylightBlueColor CGColor];
    
    // hoist
    if ([[_arrayName2 objectAtIndex:lineHoistSystem] floatValue] > 0) {
        shapeLayerCG2.strokeColor = [GreenColor CGColor];
    }else{
        shapeLayerCG2.strokeColor = [[UIColor lightGrayColor] CGColor];
    }
    
    
    if ([AC_Type isEqualToString:@"H175"]) {
        if (CGLongTOW > [[_arrayName21 objectAtIndex:9] floatValue]) {
            shapeLayerCG1.strokeColor = [yellowSpecialColor CGColor];
            shapeLayerCG2.strokeColor = [[UIColor redColor] CGColor];
            _labelCGinExtendedEnvelope.hidden = NO;
            counterAutoCheckFlagStatus = 2;
        }
        if (fuelUnitsInEnvelope2 > 0 ) {
            shapeLayerCG1.strokeColor = [yellowSpecialColor CGColor];
            shapeLayerCG2.strokeColor = [orangeSpecialColor CGColor];
            _labelCGinExtendedEnvelope.hidden = NO;
        }
        if (fuelUnitsOutsideMargin > 0) {
            shapeLayerCGMargin.strokeColor = [[UIColor redColor] CGColor];
            counterAutoCheckFlagStatus = 3;
            //_labelCGoutsideSafetyMargin.hidden = NO;
        }
    }
    
    
    
    if (fuelUnitsOutsideEnvelopes > 0) {
        flagWarningCG = 1;
        shapeLayerCG1.strokeColor = [[UIColor redColor] CGColor];
        shapeLayerCG2.strokeColor = [[UIColor redColor] CGColor];
        flagWarningCG = 1;
       
    }
    
    if (flagWarningCG == 1 ) {
        counterAutoCheckFlagStatus = 1;
        warningCGoutsideEnvelope.hidden = NO;
        [_ACtopView setImage:ACtop_Warning ];
    }
    
        
    
    // hoist
    if (densityalt > 12000 || Hp > 12000 ) {
        _warningHoistDAPA.hidden = NO;
        [shapeLayerCG2 setFillColor:[[[UIColor redColor] colorWithAlphaComponent:0.5] CGColor]];
        
    }else{
        _warningHoistDAPA.hidden = YES;
        
        [shapeLayerCG2 setFillColor:[[[UIColor clearColor] colorWithAlphaComponent:0.0] CGColor]];
        
    }
    
    
    float fuelAllowance = 0;
    float rampMass =  weightTOW;
    float takeoffWeight =  weightTOW-fuelAllowance;
    float maxRamp = [[_arrayName21 objectAtIndex:7] floatValue];
    float maxTOW = [[_arrayName21 objectAtIndex:9] floatValue];
    float maxLDW = [[_arrayName21 objectAtIndex:11] floatValue];;
    
    
    
    if (takeoffWeight > maxTOW) {
        flagWarningWeight = 1;
    }
    
    if (rampMass   > maxRamp) {
        flagWarningWeight = 2;
    }
    
    if (weightLDW > maxLDW) {
        flagWarningWeight = 3;
    }
    
    
    // show hide warnings
    warningAS355Pax5.hidden = YES; warningCGoutsideEnvelope.hidden = YES; warningLatCGExceeded.hidden = YES;  warningWeightLimitExceeded.hidden = YES;
    
    
    [_ACtopView setImage:ACtop ];
    
    
    if (flagWarningCG == 1 ) {
        counterAutoCheckFlagStatus = 1;
        warningCGoutsideEnvelope.hidden = NO;
        [_ACtopView setImage:ACtop_Warning ];
        
    }
    
    if (flagWarningWeight == 1 ) {
        counterAutoCheckFlagStatus = 1;
        warningWeightLimitExceeded.hidden = NO;
        warningWeightLimitExceeded.text =@"MAX TOM EXCEEDED";
        [_ACtopView setImage:ACtop_Warning ];
       
    }
    
    
    if (flagWarningWeight == 3 ) {
        counterAutoCheckFlagStatus = 1 ;
        warningWeightLimitExceeded.hidden = NO;
        warningWeightLimitExceeded.text =@"MAX LANDING MASS EXCEEDED";
        [_ACtopView setImage:ACtop_Warning ];
       
    }
    



    
    
    //float flightTimeMinutesInExtendedEnvelope = (fuelUnitsInEnvelope2 / [inputFuelFlowOverride.text floatValue])*60;
    //_labelCGinExtendedEnvelope.text =  [[NSString alloc] initWithFormat:@"Time in Extended Envelope: %.0fmin", flightTimeMinutesInExtendedEnvelope];
    //_labelCGinExtendedEnvelope.text =  [[NSString alloc] initWithFormat:@"Takeoff in Extended Envelope"];
    
    //float flightTimeMinutesOutsideSafetMargin = (fuelUnitsOutsideMargin / [inputFuelFlowOverride.text floatValue])*60;
    //_labelCGoutsideSafetyMargin.text =  [[NSString alloc] initWithFormat:@"Safety Margin Exceeded: %.0fmin", flightTimeMinutesOutsideSafetMargin];
    
}



- (void) animateFuelPathLateralAndCheckCG {
    
    
    //NSLog(@"[animateFuelPathLateral");
    
    
    flagWarningCG = 0;
    
    if (fuelVolume <1) {
        return;
    }
    
    for(UIView *subview in [_viewFuelPathCGLat subviews]) {
        [subview removeFromSuperview];
    }
    
    float xCGpos = 0;
    float yCGpos = 0;
    float fuelPathSteps = 10;
    [self.viewFuelPathCGLat.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    float stepWeight = 0;
    float simulatedAircraftWeight = 0;
    float simulatedFuelMoment = 0;
    float simulatedTotalMoment = 0;
    
    float weightUnit = 0;
    
    for (int i = 0; i < fuelPathSteps ; i++) { /// make dots
        
        stepWeight = i * (([labelWeightTakeoff.text floatValue] - [labelWeightZeroFuel.text floatValue]) / fuelPathSteps);
        weightUnit = ([labelWeightTakeoff.text floatValue] - [labelWeightZeroFuel.text floatValue]) / fuelPathSteps ;
        float maxTankWeight = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
        
        
        if (stepWeight >= maxTankWeight) {
            break;
            //uff, das hat ja mal den halben Tag gekostet, greetings from Wendy Way 1909
        }
        
        // get fuel moment lateral
        fuelVolume = stepWeight / [_inputSpecificFuelMassPerVolume.text floatValue];
        fuelWeight = stepWeight;
        [self interpolateFuelMomentsLateral]; // here we get fuel moment
        
         //NSLog(@"fuelMoment %.0f", fuelMoment);
        if (isnan(fuelMoment)) {
            fuelMoment = 0;
        }
        
        simulatedFuelMoment = fuelMoment;
        // compute CG
        simulatedTotalMoment = ([labelWeightZeroFuel.text floatValue] * lZFWArmLat) + simulatedFuelMoment;
        simulatedAircraftWeight = [labelWeightZeroFuel.text floatValue]  + stepWeight;
        // get point coordinates
        float xCGval = simulatedTotalMoment / simulatedAircraftWeight;
        float yCGval = simulatedAircraftWeight;
        
        CGPoint pointTakeoffCG = {xCGval, simulatedAircraftWeight};
        if (!CGPathContainsPoint(shapeLayerFreakViewCG1Lat.path, NULL, pointTakeoffCG, FALSE)) {
            flagWarningCG = 1;
        }
        
        
        
        // find landing weight
        //NSLog(@"i %d", i);
        xCGpos = leftBorderOfMeasureBoxLAT + ( (xCGval-xAxisLeftLAT) * xPixelFactorLAT );
        yCGpos = topBorderOfMeasureBoxLAT  + (  (yAxisTopLAT - yCGval) * yPixelFactorLAT );
        
        float dotSize = 5;
        CAShapeLayer *circleLayer = [CAShapeLayer layer];
        [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
        [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
        UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
        [circleLayer setPath:[pathC CGPath]];
        [circleLayer setStrokeColor:[[UIColor clearColor] CGColor]];
        [circleLayer setFillColor:[lightBlueColor CGColor]];
        [circleLayer setLineWidth:0.0f];
        
        if (i > 1 & simulatedAircraftWeight > weightLDW) {
            [self.viewFuelPathCGLat.layer addSublayer:circleLayer];
        }
        
       
        
    }// end for next make path
    
 
    
    
    // check takeoff
    CGPoint pointTakeoffCG = {CGLATTOW, weightTOW};
    if (!CGPathContainsPoint(shapeLayerFreakViewCG1Lat.path, NULL, pointTakeoffCG, FALSE)) {
        flagWarningCG = 1;
    }
    
    // check landing
    CGPoint pointLandingCG = {CGLATLDW, weightLDW};
    if (!CGPathContainsPoint(shapeLayerFreakViewCG1Lat.path, NULL, pointLandingCG, FALSE)) {
        flagWarningCG = 1;
    }
    
    // show hide warnings
    warningLatCGExceeded.hidden = YES;
    shapeLayerCG1Lat.strokeColor = [GreenColor CGColor];
    
    
    // get weightgs for hoit OP and load - if installed then show latg warning but keep Heli green
    
     float currentHoistLoadWeight = [[_arrayName2 objectAtIndex:lineHoistLoad] floatValue]; // weight
    
    float currentHoisOPSWeight = [[_arrayName2 objectAtIndex:lineHoistOP] floatValue]; // weight
    
    float currentHoisINSTRweight = [[_arrayName2 objectAtIndex:lineHoistInstructor] floatValue]; // weight
    
    float allCheckWeight = currentHoistLoadWeight + currentHoisOPSWeight + currentHoisINSTRweight;
    
    
    
    _labelForHoistOPSOK.hidden = YES;
    _labelForHoistOPSOKLM.hidden = YES;
    
    
    if (allCheckWeight > 0) {
        
        // ignorw warning
        
        
        if (flagWarningCG == 1 ) {
            warningLatCGExceeded.hidden = YES;
            shapeLayerCG1Lat.strokeColor = [[UIColor redColor] CGColor];
            [_ACtopView setImage:ACtop ];
            _labelForHoistOPSOK.hidden = NO;
            _labelForHoistOPSOKLM.hidden = NO;
        }
        
        
    }else{
        
        if (flagWarningCG == 1 ) {
            warningLatCGExceeded.hidden = NO;
            shapeLayerCG1Lat.strokeColor = [[UIColor redColor] CGColor];
            [_ACtopView setImage:ACtop_Warning ];
            _labelForHoistOPSOK.hidden = YES;
            _labelForHoistOPSOKLM.hidden = YES;
        }

        
        
    }
    
    
    return;

    
    
    
    
}












- (void) animateFuelPathManifest {
    
    //NSLog(@"animateFuelPath ");
    
    
    if (fuelVolume <1) {
        return;
    }
    
    
    for(UIView *subview in [_viewFuelPathCGManifest subviews]) {
        [subview removeFromSuperview];
    }
    
    float xCGpos = 0;
    
    float yCGpos = 0;
    
    float fuelPathSteps = 50;
    
    
    [self.viewFuelPathCGManifest.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    
    float stepWeight = 0;
    
    float simulatedAircraftWeight = 0;
    
    float simulatedFuelMoment = 0;
    
    float simulatedTotalMoment = 0;
    
    
    
    
    
    for (int i = 0; i < fuelPathSteps ; i++) { /// make dots
        
        stepWeight = i * (([labelWeightTakeoff.text floatValue] - [labelWeightZeroFuel.text floatValue]) / fuelPathSteps);
        
        
        
        // get fuel moment
        
        fuelVolume = stepWeight / [_inputSpecificFuelMassPerVolume.text floatValue];
        fuelWeight = stepWeight;
        [self interpolateFuelMomentsLongitudinal]; // here we get fuel moment
        
        
        simulatedFuelMoment = fuelMoment;
        
        // compute CG
        
        simulatedTotalMoment = ([labelWeightZeroFuel.text floatValue] * lZFWArm) + simulatedFuelMoment;
        
        simulatedAircraftWeight = [labelWeightZeroFuel.text floatValue]  + stepWeight;
        
        
        
        // get point coordinates
        
        float xCGval = simulatedTotalMoment / simulatedAircraftWeight;
        
        float yCGval = simulatedAircraftWeight;
        
        xCGpos = leftBorderOfMeasureBox2 + ( (xCGval-xAxisLeft2) * xPixelFactor2 );
        
        yCGpos = topBorderOfMeasureBox2  + (  (yAxisTop2 - yCGval) * yPixelFactor2 );
        
        
        
        
        float dotSize = 2.5;
        
        CAShapeLayer *circleLayer = [CAShapeLayer layer];
        
        [circleLayer setBounds:CGRectMake(0.0f, 0.0f, dotSize ,dotSize)];
        
        [circleLayer setPosition:CGPointMake( xCGpos, yCGpos)];
        
        
        
        
        // Create a circle path.
        
        UIBezierPath *pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake(0.0f, 0.0f, dotSize, dotSize)];
        
        // Set the path on the layer
        [circleLayer setPath:[pathC CGPath]];
        
        
        // Set the stroke color
        [circleLayer setStrokeColor:[[UIColor clearColor] CGColor]];
        
        
        //NSLog(@"flagMostFwdCGwarning   %.0f ", flagMostFwdCGwarning);
        
        [circleLayer setFillColor:[[UIColor blackColor] CGColor]];
        
        
        
        // Set the stroke line width
        [circleLayer setLineWidth:0.0f];
        
        if (i > 1) {
            [self.viewFuelPathCGManifest.layer addSublayer:circleLayer];
        }
        
        
        
    }// end for next make path
    
    
    
    
    
    
}

- (void)panRecognizerAction:(UIPanGestureRecognizer *)recognizer {
    
    
    CGPoint loc = [recognizer locationInView:_viewInterior];
    
    NSMutableArray *longPoints1 = [[NSMutableArray alloc] init];
    NSMutableArray *latPoints1 = [[NSMutableArray alloc] init];
    
    
    if (recognizer.state == UIGestureRecognizerStateBegan) {
        
        //NSLog(@"UIGestureRecognizerStateBegan");
        //NSLog(@"started originY %.0f", loc.y);
        
        
        stationName1      = @"";
        stationWeight1    = 0;
        stationArm1       = 0;
        stationMoment1    = 0;
        stationArmLat1    = 0;
        stationMomentLat1 = 0;
        
        
        stationName2      = @"";
        stationWeight2    = 0;
        stationArm2       = 0;
        stationMoment2    = 0;
        stationArmLat2    = 0;
        stationMomentLat2 = 0;
        
        // move ghost to start position
        
        ghostImage.center = CGPointMake(loc.x , loc.y  );
        [_viewInterior bringSubviewToFront:ghostImage];
        
        
        // find start long and lat
        
        float yOffset = 0;
        float latOffset = 0;
        
        float LongScale = (_viewMeasureRearSeats.center.y - _viewMeasureFrontSeats.center.y) / (LongArmRearSeat - LongArmFrontSeat) ;
        float LatScale  = (_viewMeasureLatRight.center.x  - _viewMeasureCenter.center.x)     / (LatArmRightSeat - LatArmLeftSeat) ;
        
        float LongArmGhost = ((((ghostImage.center.y - yOffset ) -_viewSeatSize.layer.frame.size.height/2)  + (_viewSeatSize.layer.frame.size.height/2) - _viewMeasureFrontSeats.center.y ) / LongScale )+ LongArmFrontSeat ;
        
        float LatArmGhost = ((((ghostImage.center.x - latOffset) -_viewSeatSize.layer.frame.size.width/2) + (_viewSeatSize.layer.frame.size.width/2) - _viewMeasureCenter.center.x ) / LatScale )+ LatArmLeftSeat ;
        
        
        float longLatTolerance = 180;
        
        int iTransfer = 0;
        
        
        
        //NSLog(@"---------------------------------------------------------");
        
        //NSLog(@"LongArmGhost %.0f", LongArmGhost);
        //NSLog(@"linePilot  %d", linePilot);
        
        
        
        
        for(int i=linePilot; i<listEnd; i++) {
            
            //NSLog(@"_arrayName1  %@", [_arrayName1 objectAtIndex:i]);
            
            
            if ([[_arrayName8 objectAtIndex:i]floatValue] == 0) {
                continue;
            }
            
            
            
            float itemLong = [[_arrayName3 objectAtIndex:i] floatValue] + [[_arrayName11 objectAtIndex:i] floatValue];
            float itemLat = [[_arrayName5 objectAtIndex:i] floatValue] + [[_arrayName13 objectAtIndex:i] floatValue];
            
            
            //NSLog(@"itemLong %.0f", itemLong);
            //NSLog(@"itemLat  %.0f", itemLat);
            
            
            if (itemLong > LongArmGhost - longLatTolerance  & itemLong < LongArmGhost + longLatTolerance     ) {
                
                //NSLog(@"ok, selbe reihe  %d",i);
                
                [longPoints1 addObject:[NSString stringWithFormat:@"%d",   i ]];
                
                if (LatArmGhost >= 0) { // search on right site only
                    
                    if ( itemLat < LatArmGhost + longLatTolerance  & itemLat > LatArmGhost - longLatTolerance){
                        
                        [latPoints1 addObject:[NSString stringWithFormat:@"%d",   i ]];
                        
                    }
                }
                
                
                
                if (LatArmGhost < 0) { // search on right site only
                    
                    if ( itemLat > LatArmGhost - longLatTolerance  & itemLat < LatArmGhost + longLatTolerance){
                        
                        //NSLog(@"match  %d",i);
                        
                        [latPoints1 addObject:[NSString stringWithFormat:@"%d",   i ]];
                        
                    }
                }
                
            }
            
        }
        
        //NSLog(@"longPoints1 %@", longPoints1);
        //NSLog(@"latPoints1 %@", latPoints1);
        
        //NSLog(@"longPoints.count %d", longPoints.count);
        //NSLog(@"latPoints.count %d", latPoints.count);
        
        
        
        if (latPoints1.count > 0) {
            
            for(int i=0; i<longPoints1.count; i++) {
                
                NSString *longP = [longPoints1 objectAtIndex:i];
                NSString *latP = [latPoints1 objectAtIndex:0];
                
                //NSLog(@"longP %@", longP);
                //NSLog(@"latP %@", latP);
                
                
                if ([latP isEqualToString:longP]) {
                    //NSLog(@"started longP1 %@", longP);
                    //NSLog(@"found latP   %@", latP);
                    
                    ghostImage.hidden = NO;
                    
                    iTransfer = [longP intValue];
                    foundMatch1 = 1;
                    matchItemID1 = iTransfer;
                    
                    stationName1      = [_arrayName7 objectAtIndex:iTransfer];
                    stationWeight1    = [[_arrayName2 objectAtIndex:iTransfer] floatValue];
                    stationArm1       = [[_arrayName3 objectAtIndex:iTransfer] floatValue];
                    stationMoment1    = [[_arrayName4 objectAtIndex:iTransfer] floatValue];
                    stationArmLat1    = [[_arrayName5 objectAtIndex:iTransfer] floatValue];
                    stationMomentLat1 = [[_arrayName6 objectAtIndex:iTransfer] floatValue];
                    
                    //NSLog(@"stationName1 %@", stationName1);
                    
                    //NSLog(@"start stationArm1 %.0f", stationArm1);
                    
                    
                    
                    break;
                    
                }else{
                    foundMatch1 = 0;
                    
                }
                
                
            }
        }
        
        
        
        
        
    }// end of touches began
    
    
    
    
    
    
    
    
    
    // move ghost
    CGPoint translation = [recognizer translationInView:self.view];
    ghostImage.center = CGPointMake(ghostImage.center.x + (translation.x ) , ghostImage.center.y + (translation.y ) );
    
    
    NSMutableArray *longPoints = [[NSMutableArray alloc] init];
    NSMutableArray *latPoints = [[NSMutableArray alloc] init];
    
    if (recognizer.state == UIGestureRecognizerStateChanged) {
        
        [[self.viewInterior viewWithTag:9999] removeFromSuperview];
        
        //NSLog(@"-");
        
        // find start long and lat
        
        float yOffset = 0;
        float latOffset = 0;
        
        float LongScale = (_viewMeasureRearSeats.center.y - _viewMeasureFrontSeats.center.y) / (LongArmRearSeat - LongArmFrontSeat) ;
        float LatScale  = (_viewMeasureLatRight.center.x  - _viewMeasureCenter.center.x)     / (LatArmRightSeat - LatArmLeftSeat) ;
        
        float LongArmGhost = ((((ghostImage.center.y - yOffset ) -_viewSeatSize.layer.frame.size.height/2)  + (_viewSeatSize.layer.frame.size.height/2) - _viewMeasureFrontSeats.center.y ) / LongScale )+ LongArmFrontSeat ;
        
        float LatArmGhost = ((((ghostImage.center.x - latOffset) -_viewSeatSize.layer.frame.size.width/2) + (_viewSeatSize.layer.frame.size.width/2) - _viewMeasureCenter.center.x ) / LatScale )+ LatArmLeftSeat ;
        
        //float longLatTolerance = (_viewSeatSize.frame.size.width / LatScale) - ((_viewSeatSize.frame.size.width / LatScale) * 0.05);
        
        
        float longLatTolerance = 180;
        //NSLog(@"LongArmGhost %.2f", LongArmGhost);
        //NSLog(@"LatArmGhost %.2f", LatArmGhost);
        
        
        
        int iTransfer = 0;
        
        for(int i=linePilot; i<listEnd; i++) {
            
            if ([[_arrayName8 objectAtIndex:i]floatValue] == 0) {
                continue;
            }
            
            
            float itemLong = [[_arrayName3 objectAtIndex:i] floatValue] + [[_arrayName11 objectAtIndex:i] floatValue];
            float itemLat = [[_arrayName5 objectAtIndex:i] floatValue] + [[_arrayName13 objectAtIndex:i] floatValue];
            
            
            if (itemLong > LongArmGhost - longLatTolerance  & itemLong < LongArmGhost + longLatTolerance     ) {
                
                //NSLog(@"ok, selbe reihe  %d",i);
                
                [longPoints addObject:[NSString stringWithFormat:@"%d",   i ]];
                
                if (LatArmGhost >= 0) { // search on right site only
                    
                    if ( itemLat < LatArmGhost + longLatTolerance  & itemLat > LatArmGhost - longLatTolerance){
                        
                        [latPoints addObject:[NSString stringWithFormat:@"%d",   i ]];
                        
                    }
                }
                
                
                
                if (LatArmGhost < 0) { // search on right site only
                    
                    if ( itemLat > LatArmGhost - longLatTolerance  & itemLat < LatArmGhost + longLatTolerance){
                        
                        //NSLog(@"match  %d",i);
                        
                        [latPoints addObject:[NSString stringWithFormat:@"%d",   i ]];
                        
                    }
                }
                
            }
            
        }
        
        //NSLog(@"longPoints %@", longPoints);
        //NSLog(@"latPoints %@", latPoints);
        
        //NSLog(@"longPoints.count %d", longPoints.count);
        //NSLog(@"latPoints.count %d", latPoints.count);
        
        
        
        if (latPoints.count > 0) {
            
            for(int i=0; i<longPoints.count; i++) {
                
                NSString *longP = [longPoints objectAtIndex:i];
                NSString *latP = [latPoints objectAtIndex:0];
                
                //NSLog(@"longP %@", longP);
                //NSLog(@"latP %@", latP);
                
                
                if ([latP isEqualToString:longP]) {
                    
                    
                    
                    //NSLog(@"found longP  %@", longP);
                    //NSLog(@"found latP   %@", latP);
                    
                    iTransfer = [longP intValue] ;
                    foundMatch2 = 1;
                    matchItemID2 = iTransfer;
                    
                    stationName2      = [_arrayName7 objectAtIndex:iTransfer];
                    stationWeight2    = [[_arrayName2 objectAtIndex:iTransfer] floatValue];
                    stationArm2       = [[_arrayName3 objectAtIndex:iTransfer] floatValue];
                    stationMoment2    = [[_arrayName4 objectAtIndex:iTransfer] floatValue];
                    stationArmLat2    = [[_arrayName5 objectAtIndex:iTransfer] floatValue];
                    stationMomentLat2 = [[_arrayName6 objectAtIndex:iTransfer] floatValue];
                    
                    //(@"222 stationArm1 %.0f", stationArm1);
                    
                    
                    if (ghostImage.hidden == NO) {
                        // make a temporary cover
                        UIImageView *stationImage = (UIImageView*)[_viewInterior viewWithTag: 1500 + iTransfer];
                        UIImageView *interiorItem =[[UIImageView alloc] initWithFrame:CGRectMake(stationImage.frame.origin.x, stationImage.frame.origin.y, stationImage.frame.size.width , stationImage.frame.size.height ) ];
                        interiorItem.image=[UIImage imageNamed: @"box generic yellow.png" ];
                        interiorItem.tag = 9999;
                        interiorItem.alpha =0.8;
                        [self.viewInterior addSubview:interiorItem];
                        
                    }
                    
                    
                    break;
                    
                    
                    
                    
                    
                }else{
                    
                    foundMatch2 = 0;
                    matchItemID2 = 0;
                }
                
                
            }
        }
        
        
        
        
        
        
        
        
    }
    
    
    
    if (recognizer.state == UIGestureRecognizerStateEnded) {
        
        //NSLog(@"UIGestureRecognizerStateEnded");
        
        
        //NSLog(@"foundMatch1 ************************************  %d",foundMatch1);
        //NSLog(@"foundMatch2 ************************************  %d",foundMatch2);
        
        
        [[self.viewInterior viewWithTag:9999] removeFromSuperview];
        
        ghostImage.hidden = YES;
        
        if (foundMatch1 == 1 & foundMatch2 == 1) {
            
            //NSLog(@"matchItemID1 ************************************  %d",matchItemID1);
            //NSLog(@"matchItemID2 ************************************  %d",matchItemID2);
            
            foundMatch1 = 0;
            foundMatch2 = 0;
            
            //NSLog(@"found two matches!");
            
            
            //NSLog(@"stationName1       %@", stationName1 );
            //NSLog(@"stationWeight1     %.0f", stationWeight1 );
            //NSLog(@"stationArm1     %.0f", stationArm1 );
            //NSLog(@"stationMoment1     %.0f", stationMoment1 );
            //NSLog(@"stationArmLat1     %.0f", stationArmLat1 );
            //NSLog(@"stationMomentLat1     %.0f", stationMomentLat1 );
            
            //NSLog(@"stationName2       %@", stationName2 );
            //NSLog(@"stationWeight2     %.0f", stationWeight2 );
            //NSLog(@"stationArm2     %.0f", stationArm2 );
            //NSLog(@"stationMoment2     %.0f", stationMoment2 );
            //NSLog(@"stationArmLat2     %.0f", stationArmLat2 );
            //NSLog(@"stationMomentLat2     %.0f", stationMomentLat2 );
            
            
            // die Hunde von der ersten Position auf die zweiter Position
            
            [_arrayName7 replaceObjectAtIndex:matchItemID2 withObject: stationName1 ];
            
            [_arrayName2 replaceObjectAtIndex:matchItemID2 withObject: [ [NSString alloc] initWithFormat:@"%.1f", stationWeight1]];
            
            float computedNewMoment = stationWeight1 * stationArm2;
            
            [_arrayName4 replaceObjectAtIndex:matchItemID2 withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMoment]];
            
            float computedNewMomentLat = stationWeight1 * stationArmLat2;
            
            [_arrayName6 replaceObjectAtIndex:matchItemID2 withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMomentLat]];
            
            
            // update name label 1200
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200 + matchItemID2];
            
            [valueField  setText: stationName1  ];
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + matchItemID2];
            
            [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", stationWeight1]  ];
            
            // update slider
            
            UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  matchItemID2 ];
            
            slider.value = stationWeight1;
            
            
            // dann die Hunde von der zweiten Position auf die erste Position
            
            
            [_arrayName7 replaceObjectAtIndex:matchItemID1 withObject: stationName2 ];
            
            [_arrayName2 replaceObjectAtIndex:matchItemID1 withObject: [ [NSString alloc] initWithFormat:@"%.1f", stationWeight2]];
            
            computedNewMoment = stationWeight2 * stationArm1;
            
            [_arrayName4 replaceObjectAtIndex:matchItemID1 withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMoment]];
            
            computedNewMomentLat = stationWeight2 * stationArmLat1;
            
            [_arrayName6 replaceObjectAtIndex:matchItemID1 withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMomentLat]];
            
            
            // update name label 1200
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200 + matchItemID1];
            
            [valueField  setText: stationName2  ];
            
            valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + matchItemID1];
            
            [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", stationWeight2]  ];
            
            // update slider
            
            slider = (UISlider*)[_viewStationsSlider viewWithTag:  matchItemID1 ];
            
            slider.value = stationWeight2;
            
            
            
            
            [self MainRoutine];
            
            
        }
        
        
        
    }
    
    [recognizer setTranslation:CGPointMake(0, 0) inView:self.view];
    
    
    
    
    
}



- (IBAction)actionLoadDispatchFlights:(id)sender {
    
    [self loadDispatcherFlightsFromServer];
}


- (void) loadDispatcherFlightsFromServer {
    
    //NSLog(@"loadDispatcherFlightsFromServer");
    
    //[self loadHelicoptersFromServerVoid];
    
    //send a request to server to get all locations of this customer
    
    NSString *url=serverpath;
    url = [url stringByAppendingString:@"get_dispatcherFlights.php?customer="];
    url = [url stringByAppendingString:customer];
    
    //NSLog(@"url %@",url);
    
    
    NSData* data = [NSData dataWithContentsOfURL:
                    [NSURL URLWithString: url]];
    __autoreleasing NSError* error = nil;
    
    
    //check if JSON data is valid
    
    if (error != nil || data == NULL) {
        
        //NSLog(@"%@",error);
        
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Error [2]"
                              message:@"Received data that is not valid or device is offline. Please check if this device is online."
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        [alert show];
        
    } else {
        
        id  result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
        
        
        [dispatcherFlights removeAllObjects];
        
        NSArray *allItems = [result objectForKey:@"dispatcherData"];
        
        
        //put locations into global locations object array
        
        for (int i=0; i<allItems.count; ++i) {
            
            NSDictionary *item = [allItems objectAtIndex:i];
            NSString *TheFlightCode=[item objectForKey:@"flightCode"];
            NSString *TheFlightName=[item objectForKey:@"flightName"];
            
            //NSLog(@"flightName: %@",TheFlightName);
            //NSLog(@"flightStatus: %@",TheFlightStatus);
            
             [dispatcherFlights addObject:[[dispatcherFlight alloc] initWithFlightCode:TheFlightCode AndFlightName:TheFlightName]];
            
        }
        
        //create button for each location
        
        [self addDispatcherFlightButtons];
        
        
    }
    
    
}

- (void) addDispatcherFlightButtons {
    
    _buttonImportFlightData.enabled = NO;
    
    
    //we create one button per location dynamically in our scrollview
    
    int xCoord=0;
    int yCoord=0;
    int buttonWidth= _viewDispatcher_sview.frame.size.width;
    int buttonHeight=50;
    int buffer = 10;
    
    
    //we take the locations that are already in our locations array
    
    for(UIView *subview in [_viewDispatcher_sview subviews]) {
        [subview removeFromSuperview];
    }
    
    
    
    for(int i=0; i<dispatcherFlights.count; i++) {
                
        
        UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.showsTouchWhenHighlighted = YES;
        aButton.frame     = CGRectMake(xCoord, yCoord,buttonWidth,buttonHeight );
        [aButton setTitle:[[dispatcherFlights objectAtIndex:i]flightName] forState:(UIControlStateNormal)];
        [aButton setTag:i+1];
        [aButton addTarget:self action:@selector(loadDispatchFlightDataFromServer:) forControlEvents:UIControlEventTouchUpInside];
        [_viewDispatcher_sview addSubview:aButton];
        
        aButton.tintColor = [UIColor blackColor];
        
        aButton.backgroundColor = [UIColor grayColor];
        
        aButton.titleLabel.font = [UIFont systemFontOfSize:14];
        
        
        
        
        yCoord += buttonHeight + buffer;
        
    }
    
    
    [_viewDispatcher_sview setContentSize:CGSizeMake(200, yCoord)];
    [_viewDispatcher_sview setScrollEnabled:YES];
    [_viewDispatcher_sview setNeedsDisplay];
    
}

- (void) loadDispatchFlightDataFromServer:(UIButton*)sender {
    
    //Check if server reachable
    
    //NSLog(@"sender.tag %d", sender.tag);
    
    for(int i=1; i<_viewDispatcher_sview.subviews.count+1; i++) {
        
        UIButton*btn  = (UIButton*)[_viewDispatcher_sview viewWithTag: i];
        
        btn.backgroundColor = [UIColor grayColor];
    }
    
    
    UIButton*btn  = (UIButton*)[_viewDispatcher_sview viewWithTag: sender.tag];
    
    btn.backgroundColor = [UIColor yellowColor];
    
    

    
    if (!([self is_online])) {
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Error"
                              message:@"Cannot reach server. Please check if this device is online."
                              delegate:self
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        [alert show];
        
    } else {
        
        
        //[self setDispatchLabelsToZero];
        
        // get location from button clicked
        
        NSString *flightName=@"";
        NSString *flightCode=@"";
        
        flightCode=[[dispatcherFlights objectAtIndex:sender.tag-1]flightCode];
        flightName=[[dispatcherFlights objectAtIndex:sender.tag-1]flightName];
        
        
        //NSLog(@" --------- loading  _labelFlightRefNumber = TheFlightName %@", flightName);
        //NSLog(@" --------- loading   = flightCode %@", flightCode);
        
        
        
        crew_lastFlight=flightCode;
        
        // send request to server
        
        NSString *url=serverpath;
        url = [url stringByAppendingString:@"get_dispatcherFlightData.php?customer="];
        url = [url stringByAppendingString:customer];
        url = [url stringByAppendingString:@"&flightCode="];
        url = [url stringByAppendingString:flightCode];
        
        
        
        
        
        NSData* data = [NSData dataWithContentsOfURL:
                        [NSURL URLWithString: url]];
        __autoreleasing NSError* error = nil;
        
        id result = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
        
        
        //NSLog(@"id result %@",result);
        
        //check if JSON data valid
        
        if (error != nil) {
            UIAlertView *alert = [[UIAlertView alloc]
                                  initWithTitle:@"Error"
                                  message:@"No flight available/invalid data. Please make sure that a flight is entered in Fleet Control."
                                  delegate:self
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil];
            [alert show];
            //NSLog(@"%@",error);
        } else {
            
            
            _buttonImportFlightData.enabled = YES;
            
            NSArray *allItems = [result objectForKey:@"dispatcherFlightData"];
            
            
            //NSLog(@"allItems  %@", allItems );
            
            
            int i=0;
            NSDictionary *item = [allItems objectAtIndex:i];
            
            //_legItem1.text=[item objectForKey:@"flightcustomer"];
            //_legItem2.text=[item objectForKey:@"flightdate"];
            
            //NSLog(@"flightcustomer  %@",[item objectForKey:@"flightcustomer"] );
            //NSLog(@"flightdate  %@",[item objectForKey:@"flightdate"] );
            //NSLog(@"contactperson  %@",[item objectForKey:@"contactperson"] );
            
            
            
            // get passengers
            
            NSString *allPassengersString = @"";
            
            NSArray *allPassengers = [item objectForKey:@"passengers"];
            
            [dispatcherPaxNames removeAllObjects];
            [dispatcherPaxWeight removeAllObjects];
            
            
            [dispatcherCrewNames removeAllObjects];
            [dispatcherCrewWeight removeAllObjects];
            
            [dispatcherCrewNames  addObject:[item objectForKey:@"pilot"] ];
            [dispatcherCrewWeight  addObject:[item objectForKey:@"pilotweight"] ];
            
            allPassengersString = [allPassengersString stringByAppendingString: @"Configuration: "  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: [item objectForKey:@"flightcustomer"]  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"Pilot: "  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: [item objectForKey:@"pilot"]  ];
            allPassengersString = [allPassengersString stringByAppendingString: @", "  ];
            allPassengersString = [allPassengersString stringByAppendingString: [item objectForKey:@"pilotweight"]  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"kg" ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"Passengers: "  ];
            allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
            
            
            NSString *ref =[item objectForKey:@"ref"];
            //NSLog(@"ref  %@", ref );
            
            _vFlightIDName.text = ref;
            
            
              // get customer offshore / onshore
            
            /*
            NSString *configTye =[item objectForKey:@"flightcustomer"];
            
            if ([configTye isEqualToString:@"Offshore"]) {
                configuration = 1;
                [self setConfiguration];
                
                dispatchedConfiguration = @"Offshore";
            }else{
                configuration = 2;
                [self setConfiguration];
                
                 dispatchedConfiguration = @"Onshore";
                
            }
             */
            //NSLog(@"configTye  %@", configTye );
            
            // get departure
            NSString *departure =[item objectForKey:@"location"];
            //NSLog(@"departure  %@", departure );
            
            vFlightDeparture.text = departure;
            
            // get route
            NSString *itin =[item objectForKey:@"itinerary"];
            vFlightDestination.text = itin;
            //NSLog(@"itin  %@", itin );
            
            
            // date
                        NSString *TOtime =[item objectForKey:@"pickuptime"];
            //NSLog(@"TOtime  %@", TOtime );
            
            NSString *TOdate=[item objectForKey:@"flightdate"];
            //NSLog(@"TOdate  %@", TOdate );
            
            if (TOdate.length > 1) {
                NSString *year = [TOdate substringWithRange:NSMakeRange(0, 4)];
                //NSLog(@"year  %@", year );
                
                NSString *month = [TOdate substringWithRange:NSMakeRange(5, 2)];
                //NSLog(@"month  %@", month );
                NSString *day = [TOdate substringWithRange:NSMakeRange(8, 2)];
                //NSLog(@"day  %@", day );
                NSString *dateNew =  [[NSString alloc] initWithFormat:@"%@-%@-%@", month, day, year];
                _labelDepartureTimeLocal.text = [[NSString alloc] initWithFormat:@"%@  %@", dateNew, TOtime];
            }
            
            // get pax names
            
            for(int i=0; i<allPassengers.count; i++) {
                
                NSDictionary *item = [allPassengers objectAtIndex:i];
                allPassengersString = [allPassengersString stringByAppendingString: [item objectForKey:@"passengerName"]  ];
                
                
                if ([[item objectForKey:@"passengerWeight"] length] > 1) {
                    allPassengersString = [allPassengersString stringByAppendingString: @", "  ];
                    allPassengersString = [allPassengersString stringByAppendingString: [item objectForKey:@"passengerWeight"]  ];
                    allPassengersString = [allPassengersString stringByAppendingString: @"kg" ];

                }
                
                               allPassengersString = [allPassengersString stringByAppendingString: @"\n"  ];
                [dispatcherPaxNames  addObject:[item objectForKey:@"passengerName"] ];
                [dispatcherPaxWeight addObject:[item objectForKey:@"passengerWeight"] ];
                
            }
            
            _passengerList.text = allPassengersString;
            
            
            
        }
    }
}


- (IBAction)actionPositionCrewAndPaxFromDispatch:(id)sender {
    
    [self positionCrewFromDispatch];
    
    [self positionPaxFromDispatch];
    
    displayWindow = 0;
    
    [self displayWindows];
    
    
    
}

- (IBAction)actionShowHideDispatch:(id)sender {
    
    guidanceDictionary[@"guidanceBtnCrew"] =  @"ok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"ok";

    

    
    if (_viewDispatch.hidden == YES) {
        _viewDispatch.hidden = NO;
        
        [viewOne bringSubviewToFront:_viewDispatch];
        
        
        [self loadDispatcherFlightsFromServer];
        
       
        
    }else{
        
        _viewDispatch.hidden = YES;
        
        
    }
    
    
    [self MainRoutine];
    
}



- (void) positionCrewFromDispatch {
    
    
    //NSLog(@"dispatcherCrewNames2 %@", dispatcherCrewNames);
    
    int paxNumberinArray;
    
    
    for(int i=0; i<dispatcherCrewNames.count; i++) {
        
        paxNumberinArray = linePilot + i;
        
        //NSLog(@"[self.arrayName2 objectAtIndex:paxNumberinArray] i = %d %@ ",paxNumberinArray,  [self.arrayName2 objectAtIndex:paxNumberinArray]);
        
        
        [_arrayName7 replaceObjectAtIndex:paxNumberinArray withObject: [dispatcherCrewNames objectAtIndex:i] ];
        
        //NSLog(@"replacing  [_arrayName2 %@ with %@",[self.arrayName2 objectAtIndex:paxNumberinArray] ,[dispatcherCrewPaxWeight objectAtIndex:i] );
        
        [self.arrayName2 replaceObjectAtIndex:paxNumberinArray withObject: [dispatcherCrewWeight objectAtIndex:i]  ];
        
        float computedNewMoment = [[dispatcherCrewWeight objectAtIndex:i] floatValue] * [[_arrayName3 objectAtIndex:paxNumberinArray] floatValue];
        
        [_arrayName4 replaceObjectAtIndex:paxNumberinArray withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMoment]];
        
        float computedNewMomentLat = [[dispatcherCrewWeight objectAtIndex:i] floatValue] * [[_arrayName5 objectAtIndex:paxNumberinArray] floatValue];
        
        [_arrayName6 replaceObjectAtIndex:paxNumberinArray withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMomentLat]];
        
        
        // update name label 1200
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200 + paxNumberinArray];
        
        [valueField  setText: [dispatcherCrewNames objectAtIndex:i]   ];
        
        valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + paxNumberinArray];
        
        [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [[dispatcherCrewWeight objectAtIndex:i] floatValue]]   ];
        
        // update slider
        
        UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  paxNumberinArray ];
        
        slider.value = [[dispatcherCrewWeight objectAtIndex:i] floatValue] ;
        
        
       
        
    }
    
}





- (void) positionPaxFromDispatch {
 
    
    //NSLog(@"dispatcherPaxNames2 %@", dispatcherPaxNames);

    
    if ([[dispatcherPaxNames objectAtIndex:0] integerValue] > 0) {
        
        // do this if you want to load a specific number of pax entered in Fleet Control
        
        _inputPaxOnBoard.text = [[NSString alloc] initWithFormat:@"%.d", [[dispatcherPaxNames objectAtIndex:0] integerValue]];
        
        //NSLog(@"[[dispatcherPaxNames objectAtIndex:0] integerValue]  %d ", [[dispatcherPaxNames objectAtIndex:0] integerValue]);
        
        
        [self setPaxOnBoard];
        
        [self MainRoutine];
        
        
    }else{
        
        _inputPaxOnBoard.text = [[NSString alloc] initWithFormat:@"%.d", dispatcherPaxNames.count];
        
        int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
        
        int desiredSeats = dispatcherPaxNames.count;
        int allocatedSeats = 0;
        
        //NSLog(@"desiredSeats %d", desiredSeats);
        
        int i = configStationsStart;
        
        do {
            
            //NSLog(@"i %d", i);
            
            if (i > desiredSeats + configStationsStart ) {
                
                //NSLog(@"i break %d", i);
                break;
            }

            
            // if seat is ON then allocate a person
            if ( [[_arrayName8 objectAtIndex:i] floatValue] == 1) {
                
                // check if there are still persons to allocate
                if (allocatedSeats < desiredSeats) {
                    
                    [_arrayName7 replaceObjectAtIndex:i withObject: [dispatcherPaxNames objectAtIndex:allocatedSeats] ];
                    [self.arrayName2 replaceObjectAtIndex:i withObject: [dispatcherPaxWeight objectAtIndex:allocatedSeats]  ];
                    
                    float computedNewMoment = [[dispatcherPaxWeight objectAtIndex:allocatedSeats] floatValue] * [[_arrayName3 objectAtIndex:i] floatValue];
                    
                    [_arrayName4 replaceObjectAtIndex:i withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMoment]];
                    
                    float computedNewMomentLat = [[dispatcherPaxWeight objectAtIndex:allocatedSeats] floatValue] * [[_arrayName5 objectAtIndex:i] floatValue];
                    
                    [_arrayName6 replaceObjectAtIndex:i withObject: [ [NSString alloc] initWithFormat:@"%.1f", computedNewMomentLat]];
                    
                    
                    // update name label 1200
                    
                    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1200 + i];
                    
                    [valueField  setText: [dispatcherPaxNames objectAtIndex:allocatedSeats]   ];
                    
                    valueField = (UITextField*)[_viewStationsSlider viewWithTag: 1000 + i];
                    
                    [valueField  setText: [ [NSString alloc] initWithFormat:@"%.0f", [[dispatcherPaxWeight objectAtIndex:allocatedSeats] floatValue]]   ];
                    
                    // update slider
                    
                    UISlider *slider = (UISlider*)[_viewStationsSlider viewWithTag:  i ];
                    
                    slider.value = [[dispatcherPaxWeight objectAtIndex:allocatedSeats] floatValue] ;
                    
                    allocatedSeats = allocatedSeats + 1;
                    
                }
                
                
            }
            
            
            i = i +1;
            
        
            
                
            
            
            
            //NSLog(@"allocatedSeats %d", allocatedSeats);

           
        }while( allocatedSeats < desiredSeats );
        
        
        
        
        
        
        
        
        
    }
    
    
    
}




- (IBAction)actionResetApp:(id)sender {
    

    
    alertFlag = 666;
    
    
    UIAlertView *alert = [[UIAlertView alloc]
                          
                          initWithTitle:@"App Reset"
                          
                          message:@"This will reset the app. All settings and flights will be deleted. Initial data will be loaded. \n\nREQUIRES INTERNET CONNECTION!!!"
                          
                          delegate:self
                          
                          cancelButtonTitle:@"CANCEL"
                          
                          
                          
                          otherButtonTitles:@"RESET!", nil];
    
    [alert show];
    
    
    
  
}






// flight manager

- (void) createFlightButtons {
    
    //NSLog(@"createFlightButtons ");
    
    // how many flights do we have?
    
    //int numberOfFlights = allFlightsDictionary.count;
    //NSLog(@"numberOfFlights %d ", numberOfFlights);
    //NSLog(@"numberOfLegs Flight 1 %d ", [[allFlightsDictionary objectForKey: @"1"] count] -1  );
    //NSLog(@"numberOfLegs Flight 2 %d ", [[allFlightsDictionary objectForKey: @"2"] count] -1 );
    
    
    
    //NSLog(@"createFlightButtons arrayFlights %@", arrayFlights);
    
    //we create one button per location dynamically in our scrollview
    
    
    if (flagIsLandscape == 1) {
        _scrollViewFlightButtons.frame = CGRectMake(0, 211, 1024, 539);
    }else{
        
         _scrollViewFlightButtons.frame = CGRectMake(0, 211, 768, 539);
        
    }
    
    
    int xCoord=0;
    int yCoord=2;
    int buttonWidth= _scrollViewFlightButtons.frame.size.width;
    int buttonHeight=80;
    int buffer = 30;
    
    
    
    for(UIView *subview in [_scrollViewFlightButtons subviews]) {
        [subview removeFromSuperview];
    }
    
    
    int currentFlightID = [vFlightID intValue];
    
 
    
    for (int i = 1; i <allFlightsMasterArray.count; i++) {
        
        int legsForThisFlight = [[allFlightsMasterArray objectAtIndex:i] count] -1  ;
        
        int allLegsForThisFLightOK = 1;
        
        for (int a = 0; a <legsForThisFlight; a++) {
            
            int guidanceCheckValue = [[[[allFlightsMasterArray objectAtIndex: i] objectAtIndex: a+1 ] objectForKey:@"guidanceLegCheckOK"] floatValue]; // trick to get values from within
            
            if (guidanceCheckValue != 1) {
                allLegsForThisFLightOK = 0;
            }
            
        }
        
        
        
        UIView *flightBox =[[UIView alloc] initWithFrame:CGRectMake(xCoord, yCoord,buttonWidth,buttonHeight) ];
        
        flightBox.backgroundColor = verydarkGrayColor;
        
        [_scrollViewFlightButtons addSubview:flightBox];
        
        
       
        
        // flight number
        
        UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord, yCoord,70,buttonHeight )];
        label.font = [UIFont boldSystemFontOfSize:16.0];
        label.textAlignment = NSTextAlignmentCenter;
      
        label.text = [ [NSString alloc] initWithFormat:@"%d",i   ];
        
        if (currentFlightID == i ) {
            label.textColor = [UIColor whiteColor];
            label.backgroundColor = blueButtonColor;
             }else{
            label.textColor = [UIColor blackColor];
            label.backgroundColor = [UIColor darkGrayColor];
        }
        label.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:label];
        
        
        label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord + 90, yCoord + 4,240,30 )];
        label.font = [UIFont boldSystemFontOfSize:16.0];
        if (currentFlightID == i ) {
            label.textColor = [UIColor whiteColor];
        }else{
            label.textColor = [UIColor lightGrayColor];
        }
        label.textAlignment = NSTextAlignmentLeft;
        label.text = [ [NSString alloc] initWithFormat:@"Flight ID: %@  --> %@", [[[allFlightsMasterArray objectAtIndex: i] objectAtIndex: 1 ] objectForKey:@"_vFlightIDName"], [[[allFlightsMasterArray objectAtIndex: i] objectAtIndex: 1 ] objectForKey:@"vFlightRegistration"] ]; // get from within legs
        label.backgroundColor = [UIColor clearColor];
        
        
        label.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:label];
        
        
        label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord + 90, yCoord + 27,240,30 )];
        label.font = [UIFont boldSystemFontOfSize:16.0];
        if (currentFlightID == i ) {
            label.textColor = [UIColor whiteColor];
        }else{
            label.textColor = [UIColor lightGrayColor];
        }
        label.textAlignment = NSTextAlignmentLeft;
        label.text = [ [NSString alloc] initWithFormat:@"Date: %@", [[[allFlightsMasterArray objectAtIndex: i] objectAtIndex: 1 ] objectForKey:@"_labelDepartureTimeLocal"] ]; // get from within legs
        label.backgroundColor = [UIColor clearColor];
        label.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:label];
        
        
       if (_segmentFlightLegMode.selectedSegmentIndex == 1) {
           
           label = [[UILabel alloc] initWithFrame:CGRectMake(xCoord + 90, yCoord + 50,240,30 )];
           label.font = [UIFont boldSystemFontOfSize:16.0];
           label.textAlignment = NSTextAlignmentLeft;
           
           label.backgroundColor = [UIColor clearColor];
           label.alpha = 0.9;
           
           if (_switchGuidance.on == YES &  allLegsForThisFLightOK == 1) {
               label.textColor = GreenColor;
               label.text = [ [NSString alloc] initWithFormat:@"Legs: %d, completed", [[allFlightsMasterArray objectAtIndex:i] count] -1  ]; // this is how many legs we have per flight
           }else{
               label.textColor = yellowSpecialColor;
               label.text = [ [NSString alloc] initWithFormat:@"Legs: %d, not completed", [[allFlightsMasterArray objectAtIndex:i] count] -1  ]; // this is how many legs we have per flight
           }
           
           [_scrollViewFlightButtons addSubview:label];
           
           
       }
        
        
        
        
        
        
        
        UIButton *aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.showsTouchWhenHighlighted = YES;
        aButton.frame     = CGRectMake(_scrollViewFlightButtons.frame.size.width - 220, yCoord,138,buttonHeight );
        [aButton setTitle: @"Copy Flight" forState:(UIControlStateNormal)];
        [aButton setTag:i+100];
        [aButton addTarget:self action:@selector(actionCopyFlightButton:) forControlEvents:UIControlEventTouchUpInside];
        aButton.tintColor = [UIColor blackColor];
        aButton.backgroundColor = [UIColor grayColor];
        aButton.titleLabel.font = [UIFont systemFontOfSize:15];
        aButton.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:aButton];
 
        
        aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.showsTouchWhenHighlighted = YES;
        aButton.frame     = CGRectMake(_scrollViewFlightButtons.frame.size.width - 80, yCoord,80,buttonHeight );
        [aButton setTitle: @"Delete" forState:(UIControlStateNormal)];
        [aButton setTag:i+100];
        [aButton addTarget:self action:@selector(actionDeleteFlightButton:) forControlEvents:UIControlEventTouchUpInside];
        aButton.tintColor = [UIColor blackColor];
        aButton.backgroundColor = [UIColor grayColor];
        aButton.titleLabel.font = [UIFont systemFontOfSize:15];
        aButton.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:aButton];

        aButton.titleLabel.font = [UIFont systemFontOfSize:15];
        [_scrollViewFlightButtons addSubview:aButton];
        
     
        
        aButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        aButton.showsTouchWhenHighlighted = YES;
        aButton.frame     = CGRectMake(_scrollViewFlightButtons.frame.size.width - 440, yCoord,218,buttonHeight );
        
        [aButton setTag:i+300];
        
         [aButton setTitle: @"Open Flight" forState:(UIControlStateNormal)];
        
        if (i == [vFlightID integerValue]) {
            [aButton addTarget:self action:@selector(actionLoadFlightButtonWhenActive:) forControlEvents:UIControlEventTouchUpInside];
        }else{
            [aButton addTarget:self action:@selector(actionLoadFlightButton:) forControlEvents:UIControlEventTouchUpInside];
        }
        
        
        aButton.tintColor = [UIColor whiteColor];
        aButton.backgroundColor = blueButtonColor;
        aButton.titleLabel.font = [UIFont systemFontOfSize:15];
        //aButton.alpha = 0.9;
        [_scrollViewFlightButtons addSubview:aButton];
        
        
        if (currentFlightID == i ) {
            
            UIView *activeFrame =[[UIView alloc] initWithFrame:CGRectMake(xCoord, yCoord - 2,buttonWidth,buttonHeight+4) ];
            activeFrame.backgroundColor = [UIColor whiteColor];
            [_scrollViewFlightButtons addSubview:activeFrame];
            [_scrollViewFlightButtons sendSubviewToBack:activeFrame];
            
        }
        
        
        
        // continue
        yCoord += buttonHeight + buffer;
        
       
        
        
    }

    
    [_scrollViewFlightButtons setContentSize:CGSizeMake(200, yCoord)];
    [_scrollViewFlightButtons setScrollEnabled:YES];
    [_scrollViewFlightButtons setNeedsDisplay];
    
 
    
  
    
}


- (IBAction)actionLoadFlightButtonWhenActive:(id)sender{
    
    
    
    
    displayWindow = 0;
    [self displayWindows];
    
    [self MainRoutine];
    
   
}


- (IBAction)actionLoadFlightButton:(id)sender{
    
    
    [self SaveValues];
    
    UIButton *btn = (UIButton*)sender;
    //NSLog(@"actionLoadFlightButton btn.tag %d ", btn.tag-300);
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    //NSLog(@"loading flight  %d ", btn.tag-300);
    
    [defaults  setObject: [ [NSString alloc] initWithFormat:@"%d", btn.tag-300 ]   forKey:@"vFlightID"];
    
    vLegID = @"1";
    
    [self LoadValues];
    
    [self createFlightButtons];
    
    displayWindow = 0;
    [self displayWindows];
    
    [self MainRoutine];
    
    
}



- (IBAction)actionCopyFlightButton:(id)sender {
    
    //NSLog(@"copy flight");
    
    [self SaveValues];
    /*
    UIButton *btn = (UIButton*)sender;
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject: [ [NSString alloc] initWithFormat:@"%d", btn.tag-100 ]   forKey:@"vFlightID"];
    [self LoadValues];
     */
    
    loadedSignatureImage = nil;
    [scrollSig removeFromSuperview];
    signatureImageData = nil;
    
    vFlightID =  [ [NSString alloc] initWithFormat:@"%lu", (unsigned long)allFlightsMasterArray.count];
    vLegID = @"1";
    [allFlightsMasterArray addObject:@"-"];
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject: vFlightID  forKey:@"vFlightID"];
    
    [self SaveValues]; // unter neuem Namen alles speichern
    [self createFlightButtons];
    
    // ********************
    
    
    int numberOfLegsThisFlight = [[flightSettingsDictionary  objectForKey:@"numberOfLegsThisFlight"] floatValue];
    
    for(int i=1; i<numberOfLegsThisFlight+1; i++) {
        //NSLog(@"i %d",  i);
        vLegID = [NSString stringWithFormat:@"%d",  i  ];
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        [defaults  setObject:vLegID                     forKey:@"vLegID"];
        
        [self LoadValues];
        [self MainRoutine];
        //NSLog(@"_vHOMSA %@",  _vHOMSA.text);
        [self guidanceResetLegDataAll];
        [self MainRoutine];
        [self SaveValues];
    }
    
    vLegID = [NSString stringWithFormat:@"%d",  1  ];
    [defaults  setObject:vLegID                     forKey:@"vLegID"];
    
    [self LoadValues];
    [self MainRoutine];
    
    [self createFlightButtons];
    
    
}









- (IBAction)actionDeleteFlightButton:(id)sender{
    
    UIButton *btn = (UIButton*)sender;
    
    buttonIDtransfer = btn.tag;
    
    alertFlag = 1003;
    
    UIAlertView *alert = [[UIAlertView alloc]
                          initWithTitle:@"Delete Flight"
                          message:@"Please Confirm"
                          delegate:self
                          
                          cancelButtonTitle:@"Cancel"
                          
                          
                          
                          otherButtonTitles:@"Delete", nil];
    [alert show];

    
    
    
   
}

- (void) deleteFlightFromManager {
    
    [self SaveValues];
    
    //NSLog(@"actionDeleteFlightButton btn.tag %d ", btn.tag-100);
    
    [allFlightsMasterArray removeObjectAtIndex: buttonIDtransfer -100 ];
    
    
    // look for new flight
    
    if ( [vFlightID intValue] >= (allFlightsMasterArray.count-1)  ) {
        
        vFlightID =  [ [NSString alloc] initWithFormat:@"%u", allFlightsMasterArray.count-1];
        
    }
    
    
    
    if ( [vFlightID intValue] == 0  ) {
        
        flagDoCreateNewFlight = 1;
        _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
        
    }else{
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        [defaults  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];
        [defaults  setObject: vFlightID                                     forKey:@"vFlightID"];
        
        vLegID = @"1";
        
        
        [self LoadValues];
        
        [self createFlightButtons];
        
        [self MainRoutine];
        
        
    }

    
    
}

- (IBAction)actionDeleteActiveLeg:(id)sender {
    
    
    if (allLegsPerFlightArray.count <= 2) {
        
        
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"One Leg Only"
                              message:@"The active flight has only one leg, therefore this leg can not be deleted. To delete the actve flight, open the Flight Manager."
                              delegate:self
                              
                              cancelButtonTitle:@"OK"
                              
                              
                              
                              otherButtonTitles: nil];
        [alert show];
        
        
    }else{
        
        alertFlag = 1001;
        
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:@"Delete Active Leg"
                              message:@"Please Confirm"
                              delegate:self
                              
                              cancelButtonTitle:@"Cancel"
                              
                              
                              
                              otherButtonTitles:@"Delete", nil];
        [alert show];
        
    }
    
   

   
    
}

- (void) deleteActiveLeg {
    
    
    [self SaveValues];
    
    int numberOfLegsThisFlight = [[flightSettingsDictionary  objectForKey:@"numberOfLegsThisFlight"] floatValue];
    
    //NSLog(@"numberOfLegsThisFlight  %d ", numberOfLegsThisFlight );
    
    //NSLog(@"allLegsPerFlightArray.count   %d ", allLegsPerFlightArray.count  );
    
    if (allLegsPerFlightArray.count <= 2) {
        return;
    }
    
    [allLegsPerFlightArray removeObjectAtIndex: [vLegID integerValue] ];
    
    
    if ( [vLegID intValue] >= (allLegsPerFlightArray.count-1)  ) {
        
        vLegID =  [ [NSString alloc] initWithFormat:@"%u", allLegsPerFlightArray.count-1];
        
    }
    
    //NSLog(@"new vLegID %d", [vLegID integerValue]);
    
    flightSettingsDictionary[@"numberOfLegsThisFlight"] = [NSString stringWithFormat:@"%d", numberOfLegsThisFlight-1 ];
    
    [allFlightsMasterArray replaceObjectAtIndex:[vFlightID integerValue] withObject:allLegsPerFlightArray];
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];
    [defaults  setObject: vFlightID                                     forKey:@"vFlightID"];
    
    [self LoadValues];
    
    [self MainRoutine];

   
    
    
}

- (IBAction)actionAddFlight:(id)sender {
    
    //NSLog(@"actionAddFlight");
    
     flagDoCreateNewFlight = 1;
    
        
    [self SaveValues];
    
    [self LoadValues];
    
    [self createNewFlight];
    
    //[self checkForUpdates_Helicopter];
 
    // dann kommt butselheli
    
    
    flagDoCreateNewFlight = 0;
    
    _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
    
    [self checkForUpdates_Helicopter];

    
    
    
}



- (void)createNewFlight {
    
    //NSLog(@"createNewFlight");
    
    justCreatedNewFlight = 1;
          
          
    loadedSignatureImage = nil;
    [scrollSig removeFromSuperview];
    signatureImageData = nil;
    
    [calculatePerformanceClass_ resetInputObstacleHeight ];
   
    
    flagDoCreateNewFlight = 0;
    
    //NSLog(@"createNewFlight allFlightsMasterArray count %d ", allFlightsMasterArray.count);
    
    vFlightID =  [ [NSString alloc] initWithFormat:@"%lu", (unsigned long)allFlightsMasterArray.count];
    
    vLegID = @"1";
    
    [allFlightsMasterArray addObject:@"-"];
    
    //NSLog(@"createNewFlight  vFlightID:%@  vLegID:  %@", vFlightID, vLegID);
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject: vFlightID  forKey:@"vFlightID"];
    
    
    [self doCreateFlightSettings];  // set configuration and load array listo
    
    flagResetAllLegs = 1;
    
    [[EquipPackagesManager sharedInstance] addNewPackageWithKey:Flight.text andDefaultConfig:0];
    
    
    [self SaveValues]; // unter neuem Namen alles speichern
    
    [self createFlightButtons];
    
    

    
}



- (IBAction)actionAddLegToActiveFlight:(id)sender {
    
    alertFlag = 1002;
    
    UIAlertView *alert = [[UIAlertView alloc]
                          initWithTitle:@"Add Leg"
                          message:@"Please Confirm"
                          delegate:self
                          
                          cancelButtonTitle:@"Cancel"
                          
                          
                          
                          otherButtonTitles:@"Add Leg", nil];
    [alert show];

    
  
    
}

- (void) addLegToActiveFlight {
    
    [self SaveValues];
    
    [self LoadValues];
    
    loadedSignatureImage = nil;
    [scrollSig removeFromSuperview];
    signatureImageData = nil;
    
    
    vLegID =  [ [NSString alloc] initWithFormat:@"%lu", (unsigned long)allLegsPerFlightArray.count]; // next leg ID
    
    //NSLog(@"add leg for flight %d and  vLegID -%@- ", [vFlightID integerValue], vLegID);
    [allLegsPerFlightArray addObject:@"-"];
    
    
    
    
    
    [self guidanceResetLegDataOnly];
    
    
    [self checkGuidance];
    
    [self SaveValues]; // unter neuem Namen alles speichern
    
    [self LoadValues];
    
    [self createFlightButtons];
    
    //NSLog(@"end create new flight");
    
    
}

- (IBAction)actionChangeAircraft:(id)sender {
    
    //NSLog(@"actionChangeAircraft");
    
     flagDoCreateNewFlight = 0;
    _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
    
    [self checkForUpdates_Helicopter];
    
}


- (IBAction)buttonActionSummaryManifest:(id)sender {
    
     displayWindow = 14;
    
    [self displayWindows];    

}


- (void) createSummaryLabels {
    
    
    
    
    
    [self SaveValues];
    
    
    
    for(UIView *subview in [_viewSummaryLegs subviews]) {
        [subview removeFromSuperview];
    }
    
 
    
    float yTop = 10;
    
    float addLines = 0;
    
    float xLeft = 15;
    
    float yGap = 40;
    
    float lineGap = 18;
    
    float boxHeight = 285;
    
    float boxWidth = 935;
    
    float itemsInRow = 5;
    
    float xGap = boxWidth / itemsInRow;

    
    int currentFlightID = [vFlightID intValue];
    
    
    // basic data
    
    [self createDateSummary];

    _sDate.text = summaryDateStamp;
    
    
    
    
    
    // data per leg
    
    int numberOfLegsThisFlight =  [[allFlightsMasterArray objectAtIndex:currentFlightID] count] -1  ; // this is how many legs we have per fligh
    
    
    // note current flight
    
    //load leg data for this flight
    
    int totalStartsEng1 = 0;
    int totalStartsEng2 = 0;
    int totalRIN = 0;
    
    int totalFlightTimeMinutes = 0;
    
    for (int legID = 1; legID < numberOfLegsThisFlight+1 ; legID++) {
        
        NSMutableDictionary *tempLegSettingsDictionary = [[NSMutableDictionary alloc] init];
        tempLegSettingsDictionary = [allLegsPerFlightArray objectAtIndex: legID ];
        
        
        // create leg line
        
        UIImageView *line =[[UIImageView alloc] initWithFrame:CGRectMake(0, (((legID+addLines)-1) *boxHeight)+ boxHeight-3 ,boxWidth, 2) ];
        line.backgroundColor = [UIColor blackColor];
        [_viewSummaryLegs addSubview: line];
        
        
        //key
        
        NSArray* legLabels              = @[@"",
                                            @"@Leg Number,legID$",
                                            @"@FROM,vFlightDeparture$",
                                            @"@TO,vFlightDestination$",
                                            @"@SIC,SICofLeg$",
                                            @"@Takeoff Mass [kg],vTOW$",
                                            @"@C.G.,labelCGTakeoff$",
                                            @"@MTOM [kg],MTOW$",
                                            @"@_Departure Date/Time,_labelDepartureTimeLocal$",
                                            @"@Landing Date/Time,_labellandingtimeLocal$",
                                            @"@Leg Time [h:min],_labelGuidanceLegTime$",
                                            @"@Fuel On Board,_labelGuidanceFuel$",
                                            @"@_Remarks,_vHOMSA$",
                                            @"@2Passengers On Board,_labelPaxOnBoard$",
                                         ];
        
        
        
        
        float counterX = -1;
        
        float counterY = 0;
        
        
        
        // get basic data from leg 1
        
        if (legID == 1) {
            
            _sFlightID.text = [tempLegSettingsDictionary objectForKey: @"_vFlightIDName"  ];
            
            _sACtype.text = [tempLegSettingsDictionary objectForKey: @"_legAC_Type"  ];
            
            _sRegistration.text = [tempLegSettingsDictionary objectForKey: @"vFlightRegistration"  ];
            
            _sBase.text = [tempLegSettingsDictionary objectForKey: @"_labelBaseName"  ];
            
            _sBEW.text = [tempLegSettingsDictionary objectForKey: @"vBEW"  ];
            
        }
        
        totalFlightTimeMinutes = totalFlightTimeMinutes +  [[tempLegSettingsDictionary objectForKey: @"legFlightTimeMinutes"]integerValue ];
        
        //NSLog(@"totalFlightTimeMinutes %d ", totalFlightTimeMinutes);
        
        int minuteDifference = totalFlightTimeMinutes;
        int hours = minuteDifference / 60;
        int minutes = minuteDifference - (hours * 60);
        NSString *flightTime=  [ [NSString alloc] initWithFormat:@"%.d", minuteDifference ];
        if (minutes >= 10)                  { flightTime =  [ [NSString alloc] initWithFormat:@"0%.dh:%.dmin", hours, minutes ];}
        if (minutes <= 9  & minutes > 0)    { flightTime =  [ [NSString alloc] initWithFormat:@"0%.dh:0%.dmin", hours, minutes ];}
        if (minutes <= 0)                   { flightTime =  [ [NSString alloc] initWithFormat:@"0%.dh:00min", hours ];}
      
        _sTotalFlightTime.text = flightTime;
        
       
        // create all leg labels
        
        for (int labelID = 1; labelID < legLabels.count ; labelID++) {
            
            
            NSString *string= [legLabels objectAtIndex: labelID ];
            
            NSRange searchFromRange = [string rangeOfString:@"@"];
            NSRange searchToRange = [string rangeOfString:@","];
            NSString *itemName = [string substringWithRange:NSMakeRange(searchFromRange.location+searchFromRange.length, searchToRange.location-searchFromRange.location-searchFromRange.length)];
            
            
            float lineWidthAdd = 0;
            int factorLineHeight = 1;
            int liftLine = 0;
            
            // carriage return with _ in front of line
            if (itemName.length >1) {
                NSString *testIfCarriageReturn = [itemName substringToIndex:1];
                
                if ([testIfCarriageReturn isEqualToString:@"_"]) {
                    itemName = [itemName substringFromIndex:1];
                    counterY = counterY + 1;
                    counterX = -1;
                    
                }
                
                if ([testIfCarriageReturn isEqualToString:@"2"]) {
                    itemName = [itemName substringFromIndex:1];
                    counterY = counterY + 1;
                    counterX = -1;
                    lineWidthAdd = 700;
                    factorLineHeight = 2;
                    
                    liftLine = 7;
                }
                
            }
            
            
            searchFromRange = [string rangeOfString:@","];
            searchToRange = [string rangeOfString:@"$"];
            NSString *itemID = [string substringWithRange:NSMakeRange(searchFromRange.location+searchFromRange.length, searchToRange.location-searchFromRange.location-searchFromRange.length)];
            
            
            // get totals
            
            
            if ([itemName isEqualToString:@"Starts Eng.#1"]) {
                totalStartsEng1 = totalStartsEng1 + [[tempLegSettingsDictionary objectForKey: itemID    ]floatValue ];
            }
            
            if ([itemName isEqualToString:@"Starts Eng.#2"]) {
                totalStartsEng2 = totalStartsEng2 + [[tempLegSettingsDictionary objectForKey: itemID    ]floatValue ];
            }
            
            
            if ([itemName isEqualToString:@"RIN"]) {
                totalRIN = totalRIN + [[tempLegSettingsDictionary objectForKey: itemID    ]floatValue ];
            }
            
                        
            
            _sTotalStartsEng1.text = [NSString stringWithFormat:@"%d",totalStartsEng1 ];
            _sTotalStartsEng2.text = [NSString stringWithFormat:@"%d",totalStartsEng2 ];
            _sTotalRIN.text = [NSString stringWithFormat:@"%d",totalRIN ];
            
           
            
            //NSLog(@"itemID -%@-", itemID);
            
            counterX = counterX + 1;
            
            if (counterX == itemsInRow) {
                counterX = 0;
                
                counterY = counterY + 1;
            }

            
            
            UILabel *legLabel = [[UILabel alloc] initWithFrame:CGRectMake(xLeft + (counterX * xGap) , yTop + ((legID-1) *boxHeight) + (counterY * yGap )  , xGap, 30)];
            legLabel.font = [UIFont systemFontOfSize:15];
            legLabel.textAlignment = NSTextAlignmentLeft;
            legLabel.textColor = [UIColor darkGrayColor];
            //legLabel.backgroundColor = [UIColor redColor];
            
            [legLabel  setText: itemName  ];
            
            [_viewSummaryLegs addSubview: legLabel];
            
            
            
            legLabel = [[UILabel alloc] initWithFrame:CGRectMake(xLeft + (counterX * xGap) , yTop + ((legID-1) *boxHeight) + (counterY * yGap ) +  lineGap - liftLine, xGap + lineWidthAdd, 30 * factorLineHeight )];
            legLabel.font = [UIFont boldSystemFontOfSize:15];
            legLabel.textAlignment = NSTextAlignmentLeft;
            legLabel.textColor = [UIColor blackColor];
            
            if (factorLineHeight > 1) {
                legLabel.font = [UIFont boldSystemFontOfSize:13];
                
                legLabel.numberOfLines = 2;
            }
            
            [legLabel  setText: [tempLegSettingsDictionary objectForKey: itemID    ]  ];
            
            [_viewSummaryLegs addSubview: legLabel];
            
            

            
            
        }// end next all labels
        
        // create vertical line
        
        UIImageView *verticalLine =[[UIImageView alloc] initWithFrame:CGRectMake(-3, 0 ,3, (boxHeight *( numberOfLegsThisFlight  +addLines) -1 ) ) ];
        verticalLine.backgroundColor = [UIColor blackColor];
        [_viewSummaryLegs addSubview: verticalLine];
        
        
        verticalLine =[[UIImageView alloc] initWithFrame:CGRectMake(935, 0 ,3, (boxHeight * ( numberOfLegsThisFlight +addLines) -1 ) ) ];
        verticalLine.backgroundColor = [UIColor blackColor];
        [_viewSummaryLegs addSubview: verticalLine];
        
       
        
        
        summaryBoxHeight = (boxHeight *( numberOfLegsThisFlight +addLines));
        
        _viewSummaryLegs.frame = CGRectMake(63, 288, 935, summaryBoxHeight    );
        
         [_scrollViewSummaryManifest setContentSize:CGSizeMake(1024, _viewSummaryLegs.frame.size.height + 800)];
        
        
    }
    
    
}




- (IBAction)actionRunMainRoutine:(id)sender {
    
    //NSLog(@"actionRunMainRoutine");
    
    [self setBasicsForConfiguration];
    
    [self MainRoutine];
    
}
- (IBAction)actionSetFuel:(id)sender {
    
    //NSLog(@"actionSetFuel");

    
    guidanceDictionary[@"guidanceBtnFuelPanel"] =  @"ok";
    
    
    if (flagFuelVisisble == 0) {
        flagFuelVisisble = 1;
    }else{
        flagFuelVisisble = 0;


    }
    
    
    [self setBasicsForConfiguration];
    
    
     [self MainRoutine];
    
}


- (IBAction)actionShowSliders:(id)sender {
    
    _viewInputOptions.hidden = YES;
   
    
    if (flagShowSliders == 0) {
        flagShowSliders = 1;
        
        
      
        
        previousConfiguration = 999;
        [self createListoItemsSlidersAndInterior];
        [self calculateListo];
        
        
    }else{
        flagShowSliders = 0;
        
      
        
        previousConfiguration = 999;
        [self createListoItemsSlidersAndInterior];
        [self calculateListo];
    }
    
    //NSLog(@"actionShowSliders");
    [self setBasicsForConfiguration];
    
    [self MainRoutine];
    
    
}



- (IBAction)actionShowInputOptions:(id)sender {
    
    
    if (_viewInputOptions.hidden == YES) {
        _viewInputOptions.hidden = NO;
        
        _viewInputOptions.frame = CGRectMake(_viewLegData.frame.origin.x, _viewLegData.frame.origin.y, _viewLegData.frame.size.width, _viewLegData.frame.size.height);
        
        [viewMain bringSubviewToFront:_viewInputOptions];
        
        [viewMain bringSubviewToFront:_viewButtonsFuelAndConfig];
        
    }else{
        _viewInputOptions.hidden = YES;
        
    }
    
    
}
- (IBAction)actionSegmentSeatLoadOptions:(id)sender {
    
    //_viewInputOptions.hidden = YES;
    
    
    [self createListoItemsSlidersAndInterior];
    
    [self MainRoutine];
    
    
}


- (IBAction)actionSegmentNamesOnSeats:(id)sender {
    
    previousConfiguration = 999;
    [self createListoItemsSlidersAndInterior];
    [self MainRoutine];
    
}



- (IBAction)actionSegmentSwapMode:(id)sender {
    
    //_viewInputOptions.hidden = YES;
    
    
    if (_segmentSwapMode.selectedSegmentIndex == 1) {
        panRecognizerForGhost.enabled = YES;
    }else{
        panRecognizerForGhost.enabled = NO;
    }
    
}



- (void) addLegButtons {
   
    //NSLog(@"addLegButtons");
    
    //NSLog(@"addLegButtons flightSettingsDictionary %@", flightSettingsDictionary);
    
    int numberOfLegsThisFlight = [[flightSettingsDictionary  objectForKey:@"numberOfLegsThisFlight"] floatValue];
    
    //NSLog(@"numberOfLegsThisFlight %d ", numberOfLegsThisFlight);
 
    
    
    int currentGuidanceCheck = guidanceLegCheckOK;  // this is for the active leg
    
    
     //NSLog(@"currentGuidanceCheck %d", currentGuidanceCheck);
    
    
    
    for(UIView *subview in [_viewLegButtons subviews]) {
        [subview removeFromSuperview];
    }
    
    
    if (flagIsLandscape == 1) {
        _viewLegButtons.frame = CGRectMake(0, 57, 1024, 52);
        
    }else{
        
        _viewLegButtons.frame = CGRectMake( 645, 57, 150, 650 ) ;
        
    }
    
    
    
    //int currentFlightID = [vFlightID intValue] ;
    
    
    float buttonWidth = 140;
    float xGap = 140;
    float buttonHeight = 52;
    float yGap = 0;
    
    float overlap =2;
    
    if (flagIsLandscape == 1) {
        
        
        buttonWidth = 140;
        buttonHeight = 52;
        
        xGap = 140;
        
        overlap =2;
        
        yGap = 0;
        
    }else{
        
        xGap = 0;
        
        buttonWidth = 125;
        buttonHeight = 60;
        
        overlap = 0;
        
        yGap = buttonHeight;
        
        
        
    }
    
    for(int i=0; i<numberOfLegsThisFlight; i++) {
        
        //NSLog(@"adding leg button i %d",i);
        
        UIButton *perfButton = [UIButton buttonWithType:UIButtonTypeCustom];
        
        perfButton.frame     = CGRectMake( i * xGap - i * overlap , 0 + i * yGap, buttonWidth, buttonHeight );
        
        perfButton.tag = i;
        
        [perfButton addTarget:self action:@selector(actionLegButton:) forControlEvents:UIControlEventTouchUpInside];
        
        
        UIImage *bg = [UIImage imageNamed:@"button grey top184x52.png"];
        
        UIImage *bb = [UIImage imageNamed:@"bb.png"];
        
        UIImage *byel = [UIImage imageNamed:@"button_yellow_leg.png"];
        
        UIImage *bgreen = [UIImage imageNamed:@"button_green.png"];
      
        int guidanceCheckValue = [[ [allLegsPerFlightArray objectAtIndex: i+1 ] objectForKey:@"guidanceLegCheckOK"] integerValue]; // trick to get the info from within leg arrays **********
        
         //NSLog(@" guidanceCheckValue i %d %d",i, guidanceCheckValue);
        
       
      
        
        int showLegStripe = 0;
        
        if (i +1 == [vLegID integerValue]) {
           
            showLegStripe = 1;
            
            [perfButton setBackgroundImage:byel forState:UIControlStateNormal];
            
            if (guidanceCheckValue == 1 & _switchGuidance.on == YES) {
                [perfButton setBackgroundImage:bgreen forState:UIControlStateNormal];
            }
            
            if (currentGuidanceCheck == 1 & _switchGuidance.on == YES) {
                [perfButton setBackgroundImage:bgreen forState:UIControlStateNormal];
            }
            
            if (currentGuidanceCheck == 0 & _switchGuidance.on == YES) {
                [perfButton setBackgroundImage:byel forState:UIControlStateNormal];
            }
            
            if ( _switchGuidance.on == NO) {
                [perfButton setBackgroundImage:bb forState:UIControlStateNormal];
            }
            
            
        }else{
          
            
            if (guidanceCheckValue == 1 & _switchGuidance.on == YES) {
                [perfButton setBackgroundImage:bgreen forState:UIControlStateNormal];
            }else{
                
                [perfButton setBackgroundImage:byel forState:UIControlStateNormal];
            }
            
            
            if ( _switchGuidance.on == NO) {
                [perfButton setBackgroundImage:bg forState:UIControlStateNormal];
            }
            
            
        }
       
        [perfButton setBackgroundImage:bg forState:UIControlStateHighlighted];
        
        [_viewLegButtons addSubview:perfButton];
        
        
        UILabel *label = [[UILabel alloc] init];
        
        label.frame       = CGRectMake( i * xGap - i * overlap , 0 + i * yGap, buttonWidth, buttonHeight );
        
        [label setFont:[UIFont systemFontOfSize:17]];
        
        label.textAlignment = NSTextAlignmentCenter;
        label.textColor = [UIColor whiteColor];
        
        label.text = [NSString stringWithFormat:@"Leg: %d",i+1];
        
        [_viewLegButtons addSubview:label];
        
        
        if (showLegStripe == 1) {
            //legStripe
            UIView *legStripe = [[UIView alloc] init];
            legStripe.tag = 888;
            legStripe.backgroundColor = [UIColor whiteColor];
            legStripe.frame     = CGRectMake( i * xGap - i * overlap , 0 + i * yGap + buttonHeight - 6, buttonWidth, 6 );
            legStripe.hidden = NO;
            [_viewLegButtons addSubview:legStripe];
        }
       
        
    }
   
    
    
}


- (IBAction)actionLegButton:(id)sender{
    
    
    [self SaveValues];
    
    
     UIButton *btn = (UIButton*)sender;
    
    vLegID = [NSString stringWithFormat:@"%d",  btn.tag +1  ];
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject:vLegID                     forKey:@"vLegID"];
    
    
    
    [self LoadValues];
    
    if (viewLoadManifest.hidden == NO) {
        [self createItemListForLoadManifest];
    }
    
    if (_viewSpecialEquiplist.hidden == NO) {
        [self createSpecialEquipListItems];
    }
    
    
    [self MainRoutine];
    [self calculateListo];

    
}





- (IBAction)actionShowHidePerformance:(id)sender {
    
    guidanceDictionary[@"guidanceBtnPerformance"] =  @"ok";
    
    
    if (flagShowPerformance == 1) {
        
        flagShowPerformance = 0;

    }else{
        
        flagShowPerformance = 1;
    }
    
    [self MainRoutine];
}


- (void) guidanceResetTotal {
    
    guidanceDictionary[@"guidanceBtnSetConfiguration"] =  @"nok";
    guidanceDictionary[@"guidanceBtnSetEquipment"] =  @"nok";
    guidanceDictionary[@"guidanceBtnPerformance"] =  @"nok";
    guidanceDictionary[@"guidanceBtnCrew"] =  @"nok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"nok";
    guidanceDictionary[@"guidanceBtnFuelPanel"] =  @"nok";
    
    guidanceDictionary[@"guidanceFlightID"] =  @"nok";
    
    return;

    
}

- (void) guidanceResetLegDataOnly {
    
    
    _labelDepartureTimeLocal.text = @"";
    _labelDepartureTimeGMT.text = @"";
    _labellandingtimeLocal.text = @"";
    
    vFlightDeparture.text = vFlightDestination.text;
    vFlightDestination.text = @"";
    
    _vEngineStarts1.text = @"";
    _vEngineStarts2.text = @"";
    _vRIN.text = @"";
    _vHOMSA.text = @"";

    
    guidanceDictionary[@"guidanceBtnPerformance"] =  @"nok";
    guidanceDictionary[@"guidanceBtnCrew"] =  @"ok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"ok";
    guidanceDictionary[@"guidanceBtnFuelPanel"] =  @"nok";

    
    return;
    
    
}



- (void) guidanceResetLegDataAll {
    
    
    _labelDepartureTimeLocal.text = @"";
    _labelDepartureTimeGMT.text = @"";
    _labellandingtimeLocal.text = @"";
    
    vFlightDeparture.text = @"";
    vFlightDestination.text = @"";
    vFlightDestination.text = @"";
    
    _vEngineStarts1.text = @"";
    _vEngineStarts2.text = @"";
    _vRIN.text = @"";
    _vHOMSA.text = @"";
    
    
    guidanceDictionary[@"guidanceBtnPerformance"] =  @"ok";
    guidanceDictionary[@"guidanceBtnCrew"] =  @"ok";
    guidanceDictionary[@"guidanceBtnDispatch"] =  @"ok";
    guidanceDictionary[@"guidanceBtnFuelPanel"] =  @"nok";
    
    
    return;
    
    
}


- (void) setGuidanceNeutral {
    
    
    _labelFlightLegID.backgroundColor = [UIColor lightGrayColor];
    _labelFlightLegID.textColor = [UIColor blackColor];
    
    [_inputPaxOnBoard setBackgroundColor: [UIColor lightGrayColor] ];
    
    [_vFlightIDName setBackgroundColor: [UIColor lightGrayColor] ];
    
    [_vEngineStarts1 setBackgroundColor: [UIColor lightGrayColor] ];
    [_vEngineStarts2 setBackgroundColor: [UIColor lightGrayColor] ];
    [_vRIN setBackgroundColor: [UIColor lightGrayColor] ];
    [_vHOMSA setBackgroundColor: [UIColor lightGrayColor] ];
    
    [_labelDepartureTimeLocal setBackgroundColor: [UIColor lightGrayColor] ];
    [_labellandingtimeLocal setBackgroundColor: [UIColor lightGrayColor] ];
    
    [vFlightDeparture setBackgroundColor: [UIColor lightGrayColor] ];
    [vFlightDestination setBackgroundColor: [UIColor lightGrayColor] ];
    
    [_vCockpitSeatLeft setBackgroundColor: [UIColor lightGrayColor] ];
    [_vCockpitSeatRight setBackgroundColor: [UIColor lightGrayColor] ];
    
    
    [_vCockpitSeatLeft setBackgroundColor: [UIColor lightGrayColor] ];
   
    
    UIImage *blueBUtton = [UIImage imageNamed:@"button generic blue.png"];
    
    [_guidanceBtnSetConfiguration setBackgroundImage:blueBUtton forState:UIControlStateNormal];    
    [_guidanceBtnSetConfiguration setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
    [_guidanceBtnSetEquipment setBackgroundImage:blueBUtton forState:UIControlStateNormal];
    [_guidanceBtnSetEquipment setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
    [_guidanceBtnPerformance setBackgroundImage:blueBUtton forState:UIControlStateNormal];
    [_guidanceBtnPerformance setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
    [_guidanceBtnCrew setBackgroundImage:blueBUtton forState:UIControlStateNormal];
    [_guidanceBtnCrew setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
    
    [_guidanceBtnDispatch setBackgroundImage:blueBUtton forState:UIControlStateNormal];
    [_guidanceBtnDispatch setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
    [_guidanceBtnFuelPanel setBackgroundImage:blueBUtton forState:UIControlStateNormal];
    [_guidanceBtnFuelPanel setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    
    
   
    
    
    _labelGuidanceOAT.text =  [ [NSString alloc] initWithFormat:@"OAT: %.0fºC", OAT ];
    _labelGuidancePA.text =  [ [NSString alloc] initWithFormat:@"PA: %.0f""", Hp ];
    
    _labelGuidanceFuel.text =  [ [NSString alloc] initWithFormat:@"%@ %@", _labelSliderFuelMain.text, _labelFuelUnitMainTank.text];
    
}


- (void) checkGuidance {
    
    //NSLog(@"checkGuidance");
    
    
    if (_switchGuidance.on == NO) {
        
        [self setGuidanceNeutral];
        
        return;
    }
    
    
    
   
   
     //NSLog(@"previousCheckResult %d", previousCheckResult);
    
    
    UIImage *yellowButton = [UIImage imageNamed:@"button strong yellow.png"];
    
    UIImage *greenButton = [UIImage imageNamed:@"button strong green.png"];
    
    guidanceLegCheckOK = 1;
    
    if ([[itemsGuidance objectAtIndex:0] isEqualToString:@"1"]) {
        
        if ( _vFlightIDName.text.length < 1) {
            [_vFlightIDName setBackgroundColor: [UIColor lightGrayColor] ]; guidanceLegCheckOK = 0;
        }else{
            [_vFlightIDName setBackgroundColor: GreenColor];
           }
    }
    
   
    if ([[itemsGuidance objectAtIndex:1] isEqualToString:@"1"]) {
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnSetConfiguration"] isEqualToString:@"nok"]) {
            
            [_guidanceBtnSetConfiguration setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnSetConfiguration setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            [_guidanceBtnSetConfiguration setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnSetConfiguration setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
    }
    
    if ([[itemsGuidance objectAtIndex:2] isEqualToString:@"1"]) {
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnSetEquipment"] isEqualToString:@"nok"]) {
            [_guidanceBtnSetEquipment setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnSetEquipment setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            [_guidanceBtnSetEquipment setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnSetEquipment setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
        
    }
    
    
    if ([[itemsGuidance objectAtIndex:3] isEqualToString:@"1"]) {
        
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnDispatch"] isEqualToString:@"nok"]) {
            [_guidanceBtnDispatch setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnDispatch setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            [_guidanceBtnDispatch setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnDispatch setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
    
    }
    
    
    if ([[itemsGuidance objectAtIndex:4] isEqualToString:@"1"]) {
        
        
        if ( _inputPaxOnBoard.text.length < 1) {
            [_inputPaxOnBoard setBackgroundColor: yellowSpecialColor]; guidanceLegCheckOK = 0;
        }else{
            [_inputPaxOnBoard setBackgroundColor: GreenColor];
        }
        
    }
    
    
    if ([[itemsGuidance objectAtIndex:5] isEqualToString:@"1"]) {
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnPerformance"] isEqualToString:@"nok"]) {
            [_guidanceBtnPerformance setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnPerformance setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            [_guidanceBtnPerformance setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnPerformance setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
    }
    
    
    if ([[itemsGuidance objectAtIndex:6] isEqualToString:@"1"]) {
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnFuelPanel"] isEqualToString:@"nok"]) {
            
            [_guidanceBtnFuelPanel setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnFuelPanel setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            [_guidanceBtnFuelPanel setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnFuelPanel setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
    }
    
    
    
    
    if ([[itemsGuidance objectAtIndex:7] isEqualToString:@"1"]) {
        
        if ( vFlightDeparture.text.length < 1) {
            [vFlightDeparture setBackgroundColor: [UIColor lightGrayColor]]; guidanceLegCheckOK = 0;
        }else{
            [vFlightDeparture setBackgroundColor: GreenColor];
        }
        
        
        if ( vFlightDestination.text.length < 1) {
            [vFlightDestination setBackgroundColor: [UIColor lightGrayColor]]; guidanceLegCheckOK = 0;
        }else{
            [vFlightDestination setBackgroundColor: GreenColor];
        }
    }

    
    
    
    if ([[itemsGuidance objectAtIndex:8] isEqualToString:@"1"]) {
        
        if ( _labelDepartureTimeLocal.text.length < 1) {
            
            [_labelDepartureTimeLocal setBackgroundColor: [UIColor lightGrayColor]]; guidanceLegCheckOK = 0;
        }else{
            [_labelDepartureTimeLocal setBackgroundColor: GreenColor];
        }
        
        if ( _labellandingtimeLocal.text.length < 1) {
            [_labellandingtimeLocal setBackgroundColor: [UIColor lightGrayColor]]; guidanceLegCheckOK = 0;
        }else{
            [_labellandingtimeLocal setBackgroundColor: GreenColor];
        }
    }
    
   
   
    if ([[itemsGuidance objectAtIndex:10] isEqualToString:@"1"]) {
        
        if ([[guidanceDictionary objectForKey:@"guidanceBtnCrew"] isEqualToString:@"nok"]) {
            
            [_guidanceBtnCrew setBackgroundImage:yellowButton forState:UIControlStateNormal]; guidanceLegCheckOK = 0;
            [_guidanceBtnCrew setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        }else{
            
            [_guidanceBtnCrew setBackgroundImage:greenButton forState:UIControlStateNormal];
            [_guidanceBtnCrew setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
            
        }
        
        
    }
    
    
    
    
     _labelGuidanceOAT.text =  [ [NSString alloc] initWithFormat:@"OAT: %.0fºC", OAT ];
     _labelGuidancePA.text =  [ [NSString alloc] initWithFormat:@"PA: %.0f""", Hp ];
    
     _labelGuidanceFuel.text =  [ [NSString alloc] initWithFormat:@"%@ %@", _labelSliderFuelMain.text, _labelFuelUnitMainTank.text];
    
    if (guidanceLegCheckOK == 1) {
        _labelFlightLegID.backgroundColor = GreenColor;
        _labelFlightLegID.textColor = [UIColor blackColor];
        
    }else{
        _labelFlightLegID.backgroundColor = yellowSpecialColor;
        _labelFlightLegID.textColor = [UIColor blackColor];
        
    }
    
     //NSLog(@"result  %d", guidanceLegCheckOK);
    
     [self addLegButtons];
    
}





- (IBAction)buttonActionLoadDispatcherFlights:(id)sender {
    
    [self loadDispatcherFlightsFromServer];
    
}
- (IBAction)switchAction:(id)sender {
    
    [self MainRoutine];

    
    
}
- (IBAction)actionCockpitSeatRight:(id)sender {
    
  
    
    
}

- (IBAction)actionCockpitSeatLeft:(id)sender {
    
    
    
   
}

- (IBAction)actionCockpitSeatSwap:(id)sender {
    
    NSString *previousLeft = _vCockpitSeatLeft.text;
    
    _vCockpitSeatLeft.text = _vCockpitSeatRight.text;
    
    _vCockpitSeatRight.text = previousLeft;
    
     [self MainRoutine];
    
    
}



- (void) calcLegTime {
    
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    
    [dateFormatter setDateFormat: [_arrayName23 objectAtIndex: 38] ];
    
    int totalFlightTimeMinutes = 0;
    
    
    NSDate *startDate = [dateFormatter dateFromString: _labelDepartureTimeLocal.text  ];
    
    NSDate *endDate   = [dateFormatter dateFromString: _labellandingtimeLocal.text ];
    
    int minuteDifference = [endDate timeIntervalSinceDate:startDate] / 60.0;
    
    totalFlightTimeMinutes = totalFlightTimeMinutes + minuteDifference;
    
    legFlightTimeMinutes = totalFlightTimeMinutes;
    
    int hours = minuteDifference / 60;
    
    int minutes = minuteDifference - (hours * 60);
    
    
    
    
    NSString *flightTimeLeg =  [ [NSString alloc] initWithFormat:@"%.d", minuteDifference ];
    
    if (minutes >= 10)                  { flightTimeLeg =  [ [NSString alloc] initWithFormat:@"0%.d:%.d", hours, minutes ];  }
    
    if (minutes <= 9  & minutes > 0)    { flightTimeLeg =  [ [NSString alloc] initWithFormat:@"0%.d:0%.d", hours, minutes ];  }
    
    if (minutes <= 0)                   { flightTimeLeg =  [ [NSString alloc] initWithFormat:@"0%.d:00", hours ];}
    
    _labelGuidanceLegTime.text = flightTimeLeg;
    
    
    //NSLog(@"flightTimeLeg %@", flightTimeLeg);
    
    
   
    
    
}




- (IBAction)actionMoveTextfieldUp:(UITextField*)sender {
    
    if (flagIsLandscape == 0) {
        return;
    }
    
    //NSLog(@"sender %d", sender.tag) ;
    
    float scrollViewOffsetPixel = _scrollViewLegData.contentOffset.y;
    
    //NSLog(@"scrollViewOffsetPixel %f", scrollViewOffsetPixel);
    
    
    float yLiftPixel = 0;
    
    if (sender.tag == 1) { // MSA field
        
        yLiftPixel = 339;
        
    }
    
    
    
    if (sender.tag == 2) { // MSA field
        
        yLiftPixel = 639;
        
    }
    
    //NSLog(@"yLiftPixel %f", yLiftPixel) ;
    
    
    if (yLiftPixel < scrollViewOffsetPixel ) {
        yLiftPixel = scrollViewOffsetPixel;
    }
    
    
    
    [_scrollViewLegData setContentOffset:CGPointMake(0, yLiftPixel) animated:YES];
    
  

}

- (void) setConfigWindow {
    
    //NSLog(@"setConfigWindow");
    
    
    if (configMode == 0) {
        configMode = 1;
        
        
        
        if (flagIsLandscape == 1) {
            _buttonCloseInteriorConfigurator.frame = CGRectMake( 955, 5, 50, 50 ) ;
            
            _scrollViewConfiguratorItems.frame = CGRectMake( 384, 57, 640, 637 ) ;
            [_scrollViewConfiguratorItems setContentSize:CGSizeMake(_viewConfiguratorStationItems.frame.size.width, _viewConfiguratorStationItems.frame.size.height)];
            
            _viewHelicopterInCenter.clipsToBounds = YES;
            
            int xMove = -160;
            
            _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 , 300, 456 + 150);
            
            
        }else{
            
            _scrollViewConfiguratorItems.frame = CGRectMake( 384, 57, 640, 980 ) ;
            [_scrollViewConfiguratorItems setContentSize:CGSizeMake(_viewConfiguratorStationItems.frame.size.width, _viewConfiguratorStationItems.frame.size.height)];
            
            
            _buttonCloseInteriorConfigurator.frame = CGRectMake( 700, 5, 50, 50 ) ;
            
            _trennerBottom.hidden = YES;
            
            _trennerVerticalBottom.hidden = YES;
            
            _viewTrennerTop.hidden = YES;
            
            _viewHelicopterInCenter.clipsToBounds = NO;
            
            
            int xMove = -160;
            
            _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 210 , 300, 456 + 150);
            
            
            
        }
        
        
        
        
        _viewConfigurator.hidden = NO;
        _viewConfigurations.hidden = YES;
        _viewTrennerTop.hidden = YES;
        [viewMain bringSubviewToFront:_viewConfigurator];
        [viewMain bringSubviewToFront:_viewHelicopterInCenter];
        _viewHeliCenterLabels.userInteractionEnabled = NO;
        [self createInteriorConfiguratorItems];
       
        
        _viewLegButtons.hidden = YES;
        _viewLowerButtons.hidden = YES;
        viewTopDisplayButtons.hidden = YES;
        
        
        
        
    }else{
        
        
        configMode = 0;
        
        _viewHeliCenterLabels.userInteractionEnabled = YES;
        
        int xMove = +160;
        
        _viewHelicopterInCenter.frame = CGRectMake( 194 + xMove, 125 , 300, 456 + 150);
        _viewHelicopterInCenter.clipsToBounds = YES;
        
        
        _viewConfigurator.hidden = YES;
        _viewLowerButtons.hidden = NO;
        
        _viewTrennerTop.hidden = NO;
        
        
        if (flagShowPerformance == 1) {
            _viewLegButtons.hidden = YES;
            
            viewTopDisplayButtons.hidden = NO;
            
        }else{
            _viewLegButtons.hidden = NO;
            
            viewTopDisplayButtons.hidden = YES;
            
        }
        
        
        if (flagIsLandscape == 1) {
            
        }else{
            _trennerBottom.hidden = NO;
            
            _trennerVerticalBottom.hidden = NO;
        }
        
        
        
        
        [self setBasicsForConfiguration];
        
        [viewMain bringSubviewToFront:_viewButtonsFuelAndConfig];
        
        [self MainRoutine];
       
        
        
        
    }
    

    
    
}

- (IBAction)actionShowConfiguratorView:(id)sender {
    
    [self setConfigWindow];
    
}



- (void)actionTapAndHold:(UILongPressGestureRecognizer*)gesture {
    
    //NSLog(@"btnHOLDidTransfer %d", btnHOLDidTransfer);
   
    if ( gesture.state == UIGestureRecognizerStateBegan ) {
        //NSLog(@"Long Press %d", btnHOLDidTransfer);
        
        rideAlongSeat = btnHOLDidTransfer + 1300;
        
        if (btnHOLDidTransfer == lineFreeLoad) {
             //NSLog(@"free load Long Press %d", btnHOLDidTransfer);
            _viewFreeLoad.hidden = NO;
            _inputSeatArmLong.text = [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName3 objectAtIndex: lineFreeLoad] floatValue]  ];
            _inputSeatArmLat.text = [ [NSString alloc] initWithFormat:@"%.0f", [[_arrayName5 objectAtIndex: lineFreeLoad] floatValue]  ];
            
            
        }else{
            _viewFreeLoad.hidden = YES;
            
            
            if ([[_arrayName16 objectAtIndex:btnHOLDidTransfer] isEqualToString:@"standby"]  ) {
                
                //NSLog(@"ok Long Press %d", btnHOLDidTransfer);
             
                [_viewSeatOptions bringSubviewToFront:_viewStationOptions];
                _viewStationOptions.hidden = NO;
            }
            
        }
        
        _viewPilotList.hidden = NO;
        _inputSeatName.text = [_arrayName7 objectAtIndex:btnHOLDidTransfer  ]; _inputSeatWeight.text = [_arrayName2 objectAtIndex:btnHOLDidTransfer ];
        _viewSeatOptions.hidden = NO;
        
     
        [viewOne bringSubviewToFront:_viewPilotList];
        [_viewPilotList bringSubviewToFront:_viewSeatOptions];
        
        _viewStationOptionsList.hidden = NO;
        
        //[self setConfigWindow];
        
        [self createSeatOptionItems];
        
    }
}

-(void)actionTapOnStationHOLD:(id)sender{
    
    UIButton *btn = (UIButton*)sender;
    //NSLog(@"actionTapOnStationHold %d", btn.tag);
    btnHOLDidTransfer = btn.tag  - 1600;
   
    
}


-(void)actionTapOnStationStandby:(id)sender{
    
    UIButton *btn = (UIButton*)sender;
    //NSLog(@"actionTapOnStationStandby %d", btn.tag);
    btnHOLDidTransfer = btn.tag  - 1600;
    

    buttonIDtransfer = btn.tag;
    
    
    _viewPilotList.hidden = NO;
    
    _viewSeatOptions.hidden = NO; _viewFreeLoad.hidden = YES;
    [viewOne bringSubviewToFront:_viewPilotList];

    [_viewPilotList bringSubviewToFront:_viewSeatOptions];
    [_viewSeatOptions bringSubviewToFront:_viewStationOptions];
    _viewStationOptions.hidden = NO;
    
    
  
    
    [self createSeatOptionItems];

    
    
}

- (IBAction)actionCloseStationOptions:(id)sender {
    
    _viewStationOptionsList.hidden = YES;
    _viewPilotList.hidden = YES;
    
    _viewStationOptions.hidden = YES;
    
}


- (void) createSeatOptionItems {
    
    _stationTypeField.items   =  @[ @"Seat", @"Baggage", @"Standby"];
    
    _labelStationNameLong.text = [_arrayName1 objectAtIndex: btnHOLDidTransfer];
    
    if ([[_arrayName8 objectAtIndex: btnHOLDidTransfer] floatValue] == 0) {
        _segmentStationItemInOUT.selectedSegmentIndex = 0;
    }else{
        _segmentStationItemInOUT.selectedSegmentIndex = 1;
    }
    
    _inputStationInstallationWeight.text = [_arrayName17 objectAtIndex: btnHOLDidTransfer];
  
    
}


- (IBAction)actionStationInOutSingle:(id)sender {
    
    NSString *replacementItem;
    
    if ([_stationTypeField.text isEqualToString:@"Seat"]) {
        replacementItem = @"seat";
        
        _inputStationInstallationWeight.text = @"12";
    }
    if ([_stationTypeField.text isEqualToString:@"Baggage"]) {
        replacementItem = @"baggageBox";
        _inputStationInstallationWeight.text = @"5";
    }
    if ([_stationTypeField.text isEqualToString:@"Standby"]) {
        replacementItem = @"dashedBox";
    }
  
    
   
    if (_segmentStationItemInOUT.selectedSegmentIndex == 0) {
        [_arrayName8 replaceObjectAtIndex:btnHOLDidTransfer withObject:@"0"];
        [_arrayName2 replaceObjectAtIndex:btnHOLDidTransfer withObject:@"0"];
    }else{
        [_arrayName8 replaceObjectAtIndex:btnHOLDidTransfer withObject:@"1"];
    }
    
    [_arrayName10 replaceObjectAtIndex:btnHOLDidTransfer withObject:replacementItem];
    
    previousConfiguration = 999;
    [self createListoItemsSlidersAndInterior];
    [self MainRoutine];
    [self createSeatOptionItems];    
    
}

- (IBAction)closeKeyboardFuelFlow:(id)sender {
    
  
   
    [_arrayName21 replaceObjectAtIndex:27 withObject: inputFuelFlowOverride.text];
    
    
    actypeForConfig = AC_Type;
    defaultConfigName = arrayConfigurations[configuration];
    [self saveArrayListo];
    [self SaveValues];
    [self.view endEditing:TRUE];
    [self MainRoutine];

    
}


- (IBAction)closeKeyboardFuelOnBoard:(id)sender {
    
    _sliderFuelMain1.value = [_inputFuelOnBoard.text floatValue] / [_inputSpecificFuelMassPerVolume.text floatValue];
    
    [self MainRoutine];
    
       [_arrayName21 replaceObjectAtIndex:29 withObject: _inputFuelOnBoard.text];
    
    
    actypeForConfig = AC_Type;
    defaultConfigName = arrayConfigurations[configuration];
    [self saveArrayListo];
    [self SaveValues];
    [self.view endEditing:TRUE];
    [self MainRoutine];
    
    
}

- (IBAction)closeKeyboardFreeloadArmLong:(id)sender {
    
    [_arrayName3 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLong.text];
    [_arrayName5 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLat.text];
    
    [self createListoItemsSlidersAndInterior];
    
    actypeForConfig = AC_Type;
    defaultConfigName = arrayConfigurations[configuration];
    [self saveArrayListo];
    [self SaveValues];
    [self.view endEditing:TRUE];
    [self MainRoutine];
    
    
    
    
}

- (IBAction)closeKeyboardFreeloadArmLateral:(id)sender {
    
    [_arrayName3 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLong.text];
    [_arrayName5 replaceObjectAtIndex:lineFreeLoad withObject:_inputSeatArmLat.text];
    
    [self createListoItemsSlidersAndInterior];
    
    actypeForConfig = AC_Type;
    defaultConfigName = arrayConfigurations[configuration];
    [self saveArrayListo];
    [self SaveValues];
    [self.view endEditing:TRUE];
    [self MainRoutine];
    
}



- (void) createInteriorConfiguratorItems {
    
    for(UIView *subview in [_viewConfiguratorStationItems subviews]) {
        [subview removeFromSuperview];
    }
    
    
    float yStart = 20;
    float xPos1 = 30;
    float yGap = 40;
    
    int itemCount = -1;
    
    int configStationsStart = [[_arrayName23 objectAtIndex:11] intValue];
    int configStationsEnd = [[_arrayName23 objectAtIndex:13] intValue];
    
    
   
    
    
    for(int i =configStationsStart; i<configStationsEnd+1; i++) {
        
        itemCount = itemCount + 1;
        
        // station in / out button
        
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        btn.frame = CGRectMake(xPos1 ,  yStart + (itemCount *yGap)  , 60, 35);
        [btn addTarget:self
                action:@selector(actionConfiguratorStationInOut:)
      forControlEvents:UIControlEventTouchUpInside];
        
        btn.tag = i;
        
        if ( [[_arrayName8 objectAtIndex:i] integerValue] == 0) {
            [btn setTitle: @"OUT" forState: UIControlStateNormal];
            btn.backgroundColor = [UIColor redColor];
            [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }else{
            [btn setTitle: @"IN" forState: UIControlStateNormal];
            btn.backgroundColor = GreenColor;
            [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        }
        
        [_viewConfiguratorStationItems addSubview: btn];
        
        
        
        // station name arrayName1
        
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake( xPos1 + 90 , yStart + (itemCount *yGap)  , 120, 35)];
        textField.borderStyle = UITextBorderStyleNone;
        textField.font = [UIFont boldSystemFontOfSize:16];
        textField.autocorrectionType = UITextAutocorrectionTypeNo;
        textField.textAlignment = NSTextAlignmentLeft;
        textField.enabled = NO;
        textField.backgroundColor = [UIColor clearColor];
        textField.textColor = [UIColor whiteColor];
        
        [textField  setText: [[NSString alloc] initWithFormat:@"%@ ", [_arrayName12 objectAtIndex:i] ] ];
        
         [_viewConfiguratorStationItems addSubview: textField];
        
    }
    
    
    
}


- (IBAction)actionConfiguratorStationInOut:(id)sender{
    
    UIButton *btn = (UIButton*)sender;
    int currentState = [[_arrayName8 objectAtIndex:btn.tag] integerValue];
    
    // rule entire row:
    if (currentState == 0) {
        currentState = 1;
        [_arrayName8 replaceObjectAtIndex:btn.tag withObject:[[NSString alloc] initWithFormat:@"%d ", currentState]];
    }else{
         currentState = 0;
        [_arrayName8 replaceObjectAtIndex:btn.tag withObject:[[NSString alloc] initWithFormat:@"%d ", currentState]];
       }
    
    previousConfiguration = 999;
    [self createListoItemsSlidersAndInterior];
    [self MainRoutine];
    [self createInteriorConfiguratorItems];
    
    _viewLegButtons.hidden = YES;
    viewTopDisplayButtons.hidden = YES;
    
}








- (IBAction)actionExportSummaryAsPDF:(id)sender {
    
    
   

}


- (void)createPDFDataFromSummary {
    
    
    
    int pixelWidth = _scrollViewSummaryManifest.contentSize.width;
    int pixelHeight = summaryBoxHeight +290;  // set hight of pdf page here (cut off the bottom)
    
    pdfData = [NSMutableData data];
    
    UIGraphicsBeginPDFContextToData( pdfData, CGRectMake(0, 0, pixelWidth, pixelHeight),  nil );
    UIGraphicsBeginPDFPage();
    CGPoint savedContentOffset = _scrollViewSummaryManifest.contentOffset;
    CGRect savedFrame = _scrollViewSummaryManifest.frame;
    
    
    
    _scrollViewSummaryManifest.contentOffset = CGPointZero;
    _scrollViewSummaryManifest.frame = CGRectMake(0, 0, pixelWidth, pixelHeight);
    
    [_scrollViewSummaryManifest.layer renderInContext: UIGraphicsGetCurrentContext()];
    
    _scrollViewSummaryManifest.contentOffset = savedContentOffset;
    _scrollViewSummaryManifest.frame = savedFrame;
    
    UIGraphicsEndPDFContext();
    
    
}




- (IBAction)actionOverrideBEWData:(id)sender {
    
    if (_inputOverrideRegistration.text.length < 1|| _inputOverrideBEW.text.length < 1 || _inputOverrideMoment.text.length < 1 || _inputOverrideMomentLat.text.length < 1  ) {
        return;
    }
    
    
    
     [self.view endEditing:TRUE];
    
    
    bew = [_inputOverrideBEW.text floatValue];
    momlong = [_inputOverrideMoment.text floatValue];
    momlat = [_inputOverrideMomentLat.text floatValue];
    
    armlong = momlong / bew;
    armlat = momlat   / bew;
    
    vBEW.text = [NSString stringWithFormat:@"%.1f",bew];
    vBEWMom.text = [NSString stringWithFormat:@"%.1f",momlong];
    vBEWMomLat.text = [NSString stringWithFormat:@"%.1f",momlat];
    lBEWArm.text = [NSString stringWithFormat:@"%.1f",armlong];
    lBEWArmLat.text = [NSString stringWithFormat:@"%.1f",armlat];
    
    
    // replace BEW
    [_arrayName2 replaceObjectAtIndex:3 withObject:vBEW.text];
    [_arrayName3 replaceObjectAtIndex:3 withObject:lBEWArm.text];
    [_arrayName4 replaceObjectAtIndex:3 withObject:vBEWMom.text];
    [_arrayName5 replaceObjectAtIndex:3 withObject:lBEWArmLat.text];
    [_arrayName6 replaceObjectAtIndex:3 withObject:vBEWMomLat.text];

    _viewSelectHelicopter.hidden = YES;
    
    
    vFlightRegistration.text = _inputOverrideRegistration.text;
    
    //NSLog (@"flagDoCreateNewFlight %d " , flagDoCreateNewFlight);
    
    if (flagDoCreateNewFlight == 1) {
        [self createNewFlight];
    }else{
        
        [self MainRoutine];
    }
    
    
    displayWindow = 0;
    [self displayWindows];
    
}
- (IBAction)actionloadPerfChartData:(id)sender {
    
    
    [self loadPerfChartData];
    
    [self MainRoutine];
}

- (IBAction)actionUseEnterPad:(UIButton*)sender {
    
    if (sender.tag == 1) {
        selectedItem = 30;
        calculatorscreen.text = @"" ; EnterPadString = @"";
        enterPad.hidden = NO; [viewOne bringSubviewToFront:enterPad]; flagButtonPressed = 1;
    }
    
}



- (IBAction)buttonActionFuelPlus:(id)sender {
    
    float enterValue = [_inputFuelIncrement.text floatValue] + (_sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue] );
    //NSLog(@"enterValue %.0f ", enterValue);
    
    if ([fuelEnterMode isEqualToString:@"mass"]) {
        if (enterValue > tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue] ) {
            enterValue = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
        }
        _sliderFuelMain1.value =  enterValue / [_inputSpecificFuelMassPerVolume.text floatValue];
        
    }else{
        
        if (enterValue > tankCapacityVolume) {
            enterValue = tankCapacityVolume;
        }
        _sliderFuelMain1.value =  enterValue;
    }
    
    
    if (_sliderFuelLanding.value >= _sliderFuelMain1.value) {
        _sliderFuelLanding.value = _sliderFuelMain1.value - 20;
    }
    
    [self MainRoutine];
    
}



- (IBAction)buttonActionFuelMinus:(id)sender {
    
    float enterValue =  (_sliderFuelMain1.value * [_inputSpecificFuelMassPerVolume.text floatValue]) - [_inputFuelIncrement.text floatValue] ;
    //NSLog(@"enterValue %.0f ", enterValue);
    
    if ([fuelEnterMode isEqualToString:@"mass"]) {
        if (enterValue > tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue] ) {
            enterValue = tankCapacityVolume * [_inputSpecificFuelMassPerVolume.text floatValue];
        }
        _sliderFuelMain1.value =  enterValue / [_inputSpecificFuelMassPerVolume.text floatValue];
        
    }else{
        
        if (enterValue > tankCapacityVolume) {
            enterValue = tankCapacityVolume;
        }
        _sliderFuelMain1.value =  enterValue;
    }
    
    
    if (_sliderFuelLanding.value >= _sliderFuelMain1.value) {
        _sliderFuelLanding.value = _sliderFuelMain1.value - 20;
    }
    
    [self MainRoutine];
    
}


- (IBAction)buttonActionPatientON:(id)sender {
    
    [_arrayName8 replaceObjectAtIndex:linePatient withObject:@"1"];
    
    [_arrayName2 replaceObjectAtIndex:linePatient withObject:@"90"];
    
    [self MainRoutine];
    
}

- (IBAction)buttonActionPatientOFF:(id)sender {
    
    [_arrayName2 replaceObjectAtIndex:linePatient withObject:@"0"];
    
    [_arrayName8 replaceObjectAtIndex:linePatient withObject:@"0"];
    
    [self MainRoutine];
    
}

- (IBAction)actionResetAllFlightsButton:(id)sender{
    
    UIButton *btn = (UIButton*)sender;
    
    buttonIDtransfer = btn.tag;
    
    alertFlag = 1005;
    
    UIAlertView *alert = [[UIAlertView alloc]
                          initWithTitle:@"Reset All Flights"
                          message:@"This will delete all flights. Please Confirm"
                          delegate:self
                          
                          cancelButtonTitle:@"Cancel"
                          
                          
                          
                          otherButtonTitles:@"Reset All!", nil];
    [alert show];
    
    
    
    
    
}


- (void) resetAllFlightsFromManager {
    
    
    [allFlightsMasterArray removeAllObjects];
    
    //[allLegsPerFlightArray removeAllObjects];
    
    
    [allFlightsMasterArray addObject:@"-"];
    [[NSUserDefaults standardUserDefaults]  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];
    
    
    //[allLegsPerFlightArray addObject:@"-"];
    //[[NSUserDefaults standardUserDefaults]  setObject: allLegsPerFlightArray  forKey:@"allLegsPerFlightArray"];
    
    
    /*
     
     for(int i=0; i<allFlightsMasterArray.count; i++) {
     
     [allFlightsMasterArray removeAllObjects]
     
     //[allFlightsMasterArray removeObjectAtIndex: i ];
     
     }
     */
    
    vLegID = @"1";
    vFlightID = @"0";
    
    
    flagDoCreateNewFlight = 1;
    _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
    
    
}

- (void) deleteActiveFlightFromManager {
    
    [self SaveValues];
    
    //NSLog(@"actionDeleteFlightButton btn.tag %d ", btn.tag-100);
    
    [allFlightsMasterArray removeObjectAtIndex: [vFlightID integerValue] ];
    
    
    // look for new flight
    
    if ( [vFlightID intValue] >= (allFlightsMasterArray.count-1)  ) {
        
        vFlightID =  [ [NSString alloc] initWithFormat:@"%u", allFlightsMasterArray.count-1];
        
    }
    
    
    
    if ( [vFlightID intValue] == 0  ) {
        
        flagDoCreateNewFlight = 1;
        _viewSelectHelicopter.hidden = NO; [viewOne bringSubviewToFront:_viewSelectHelicopter];
        
    }else{
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        [defaults  setObject: allFlightsMasterArray  forKey:@"allFlightsMasterArray"];
        [defaults  setObject: vFlightID                                     forKey:@"vFlightID"];
        
        vLegID = @"1";
        
        
        [self LoadValues];
        
        [self createFlightButtons];
        
        [self MainRoutine];
        
        
    }
    
    
    
}





- (IBAction)actionSliderTestWeightPenalty:(id)sender {
    
    int dummy = _sliderTestWeightPenalty.value/5;
    _sliderTestWeightPenalty.value = dummy * 5;
    
    [self MainRoutine];
    

}

- (IBAction)actionSliderTestHeightGainPenalty:(id)sender {
    
    int dummy = _sliderTestHeightGainPenalty.value/0.05;
    _sliderTestHeightGainPenalty.value = dummy * 0.05;
    
    [self MainRoutine];
    
    
}


- (IBAction)actionOverridePenalties:(id)sender {
    
    if (_viewPenaltyOverride.hidden == YES) {
        _viewPenaltyOverride.hidden = NO;
    }else{
        
        _viewPenaltyOverride.hidden = YES;
    }
    [self MainRoutine];
}
- (IBAction)actionShowHidePerformancePage:(id)sender {
    
    if (_viewManifest1.hidden == NO) {
        _viewManifest1.hidden = YES;
        _viewManifest2.hidden = NO;
    }else{
        _viewManifest1.hidden = NO;
        _viewManifest2.hidden = YES;
        
        
    }
}
@end




